#!/usr/bin/perl

package eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RemoveFromWatchListRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListRequestType

=head1 DESCRIPTION

Enables a user to remove item from his or her My eBay watch list.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RemoveFromWatchList::RemoveFromWatchListRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;


my @gaProperties = ( [ 'ItemID', 'ns:ItemIDType', '1'
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'RemoveAllItems', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItemID()

The ID of the item to be removed from the
watch list. Either ItemID or RemoveAllItems must
be specified, but NOT both. One or more Item IDs
can be specified, each in it's own ItemID container.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: reference to an array  
                      of 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getItemID()

#    Returns: reference to an array  
                      of 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeArray('ItemID');
}


=head2 setRemoveAllItems()

If true, then all the items in the user's
watch list are removed. Either ItemID or
RemoveAllItems must be specified, but NOT both.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut

sub setRemoveAllItems {
  my $self = shift;
  $self->{'RemoveAllItems'} = shift
}

=head2 isRemoveAllItems()

#    Returns: 'xs:boolean'

=cut

sub isRemoveAllItems {
  my $self = shift;
  return $self->{'RemoveAllItems'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
