#!/usr/bin/perl

package eBay::API::XML::DataType::LiveAuctionBidArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LiveAuctionBidArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::LiveAuctionBidArrayType

=head1 DESCRIPTION

Container for a list of Live Auction Bidders, such as returned by
GetLiveAuctionBidders. Will contain zero, one, or multiple
LiveAuctionBidType bidders, each of which represents one bidder's request listing
that was found by the search.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::LiveAuctionBidArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::LiveAuctionBidType;


my @gaProperties = ( [ 'LiveAuctionBid', 'ns:LiveAuctionBidType', '1'
	     ,'eBay::API::XML::DataType::LiveAuctionBidType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setLiveAuctionBid()

Contains data for an item listing found by a search.

#    Argument: reference to an array  
                      of 'ns:LiveAuctionBidType'

=cut

sub setLiveAuctionBid {
  my $self = shift;
  $self->{'LiveAuctionBid'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getLiveAuctionBid()

  Calls: GetLiveAuctionBidders
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:LiveAuctionBidType'

=cut

sub getLiveAuctionBid {
  my $self = shift;
  return $self->_getDataTypeArray('LiveAuctionBid');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
