#!/usr/bin/env perl
use warnings;
use strict;
use Sub::CharacterProperties;
use Test::More tests => 1;
use Test::Differences;
my $n = Sub::CharacterProperties->new(
    characters => [
        'LATIN SMALL LETTER A',
        'LATIN SMALL LETTER B',
        'LATIN SMALL LETTER C',
        'LATIN SMALL LETTER D',
        'LATIN SMALL LETTER E',
        'LATIN SMALL LETTER F',
        'LATIN SMALL LETTER G',
        'LATIN SMALL LETTER H',
        'LATIN SMALL LETTER I',
        'LATIN SMALL LETTER J',
        'LATIN SMALL LETTER K',
        'LATIN SMALL LETTER L',
        'LATIN SMALL LETTER M',
        'LATIN SMALL LETTER N',
        'LATIN SMALL LETTER O',
        'LATIN SMALL LETTER P',
        'LATIN SMALL LETTER Q',
        'LATIN SMALL LETTER R',
        'LATIN SMALL LETTER S',
        'LATIN SMALL LETTER T',
        'LATIN SMALL LETTER U',
        'LATIN SMALL LETTER V',
        'LATIN SMALL LETTER W',
        'LATIN SMALL LETTER X',
        'LATIN SMALL LETTER Y',
        'LATIN SMALL LETTER Z',
        'DIGIT ZERO',
        'DIGIT ONE',
        'DIGIT TWO',
        'DIGIT THREE',
        'DIGIT FOUR',
        'DIGIT FIVE',
        'DIGIT SIX',
        'DIGIT SEVEN',
        'DIGIT EIGHT',
        'DIGIT NINE',
        'LATIN SMALL LETTER A WITH GRAVE',
        'LATIN SMALL LETTER A WITH ACUTE',
        'LATIN SMALL LETTER A WITH CIRCUMFLEX',
        'LATIN SMALL LETTER A WITH TILDE',
        'LATIN SMALL LETTER A WITH DIAERESIS',
        'LATIN SMALL LETTER A WITH RING ABOVE',
        'LATIN SMALL LETTER AE',
        'LATIN SMALL LETTER C WITH CEDILLA',
        'LATIN SMALL LETTER E WITH GRAVE',
        'LATIN SMALL LETTER E WITH ACUTE',
        'LATIN SMALL LETTER E WITH CIRCUMFLEX',
        'LATIN SMALL LETTER E WITH DIAERESIS',
        'LATIN SMALL LETTER I WITH GRAVE',
        'LATIN SMALL LETTER I WITH ACUTE',
        'LATIN SMALL LETTER I WITH CIRCUMFLEX',
        'LATIN SMALL LETTER I WITH DIAERESIS',
        'LATIN SMALL LETTER ETH',
        'LATIN SMALL LETTER N WITH TILDE',
        'LATIN SMALL LETTER O WITH GRAVE',
        'LATIN SMALL LETTER O WITH ACUTE',
        'LATIN SMALL LETTER O WITH CIRCUMFLEX',
        'LATIN SMALL LETTER O WITH TILDE',
        'LATIN SMALL LETTER O WITH DIAERESIS',
        'LATIN SMALL LETTER O WITH STROKE',
        'LATIN SMALL LETTER U WITH GRAVE',
        'LATIN SMALL LETTER U WITH ACUTE',
        'LATIN SMALL LETTER U WITH CIRCUMFLEX',
        'LATIN SMALL LETTER U WITH DIAERESIS',
        'LATIN SMALL LETTER Y WITH ACUTE',
        'LATIN SMALL LETTER THORN',
        'LATIN SMALL LETTER Y WITH DIAERESIS',
        'LATIN SMALL LIGATURE OE',
        'LATIN SMALL LETTER S WITH CARON',
        'LATIN SMALL LETTER Z WITH CARON',
    ]
);
my $expect = <<EOCODE;
sub InDomainLabel { <<'END' }
30 39
61 7A
E0 F6
F8 FF
153
161
17E
END
EOCODE
eq_or_diff($n->as_code('InDomainLabel'), $expect, 'generated sub code');
