# Before `make install' is performed this script should be runnable with
# `make test'. 

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 2;

BEGIN { use_ok('File::Rename') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

unshift @INC, 't' if -d 't';
require 'testlib.pl';

my $dir = do { require File::Temp; File::Temp::tempdir(); };
chdir $dir or die;

my $test = "A \x{2013} B.txt";  # en dash
my $xxx = 'A XXX B.txt';
create_file($test) or die;

our $found;
our $print;
our $warn;
local $SIG{__WARN__} = sub { $warn .= $_[0] };

my $s = sub { s/\N{EN DASH}+/XXX/ };
 
test_rename_files($s, $test); 
ok( (-e $xxx and !-e $test and $found), "rename with \\N{EN DASH}");
diag_rename();
 
