#!perl
# HopenTest.pm: test kit for Data::Hopen

package HopenTest;
use parent 'Exporter';
use Import::Into;

# Pragmas
use 5.014;
use feature ":5.14";
use strict;
use warnings;

# Packages
use Data::Dumper;
use Carp;
#use Capture::Tiny 'capture';
#use Config;
#use IPC::Run3;
use Test::More;
#use Text::ParseWords qw(shellwords);

use strict;
use Data::Hopen::Base;

BEGIN { $Data::Dumper::Indent = 1; }    # For easier-to-read dumps

# Definitions from this file
use constant {
    true => !!1,
    false => !!0,
};

our (@EXPORT, @EXPORT_FAIL);
BEGIN { @EXPORT = qw(true false); }

sub import {
    my ($target, $filename) = caller;
    #my $pkg =
               shift;   # Don't need our package name

    # Keep output lines in order
    STDOUT->autoflush(true);
    STDERR->autoflush(true);

    # --- Basic exports/re-exports  ------------------------------------

    # Export all symbols listed in @EXPORT
    __PACKAGE__->export_to_level(1, __PACKAGE__);

    # Re-export pragmas and packages
    feature->import::into($target, qw(:5.14));
    Carp->import::into($target, qw(carp croak confess));
    foreach (qw(strict warnings Data::Dumper Test::More Data::Hopen::Base)) {
        $_->import::into($target);
    };

    # --- Process argument list ----------------------------------------

    # First argument: if a non-reference, the name of the package to load.
    if(@_ && $_[0] && !ref($_[0])) {
        my $dut = shift;

        # Make sure it's there
        eval "require $dut;";
        die "Could not locate DUT $dut\n$@\n" if $@;

        $dut->import::into($target);    # load it

        #Package::Alias->import::into($target, DUT => $dut);     # Load it
        # NOTE: Class::Tiny subclasses won't construct properly if called via
        # a package alias (e.g., DUT->new).  Therefore, don't do the alias.

        { # Export the name of the DUT package as the caller's $DUT
            no strict 'refs';
            *{ $target . '::DUT' } = eval qq(\\"$dut");     # eval => constant
        }

        diag "$filename: DUT is $dut";
    }

} #import()

1;
# vi: set ts=4 sts=0 sw=4 ai fdm=marker fdl=1: #
