/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonItem<T extends Item>
extends Value<T>
implements GroundedValue<T> {
    protected T item = null;

    public SingletonItem(T item) {
        this.item = item;
    }

    public T asItem() {
        return this.item;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        if (this.item != null) {
            context.getReceiver().append((Item)this.item, 0, 2);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.item == null) {
            return AnyItemType.getInstance();
        }
        if (this.item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)this.item;
            if (th == null) {
                th = node.getConfiguration().getTypeHierarchy();
            }
            switch (node.getNodeKind()) {
                case 9: {
                    Object n;
                    AxisIterator iter = node.iterateAxis((byte)3);
                    ItemType elementType = null;
                    while ((n = iter.next()) != null) {
                        int kind = n.getNodeKind();
                        if (kind == 3) {
                            elementType = null;
                            break;
                        }
                        if (kind != 1) continue;
                        if (elementType != null) {
                            elementType = null;
                            break;
                        }
                        elementType = new SingletonItem(n).getItemType(th);
                    }
                    if (elementType == null) {
                        return NodeKindTest.DOCUMENT;
                    }
                    return new DocumentNodeTest((NodeTest)elementType);
                }
                case 1: {
                    SchemaType eltype = node.getSchemaType();
                    if (eltype.equals(Untyped.getInstance()) || eltype.equals(AnyType.getInstance())) {
                        return new NameTest(1, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(1, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(1, eltype, node.getConfiguration()));
                }
                case 2: {
                    SchemaType attype = node.getSchemaType();
                    if (attype.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                        return new NameTest(2, node.getFingerprint(), node.getNamePool());
                    }
                    return new CombinedNodeTest(new NameTest(2, node.getFingerprint(), node.getNamePool()), 23, new ContentTypeTest(2, attype, node.getConfiguration()));
                }
                case 3: {
                    return NodeKindTest.TEXT;
                }
                case 8: {
                    return NodeKindTest.COMMENT;
                }
                case 7: {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                case 13: {
                    return NodeKindTest.NAMESPACE;
                }
            }
            throw new IllegalArgumentException("Unknown node kind " + node.getNodeKind());
        }
        if (this.item instanceof FunctionItem) {
            return ((FunctionItem)this.item).getFunctionItemType(th);
        }
        return ((AtomicValue)this.item).getTypeLabel();
    }

    @Override
    public int getCardinality() {
        if (this.item == null) {
            return 8192;
        }
        return 16384;
    }

    @Override
    public int getLength() {
        return this.item == null ? 0 : 1;
    }

    @Override
    public T itemAt(int n) {
        if (n == 0 && this.item != null) {
            return this.item;
        }
        return null;
    }

    @Override
    public GroundedValue<T> subsequence(int start, int length) {
        if (this.item != null && start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    @Override
    public SequenceIterator<T> iterate() {
        return SingletonIterator.makeIterator(this.item);
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.item != null;
    }

    @Override
    public String getStringValue() {
        return this.item == null ? "" : this.item.getStringValue();
    }
}

