use strict;
use warnings;
use utf8;

use Test::More;
use Test::TypeTiny;

use Types::XSD;

sub mk_type { "Types::XSD"->get_type($_[0])->parameterize(%{$_[1]}) }

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 861." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '861'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced", $type, 0);
	should_pass(" concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computer", $type, 0);
	should_pass("s to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from we", $type, 0);
	should_pass("b browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conf", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 295." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '295'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language f", $type, 0);
	should_pass("or defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced con", $type, 0);
	should_pass("cepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world ", $type, 0);
	should_pass(" XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to ", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 266." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '266'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation lan", $type, 0);
	should_pass("guage for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML w", $type, 0);
	should_pass("ith more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one o", $type, 0);
	should_pass("f the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '1000'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing commu", $type, 0);
	should_pass("nity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain ", $type, 0);
	should_pass("processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processo", $type, 0);
	should_pass("rs and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide tes", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 0." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '0'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing commu", $type, 0);
	should_pass("nity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain ", $type, 0);
	should_pass("processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processo", $type, 0);
	should_pass("rs and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide tes", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 139." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '139'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the wo", $type, 0);
	should_pass("rld s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applicati", $type, 0);
	should_pass("ons alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for i", $type, 0);
	should_pass("nteracting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations", $type, 0);
	should_pass(" is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       m", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 628." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '628'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way tha", $type, 0);
	should_pass("t allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virt", $type, 0);
	should_pass("ually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NI", $type, 0);
	should_pass("ST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widel", $type, 0);
	should_pass("y used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging specifications and related  vocabularies  based upon the XML syntax   In", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 74." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '74'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language fo", $type, 0);
	should_pass("r defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapid", $type, 0);
	should_pass("ly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-r", $type, 0);
	should_pass("ich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availabili", $type, 0);
	should_pass("ty of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML S", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex do", $type, 0);
	should_pass("cuments  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to ", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS X", $type, 0);
	should_pass("ML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging sp", $type, 0);
	should_pass("ecifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  including the location of the object  A repository is where the object resides  A user retrieves an object from a repository    Although XML is a recent newcomer in the electronic commerce landscape  supply chains in many industries  as well as industry consortiums and standards organizations  are using XML to define their own vocabularies for business relationships and transactions  The vocabularies  business templates  and business processes ", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 0." => sub {
	my $type = mk_type('NormalizedString', {'length' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 625." => sub {
	my $type = mk_type('NormalizedString', {'length' => '625'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way ", $type, 0);
	should_pass("that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML do", $type, 0);
	should_pass("cuments on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build intero", $type, 0);
	should_pass("perable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide tes", $type, 0);
	should_pass("t frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed i", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 916." => sub {
	my $type = mk_type('NormalizedString', {'length' => '916'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-ri", $type, 0);
	should_pass("ch data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C R", $type, 0);
	should_pass("ecommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generatio", $type, 0);
	should_pass("n for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit ", $type, 0);
	should_pass("intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging specifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  including the location of th", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 645." => sub {
	my $type = mk_type('NormalizedString', {'length' => '645'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computer", $type, 0);
	should_pass("s to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from we", $type, 0);
	should_pass("b browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of S", $type, 0);
	should_pass("tructured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner wi", $type, 0);
	should_pass("th industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including X", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'length' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex do", $type, 0);
	should_pass("cuments  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to ", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS X", $type, 0);
	should_pass("ML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging sp", $type, 0);
	should_pass("ecifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  including the location of the object  A repository is where the object resides  A user retrieves an object from a repository    Although XML is a recent newcomer in the electronic commerce landscape  supply chains in many industries  as well as industry consortiums and standards organizations  are using XML to define their own vocabularies for business relationships and transactions  The vocabularies  business templates  and business processes ", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){1},\\s[A-Z]{2}\\s18037." => sub {
	my $type = mk_type('NormalizedString', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){1},\s[A-Z]{2}\s18037$)/});
	should_pass("8259 Structured Participants And Of Street Forum , MT 18037", $type, 0);
	should_pass("55 Improved Computing Future Such Street Individual , OR 18037", $type, 0);
	should_pass("32 To And And Collaborate Street Organizations , DE 18037", $type, 0);
	should_pass("735 To Groups Signatures Acting Street And , MI 18037", $type, 0);
	should_pass("874 Of Primary Standards To Street Disseminate , HI 18037", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s11352." => sub {
	my $type = mk_type('NormalizedString', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s11352$)/});
	should_pass("63663 That These At Certain Street Meets Of , MI 11352", $type, 0);
	should_pass("9568 Registry Standards Those Beta Street Of Organizations , IA 11352", $type, 0);
	should_pass("637 For Issues Associated Guidelines Street Better Of , LA 11352", $type, 0);
	should_pass("1 Both Language Is And Street Must Infrastructure , SC 11352", $type, 0);
	should_pass("7 Modeling Versions To The Street Is File , CT 11352", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\s([A-Z][a-z]{1,20}\\s){3},\\s[A-Z]{2}\\s12317." => sub {
	my $type = mk_type('NormalizedString', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\s([A-Z][a-z]{1,20}\s){3},\s[A-Z]{2}\s12317$)/});
	should_pass("4 The Language That Reviewed Street Object Furthermore Not , AL 12317", $type, 0);
	should_pass("382 This Academy Is Is Street For Accelerate Computing , NY 12317", $type, 0);
	should_pass("437 Promises That Allow Xml Street The Software Review , UT 12317", $type, 0);
	should_pass("31272 Technical To On To Street As Software And , WA 12317", $type, 0);
	should_pass("66 Build The Law Into Street Defining Industry Be , MD 12317", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){1}Street\\s([A-Z][a-z]{1,20}\\s){1},\\s[A-Z]{2}\\s17076." => sub {
	my $type = mk_type('NormalizedString', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){1}Street\s([A-Z][a-z]{1,20}\s){1},\s[A-Z]{2}\s17076$)/});
	should_pass("5 Provide Street Location , SD 17076", $type, 0);
	should_pass("81846 Reviewed Street By , IL 17076", $type, 0);
	should_pass("537 Dom Street In , WI 17076", $type, 0);
	should_pass("4 If Street Bandwidth , UT 17076", $type, 0);
	should_pass("89 Offer Street Dom , HI 17076", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){1}Street\\s([A-Z][a-z]{1,20}\\s){3},\\s[A-Z]{2}\\s19099-1858." => sub {
	my $type = mk_type('NormalizedString', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){1}Street\s([A-Z][a-z]{1,20}\s){3},\s[A-Z]{2}\s19099-1858$)/});
	should_pass("3453 Of Street Do Of Security , NM 19099-1858", $type, 0);
	should_pass("236 Industry Street Chi Standardization Tools , NE 19099-1858", $type, 0);
	should_pass("154 Be Street Of Database Oasis , IL 19099-1858", $type, 0);
	should_pass("837 Provide Street Information The Environments , DE 19099-1858", $type, 0);
	should_pass("158 Intelligent Street Files And Documents , ME 19099-1858", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet enumeration." => sub {
	my $type = mk_type('NormalizedString', {'enumeration' => ['tests','Therefore','by','Such','participating','into','and']});
	should_pass("and", $type, 0);
	should_pass("Therefore", $type, 0);
	should_pass("participating", $type, 0);
	should_pass("participating", $type, 0);
	should_pass("participating", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet enumeration." => sub {
	my $type = mk_type('NormalizedString', {'enumeration' => ['be','as','tools','XML','Such','creates','related','software']});
	should_pass("Such", $type, 0);
	should_pass("Such", $type, 0);
	should_pass("Such", $type, 0);
	should_pass("tools", $type, 0);
	should_pass("related", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet enumeration." => sub {
	my $type = mk_type('NormalizedString', {'enumeration' => ['and','NIST','enabling','manufacturers','database','the','pico-cellular','including','ebXML']});
	should_pass("the", $type, 0);
	should_pass("enabling", $type, 0);
	should_pass("database", $type, 0);
	should_pass("enabling", $type, 0);
	should_pass("NIST", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet enumeration." => sub {
	my $type = mk_type('NormalizedString', {'enumeration' => ['without','measurement','and','engineering','of']});
	should_pass("of", $type, 0);
	should_pass("of", $type, 0);
	should_pass("and", $type, 0);
	should_pass("without", $type, 0);
	should_pass("without", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet enumeration." => sub {
	my $type = mk_type('NormalizedString', {'enumeration' => ['By','devices','the','PC','be','operating']});
	should_pass("By", $type, 0);
	should_pass("PC", $type, 0);
	should_pass("PC", $type, 0);
	should_pass("PC", $type, 0);
	should_pass("PC", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet whiteSpace with value replace." => sub {
	my $type = mk_type('NormalizedString', {'whiteSpace' => 'replace'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defi", $type, 0);
	should_pass("ning data  known as HTML  has led to the creation of the world s first digital l", $type, 0);
	should_pass("ibrary  Using the simplicity of HTML with more advanced concepts from the publis", $type, 0);
	should_pass("hing community has led to the creation of a second-generation Internet language ", $type, 0);
	should_pass("called the Extensible Markup Language  XML   which is rapidly becoming one of th", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet whiteSpace with value collapse." => sub {
	my $type = mk_type('NormalizedString', {'whiteSpace' => 'collapse'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defi", $type, 0);
	should_pass("ning data known as HTML has led to the creation of the world s first digital lib", $type, 0);
	should_pass("rary Using the simplicity of HTML with more advanced concepts from the publishin", $type, 0);
	should_pass("g community has led to the creation of a second-generation Internet language cal", $type, 0);
	should_pass("led the Extensible Markup Language XML which is rapidly becoming one of the most", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 261." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '261'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation la", $type, 0);
	should_fail("nguage for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTM", $type, 0);
	should_fail("L with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming", $type, 0);
	should_fail(" one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to ", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 247." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '247'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generatio", $type, 0);
	should_fail("n language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simpl", $type, 0);
	should_fail("icity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   w", $type, 0);
	should_fail("hich is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes informat", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 230." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '230'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-gener", $type, 0);
	should_fail("ation language for defining data  known as HTML  has led to the creation of the world s first digital library  Usi", $type, 0);
	should_fail("ng the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible ", $type, 0);
	should_fail("Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications ", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 452." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '452'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has le", $type, 0);
	should_fail("d to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Exten", $type, 0);
	should_fail("sible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatic", $type, 0);
	should_fail("ally act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'minLength' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing comm", $type, 0);
	should_fail("unity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certa", $type, 0);
	should_fail("in processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML pr", $type, 0);
	should_fail("ocessors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Prov", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing commun", $type, 0);
	should_fail("ity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain ", $type, 0);
	should_fail("processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML proces", $type, 0);
	should_fail("sors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide t", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 823." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '823'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet langua", $type, 0);
	should_fail("ge define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of thes", $type, 0);
	should_fail("e technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants", $type, 0);
	should_fail(" to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic com", $type, 0);
	should_fail("merce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging specifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  includin", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 841." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '841'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich s", $type, 0);
	should_fail("et of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them ob", $type, 0);
	should_fail("vious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       ", $type, 0);
	should_fail("XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily o", $type, 0);
	should_fail("n that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Markup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging specifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  including the location of the object  A repository", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 374." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '374'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is r", $type, 0);
	should_fail("apidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display ", $type, 0);
	should_fail("context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta version", $type, 0);
	should_fail("s of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W", $type, 0);
	should_fail("3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'maxLength' => '1000'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex doc", $type, 0);
	should_fail("uments  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following relate", $type, 0);
	should_fail("d tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguities raised as a result of these tools are fed back into the development process for correction in future revisions    An industry s ability to use electronic commerce  EC  effectively depends primarily on that industry s ability to create  manipulate  and transmit intelligent information among partners and throughout the industry  The eXtensible Mar", $type, 0);
	should_fail("kup Language  XML   which is already targeted as the enabling technology for EC  is the primary standard by which industries are defining the structure and semantics of their information  XML is a base recommendation coupled with a set of emerging specifications and related  vocabularies  based upon the XML syntax   In the simplest sense  the benefits of XML will only be achieved if organizations of a significant number are using the same XML documents  Therefore  these XML documents must be available for partners to discover and retrieve  A registry/repository is a mechanism used to discover and retrieve documents  templates  software  i e   objects and resources  over the Internet  A registry is the mechanism used to discover the object  The registry provides information about the object  including the location of the object  A repository is where the object resides  A user retrieves an object from a repository    Although XML is a recent newcomer in the electronic commerce landscape  supply chains in many industries  as well as industry consortiums and standards organizations  are using XML to define their own vocabularies for business relationships and transactions  The vocabularies  business templates  and business processes used by these groups to transact business must be accessible by all partners at any time  Furthermore  newcomers to the supply chain or business partnerships must be able to discover these documents and retrieve them  A registry and repository can be used to provide this service  A series of registries and repositories can link many organizations and industries  acting as a web of registries for discovery  Standards are needed to ensure interoperability of these registries; additionally  a reg", $type, 0);
	should_fail("istry vocabulary must be created for consistency of discovery information among them    NIST/ITL is working with the Organization for the Advancement of Structured Information Standards  OASIS   the prominent industry consortium for defining specifications for the discovery and retrieval of XML-related documents  NIST chairs the OASIS Registry/Repository Technical Committee and is a significant contributor  NIST/ITL is also working within the ebXML Project  a joint project between OASIS and the United Nations body for Trade Facilitation and Electronic Business  UN/CEFACT   the prominent business-oriented  international standards organization for the discovery  retrieval  and use of business processes and related documents  The role of NIST/ITL is to influence the quality  correctness  and testability of the specifications of both the OASIS and ebXML Registry/Repository Working Groups through our reference implementation of a registry and repository that is conformant to both specifications  Additionally  NIST/ITL facilitates cross-over discussions between OASIS and ebXML; thus helping to ensure compatibility of the specifications    NIST/ITL  through its leadership in developing a reference implementation that is compliant to both specifications  will help ensure that both specifications are unambiguous  complete  and testable  This work will also contribute to the compatibility of these two specifications  An early indication of success is that the draft ebXML specification uses the OASIS specification as its basis  The completion of these specifications will allow small- and medium-sized enterprises  SMEs  to make appropriate choices with regard to EC tools and applications  and will allow them access to the emerging supply chain and industry partnership EC models    The National Software Reference Library  NSRL  provides a repository of known software  file profiles  and file signatures for use by law enforcement organizations in computer forensics investigations", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 0." => sub {
	my $type = mk_type('NormalizedString', {'length' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing commun", $type, 0);
	should_fail("ity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain ", $type, 0);
	should_fail("processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML proces", $type, 0);
	should_fail("sors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide t", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 359." => sub {
	my $type = mk_type('NormalizedString', {'length' => '359'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  X", $type, 0);
	should_fail("ML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define", $type, 0);
	should_fail("  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technolog", $type, 0);
	should_fail("ies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSL", $type, 0);
	should_fail("T/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIST/ITL led the development of the widely used XML test suite  NIST/ITL has further developed in cooperation with OASIS and W3C  robust testing resources for related XML technologies  including XML Schemas  DOM  and XSL  Developers and users utilize these tools to exercise both the appropriate W3C Recommendation and the associated implementations  Errors and ambiguiti", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 213." => sub {
	my $type = mk_type('NormalizedString', {'length' => '213'});
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advance", $type, 0);
	should_fail("d concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way", $type, 0);
	should_fail(" that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming a", $type, 0);
	should_fail("nd displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these", $type, 0);
	should_fail(" standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Provide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML       Schemas  Partner with industry participants to build robust test suites for       XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas  Develop in-house tools to aid in automating test generation for       XML-based languages  Work with industry to ensure that these tests are used as       metrology tools  and that the results of the tests are fed back       into both the standards process and the development process   As chair of the OASIS XML Conformance Subcommittee  NIS", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 683." => sub {
	my $type = mk_type('NormalizedString', {'length' => '683'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Us", $type, 0);
	should_fail("ing the simplicity of HTML with more advanced concepts from the publishing community has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  partic", $type, 0);
	should_fail("ularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certain processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Documen", $type, 0);
	should_fail("t Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML processors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technolo", $type, 0);
	done_testing;
};

subtest "Type atomic/normalizedString is restricted by facet length with value 1000." => sub {
	my $type = mk_type('NormalizedString', {'length' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a first-generation language for defining data  known as HTML  has led to the creation of the world s first digital library  Using the simplicity of HTML with more advanced concepts from the publishing comm", $type, 0);
	should_fail("unity has led to the creation of a second-generation Internet language called the Extensible Markup Language  XML   which is rapidly becoming one of the most popular languages in the world  XML is being incorporated into web pages and applications alike  particularly in those involved in electronic commerce applications  It is a language that describes information in a way that allows computers to exchange and automatically act on the information  Consequently  it can be used to automate certa", $type, 0);
	should_fail("in processes  A set of related technologies built around this Internet language define a rich set of tools that can be used to define  manipulate  and display context-rich data  In particular  XML Schemas define intuitive methods for creating complex documents  The Document Object Model  DOM  defines methods for interacting with XML and HTML  permitting the dynamic creation and manipulation of documents  The Extensible Stylesheet Language  XSL  defines methods for transforming and displaying XML documents on a variety of devices  from web browsers to print mediums to voice-enabled devices   Virtually all application domains are looking to use XML technologies to define  manipulate  and exchange structured information  In addition  XML pr", $type, 0);
	should_fail("ocessors and support for the related Schema  DOM and XSL technologies are available in beta versions of popular web browsers and application development software  The widespread availability of these technologies has made them obvious choices as building blocks for electronic commerce  As such  conformance of these products to the W3C Recommendations is necessary to build interoperable solutions  The Organization for the Advancement of Structured Information Standards  OASIS  consortium was formed to accelerate the adoption of these standards by addressing market needs and directions  and recommending guidelines for product interoperability and conformance   NIST/ITL is collaborating with industry to solve these problems using the following related tasks:  Provide technical leadership by chairing and/or participating in       appropriate OASIS and W3C efforts  including OASIS XML and       XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML       Schema Working Groups  Prov", $type, 0);
	done_testing;
};

done_testing;

