/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;

public class CollatingAtomicComparer
implements AtomicComparer {
    private StringCollator collator;

    public CollatingAtomicComparer(StringCollator collator) {
        this.collator = collator == null ? CodepointCollator.getInstance() : collator;
    }

    public StringCollator getCollator() {
        return this.collator;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return this.collator.compareStrings(a.getStringValue(), b.getStringValue());
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        return this.compareAtomicValues(a, b) == 0;
    }

    public String save() {
        return "CAC|" + this.getCollator().getCollationURI();
    }
}

