/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLWarning;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private final Parser parser;
    private LanguageConnectionFactory lcf;
    private TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dmgr;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int entryIsolationLevel;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private Vector savedObjects;
    private String classPrefix;
    private ParameterValueSet params;
    private SchemaDescriptor compilationSchema;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private Vector storeCostControllers = new Vector();
    private Vector storeCostConglomIds = new Vector();
    private SortCostController sortCostController;
    private Vector parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private Object cursorInfo;
    private SQLWarning warnings;

    public void cleanupOnError(Throwable throwable) throws StandardException {
        StandardException standardException;
        this.setInUse(false);
        this.resetContext();
        if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() < 50000) {
            if (this.currentDependent != null) {
                LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
                this.currentDependent.makeInvalid(0, languageConnectionContext);
            }
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
    }

    public Parser getParser() {
        return this.parser;
    }

    public NodeFactory getNodeFactory() {
        return this.lcf.getNodeFactory();
    }

    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    public int getNumTables() {
        return this.nextTableNumber;
    }

    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    public String getUniqueClassName() {
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    public Dependent getCurrentDependent() {
        return this.currentDependent;
    }

    public void setCurrentDependent(Dependent dependent) {
        this.currentDependent = dependent;
    }

    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    public void setCurrentAuxiliaryProviderList(ProviderList providerList) {
        this.currentAPL = providerList;
    }

    public void createDependency(Provider provider) throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        DependencyManager dependencyManager = languageConnectionContext.getDataDictionary().getDependencyManager();
        dependencyManager.addDependency(this.getCurrentDependent(), provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    public void createDependency(Dependent dependent, Provider provider) throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        DependencyManager dependencyManager = languageConnectionContext.getDataDictionary().getDependencyManager();
        dependencyManager.addDependency(dependent, provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    private void addProviderToAuxiliaryList(Provider provider) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(provider);
        }
    }

    public int addSavedObject(Object object) {
        if (this.savedObjects == null) {
            this.savedObjects = new Vector();
        }
        this.savedObjects.addElement(object);
        return this.savedObjects.size() - 1;
    }

    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] objectArray = new Object[this.savedObjects.size()];
        this.savedObjects.copyInto(objectArray);
        this.savedObjects = null;
        return objectArray;
    }

    public void setSavedObjects(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.addSavedObject(objectArray[i]);
        }
    }

    public void setParams(ParameterValueSet parameterValueSet) {
        this.params = parameterValueSet;
    }

    public ParameterValueSet getParams() {
        ParameterValueSet parameterValueSet = this.params;
        this.params = null;
        return parameterValueSet;
    }

    public void setCursorInfo(Object object) {
        this.cursorInfo = object;
    }

    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    public void firstOnStack() {
        this.firstOnStack = true;
    }

    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    public void setInUse(boolean bl) {
        this.inUse = bl;
        if (!bl) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void setReliability(int n) {
        this.reliability = n;
    }

    public int getReliability() {
        return this.reliability;
    }

    public StoreCostController getStoreCostController(long l, LanguageConnectionContext languageConnectionContext) throws StandardException {
        for (int i = 0; i < this.storeCostConglomIds.size(); ++i) {
            Long l2 = (Long)this.storeCostConglomIds.elementAt(i);
            if (l2 != l) continue;
            return (StoreCostController)this.storeCostControllers.elementAt(i);
        }
        StoreCostController storeCostController = languageConnectionContext.getTransactionCompile().openStoreCost(l);
        this.storeCostControllers.insertElementAt(storeCostController, this.storeCostControllers.size());
        this.storeCostConglomIds.insertElementAt(new Long(l), this.storeCostConglomIds.size());
        return storeCostController;
    }

    private void closeStoreCostControllers() {
        for (int i = 0; i < this.storeCostControllers.size(); ++i) {
            StoreCostController storeCostController = (StoreCostController)this.storeCostControllers.elementAt(i);
            try {
                storeCostController.close();
                continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.storeCostControllers.removeAllElements();
        this.storeCostConglomIds.removeAllElements();
    }

    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
            this.sortCostController = languageConnectionContext.getTransactionCompile().openSortCostController(null);
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    public SchemaDescriptor setCompilationSchema(SchemaDescriptor schemaDescriptor) {
        SchemaDescriptor schemaDescriptor2 = this.compilationSchema;
        this.compilationSchema = schemaDescriptor;
        return schemaDescriptor2;
    }

    public void setParameterList(Vector vector) {
        int n;
        this.parameterList = vector;
        int n2 = n = vector == null ? 0 : vector.size();
        if (n > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[n];
        }
    }

    public Vector getParameterList() {
        return this.parameterList;
    }

    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    public int getNextParameterNumber() {
        return this.parameterList.size();
    }

    public void setScanIsolationLevel(int n) {
        this.scanIsolationLevel = n;
    }

    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public void setEntryIsolationLevel(int n) {
        this.entryIsolationLevel = n;
    }

    public int getEntryIsolationLevel() {
        return this.entryIsolationLevel;
    }

    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager contextManager, LanguageConnectionFactory languageConnectionFactory, TypeCompilerFactory typeCompilerFactory) {
        super(contextManager, "CompilerContext");
        this.parser = languageConnectionFactory.newParser(this);
        this.lcf = languageConnectionFactory;
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + languageConnectionFactory.getUUIDFactory().createUUID().toString().replace('-', 'x');
    }
}

