DROP TABLE IF EXISTS `state_capitals`;
CREATE TABLE `state_capitals` (
  `state_capital_id` int(2) NOT NULL auto_increment,
  `state`            varchar(24) default NULL,
  `statehood_year`   int(4) default 1492,
  `capital`          varchar(24) default NULL,
  `capital_since`    int(4) default 1492,
  `most_populous`    varchar(3) default 'No',
  `city_population`  int(8) default 0,
  `metro_population` int(8) default 0,
  `notes`            blob default NULL,
  PRIMARY KEY  (`state_capital_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

 
INSERT INTO state_capitals (state, statehood_year, capital, capital_since, most_populous, city_population, metro_population, notes) VALUES 
("Alabama", "1819", "Montgomery", "1846", "No", "200127", "469268", "Birmingham is the state's largest city."), 
("Alaska", "1959", "Juneau", "1906", "No", "30987", "", "Anchorage is the state's largest city. Only state capital to border another country."), 
("Arizona", "1912", "Phoenix", "1889", "Yes", "1512986", "4039182", "Phoenix is the most populous U.S. state capital."), 
("Arkansas", "1836", "Little Rock", "1821", "Yes", "204370", "652834", ""), 
("California", "1850", "Sacramento", "1854", "No", "467343", "2136604", "The Supreme Court of California sits in San Francisco. Los Angeles is the state's largest city."), 
("Colorado", "1876", "Denver", "1867", "Yes", "566974", "2408750", ""), 
("Connecticut", "1788", "Hartford", "1875", "No", "124397", "1188241", "Bridgeport is the state's largest city, but Greater Hartford is the largest metro area."), 
("Delaware", "1787", "Dover", "1777", "No", "32135", "", "Wilmington is the state's largest city."), 
("Florida", "1845", "Tallahassee", "1824", "No", "168979", "336501", "Jacksonville is the largest city, and Miami has the largest metro area."), 
("Georgia", "1788", "Atlanta", "1868", "Yes", "486411", "5138223", "Atlanta is the most populous state capital by metropolitan area."), 
("Hawaii", "1959", "Honolulu", "1845", "Yes", "377357", "909863", ""), 
("Idaho", "1890", "Boise", "1865", "Yes", "201287", "635450", ""), 
("Illinois", "1818", "Springfield", "1837", "No", "116482", "188951", "Chicago is the state's largest city."), 
("Indiana", "1816", "Indianapolis", "1825", "Yes", "791926", "1984664", "In addition to being the second-largest state capital, Indianapolis is also the third largest city in the Midwest and the largest state capital east of the Mississippi River."), 
("Iowa", "1846", "Des Moines", "1857", "Yes", "209124", "625384", ""), 
("Kansas", "1861", "Topeka", "1856", "No", "122327", "228894", "Wichita is the state's largest city."), 
("Kentucky", "1792", "Frankfort", "1792", "No", "27741", "69670", "Louisville is the state's largest city."), 
("Louisiana", "1812", "Baton Rouge", "1880", "No", "224097", "751965", "New Orleans is the state's largest city and home to the Louisiana Supreme Court."), 
("Maine", "1820", "Augusta", "1832", "No", "18560", "117114", "Augusta was officially made the capital 1827, but the legislature did not sit there until 1832. Portland is the state's largest city."), 
("Maryland", "1788", "Annapolis", "1694", "No", "36217", "", "Annapolis is the third-longest serving capital in the United States after Santa Fe and Boston. Its capitol building is the oldest still in use. Baltimore is the state's largest city."), 
("Massachusetts", "1788", "Boston", "1630", "Yes", "590763", "4455217", "Boston is the longest continuously serving capital in the United States. The Boston-Worcester-Manchester Combined Statistical Area encompasses the state capitals of Massachusetts, New Hampshire, and Rhode Island."), 
("Michigan", "1837", "Lansing", "1847", "No", "119128", "454044", "Lansing is the only state capital that is not also the county seat of the county in which it is situated. Detroit is the state's largest city."), 
("Minnesota", "1858", "Saint Paul", "1849", "No", "287151", "3502891", "Minneapolis is the state's largest city; it and Saint Paul form the core of the state's largest metropolitan area."), 
("Mississippi", "1817", "Jackson", "1821", "Yes", "184256", "529456", ""), 
("Missouri", "1821", "Jefferson City", "1826", "No", "39636", "146363", "Kansas City is the state's largest city, and Greater St. Louis is the state's largest metropolitan area."), 
("Montana", "1889", "Helena", "1875", "No", "25780", "67636", "Billings is the state's largest city."), 
("Nebraska", "1867", "Lincoln", "1867", "No", "225581", "283970", "Omaha is the state's largest city."), 
("Nevada", "1864", "Carson City", "1861", "No", "57701", "", "Las Vegas is the state's largest city."), 
("New Hampshire", "1788", "Concord", "1808", "No", "42221", "", "Manchester is the state's largest city."), 
("New Jersey", "1787", "Trenton", "1784", "No", "84639", "367605", "Newark is the state's largest city."), 
("New Mexico", "1912", "Santa Fe", "1610", "No", "70631", "142407", "Santa Fe is the longest serving capital in the United States. El Paso del Norte served as the capital of the Santa Fe de Nuevo Méco colony-in-exile during the Pueblo Revolt of 1680-1692. Albuquerque is the state's largest city."), 
("New York", "1788", "Albany", "1797", "No", "95993", "1147850", "New York City is the state's largest city."), 
("North Carolina", "1789", "Raleigh", "1794", "No", "380173", "1635974", "Charlotte is the state's largest city."), 
("North Dakota", "1889", "Bismarck", "1883", "No", "55533", "101138", "Fargo is the state's largest city."), 
("Ohio", "1803", "Columbus", "1816", "Yes", "733203", "1725570", "Columbus is Ohio's largest city but the Cleveland and Cincinnati metropolitan areas are both larger."), 
("Oklahoma", "1907", "Oklahoma City", "1910", "Yes", "541500", "1266445", "Oklahoma City is the shortest serving current state capital in the United States."), 
("Oregon", "1859", "Salem", "1855", "No", "149305", "539203", "Portland is the state's largest city."), 
("Pennsylvania", "1786", "Harrisburg", "1812", "No", "48950", "384600", "Philadelphia is the state's largest city."), 
("Rhode Island", "1790", "Providence", "1900", "Yes", "176862", "1612989", "Providence also served as the capital 1636-1686 and 1689-1776. It was one of five co-capitals 1776-1853, and one of two co-capitals 1853-1900."), 
("South Carolina", "1788", "Columbia", "1786", "Yes", "122819", "703771", ""), 
("South Dakota", "1889", "Pierre", "1889", "No", "13876", "", "Sioux Falls is the state's largest city."), 
("Tennessee", "1796", "Nashville", "1826", "No", "607413", "1455097", "Memphis is the state's largest city, and Nashville is the largest metro area."), 
("Texas", "1845", "Austin", "1839", "No", "709893", "1513565", "Houston is the state's largest city, and DallasFort Worth is the largest metro area. It is the largest state capital that is not also state's largest city."), 
("Utah", "1896", "Salt Lake City", "1858", "Yes", "181743", "1115692", ""), 
("Vermont", "1791", "Montpelier", "1805", "No", "8035", "", "Montpelier is the least populous U.S. state capital. Burlington is the state's largest city."), 
("Virginia", "1788", "Richmond", "1780", "No", "195251", "1194008", "Virginia Beach is the state's largest city, and Northern Virginia is the state's largest metro area."), 
("Washington", "1889", "Olympia", "1853", "No", "42514", "234670", "Seattle is the state's largest city."), 
("West Virginia", "1863", "Charleston", "1885", "Yes", "52700", "305526", ""), 
("Wisconsin", "1848", "Madison", "1838", "No", "221551", "543022", "Milwaukee is the state's largest city."), 
("Wyoming", "1890", "Cheyenne", "1869", "Yes", "55362", "85384", "");
 
