package Config_mO;

# Package that takes the standard Config as generated by
# Extutiles:FakeConfig's Config_m package, and adjusts
# the compiler flags to get a more optimised (read smalled size)
# GUI.dll when making Win32::GUI.
#
# Use as perl -Ibuild_tools -MConfig_mO Makefile.PL when
# creating your makefile.
#
# Author: Robert May , rmay@popeslane.clara.co.uk, 20 June 2005
# $Id: Config_mO.pm,v 1.1 2005/06/26 16:41:00 robertemay Exp $

use strict;
use warnings;

use Config_m;
use Config;
use Extutils::FakeConfig;

# get the items we want to modify:
my $ccflags = $Config{ccflags};
my $lddlflags = $Config{lddlflags};
my $ldflags = $Config{ldflags};
my $optimize = $Config{optimize};

# remove -g flags
$ccflags =~ s/-g\s*//g;
$lddlflags =~ s/-g\s*//g;
$ldflags =~ s/-g\s*//g;
$optimize =~ s/-g\s*//g;

# remove -O2 flags
$ccflags =~ s/-O2\s*//g;
$lddlflags =~ s/-O2\s*//g;
$ldflags =~ s/-O2\s*//g;
$optimize =~ s/-O2\s*//g;

# add -Os flags to OPTIMIZE
$optimize .= " -Os";

#Add -s flag to linker
$lddlflags .= " -s";
$ldflags .= " -s";

eval 'use ExtUtils::FakeConfig (
			ccflags => $ccflags,
			lddlflags => $lddlflags,
			ldflags => $ldflags,
			optimize => $optimize,
		)';

1; #end of Config_m0
