# Generated by default/object.tt
package Paws::EMR::InstanceFleetProvisioningSpecifications;
  use Moose;
  has OnDemandSpecification => (is => 'ro', isa => 'Paws::EMR::OnDemandProvisioningSpecification');
  has SpotSpecification => (is => 'ro', isa => 'Paws::EMR::SpotProvisioningSpecification');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::InstanceFleetProvisioningSpecifications

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::InstanceFleetProvisioningSpecifications object:

  $service_obj->Method(Att1 => { OnDemandSpecification => $value, ..., SpotSpecification => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::InstanceFleetProvisioningSpecifications object:

  $result = $service_obj->Method(...);
  $result->Att1->OnDemandSpecification

=head1 DESCRIPTION

The launch specification for Spot Instances in the fleet, which
determines the defined duration, provisioning timeout behavior, and
allocation strategy.

The instance fleet configuration is available only in Amazon EMR
versions 4.8.0 and later, excluding 5.0.x versions. On-Demand and Spot
Instance allocation strategies are available in Amazon EMR version
5.12.1 and later.

=head1 ATTRIBUTES


=head2 OnDemandSpecification => L<Paws::EMR::OnDemandProvisioningSpecification>

The launch specification for On-Demand Instances in the instance fleet,
which determines the allocation strategy.

The instance fleet configuration is available only in Amazon EMR
versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances
allocation strategy is available in Amazon EMR version 5.12.1 and
later.


=head2 SpotSpecification => L<Paws::EMR::SpotProvisioningSpecification>

The launch specification for Spot Instances in the fleet, which
determines the defined duration, provisioning timeout behavior, and
allocation strategy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

