# Generated by default/object.tt
package Paws::FSX::UpdateFileSystemLustreConfiguration;
  use Moose;
  has AutoImportPolicy => (is => 'ro', isa => 'Str');
  has AutomaticBackupRetentionDays => (is => 'ro', isa => 'Int');
  has DailyAutomaticBackupStartTime => (is => 'ro', isa => 'Str');
  has DataCompressionType => (is => 'ro', isa => 'Str');
  has WeeklyMaintenanceStartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::UpdateFileSystemLustreConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::UpdateFileSystemLustreConfiguration object:

  $service_obj->Method(Att1 => { AutoImportPolicy => $value, ..., WeeklyMaintenanceStartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::UpdateFileSystemLustreConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoImportPolicy

=head1 DESCRIPTION

The configuration object for Amazon FSx for Lustre file systems used in
the C<UpdateFileSystem> operation.

=head1 ATTRIBUTES


=head2 AutoImportPolicy => Str

(Optional) When you create your file system, your existing S3 objects
appear as file and directory listings. Use this property to choose how
Amazon FSx keeps your file and directory listing up to date as you add
or modify objects in your linked S3 bucket. C<AutoImportPolicy> can
have the following values:

=over

=item *

C<NONE> - (Default) AutoImport is off. Amazon FSx only updates file and
directory listings from the linked S3 bucket when the file system is
created. FSx does not update the file and directory listing for any new
or changed objects after choosing this option.

=item *

C<NEW> - AutoImport is on. Amazon FSx automatically imports directory
listings of any new objects added to the linked S3 bucket that do not
currently exist in the FSx file system.

=item *

C<NEW_CHANGED> - AutoImport is on. Amazon FSx automatically imports
file and directory listings of any new objects added to the S3 bucket
and any existing objects that are changed in the S3 bucket after you
choose this option.

=back

For more information, see Automatically import updates from your S3
bucket
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).


=head2 AutomaticBackupRetentionDays => Int




=head2 DailyAutomaticBackupStartTime => Str




=head2 DataCompressionType => Str

Sets the data compression configuration for the file system.
C<DataCompressionType> can have the following values:

=over

=item *

C<NONE> - Data compression is turned off for the file system.

=item *

C<LZ4> - Data compression is turned on with the LZ4 algorithm.

=back

If you don't use C<DataCompressionType>, the file system retains its
current data compression configuration.

For more information, see Lustre data compression
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html).


=head2 WeeklyMaintenanceStartTime => Str

(Optional) The preferred start time to perform weekly maintenance,
formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1
through 7, beginning with Monday and ending with Sunday.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

