# Generated by default/object.tt
package Paws::GlueDataBrew::JobSample;
  use Moose;
  has Mode => (is => 'ro', isa => 'Str');
  has Size => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::JobSample

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::JobSample object:

  $service_obj->Method(Att1 => { Mode => $value, ..., Size => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::JobSample object:

  $result = $service_obj->Method(...);
  $result->Att1->Mode

=head1 DESCRIPTION

A sample configuration for profile jobs only, which determines the
number of rows on which the profile job is run. If a C<JobSample> value
isn't provided, the default is used. The default value is CUSTOM_ROWS
for the mode parameter and 20,000 for the size parameter.

=head1 ATTRIBUTES


=head2 Mode => Str

A value that determines whether the profile job is run on the entire
dataset or a specified number of rows. This value must be one of the
following:

=over

=item *

FULL_DATASET - The profile job is run on the entire dataset.

=item *

CUSTOM_ROWS - The profile job is run on the number of rows specified in
the C<Size> parameter.

=back



=head2 Size => Int

The C<Size> parameter is only required when the mode is CUSTOM_ROWS.
The profile job is run on the specified number of rows. The maximum
value for size is Long.MAX_VALUE.

Long.MAX_VALUE = 9223372036854775807



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

