# Generated by default/object.tt
package Paws::IoTEvents::AnalysisResult;
  use Moose;
  has Level => (is => 'ro', isa => 'Str', request_name => 'level', traits => ['NameInRequest']);
  has Locations => (is => 'ro', isa => 'ArrayRef[Paws::IoTEvents::AnalysisResultLocation]', request_name => 'locations', traits => ['NameInRequest']);
  has Message => (is => 'ro', isa => 'Str', request_name => 'message', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::AnalysisResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::AnalysisResult object:

  $service_obj->Method(Att1 => { Level => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::AnalysisResult object:

  $result = $service_obj->Method(...);
  $result->Att1->Level

=head1 DESCRIPTION

Contains the result of the analysis.

=head1 ATTRIBUTES


=head2 Level => Str

The severity level of the analysis result. Based on the severity level,
analysis results fall into three general categories:

=over

=item *

C<INFO> - An information result tells you about a significant field in
your detector model. This type of result usually doesn't require
immediate action.

=item *

C<WARNING> - A warning result draws special attention to fields that
might cause issues for your detector model. We recommend that you
review warnings and take necessary actions before you use your detector
model in production environments. Otherwise, the detector model might
not work as expected.

=item *

C<ERROR> - An error result notifies you about a problem found in your
detector model. You must fix all errors before you can publish your
detector model.

=back



=head2 Locations => ArrayRef[L<Paws::IoTEvents::AnalysisResultLocation>]

Contains one or more locations that you can use to locate the fields in
your detector model that the analysis result references.


=head2 Message => Str

Contains additional information about the analysis result.


=head2 Type => Str

The type of the analysis result. Analyses fall into the following types
based on the validators used to generate the analysis result:

=over

=item *

C<supported-actions> - You must specify AWS IoT Events supported
actions that work with other AWS services in a supported AWS Region.

=item *

C<service-limits> - Resources or API operations can't exceed service
quotas (also known as limits). Update your detector model or request a
quota increase.

=item *

C<structure> - The detector model must follow a structure that AWS IoT
Events supports.

=item *

C<expression-syntax> - Your expression must follow the required syntax.

=item *

C<data-type> - Data types referenced in the detector model must be
compatible.

=item *

C<referenced-data> - You must define the data referenced in your
detector model before you can use the data.

=item *

C<referenced-resource> - Resources that the detector model uses must be
available.

=back

For more information, see Running detector model analyses
(https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html)
in the I<AWS IoT Events Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

