# Generated by default/object.tt
package Paws::LexModelsV2::BotLocaleSummary;
  use Moose;
  has BotLocaleStatus => (is => 'ro', isa => 'Str', request_name => 'botLocaleStatus', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastBuildSubmittedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastBuildSubmittedDateTime', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has LocaleId => (is => 'ro', isa => 'Str', request_name => 'localeId', traits => ['NameInRequest']);
  has LocaleName => (is => 'ro', isa => 'Str', request_name => 'localeName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BotLocaleSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BotLocaleSummary object:

  $service_obj->Method(Att1 => { BotLocaleStatus => $value, ..., LocaleName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BotLocaleSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BotLocaleStatus

=head1 DESCRIPTION

Summary information about bot locales returned by the ListBotLocales
operation.

=head1 ATTRIBUTES


=head2 BotLocaleStatus => Str

The current status of the bot locale. When the status is C<Built> the
locale is ready for use.


=head2 Description => Str

The description of the bot locale.


=head2 LastBuildSubmittedDateTime => Str

A timestamp of the date and time that the bot locale was last built.


=head2 LastUpdatedDateTime => Str

A timestamp of the date and time that the bot locale was last updated.


=head2 LocaleId => Str

The language and locale of the bot locale.


=head2 LocaleName => Str

The name of the bot locale.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

