# Generated by default/object.tt
package Paws::SageMaker::FileSystemConfig;
  use Moose;
  has DefaultGid => (is => 'ro', isa => 'Int');
  has DefaultUid => (is => 'ro', isa => 'Int');
  has MountPath => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::FileSystemConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::FileSystemConfig object:

  $service_obj->Method(Att1 => { DefaultGid => $value, ..., MountPath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::FileSystemConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultGid

=head1 DESCRIPTION

The Amazon Elastic File System (EFS) storage configuration for a
SageMaker image.

=head1 ATTRIBUTES


=head2 DefaultGid => Int

The default POSIX group ID (GID). If not specified, defaults to C<100>.


=head2 DefaultUid => Int

The default POSIX user ID (UID). If not specified, defaults to C<1000>.


=head2 MountPath => Str

The path within the image to mount the user's EFS home directory. The
directory should be empty. If not specified, defaults to
I</home/sagemaker-user>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

