# Generated by default/object.tt
package Paws::SecurityHub::AwsElasticBeanstalkEnvironmentDetails;
  use Moose;
  has ApplicationName => (is => 'ro', isa => 'Str');
  has Cname => (is => 'ro', isa => 'Str');
  has DateCreated => (is => 'ro', isa => 'Str');
  has DateUpdated => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has EndpointUrl => (is => 'ro', isa => 'Str');
  has EnvironmentArn => (is => 'ro', isa => 'Str');
  has EnvironmentId => (is => 'ro', isa => 'Str');
  has EnvironmentLinks => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsElasticBeanstalkEnvironmentEnvironmentLink]');
  has EnvironmentName => (is => 'ro', isa => 'Str');
  has OptionSettings => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsElasticBeanstalkEnvironmentOptionSetting]');
  has PlatformArn => (is => 'ro', isa => 'Str');
  has SolutionStackName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Tier => (is => 'ro', isa => 'Paws::SecurityHub::AwsElasticBeanstalkEnvironmentTier');
  has VersionLabel => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElasticBeanstalkEnvironmentDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElasticBeanstalkEnvironmentDetails object:

  $service_obj->Method(Att1 => { ApplicationName => $value, ..., VersionLabel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElasticBeanstalkEnvironmentDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationName

=head1 DESCRIPTION

Contains details about an Elastic Beanstalk environment.

=head1 ATTRIBUTES


=head2 ApplicationName => Str

The name of the application that is associated with the environment.


=head2 Cname => Str

The URL to the CNAME for this environment.


=head2 DateCreated => Str

The creation date for this environment.


=head2 DateUpdated => Str

The date when this environment was last modified.


=head2 Description => Str

A description of the environment.


=head2 EndpointUrl => Str

For load-balanced, autoscaling environments, the URL to the load
balancer. For single-instance environments, the IP address of the
instance.


=head2 EnvironmentArn => Str

The ARN of the environment.


=head2 EnvironmentId => Str

The identifier of the environment.


=head2 EnvironmentLinks => ArrayRef[L<Paws::SecurityHub::AwsElasticBeanstalkEnvironmentEnvironmentLink>]

Links to other environments in the same group.


=head2 EnvironmentName => Str

The name of the environment.


=head2 OptionSettings => ArrayRef[L<Paws::SecurityHub::AwsElasticBeanstalkEnvironmentOptionSetting>]

The configuration setting for the environment.


=head2 PlatformArn => Str

The ARN of the platform version for the environment.


=head2 SolutionStackName => Str

The name of the solution stack that is deployed with the environment.


=head2 Status => Str

The current operational status of the environment.


=head2 Tier => L<Paws::SecurityHub::AwsElasticBeanstalkEnvironmentTier>

The tier of the environment.


=head2 VersionLabel => Str

The application version of the environment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

