package Sport::Analytics::NHL::Errors;
use strict;
use warnings FATAL => 'all';

=head1 NAME

Sport::Analytics::NHL::Errors - Hard fixes to errors in the NHL reports

=head1 SYNOPSYS

Hard fixes to errors in the NHL reports

Provides hard-coded corrections to the errors in the NHL reports or marks certain files as broken and unoperatable

This list shall expand as the release grows.

    use Sport::Analytics::NHL::Errors;
    # TBA

=cut

1;

=head1 AUTHOR

More Hockey Stats, C<< <contact at morehockeystats.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<contact at morehockeystats.com>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Sport::Analytics::NHL::Errors>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Sport::Analytics::NHL::Errors


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Sport::Analytics::NHL::Errors>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Sport::Analytics::NHL::Errors>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Sport::Analytics::NHL::Errors>

=item * Search CPAN

L<https://metacpan.org/release/Sport::Analytics::NHL::Errors>

=back

