#!/usr/bin/perl -w
#
#    Normalizer.t
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;

use strict;

use Test;
BEGIN { plan tests => 6 }
use ExtUtils::testlib;

use utf8;
use POSIX qw( locale_h errno );

use ICU qw( U_ZERO_ERROR );
use ICU::Normalizer qw( :EMode :EModeBit :EStatus :EOption );

ok(check_compose(), 1);
ok(check_decompose(), 1);
ok(check_normalizer_formD(), 1);
ok(check_normalizer_formC(), 1);
ok(check_normalizer_formKD(), 1);
ok(check_normalizer_formKC(), 1);

########################################################################
#
# The subroutines and tests
#
# (in alphabetic order)
#
########################################################################

sub check_compose {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::compose($input, DECOMP_BIT, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}

sub check_decompose {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::decompose($input, COMPAT_BIT, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}

sub check_normalizer_formC {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::normalize($input, COMPOSE, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}

sub check_normalizer_formD {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::normalize($input, DECOMP, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}

sub check_normalizer_formKC {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::normalize($input, COMPOSE_COMPAT, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}

sub check_normalizer_formKD {
   my $status = U_ZERO_ERROR;
   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   ICU::Normalizer::normalize($input, DECOMP_COMPAT, IGNORE_HANGUL, \$status);
   return 0 if $status;
   return 1;
}


exit(0);

