# Generated by default/object.tt
package Paws::FraudDetector::MetricDataPoint;
  use Moose;
  has Fpr => (is => 'ro', isa => 'Num', request_name => 'fpr', traits => ['NameInRequest']);
  has Precision => (is => 'ro', isa => 'Num', request_name => 'precision', traits => ['NameInRequest']);
  has Threshold => (is => 'ro', isa => 'Num', request_name => 'threshold', traits => ['NameInRequest']);
  has Tpr => (is => 'ro', isa => 'Num', request_name => 'tpr', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::MetricDataPoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::MetricDataPoint object:

  $service_obj->Method(Att1 => { Fpr => $value, ..., Tpr => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::MetricDataPoint object:

  $result = $service_obj->Method(...);
  $result->Att1->Fpr

=head1 DESCRIPTION

Model performance metrics data points.

=head1 ATTRIBUTES


=head2 Fpr => Num

The false positive rate. This is the percentage of total legitimate
events that are incorrectly predicted as fraud.


=head2 Precision => Num

The percentage of fraud events correctly predicted as fraudulent as
compared to all events predicted as fraudulent.


=head2 Threshold => Num

The model threshold that specifies an acceptable fraud capture rate.
For example, a threshold of 500 means any model score 500 or above is
labeled as fraud.


=head2 Tpr => Num

The true positive rate. This is the percentage of total fraud the model
detects. Also known as capture rate.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

