# Generated by default/object.tt
package Paws::LexRuntimeV2::SentimentResponse;
  use Moose;
  has Sentiment => (is => 'ro', isa => 'Str', request_name => 'sentiment', traits => ['NameInRequest']);
  has SentimentScore => (is => 'ro', isa => 'Paws::LexRuntimeV2::SentimentScore', request_name => 'sentimentScore', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::SentimentResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::SentimentResponse object:

  $service_obj->Method(Att1 => { Sentiment => $value, ..., SentimentScore => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::SentimentResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->Sentiment

=head1 DESCRIPTION

Provides information about the sentiment expressed in a user's response
in a conversation. Sentiments are determined using Amazon Comprehend.
Sentiments are only returned if they are enabled for the bot.

For more information, see Determine Sentiment
(https://docs.aws.amazon.com/comprehend/latest/dg/how-sentiment.html)
in the I<Amazon Comprehend developer guide>.

=head1 ATTRIBUTES


=head2 Sentiment => Str

The overall sentiment expressed in the user's response. This is the
sentiment most likely expressed by the user based on the analysis by
Amazon Comprehend.


=head2 SentimentScore => L<Paws::LexRuntimeV2::SentimentScore>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

