use strict;
use warnings;
use Module::Build;

use lib qw(t);
use t::Build;			# my Module::Build subclass
my $class='t::Build';

# CAUTION: may not work to have DBD::mysql in prereqs. 
#  in past, saw bug where if DBD::mysq not present, install tries to install 'DBD'
#  which does not exist

my $builder = $class->new
  (module_name         => 'Data::Babel',
   license             => 'perl',
   dist_author         => q{Nat Goodman <natg@shore.net>},
   configure_requires=>{'Module::Build' => 0.4007,
		       },
   build_requires =>   {'Carp' => 1.20,
			'Class::AutoClass' => 1.55,
			'Class::AutoDB' => 1.26,
			'Clone' => 0.35,
			'Cwd' => 3.40,
			'DBI' => 1.628,
			'English' => 1.04,
			'Exporter' => 5.68,
			'File::Basename' => 2.82,
			'File::Spec' => 3.40,
			'File::Spec::Functions' => 3.40,
			'FindBin' => 1.50,
			'Getopt::Long' => 2.38,
			'Graph' => 0.96,
			'Hash::AutoHash' => 1.16,
			'Hash::AutoHash::Args' => 1.17,
			'List::MoreUtils' => 0.33,
			'List::Util' => 1.23,
			'Math::BaseCalc' => 1.014,
			'Module::Build' => 0.4007,
			'POSIX' => 1.24,
			'Scalar::Util' => 1.23,
			'TAP::Formatter::Console' => 3.28,
			'TAP::Harness' => 3.28,
			'TAP::Parser::Aggregator' => 3.28,
			'Test::Deep' => 0.11,
			'Test::More' => 0.98,
			'Test::Pod' => 1.48,
			'Test::Pod::Content' => '0.0.6',
			'Text::Abbrev' => 1.02,
			'Text::Balanced' => 2.02,
		       },
   requires =>         {'AutoLoader' => 5.71,
			'B' => 1.29,
			'B::Deparse' => 1.04,
			'Carp' => 1.20,
			'Class::AutoClass' => 1.55,
			'Class::AutoDB' => 1.26,
			'Class::Singleton' => 1.4,
			'Config::IniFiles' => 2.82,
			'Cwd' => 3.40,
			'DBD::mysql'=> 4.024,
			'DBI' => 1.628,
			'Data::Dumper' => 2.145,
			'Exporter' => 5.68,
			'File::Basename' => 2.82,
			'File::Path' => 2.07,
			'File::Spec' => 3.40,
			'File::Temp' => 0.2302,
			'Graph' => 0.96,
			'Hash::AutoHash' => 1.16,
			'Hash::AutoHash::Args' => 1.17,
			'Hash::AutoHash::MultiValued' => 1.16,
			'List::Categorize' => 0.03,
			'List::MoreUtils' => 0.33,
			'List::Util' => 1.32,
			'Safe' => 2.35,
			'Storable' => 2.30,
			'Template' => 2.25,
			'Text::Abbrev' => 1.02,
			'Tie::ToObject' => 0.03,
			'Tree::Trie' => 1.9,
			'XSLoader' => 0.16,
		       },
   recommends =>       {'List::BinarySearch' => 0.14,
			'Tree::RB' => 0.500004,
			},
   create_makefile_pl => 'small',
   extra_compiler_flags => ['-DUSE_PPPORT_H'],
   use_tap_harness => 1,			  
   test_files => 't/babel.*.t',
  );

$builder->create_build_script();
