use 5.005;
use strict;
use ExtUtils::MakeMaker;

&WriteMakefile(
    NAME            => 'PICA::Record',
    DISTNAME        => 'PICA-Record',
    VERSION_FROM    => 'lib/PICA/Record.pm',
    ABSTRACT_FROM   => 'lib/PICA/Record.pm',
    PMLIBDIRS       => [ qw( lib/ ) ],
    AUTHOR          => 'Jakob Voss <jakob.voss@gbv.de>',
    PREREQ_PM       => {
        'LWP::UserAgent' => '2.0',
        'URI::Escape' => '1.35',
        'SOAP::Lite' => '0.71',
        'Scalar::Util' => '1.14',
        'Config::Simple' => '4.58',
        'PerlIO' => '1.0',
        'IO::File' => '1.11',
        'IO::Scalar' => '1.126',
        'Encode' => '2.33',
        'XML::Parser' => '2.32',
        'XML::Writer' => '0.605',
        'DBD::SQLite' => '0',
    },
    EXE_FILES       => [ 
        'script/parsepica', 
        'script/picaimport',
        'script/picawebcat', # deprecated
    ],
    dist            => {
        COMPRESS => 'gzip -9f',
        SUFFIX => 'gz',
    },
    depend          => {
        Makefile => '$(VERSION_FROM)'
    },
    clean           => { FILES => 'PICA-Record-*' },
);
