use Test::More;

use_ok('App::financeta::language');

my $lang = new_ok('App::financeta::language' => [ debug => 0]);
can_ok($lang, 'grammar');
can_ok($lang, 'receiver');
can_ok($lang, 'parser');
can_ok($lang, 'compile');
is($lang->compile(''), undef, 'compiler works on undefined');

my $test1 = << 'TEST1';
# --DO NOT EDIT--
# these are autogenerated comments. removing them will not regenerate them.
# default variables: open, high, low, close, volume
# MACD variables: macd, macd_signal, macd_hist
# --END OF DO NOT EDIT--
# Add your own comments here
TEST1
is($lang->compile($test1), undef, 'compiler works on comments');


my $test2 = << 'TEST2';
# --DO NOT EDIT--
# these are autogenerated comments. removing them will not regenerate them.
# default variables: open, high, low, close, volume
# MACD variables: macd, macd_signal, macd_hist
# --END OF DO NOT EDIT--
# Add your own comments here
buy at $open WHEN $macd_hist becomes positive and $macd CROSSES over $macd_signal;
TEST2
isnt($lang->compile($test2), undef, 'compiler can parse an instruction');

done_testing();

__END__
### COPYRIGHT: 2014 Vikas N. Kumar. All Rights Reserved.
### AUTHOR: Vikas N Kumar <vikas@cpan.org>
### DATE: 3rd Sept 2014
### LICENSE: Refer LICENSE file
