/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;

public class SelectedElementsSpaceStrippingRule
implements SpaceStrippingRule {
    private Rule anyElementRule = null;
    private Rule unnamedElementRuleChain = null;
    private HashMap<NodeName, Rule> namedElementRules = new HashMap(32);
    private int sequence = 0;

    public byte isSpacePreserving(NodeName fingerprint) throws XPathException {
        Rule rule = this.getRule(fingerprint);
        if (rule == null) {
            return 1;
        }
        return rule.getAction() == Stripper.PRESERVE ? (byte)1 : 0;
    }

    public void addRule(NodeTest test, Stripper.StripRuleTarget action, StylesheetModule module, int lineNumber) {
        int precedence = module.getPrecedence();
        int minImportPrecedence = module.getMinImportPrecedence();
        double priority = test.getDefaultPriority();
        ItemTypePattern pattern = new ItemTypePattern(test);
        pattern.setSystemId(module.getSourceElement().getSystemId());
        pattern.setLineNumber(lineNumber);
        Rule newRule = new Rule(pattern, action, precedence, minImportPrecedence, priority, this.sequence++);
        newRule.setRank((precedence << 16) + this.sequence);
        if (test instanceof NodeKindTest) {
            newRule.setAlwaysMatches(true);
            this.anyElementRule = this.addRuleToList(newRule, this.anyElementRule, true);
        } else if (test instanceof NameTest) {
            newRule.setAlwaysMatches(true);
            int fp = test.getFingerprint();
            CodedName key = new CodedName(fp, ((NameTest)test).getNamePool());
            Rule chain = this.namedElementRules.get(key);
            this.namedElementRules.put(key, this.addRuleToList(newRule, chain, true));
        } else {
            this.unnamedElementRuleChain = this.addRuleToList(newRule, this.unnamedElementRuleChain, false);
        }
    }

    private Rule addRuleToList(Rule newRule, Rule list, boolean dropRemainder) {
        Rule rule;
        if (list == null) {
            return newRule;
        }
        int precedence = newRule.getPrecedence();
        Rule prev = null;
        for (rule = list; rule != null; rule = rule.getNext()) {
            if (rule.getPrecedence() <= precedence) {
                newRule.setNext(dropRemainder ? null : rule);
                if (prev == null) {
                    return newRule;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
        return list;
    }

    public Rule getRule(NodeName nodeName) {
        Rule bestRule = this.namedElementRules.get(nodeName);
        if (this.unnamedElementRuleChain != null) {
            bestRule = this.searchRuleChain(nodeName, bestRule, this.unnamedElementRuleChain);
        }
        if (this.anyElementRule != null) {
            bestRule = this.searchRuleChain(nodeName, bestRule, this.anyElementRule);
        }
        return bestRule;
    }

    private Rule searchRuleChain(NodeName nodeName, Rule bestRule, Rule head) {
        while (head != null) {
            block5: {
                block3: {
                    block4: {
                        if (bestRule == null) break block3;
                        int rank = head.compareRank(bestRule);
                        if (rank < 0) break;
                        if (rank != 0) break block4;
                        if (head.isAlwaysMatches() || ((NodeTest)head.getPattern().getItemType()).matches(1, nodeName, -1)) {
                            bestRule = head;
                            break;
                        }
                        break block5;
                    }
                    if (!head.isAlwaysMatches() && !((NodeTest)head.getPattern().getItemType()).matches(1, nodeName, -1)) break block5;
                    bestRule = head;
                    break block5;
                }
                if (head.isAlwaysMatches() || ((NodeTest)head.getPattern().getItemType()).matches(1, nodeName, -1)) {
                    bestRule = head;
                    break;
                }
            }
            head = head.getNext();
        }
        return bestRule;
    }

    public static class StripRuleTarget
    implements RuleTarget,
    Serializable {
        public void explain(ExpressionPresenter presenter) {
        }
    }
}

