/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReverseArrayIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<T extends Item>
implements UnfailingIterator<T>,
ReversibleIterator<T>,
LastPositionFinder<T>,
LookaheadIterator<T>,
GroundedIterator<T> {
    protected T[] items;
    private int index;
    protected int start;
    protected int end;
    private T current = null;

    public ArrayIterator(T[] nodes) {
        this.items = nodes;
        this.start = 0;
        this.end = nodes.length;
        this.index = 0;
    }

    public ArrayIterator(T[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = start;
    }

    public SequenceIterator<T> makeSliceIterator(int min, int max) {
        int newEnd;
        int newStart;
        Item[] items = this.getArray();
        int currentStart = this.getStartPosition();
        int currentEnd = this.getEndPosition();
        if (min < 1) {
            min = 1;
        }
        if ((newStart = currentStart + (min - 1)) < currentStart) {
            newStart = currentStart;
        }
        int n = newEnd = max == Integer.MAX_VALUE ? currentEnd : newStart + (max - min + 1);
        if (newEnd > currentEnd) {
            newEnd = currentEnd;
        }
        if (newEnd <= newStart) {
            return EmptyIterator.emptyIterator();
        }
        return new ArrayIterator(items, newStart, newEnd);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end;
    }

    @Override
    public T next() {
        if (this.index >= this.end) {
            this.index = this.end + 1;
            this.current = null;
            return null;
        }
        this.current = this.items[this.index++];
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        if (this.index > this.end) {
            return -1;
        }
        return this.index - this.start;
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    public void close() {
    }

    @Override
    public ArrayIterator<T> getAnother() {
        return new ArrayIterator(this.items, this.start, this.end);
    }

    @Override
    public SequenceIterator<T> getReverseIterator() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    public T[] getArray() {
        return this.items;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }

    @Override
    public GroundedValue materialize() {
        if (this.start == 0 && this.end == this.items.length) {
            return new SequenceExtent(this.items);
        }
        SequenceExtent e = new SequenceExtent(this.items);
        return new SequenceExtent(e, this.start, this.end - this.start);
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

