/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.InvalidVersionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionRetriever
implements EntityResolver,
ErrorHandler {
    public static final String VERSION_3 = "3.0";
    public static final String VERSION_2 = "2.0";
    private Report report;
    private String path;

    public VersionRetriever(String path, Report report) {
        this.path = path;
        this.report = report;
    }

    public EPUBVersion retrieveOpfVersion(InputStream inputStream) throws InvalidVersionException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().setEntityResolver(this);
            parser.getXMLReader().setErrorHandler(this);
            parser.getXMLReader().setContentHandler(new OPFhandler());
            parser.getXMLReader().parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException e) {
            this.report.exception(this.path, e);
        }
        catch (SAXException e) {
            if (VERSION_3.equals(e.getMessage())) {
                this.report.info(null, FeatureEnum.FORMAT_VERSION, EPUBVersion.VERSION_3.toString());
                return EPUBVersion.VERSION_3;
            }
            if (VERSION_2.equals(e.getMessage())) {
                this.report.info(null, FeatureEnum.FORMAT_VERSION, EPUBVersion.VERSION_2.toString());
                return EPUBVersion.VERSION_2;
            }
            if (InvalidVersionException.UNSUPPORTED_VERSION.equals(e.getMessage())) {
                throw new InvalidVersionException(InvalidVersionException.UNSUPPORTED_VERSION);
            }
            if (InvalidVersionException.VERSION_ATTRIBUTE_NOT_FOUND.equals(e.getMessage())) {
                throw new InvalidVersionException(InvalidVersionException.VERSION_ATTRIBUTE_NOT_FOUND);
            }
            if (InvalidVersionException.PACKAGE_ELEMENT_NOT_FOUND.equals(e.getMessage())) {
                throw new InvalidVersionException(InvalidVersionException.PACKAGE_ELEMENT_NOT_FOUND);
            }
            this.report.exception(this.path, e);
        }
        catch (IOException e) {
            this.report.error(this.path, 0, 0, e.getMessage());
        }
        throw new InvalidVersionException(InvalidVersionException.VERSION_NOT_FOUND);
    }

    @Override
    public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
    }

    private class OPFhandler
    extends DefaultHandler {
        private OPFhandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"package".equals(localName)) {
                throw new SAXException(InvalidVersionException.PACKAGE_ELEMENT_NOT_FOUND);
            }
            this.processPackage(attributes);
        }

        private void processPackage(Attributes attributes) throws SAXException {
            String version = attributes.getValue("version");
            if (version == null) {
                throw new SAXException(InvalidVersionException.VERSION_ATTRIBUTE_NOT_FOUND);
            }
            if (VersionRetriever.VERSION_3.equals(version)) {
                throw new SAXException(VersionRetriever.VERSION_3);
            }
            if (VersionRetriever.VERSION_2.equals(version)) {
                throw new SAXException(VersionRetriever.VERSION_2);
            }
            throw new SAXException(InvalidVersionException.UNSUPPORTED_VERSION);
        }
    }
}

