package Task::Kramerius;

use strict;
use warnings;

our $VERSION = 0.01;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Kramerius - Install modules for Kramerius system.

=head1 SYNOPSIS

 cpanm Task::Kramerius

=head1 DESCRIPTION

Kramerius is an open source software solution for accessing digital documents.
Homepage of project is in L<https://system-kramerius.cz/>.

=head1 SEE ALSO

=over

=item L<App::Kramerius::To::Images>

Base class for kramerius2images script.

=item L<App::Kramerius::URI>

Base class for kramerius-uri script.

=item L<App::Kramerius::V4>

Base class for kramerius4 script.

=item L<Data::Kramerius>

Information about all Kramerius systems.Information about all Kramerius systems.

=item L<WebService::Kramerius::API4>

Class to Kramerius v4+ API.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Task-Kramerius>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2021 Michal Josef Špaček

BSD 2-Clause License

=head1 VERSION

0.01

=cut
