package Google::Ads::AdWords::v201206::OAuthInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %httpMethod_of :ATTR(:get<httpMethod>);
my %httpRequestUrl_of :ATTR(:get<httpRequestUrl>);
my %httpAuthorizationHeader_of :ATTR(:get<httpAuthorizationHeader>);

__PACKAGE__->_factory(
    [ qw(        httpMethod
        httpRequestUrl
        httpAuthorizationHeader

    ) ],
    {
        'httpMethod' => \%httpMethod_of,
        'httpRequestUrl' => \%httpRequestUrl_of,
        'httpAuthorizationHeader' => \%httpAuthorizationHeader_of,
    },
    {
        'httpMethod' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'httpRequestUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'httpAuthorizationHeader' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'httpMethod' => 'httpMethod',
        'httpRequestUrl' => 'httpRequestUrl',
        'httpAuthorizationHeader' => 'httpAuthorizationHeader',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::OAuthInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
OAuthInfo from the namespace https://adwords.google.com/api/adwords/cm/v201206.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * httpMethod


=item * httpRequestUrl


=item * httpAuthorizationHeader




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::OAuthInfo
   httpMethod =>  $some_value, # string
   httpRequestUrl =>  $some_value, # string
   httpAuthorizationHeader =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

