/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriverShell;
import net.sf.saxon.testdriver.TestReport;
import org.w3c.dom.Document;

public abstract class TestDriver {
    protected String catalogFileName;
    protected String exceptionsFileName = "exceptions.xml";
    protected String resultsDir = null;
    protected TestReport resultsDoc;
    protected int successes = 0;
    protected int failures = 0;
    protected int notrun = 0;
    protected int wrongErrorResults = 0;
    protected TestDriverShell shell = new TestDriverShell();
    protected boolean unfolded = false;
    protected boolean saveResults = false;
    protected boolean runPostureAndSweepTests = true;
    protected int generateByteCode = 1;
    protected boolean debugByteCode = false;
    protected boolean jitFlag = false;
    protected int streaming = 1;
    protected TreeModel treeModel = TreeModel.TINY_TREE;
    protected boolean debug = false;
    protected boolean export = false;
    protected boolean runWithJS = false;
    protected boolean relocatable = false;
    protected String jsBase = null;
    protected Pattern testPattern = null;
    protected String requestedTestSet = null;
    protected String testSuiteDir;
    protected Processor driverProc = null;
    protected Serializer driverSerializer = null;
    protected HashMap<String, XdmNode> exceptionsMap = new HashMap();
    protected HashMap<String, String> optimizationAssertions = new HashMap();
    protected Map<String, Environment> globalEnvironments = new HashMap<String, Environment>();
    protected Map<String, Environment> localEnvironments = new HashMap<String, Environment>();
    protected Map<String, File> queryModules = new HashMap<String, File>();
    protected Spec spec;
    protected String lang;
    protected boolean useXslt30Transformer = true;
    protected boolean tracing = false;
    protected boolean isAltova = false;
    protected Map<String, Integer> failSummary = new TreeMap<String, Integer>();
    protected boolean quiet = false;
    static Set<String> unsharedEnvironments = new HashSet<String>();

    public abstract String catalogNamespace();

    public boolean hasEECapability() {
        return false;
    }

    public void go(String[] args) throws Exception {
        if (this.driverProc == null) {
            this.driverProc = new Processor(false);
        }
        this.driverSerializer = this.driverProc.newSerializer();
        System.err.println("Testing " + this.getProductEdition() + " " + Version.getProductVersion());
        System.err.println("Java version " + System.getProperty("java.version"));
        this.testSuiteDir = args[0];
        String catalog = args[1];
        char separatorChar = '/';
        if (File.separatorChar != '/') {
            separatorChar = '\\';
        }
        if (!this.testSuiteDir.endsWith("" + separatorChar)) {
            this.testSuiteDir = this.testSuiteDir + separatorChar;
        }
        this.catalogFileName = catalog;
        catalog = this.testSuiteDir + catalog;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-t:")) {
                this.testPattern = Pattern.compile(args[i].substring(3));
            }
            if (args[i].startsWith("-s:")) {
                this.requestedTestSet = args[i].substring(3);
            }
            if (args[i].equals("-quiet")) {
                this.quiet = true;
            }
            if (args[i].startsWith("-o:")) {
                this.resultsDir = args[i].substring(3);
            }
            if (args[i].startsWith("-debug")) {
                this.debug = true;
            }
            if (args[i].startsWith("-export") && !args[i].equals("-export:off")) {
                this.export = true;
            }
            if (args[i].startsWith("-jit")) {
                this.jitFlag = true;
            }
            if (args[i].startsWith("-js")) {
                this.export = true;
                this.runWithJS = true;
                this.treeModel = DOMObjectModel.getInstance();
                if (args[i].startsWith("-js:")) {
                    this.jsBase = args[i].substring(4);
                }
            }
            if (args[i].equals("-unfolded")) {
                this.unfolded = true;
            }
            if (args[i].equals("-save")) {
                this.saveResults = true;
            }
            if (args[i].startsWith("-exceptions:")) {
                this.exceptionsFileName = args[i].substring(12);
            }
            if (args[i].equals("-T")) {
                this.tracing = true;
            }
            if (args[i].startsWith("-bytecode:")) {
                String value = args[i].substring(10);
                if (args[i].substring(10).equals("on")) {
                    this.generateByteCode = 0;
                } else if (args[i].substring(10).equals("debug")) {
                    this.debugByteCode = true;
                    this.generateByteCode = 0;
                } else {
                    this.generateByteCode = args[i].substring(10).equals("off") ? -1 : Integer.parseInt(value);
                }
            }
            if (args[i].startsWith("-streaming:")) {
                if (args[i].substring(11).equals("off")) {
                    this.streaming = 0;
                } else if (args[i].substring(11).equals("on")) {
                    this.streaming = 1;
                } else if (args[i].substring(11).equals("strict")) {
                    this.streaming = 3;
                } else {
                    throw new Exception("-streaming must be off|on|strict");
                }
            }
            if (args[i].startsWith("-tree")) {
                String model = args[i].substring(6);
                this.treeModel = this.getTreeModel(model);
                if (this.treeModel == null) {
                    throw new Exception("The requested TreeModel '" + model + "' does not exist");
                }
            }
            if (args[i].startsWith("-lang:")) {
                String specStr = null;
                this.lang = specStr = args[i].substring(6);
                this.processSpec(specStr);
            }
            if (args[i].startsWith("-xt30:")) {
                if (args[i].substring(6).equals("on")) {
                    this.useXslt30Transformer = true;
                } else if (args[i].substring(6).equals("off")) {
                    this.useXslt30Transformer = false;
                }
            }
            if (args[i].startsWith("-ps:")) {
                if (args[i].substring(4).equals("on")) {
                    this.runPostureAndSweepTests = true;
                } else if (args[i].substring(4).equals("off")) {
                    this.runPostureAndSweepTests = false;
                }
            }
            if (!args[i].startsWith("-relocatable:")) continue;
            if (args[i].substring(13).equals("on")) {
                this.relocatable = true;
                continue;
            }
            if (!args[i].substring(13).equals("off")) continue;
            this.relocatable = false;
        }
        if (this.resultsDoc == null) {
            this.printError("No result document: missing -lang option", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        if (this.resultsDir == null) {
            this.printError("No results directory specified (use -o:dirname)", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        System.err.println("UsingXslt30Transformer: " + this.useXslt30Transformer);
        System.err.println("Relocatable: " + this.relocatable);
        this.driverSerializer.setOutputStream((OutputStream)System.err);
        this.driverSerializer.setOutputProperty(Serializer.Property.METHOD, "adaptive");
        this.driverSerializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        this.driverSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/stableUnparsedText", (Object)true);
        this.processCatalog(new File(catalog));
        this.printResults(this.resultsDir + "/results" + Version.getProductVersion() + ".xml");
    }

    public boolean isDebugByteCode() {
        return this.debugByteCode;
    }

    protected TreeModel getTreeModel(String s) {
        DOMObjectModel tree = null;
        if (s.equalsIgnoreCase("dom")) {
            tree = new DOMObjectModel();
        } else if (s.equalsIgnoreCase("tinytree")) {
            tree = TreeModel.TINY_TREE;
        } else if (s.equalsIgnoreCase("condensed")) {
            tree = TreeModel.TINY_TREE_CONDENSED;
        } else if (s.equalsIgnoreCase("linked")) {
            tree = TreeModel.LINKED_TREE;
        }
        return tree;
    }

    public XdmNode makeDominoTree(Document doc, Configuration config, String baseUri) throws SaxonApiException {
        throw new UnsupportedOperationException("Domino needs PE+");
    }

    public String getResultsDir() {
        return this.resultsDir;
    }

    public abstract void processSpec(String var1);

    public boolean isByteCode() {
        return this.generateByteCode == 0;
    }

    public String getProductEdition() {
        return "Saxon-" + this.driverProc.getSaxonEdition();
    }

    public String getProductVersion() {
        return Version.getProductVersion();
    }

    public void prepareForSQL(Processor processor) {
    }

    protected void processCatalog(File catalogFile) throws SaxonApiException {
        if (this.driverProc.getSaxonEdition().equals("EE")) {
            if (this.generateByteCode == 0 && !this.debugByteCode) {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"true");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"false");
            } else if (this.generateByteCode > 0) {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)("" + this.generateByteCode));
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"false");
            } else if (this.generateByteCode == 0 && this.debugByteCode) {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"true");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"true");
            } else {
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/generateByteCode", (Object)"false");
                this.driverProc.setConfigurationProperty("http://saxon.sf.net/feature/debugByteCode", (Object)"false");
            }
        }
        DocumentBuilder catbuilder = this.driverProc.newDocumentBuilder();
        catbuilder.setTreeModel(this.treeModel);
        catbuilder.setLineNumbering(true);
        XdmNode catalog = catbuilder.build(catalogFile);
        XPathCompiler xpc = this.driverProc.newXPathCompiler();
        xpc.setLanguageVersion("3.1");
        xpc.setCaching(true);
        xpc.declareNamespace("", this.catalogNamespace());
        this.createGlobalEnvironments(catalog, xpc);
        try {
            this.writeResultFilePreamble(this.driverProc, catalog);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.readExceptionsFile();
        if (this.requestedTestSet != null) {
            try {
                XdmNode funcSetNode = (XdmNode)xpc.evaluateSingle("//test-set[@name='" + this.requestedTestSet + "']", (XdmItem)catalog);
                if (funcSetNode == null) {
                    throw new Exception("Test-set " + this.requestedTestSet + " not found!");
                }
                this.processTestSet(catbuilder, xpc, funcSetNode);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            for (XdmItem testSet : xpc.evaluate("//test-set", (XdmItem)catalog)) {
                this.processTestSet(catbuilder, xpc, (XdmNode)testSet);
            }
        }
        try {
            this.writeResultFilePostamble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getNameOfExceptionsFile() {
        return this.exceptionsFileName;
    }

    protected void readExceptionsFile() {
        XdmNode exceptionsDoc = null;
        DocumentBuilder exceptBuilder = this.driverProc.newDocumentBuilder();
        QName testSet = new QName("", "test-set");
        QName testCase = new QName("", "test-case");
        QName run = new QName("", "run");
        QName edition = new QName("", "edition");
        String saxonEdition = this.driverProc.getSaxonEdition();
        try {
            String suppliedName = this.getNameOfExceptionsFile();
            File exceptionsFile = suppliedName.startsWith("/") || suppliedName.matches("^[a-zA-Z]:.*") ? new File(suppliedName) : new File(this.resultsDir + "/" + suppliedName);
            System.err.println("Loading exceptions file " + exceptionsFile.getAbsolutePath());
            exceptionsDoc = exceptBuilder.build(exceptionsFile);
            XdmSequenceIterator iter = exceptionsDoc.axisIterator(Axis.DESCENDANT, new QName("", "exception"));
            while (iter.hasNext()) {
                XdmNode entry = (XdmNode)iter.next();
                String testName = entry.getAttributeValue(testCase);
                if (testName == null) {
                    testName = "$" + entry.getAttributeValue(testSet);
                }
                String runVal = entry.getAttributeValue(run);
                String editionVal = entry.getAttributeValue(edition);
                if (runVal == null) {
                    runVal = "false";
                }
                if (editionVal == null) {
                    editionVal = saxonEdition;
                }
                boolean appliesThisEdition = false;
                for (String ed : editionVal.trim().split("\\s+")) {
                    if (!ed.equals(saxonEdition)) continue;
                    appliesThisEdition = true;
                    break;
                }
                if (!appliesThisEdition) continue;
                if (runVal.equals("false")) {
                    for (String tc : testName.trim().split("\\s+")) {
                        this.exceptionsMap.put(tc, entry);
                    }
                    continue;
                }
                XdmSequenceIterator iter2 = entry.axisIterator(Axis.CHILD, new QName("optimization"));
                if (!iter2.hasNext()) continue;
                XdmNode optim = (XdmNode)iter2.next();
                this.optimizationAssertions.put(testName, optim.getAttributeValue(new QName("", "assert")));
            }
        }
        catch (SaxonApiException e) {
            this.printError("*** Failed to process exceptions file: ", e.getMessage());
        }
    }

    protected abstract void createGlobalEnvironments(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    protected void createLocalEnvironments(XdmNode testSetDocNode) {
        this.localEnvironments.clear();
        Environment defaultEnvironment = Environment.createLocalEnvironment(testSetDocNode.getBaseURI(), this.generateByteCode, this.unfolded, this.spec, this);
        this.localEnvironments.put("default", defaultEnvironment);
    }

    protected Environment getEnvironment(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        Environment env;
        String testCaseName = testCase.getAttributeValue(new QName("name"));
        XdmNode environmentNode = (XdmNode)xpc.evaluateSingle("environment", (XdmItem)testCase);
        if (environmentNode == null) {
            env = this.localEnvironments.get("default");
        } else {
            String envName = environmentNode.getAttributeValue(new QName("ref"));
            if (envName == null || envName.equals("")) {
                boolean baseUriCheck;
                block14: {
                    baseUriCheck = false;
                    env = null;
                    try {
                        env = Environment.processEnvironment(this, xpc, (XdmItem)environmentNode, null, this.localEnvironments.get("default"));
                        baseUriCheck = ((XdmAtomicValue)xpc.evaluateSingle("static-base-uri/@uri='#UNDEFINED'", (XdmItem)environmentNode)).getBooleanValue();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                        System.err.println("Failure loading environment");
                        if (env == null) break block14;
                        env.usable = false;
                    }
                }
                if (baseUriCheck) {
                    return null;
                }
            } else {
                block15: {
                    env = this.localEnvironments.get(envName);
                    if (env == null) {
                        env = this.globalEnvironments.get(envName);
                    }
                    if (env == null) {
                        try {
                            for (XdmItem e : xpc.evaluate("//environment[@name='" + envName + "']", (XdmItem)testCase)) {
                                Environment.processEnvironment(this, xpc, e, this.localEnvironments, this.localEnvironments.get("default"));
                            }
                            env = this.localEnvironments.get(envName);
                            if (unsharedEnvironments.contains(envName)) {
                                this.localEnvironments.remove(envName);
                            }
                        }
                        catch (NullPointerException ex) {
                            ex.printStackTrace();
                            System.err.println("Failure loading environment");
                            if (env == null) break block15;
                            env.usable = false;
                        }
                    }
                }
                if (env == null) {
                    this.println("*** Unknown environment " + envName);
                    this.noteFailure(testCase.getParent().getAttributeValue(new QName("name")), testCaseName);
                    return null;
                }
            }
        }
        return env;
    }

    public void registerXQueryModule(String uri, File resource) {
        this.queryModules.put(uri, resource);
    }

    public File exportStylesheet(XsltCompiler compiler, String fileName) {
        return null;
    }

    public void addInjection(XQueryCompiler compiler) {
    }

    public void noteFailure(String testSet, String testCase) {
        ++this.failures;
        if (this.requestedTestSet != null) {
            this.failSummary.put(testCase, 1);
        } else {
            Integer fails = this.failSummary.get(testSet);
            if (fails != null) {
                this.failSummary.put(testSet, fails + 1);
            } else {
                this.failSummary.put(testSet, 1);
            }
        }
    }

    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws IOException, SaxonApiException, XMLStreamException, Exception {
        this.resultsDoc.writeResultFilePreamble(processor, catalog);
    }

    protected void writeResultFilePostamble() throws XMLStreamException {
        this.resultsDoc.writeResultFilePostamble();
        if (this.requestedTestSet != null) {
            System.err.println("Failing tests: ");
            for (Map.Entry<String, Integer> entry : this.failSummary.entrySet()) {
                System.err.println("  " + entry.getKey());
            }
        } else {
            System.err.println("Failures by Test Set: ");
            for (Map.Entry<String, Integer> entry : this.failSummary.entrySet()) {
                System.err.println("  " + entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    protected void startTestSetElement(XdmNode testSetNode) {
        this.resultsDoc.startTestSetElement(testSetNode);
    }

    protected void writeTestSetEndElement() {
        this.resultsDoc.endElement();
    }

    private void processTestSet(DocumentBuilder catbuilder, XPathCompiler xpc, XdmNode testSetNode) throws SaxonApiException {
        this.startTestSetElement(testSetNode);
        File testSetFile = new File(this.testSuiteDir + "/" + testSetNode.getAttributeValue(new QName("file")));
        XdmNode testSetDocNode = catbuilder.build(testSetFile);
        this.createLocalEnvironments(testSetDocNode);
        boolean run = true;
        if (((XdmAtomicValue)xpc.evaluate("exists(/test-set/dependency)", (XdmItem)testSetDocNode).itemAt(0)).getBooleanValue()) {
            for (XdmItem dependency : xpc.evaluate("/test-set/dependency", (XdmItem)testSetDocNode)) {
                if (this.ensureDependencySatisfied((XdmNode)dependency, this.localEnvironments.get("default"))) continue;
                for (XdmItem testCase : xpc.evaluate("//test-case", (XdmItem)testSetDocNode)) {
                    String testCaseName = ((XdmNode)testCase).getAttributeValue(new QName("name"));
                    this.resultsDoc.writeTestcaseElement(testCaseName, "n/a", "test-set dependencies not satisfied");
                    ++this.notrun;
                }
                run = false;
                break;
            }
        }
        if (((XdmAtomicValue)xpc.evaluate("exists(/test-set/dependencies)", (XdmItem)testSetDocNode).itemAt(0)).getBooleanValue()) {
            for (XdmItem dependency : xpc.evaluate("/test-set/dependencies/*", (XdmItem)testSetDocNode)) {
                if (this.ensureDependencySatisfied((XdmNode)dependency, this.localEnvironments.get("default"))) continue;
                for (XdmItem testCase : xpc.evaluate("//test-case", (XdmItem)testSetDocNode)) {
                    String type = ((XdmNode)dependency).getNodeName().getLocalName();
                    String value = ((XdmNode)dependency).getAttributeValue(new QName("", "value"));
                    value = value == null ? type : type + ":" + value;
                    if ("false".equals(((XdmNode)dependency).getAttributeValue(new QName("", "satisfied")))) {
                        value = "!" + value;
                    }
                    String testCaseName = ((XdmNode)testCase).getAttributeValue(new QName("name"));
                    this.resultsDoc.writeTestcaseElement(testCaseName, "n/a", "test-set dependencies not satisfied: " + value);
                    ++this.notrun;
                }
                run = false;
                break;
            }
        }
        if (run) {
            if (this.testPattern == null) {
                for (XdmItem env : xpc.evaluate("//environment[@name]", (XdmItem)testSetDocNode)) {
                    String envName = ((XdmNode)env).getAttributeValue(new QName("name"));
                    if (unsharedEnvironments.contains(envName)) continue;
                    try {
                        Environment.processEnvironment(this, xpc, env, this.localEnvironments, this.localEnvironments.get("default"));
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                        System.err.println("Failure loading environment, in processTestSet");
                    }
                }
            }
            String testSet = xpc.evaluateSingle("/test-set/@name", (XdmItem)testSetDocNode).getStringValue();
            for (XdmItem testCase : xpc.evaluate("//test-case", (XdmItem)testSetDocNode)) {
                String testName = xpc.evaluateSingle("@name", testCase).getStringValue();
                if (this.testPattern != null && !this.testPattern.matcher(testName).matches()) continue;
                this.println("-s:" + testSet + " -t:" + testName);
                try {
                    this.runTestCase((XdmNode)testCase, xpc);
                }
                catch (SaxonApiException ex) {
                    ex.printStackTrace();
                    System.err.println("*** Error in evaluating testcase:" + ex.getMessage());
                }
            }
        }
        this.writeTestSetEndElement();
    }

    protected abstract void runTestCase(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    public void setTestDriverShell(TestDriverShell gui) {
        this.shell = gui;
    }

    public void println(String data) {
        if (!this.quiet) {
            this.shell.println(data);
        }
    }

    public void printResults(String resultsFileStr) {
        this.shell.printResults("Result: " + this.successes + " successes, " + this.failures + " failures, " + this.wrongErrorResults + " incorrect ErrorCode, " + this.notrun + " not run", resultsFileStr, this.resultsDir);
    }

    public void printError(String error, String message) {
        this.shell.alert(error);
        this.shell.println(error + message);
    }

    public void printError(String error, Exception e) {
        this.shell.alert(error);
        e.printStackTrace();
    }

    public abstract boolean ensureDependencySatisfied(XdmNode var1, Environment var2);

    static {
        unsharedEnvironments.add("import-schema-e01");
        unsharedEnvironments.add("merge002");
    }
}

