use strict;
use warnings;
use utf8;

use Test::More;
use Test::TypeTiny;

use Types::XSD;

sub mk_type { "Types::XSD"->get_type($_[0])->parameterize(%{$_[1]}) }

subtest "Type atomic/string is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('String', {'maxLength' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 969." => sub {
	my $type = mk_type('String', {'maxLength' => '969'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishi", $type, 0);
	should_pass("ng community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be u", $type, 0);
	should_pass("sed to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange s", $type, 0);
	should_pass("tructured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance S", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 913." => sub {
	my $type = mk_type('String', {'maxLength' => '913'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts fro", $type, 0);
	should_pass("m the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on ", $type, 0);
	should_pass("the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all applicati", $type, 0);
	should_pass("on domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical le", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 205." => sub {
	my $type = mk_type('String', {'maxLength' => '205'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a\nfirst", $type, 0);
	should_pass("-generation language for defining data  known as HTML  has led to\nthe creation of the world s first di", $type, 0);
	should_pass("gital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Inte", $type, 0);
	should_pass("rnet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particu", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('String', {'maxLength' => '1000'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing commu", $type, 0);
	should_pass("nity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\n", $type, 0);
	should_pass("processes  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processo", $type, 0);
	should_pass("rs and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide tes", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 0." => sub {
	my $type = mk_type('String', {'minLength' => '0'});
	should_pass("", $type, 0);
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing commu", $type, 0);
	should_pass("nity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\n", $type, 0);
	should_pass("processes  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processo", $type, 0);
	should_pass("rs and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide tes", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 657." => sub {
	my $type = mk_type('String', {'minLength' => '657'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchang", $type, 0);
	should_pass("e and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use X", $type, 0);
	should_pass("ML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems u", $type, 0);
	should_pass("sing the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation", $type, 0);
	should_pass(" with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging specifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\nor", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 90." => sub {
	my $type = mk_type('String', {'minLength' => '90'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data ", $type, 0);
	should_pass(" known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost ", $type, 0);
	should_pass("popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas", $type, 0);
	should_pass("\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them o", $type, 0);
	should_pass("bvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 946." => sub {
	my $type = mk_type('String', {'minLength' => '946'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Sc", $type, 0);
	should_pass("hemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organiz", $type, 0);
	should_pass("ation for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the re", $type, 0);
	should_pass("sults of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by whic", $type, 0);
	should_pass("h industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging specifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\norganizations of a significant number are using the same XML documents \nTherefore  these XML documents must be available for partners to\ndiscover and retrieve  A registry/repository is a mechanism used to\ndiscover and retrieve documents  templates  software  i e   objects\nand resources  over the Internet  A registry is the mechanism used to\ndiscover the object  The registry provides information about the\nobject  including the location of the object  A repository is where\nthe object resides  A user retrieves an object from a repository \n\n Although XML is a recent newcomer in the\nelectronic commerce landscape  supply chains in many industries  as well\nas industry consortiums and standards organizations  are using XML t", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('String', {'minLength' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex do", $type, 0);
	should_pass("cuments  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\n", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS X", $type, 0);
	should_pass("ML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging sp", $type, 0);
	should_pass("ecifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\norganizations of a significant number are using the same XML documents \nTherefore  these XML documents must be available for partners to\ndiscover and retrieve  A registry/repository is a mechanism used to\ndiscover and retrieve documents  templates  software  i e   objects\nand resources  over the Internet  A registry is the mechanism used to\ndiscover the object  The registry provides information about the\nobject  including the location of the object  A repository is where\nthe object resides  A user retrieves an object from a repository \n\n Although XML is a recent newcomer in the\nelectronic commerce landscape  supply chains in many industries  as well\nas industry consortiums and standards organizations  are using XML to\ndefine their own vocabularies for business relationships and\ntransactions  The vocabularies  business templates  and business\nprocesses ", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 0." => sub {
	my $type = mk_type('String', {'length' => '0'});
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	should_pass("", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 925." => sub {
	my $type = mk_type('String', {'length' => '925'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  ", $type, 0);
	should_pass("In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is ", $type, 0);
	should_pass("necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based langu", $type, 0);
	should_pass("ages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partne", $type, 0);
	should_pass("rs and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging specifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\norganizations of a significant number are using the same XML documents \nTherefore  these XML documents must be available for partners to\ndiscover and retrieve  A registry/repository is a mechanism used to\ndiscover and retrieve documents  templates  software  i e   objects\nand resources  over the Internet  A registry is the mechanism used to\ndiscover the object  The registry provides information about the\nobject  including the location of the object  A repository is where\nthe object re", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 713." => sub {
	my $type = mk_type('String', {'length' => '713'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently", $type, 0);
	should_pass("  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  ", $type, 0);
	should_pass("manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperabil", $type, 0);
	should_pass("ity\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrolo", $type, 0);
	should_pass("gy tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 243." => sub {
	my $type = mk_type('String', {'length' => '243'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishin", $type, 0);
	should_pass("g community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and ap", $type, 0);
	should_pass("plications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used", $type, 0);
	should_pass(" to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive met", $type, 0);
	should_pass("hods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 1000." => sub {
	my $type = mk_type('String', {'length' => '1000'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex do", $type, 0);
	should_pass("cuments  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\n", $type, 0);
	should_pass("accelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS X", $type, 0);
	should_pass("ML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging sp", $type, 0);
	should_pass("ecifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\norganizations of a significant number are using the same XML documents \nTherefore  these XML documents must be available for partners to\ndiscover and retrieve  A registry/repository is a mechanism used to\ndiscover and retrieve documents  templates  software  i e   objects\nand resources  over the Internet  A registry is the mechanism used to\ndiscover the object  The registry provides information about the\nobject  including the location of the object  A repository is where\nthe object resides  A user retrieves an object from a repository \n\n Although XML is a recent newcomer in the\nelectronic commerce landscape  supply chains in many industries  as well\nas industry consortiums and standards organizations  are using XML to\ndefine their own vocabularies for business relationships and\ntransactions  The vocabularies  business templates  and business\nprocesses ", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\n([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s12848." => sub {
	my $type = mk_type('String', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\n([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s12848$)/});
	should_pass("27951 Frameworks Library Them Objects Street\nRegard As , DC 12848", $type, 0);
	should_pass("7 Of Typical To Original Street\nIn Prominent , AK 12848", $type, 0);
	should_pass("5367 Bandwidth To Oasis Based Street\nCommunication Popular , NM 12848", $type, 0);
	should_pass("4 Many Different Means Of Street\nFiles In , OR 12848", $type, 0);
	should_pass("64 Those Soc Full Software Street\nChain Is , MT 12848", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){2}Street\\n([A-Z][a-z]{1,20}\\s){3},\\s[A-Z]{2}\\s15849." => sub {
	my $type = mk_type('String', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){2}Street\n([A-Z][a-z]{1,20}\s){3},\s[A-Z]{2}\s15849$)/});
	should_pass("726 Of In Street\nUser Those Of , IL 15849", $type, 0);
	should_pass("598 In This Street\nDespite Partnerships Generation , TN 15849", $type, 0);
	should_pass("53544 Compatibility Already Street\nTesting Business For , NY 15849", $type, 0);
	should_pass("3 Manipulate Robust Street\nUse Is And , AZ 15849", $type, 0);
	should_pass("41135 Tools Standardization Street\nThe Signatures Compatibility , ND 15849", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\n([A-Z][a-z]{1,20}\\s){1},\\s[A-Z]{2}\\s13420-1016." => sub {
	my $type = mk_type('String', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\n([A-Z][a-z]{1,20}\s){1},\s[A-Z]{2}\s13420-1016$)/});
	should_pass("367 Less Of Of Testing Street\nWidespread , MN 13420-1016", $type, 0);
	should_pass("138 Provides Available Related Efforts Street\nAct , IN 13420-1016", $type, 0);
	should_pass("967 Systems Allows Technology Health Street\nCommunity , IL 13420-1016", $type, 0);
	should_pass("8333 Chair Of Pc Languages Street\nTo , IA 13420-1016", $type, 0);
	should_pass("88539 Them Data Build That Street\nResides , MI 13420-1016", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){4}Street\\n([A-Z][a-z]{1,20}\\s){2},\\s[A-Z]{2}\\s17687." => sub {
	my $type = mk_type('String', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){4}Street\n([A-Z][a-z]{1,20}\s){2},\s[A-Z]{2}\s17687$)/});
	should_pass("45 Paradigm User Management Dependability Street\nThe Industry , SD 17687", $type, 0);
	should_pass("96 Mediums Benefits Technologies Reference Street\nMicrosystems Files , UT 17687", $type, 0);
	should_pass("1138 Computing Systems Other Architectural Street\nIts Key , AZ 17687", $type, 0);
	should_pass("6131 Object Techniques To Transmit Street\nIs Applications , AR 17687", $type, 0);
	should_pass("32 Addressing Nsrl Typical The Street\nTo All , OR 17687", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet pattern with value \\d{1,5}\\s([A-Z][a-z]{1,20}\\s){3}Street\\n([A-Z][a-z]{1,20}\\s){1},\\s[A-Z]{2}\\s11101." => sub {
	my $type = mk_type('String', {'pattern' => qr/(?ms:^\d{1,5}\s([A-Z][a-z]{1,20}\s){3}Street\n([A-Z][a-z]{1,20}\s){1},\s[A-Z]{2}\s11101$)/});
	should_pass("37 To Filter The Street\nAnd , GA 11101", $type, 0);
	should_pass("3358 Techniques Interoperability Exchange Street\nAs , AL 11101", $type, 0);
	should_pass("327 Criteria Information The Street\nTools , FL 11101", $type, 0);
	should_pass("6643 Interoperability Robust Of Street\nClean , LA 11101", $type, 0);
	should_pass("4173 Defines An Addressing Street\nTransforming , SC 11101", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet enumeration." => sub {
	my $type = mk_type('String', {'enumeration' => ['EC','obvious','to','design','enterprises','associated','and/or','standards','development']});
	should_pass("to", $type, 0);
	should_pass("and/or", $type, 0);
	should_pass("associated", $type, 0);
	should_pass("design", $type, 0);
	should_pass("enterprises", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet enumeration." => sub {
	my $type = mk_type('String', {'enumeration' => ['voice-enabled','launching','tremendous','robust','is','NIST/ITL','as','Business']});
	should_pass("tremendous", $type, 0);
	should_pass("tremendous", $type, 0);
	should_pass("NIST/ITL", $type, 0);
	should_pass("is", $type, 0);
	should_pass("as", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet enumeration." => sub {
	my $type = mk_type('String', {'enumeration' => ['syntax','through','only','any','our','that']});
	should_pass("only", $type, 0);
	should_pass("through", $type, 0);
	should_pass("our", $type, 0);
	should_pass("only", $type, 0);
	should_pass("through", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet enumeration." => sub {
	my $type = mk_type('String', {'enumeration' => ['the','ebXML','The','many','2000']});
	should_pass("ebXML", $type, 0);
	should_pass("The", $type, 0);
	should_pass("many", $type, 0);
	should_pass("ebXML", $type, 0);
	should_pass("The", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet enumeration." => sub {
	my $type = mk_type('String', {'enumeration' => ['well','for','these','such','as']});
	should_pass("such", $type, 0);
	should_pass("as", $type, 0);
	should_pass("well", $type, 0);
	should_pass("these", $type, 0);
	should_pass("for", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet whiteSpace with value preserve." => sub {
	my $type = mk_type('String', {'whiteSpace' => 'preserve'});
	should_pass("The advent of Internet-enabled browsers and a\nfirst-generation language for defi", $type, 0);
	should_pass("ning data  known as HTML  has led to\nthe creation of the world s first digital l", $type, 0);
	should_pass("ibrary  Using the simplicity\nof HTML with more advanced concepts from the publis", $type, 0);
	should_pass("hing community has\nled to the creation of a second-generation Internet language ", $type, 0);
	should_pass("called the\nExtensible Markup Language  XML   which is rapidly becoming one of th", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet whiteSpace with value collapse." => sub {
	my $type = mk_type('String', {'whiteSpace' => 'collapse'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defi", $type, 0);
	should_pass("ning data known as HTML has led to the creation of the world s first digital lib", $type, 0);
	should_pass("rary Using the simplicity of HTML with more advanced concepts from the publishin", $type, 0);
	should_pass("g community has led to the creation of a second-generation Internet language cal", $type, 0);
	should_pass("led the Extensible Markup Language XML which is rapidly becoming one of the most", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet whiteSpace with value replace." => sub {
	my $type = mk_type('String', {'whiteSpace' => 'replace'});
	should_pass("The advent of Internet-enabled browsers and a first-generation language for defi", $type, 0);
	should_pass("ning data  known as HTML  has led to the creation of the world s first digital l", $type, 0);
	should_pass("ibrary  Using the simplicity of HTML with more advanced concepts from the publis", $type, 0);
	should_pass("hing community has led to the creation of a second-generation Internet language ", $type, 0);
	should_pass("called the Extensible Markup Language  XML   which is rapidly becoming one of th", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 998." => sub {
	my $type = mk_type('String', {'minLength' => '998'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing comm", $type, 0);
	should_fail("unity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certa", $type, 0);
	should_fail("in\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML pr", $type, 0);
	should_fail("ocessors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nPr", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 275." => sub {
	my $type = mk_type('String', {'minLength' => '275'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation langu", $type, 0);
	should_fail("age for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with mo", $type, 0);
	should_fail("re advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost p", $type, 0);
	should_fail("opular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact o", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 838." => sub {
	my $type = mk_type('String', {'minLength' => '838'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more ad", $type, 0);
	should_fail("vanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way th", $type, 0);
	should_fail("at allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML docume", $type, 0);
	should_fail("nts on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and r", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 791." => sub {
	my $type = mk_type('String', {'minLength' => '791'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML ", $type, 0);
	should_fail("with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language th", $type, 0);
	should_fail("at describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet L", $type, 0);
	should_fail("anguage  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASI", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet minLength with value 1000." => sub {
	my $type = mk_type('String', {'minLength' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing comm", $type, 0);
	should_fail("unity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certa", $type, 0);
	should_fail("in\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML pr", $type, 0);
	should_fail("ocessors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProv", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 0." => sub {
	my $type = mk_type('String', {'maxLength' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing commun", $type, 0);
	should_fail("ity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\n", $type, 0);
	should_fail("processes  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML proces", $type, 0);
	should_fail("sors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide t", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 567." => sub {
	my $type = mk_type('String', {'maxLength' => '567'});
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applicatio", $type, 0);
	should_fail("ns  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying ", $type, 0);
	should_fail("XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of t", $type, 0);
	should_fail("hese standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into ", $type, 0);
	should_fail("both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Markup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\nt", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 46." => sub {
	my $type = mk_type('String', {'maxLength' => '46'});
	should_fail("The advent of Internet-enabled browsers and a\nf", $type, 0);
	should_fail("irst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nE", $type, 0);
	should_fail("xtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools t", $type, 0);
	should_fail("hat can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browse", $type, 0);
	should_fail("rs and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build ro", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 412." => sub {
	my $type = mk_type('String', {'maxLength' => '412'});
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popula", $type, 0);
	should_fail("r languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive met", $type, 0);
	should_fail("hods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread avail", $type, 0);
	should_fail("ability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  X", $type, 0);
	should_fail("SL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet maxLength with value 1000." => sub {
	my $type = mk_type('String', {'maxLength' => '1000'});
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex doc", $type, 0);
	should_fail("uments  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following relate", $type, 0);
	should_fail("d tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the results of the tests are fed back\n      into both the standards process and the development process \n\nAs chair of the OASIS XML Conformance Subcommittee  NIST/ITL\nled the development of the widely used XML test suite  NIST/ITL has\nfurther developed in cooperation with OASIS and W3C  robust testing\nresources for related XML technologies  including XML Schemas  DOM  and\nXSL  Developers and users utilize these tools to exercise both the\nappropriate W3C Recommendation and the associated implementations \nErrors and ambiguities raised as a result of these tools are fed back\ninto the development process for correction in future revisions \n\n An industry s ability to use electronic commerce  EC \neffectively depends primarily on that industry s ability to create \nmanipulate  and transmit intelligent information among partners and\nthroughout the industry  The eXtensible Mar", $type, 0);
	should_fail("kup Language  XML   which is\nalready targeted as the enabling technology for EC  is the primary\nstandard by which industries are defining the structure and semantics of\ntheir information  XML is a base recommendation coupled with a set of\nemerging specifications and related  vocabularies  based upon the XML\nsyntax \n\nIn the simplest sense  the benefits of XML will only be achieved if\norganizations of a significant number are using the same XML documents \nTherefore  these XML documents must be available for partners to\ndiscover and retrieve  A registry/repository is a mechanism used to\ndiscover and retrieve documents  templates  software  i e   objects\nand resources  over the Internet  A registry is the mechanism used to\ndiscover the object  The registry provides information about the\nobject  including the location of the object  A repository is where\nthe object resides  A user retrieves an object from a repository \n\n Although XML is a recent newcomer in the\nelectronic commerce landscape  supply chains in many industries  as well\nas industry consortiums and standards organizations  are using XML to\ndefine their own vocabularies for business relationships and\ntransactions  The vocabularies  business templates  and business\nprocesses used by these groups to transact business must be accessible\nby all partners at any time  Furthermore  newcomers to the supply chain\nor business partnerships must be able to discover these documents and\nretrieve them  A registry and repository can be used to provide this\nservice  A series of registries and repositories can link many\norganizations and industries  acting as a web of registries for\ndiscovery  Standards are needed to ensure interoperability of these\nregistries; additionally  a reg", $type, 0);
	should_fail("istry vocabulary must be created for\nconsistency of discovery information among them \n\n NIST/ITL is working with the Organization for the\nAdvancement of Structured Information Standards  OASIS   the prominent\nindustry consortium for defining specifications for the discovery and\nretrieval of XML-related documents  NIST chairs the OASIS\nRegistry/Repository Technical Committee and is a significant\ncontributor  NIST/ITL is also working within the ebXML Project  a joint\nproject between OASIS and the United Nations body for Trade Facilitation\nand Electronic Business  UN/CEFACT   the prominent business-oriented \ninternational standards organization for the discovery  retrieval  and\nuse of business processes and related documents  The role of NIST/ITL is\nto influence the quality  correctness  and testability of the\nspecifications of both the OASIS and ebXML Registry/Repository Working\nGroups through our reference implementation of a registry and repository\nthat is conformant to both specifications  Additionally  NIST/ITL\nfacilitates cross-over discussions between OASIS and ebXML; thus helping\nto ensure compatibility of the specifications \n\n NIST/ITL  through its leadership in developing a reference\nimplementation that is compliant to both specifications  will help\nensure that both specifications are unambiguous  complete  and testable \nThis work will also contribute to the compatibility of these two\nspecifications  An early indication of success is that the draft ebXML\nspecification uses the OASIS specification as its basis  The completion\nof these specifications will allow small- and medium-sized enterprises\n SMEs  to make appropriate choices with regard to EC tools and\napplications  and will allow them access to the emerging supply chain\nand industry partnership EC models \n\n The National Software Reference Library  NSRL  provides a\nrepository of known software  file profiles  and file signatures for use\nby law enforcement organizations in computer forensics investigations", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 0." => sub {
	my $type = mk_type('String', {'length' => '0'});
	should_fail("T", $type, 0);
	should_fail("he advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing commun", $type, 0);
	should_fail("ity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\n", $type, 0);
	should_fail("processes  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML proces", $type, 0);
	should_fail("sors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide t", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 151." => sub {
	my $type = mk_type('String', {'length' => '151'});
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first d", $type, 0);
	should_fail("igital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly", $type, 0);
	should_fail(" in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \n", $type, 0);
	should_fail("permitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML processors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperab", $type, 0);
	should_fail("le solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProvide test frameworks for XML  DOM  XSL-FO  XSLT/Xpath  and XML\n      Schemas \nPartner with industry participants to build robust test suites for\n      XML  DOM  XSL-FO  XSLT/Xpath  and XML Schemas \nDevelop in-house tools to aid in automating test generation for\n      XML-based languages \nWork with industry to ensure that these tests are used as\n      metrology tools  and that the resul", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 581." => sub {
	my $type = mk_type('String', {'length' => '581'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s ", $type, 0);
	should_fail("first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the wor", $type, 0);
	should_fail("ld  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used", $type, 0);
	should_fail(" to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 532." => sub {
	my $type = mk_type('String', {'length' => '532'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of", $type, 0);
	should_fail(" the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing community has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one o", $type, 0);
	should_fail("f the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certain\nprocesses  A set of related technologies b", $type, 0);
	should_fail("uilt around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to vo", $type, 0);
	done_testing;
};

subtest "Type atomic/string is restricted by facet length with value 1000." => sub {
	my $type = mk_type('String', {'length' => '1000'});
	should_fail("", $type, 0);
	should_fail("The advent of Internet-enabled browsers and a\nfirst-generation language for defining data  known as HTML  has led to\nthe creation of the world s first digital library  Using the simplicity\nof HTML with more advanced concepts from the publishing comm", $type, 0);
	should_fail("unity has\nled to the creation of a second-generation Internet language called the\nExtensible Markup Language  XML   which is rapidly becoming one of the\nmost popular languages in the world  XML is being incorporated into web\npages and applications alike  particularly in those involved in\nelectronic commerce applications  It is a language that describes\ninformation in a way that allows computers to exchange and automatically\nact on the information  Consequently  it can be used to automate certa", $type, 0);
	should_fail("in\nprocesses  A set of related technologies built around this Internet\nlanguage define a rich set of tools that can be used to define \nmanipulate  and display context-rich data  In particular  XML Schemas\ndefine intuitive methods for creating complex documents  The Document\nObject Model  DOM  defines methods for interacting with XML and HTML \npermitting the dynamic creation and manipulation of documents  The\nExtensible Stylesheet Language  XSL  defines methods for transforming\nand displaying XML documents on a variety of devices  from web browsers\nto print mediums to voice-enabled devices \n\nVirtually all application domains are looking\nto use XML technologies to define  manipulate  and exchange structured\ninformation  In addition  XML pr", $type, 0);
	should_fail("ocessors and support for the related\nSchema  DOM and XSL technologies are available in beta versions of\npopular web browsers and application development software  The\nwidespread availability of these technologies has made them obvious\nchoices as building blocks for electronic commerce  As such  conformance\nof these products to the W3C Recommendations is necessary to build\ninteroperable solutions  The Organization for the Advancement of\nStructured Information Standards  OASIS  consortium was formed to\naccelerate the adoption of these standards by addressing market needs\nand directions  and recommending guidelines for product interoperability\nand conformance \n\nNIST/ITL is collaborating with industry to solve\nthese problems using the following related tasks:\n\nProvide technical leadership by chairing and/or participating in\n      appropriate OASIS and W3C efforts  including OASIS XML and\n      XSLT/Xpath Conformance Subcommittees  W3C XSL-FO  DOM  and XML\n      Schema Working Groups \nProv", $type, 0);
	done_testing;
};

done_testing;

