/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OCFHandler
implements OCFData,
XMLHandler {
    private Map<String, List<String>> entries = new HashMap<String, List<String>>();
    XMLParser parser;

    OCFHandler(XMLParser parser) {
        this.parser = parser;
    }

    @Override
    public List<String> getEntries(String mediatype) {
        if (this.entries.containsKey(mediatype)) {
            return Collections.unmodifiableList(this.entries.get(mediatype));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getEntries() {
        LinkedList<String> result = new LinkedList<String>();
        for (List<String> paths : this.entries.values()) {
            result.addAll(paths);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void startElement() {
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (e.getName().equals("rootfile") && ns != null && ns.equals("urn:oasis:names:tc:opendocument:xmlns:container")) {
            String mediaType = e.getAttribute("media-type") != null ? e.getAttribute("media-type").trim() : "unknown";
            String fullPath = e.getAttribute("full-path");
            if (!this.entries.containsKey(mediaType)) {
                this.entries.put(mediaType, new LinkedList());
            }
            this.entries.get(mediaType).add(fullPath);
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }
}

