# Util::Bitfield

Utility subroutines for working with bitfields

[![Build Status](https://travis-ci.org/jonathanstowe/Util-Bitfield.svg?branch=master)](https://travis-ci.org/jonathanstowe/Util-Bitfield)

## Synopsis

```perl6

use Util::Bitfield;

my $number = 0b0001011101101010;

# source integer, number of bits, starting position, word size
say extract-bits($number,3,3,16); # 5
say sprintf "%016b",insert-bits(7, $number, 3, 3, 16); # "0001111101101010"

```

## Description

"Bitfields" are common in hardware interfaces and 
compact binary data formats, allowing the packing
of multiple fields of information within a single
machine word sized value for instance, hardware
examples might include device registers or gpio
ports, software examples include MP3 "frame headers".

Whilst highly efficient for data storage and
transmission, they're usually a pain to work with
in high level languages, requiring masking and
shifting of numbers possibly multiple times to
get a value you can sensibly use in your program.

Also because it's not something I at least tend
to do very frequently the patterns don't come
naturally and I end up starting from first principles
every time.

So to this end, on being presented with some data
that required unpacking of a bit field, I made this
fairly simple library to extract and insert an
arbitrary number of bits from an arbitrary location
within a larger integer as smaller integers.

## Installation

Assuming you have a working Rakudo Perl 6 installation you should be able to
install this with *zef* :

    # From the source directory
   
    zef install .

    # Remote installation

    zef install Util::Bitfield

Other install mechanisms may be become available in the future.

## Support

Suggestions/patches are welcomed via github at

https://github.com/jonathanstowe/Util-Bitfield/issues

## Licence

This is free software.

Please see the [LICENCE](LICENCE) file in the distribution

© Jonathan Stowe 2016, 2017, 2019
