#!/usr/bin/perl

use warnings;
use strict;
use Test::Inter;
$::ti = new Test::Inter $0;
require "tests.pl";

our $dmt = new Date::Manip::TZ;
our $obj = $dmt->base();
$dmt->config("forcedate","now,America/New_York");

sub test {
   my(@test)=@_;
   my @ret = $obj->calc_time_time(@test);
   return @ret;
}

my $tests="

[ +2 2 2 ]   [ +1 1 1 ]     => [ 3 3 3 ]

[ +2 2 2 ]   [ -1 -1 -1 ]   => [ 1 1 1 ]

[ +2 2 2 ]   [ 1 1 1 ] 1    => [ 1 1 1 ]

[ 10 45 90 ] [ 5 30 45 ]    => [ 16 17 15 ]

[ 10 45 90 ] [ -5 -30 -15 ] => [ 5 16 15 ]

[ 5 -5 +5 ]  [ -2 +2 -2 ]   => [ 2 57 3 ]

";

$::ti->tests(func  => \&test,
             tests => $tests);
$::ti->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: 0
#End:
