#!perl
use lib 't/lib';
use Test::Sietima;

package Sietima::Role::ForTesting {
    use Moo::Role;
    use Sietima::Policy;
    use Sietima::Types qw(AddressFromStr);

    around list_addresses => sub($orig,$self) {
        return {
            $self->$orig->%*,
            test1 => AddressFromStr->coerce('name <someone@example.com>'),
            'test+2' => 'http://test.example.com',
        };
    };
};

my $s = make_sietima(
    with_traits => ['Headers','WithOwner','ForTesting'],
    name => 'test-list',
    owner => 'owner@example.com',
    subscribers => [
        'one@users.example.com',
        'two@users.example.com',
    ],
);

subtest 'list headers should be added' => sub {
    test_sending(
        sietima => $s,
        mails => [
            object {
                call sub { +{ shift->header_str_pairs } } => hash {
                    field 'List-Id' => 'test-list <sietima-test.list.example.com>';
                    field 'List-Owner' => '<mailto:owner@example.com>';
                    field 'List-Post' => '<mailto:sietima-test@list.example.com>';
                    field 'List-Test1' => '<mailto:someone@example.com>';
                    field 'List-Test-2' => '<http://test.example.com>';

                    field 'Date' => D();
                    field 'MIME-Version' => D();
                    field 'Content-Type' => D();
                    field 'Content-Transfer-Encoding' => D();
                    field 'From' => 'someone@users.example.com';
                    field 'To' => 'sietima-test@list.example.com';
                    field 'Subject' => 'Test Message';

                    end;
                };
            },
        ],
    );
};

done_testing;
