/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class UntypedAtomizingIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private AtomicValue current = null;

    public UntypedAtomizingIterator(SequenceIterator base) {
        this.base = base;
    }

    public AtomicValue next() throws XPathException {
        Item nextSource = this.base.next();
        if (nextSource != null) {
            if (nextSource instanceof NodeInfo) {
                this.current = (AtomicValue)((NodeInfo)nextSource).atomize();
                return this.current;
            }
            if (nextSource instanceof AtomicValue) {
                return (AtomicValue)nextSource;
            }
            if (nextSource instanceof ObjectValue) {
                return StringValue.makeStringValue(nextSource.getStringValue());
            }
            throw new XPathException("The typed value of a function item is not defined", "FOTY0013");
        }
        this.current = null;
        return null;
    }

    public void close() {
        this.base.close();
    }

    public int getProperties() {
        return this.base.getProperties() & 6;
    }

    public int getLength() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLength();
    }

    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }
}

