#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

U32 murmur_hash2_neutral(char *data, size_t len) {
    U32  h, k;

    h = 0 ^ len;

    while (len >= 4) {
        k  = data[0];
        k |= data[1] << 8;
        k |= data[2] << 16;
        k |= data[3] << 24;

        k *= 0x5bd1e995;
        k ^= k >> 24;
        k *= 0x5bd1e995;

        h *= 0x5bd1e995;
        h ^= k;

        data += 4;
        len -= 4;
    }

    switch (len) {
    case 3:
        h ^= data[2] << 16;
    case 2:
        h ^= data[1] << 8;
    case 1:
        h ^= data[0];
        h *= 0x5bd1e995;
    }

    h ^= h >> 13;
    h *= 0x5bd1e995;
    h ^= h >> 15;

    return h;
}

MODULE = Digest::MurmurHash2::Neutral	PACKAGE = Digest::MurmurHash2::Neutral

U32 murmur_hash2_neutral(char *data, size_t length(data))
