use strict;
use warnings;
use Module::Build;

Module::Build->new(
  module_name => 'App::Netdisco',
  license     => 'bsd',
  dynamic_config => 1,
  configure_requires => {
    'DBIx::Class' => '0.082810',
    'Module::Build' => '0.42',
  },
  build_requires => {
  },
  requires => {
    'Algorithm::Cron' => '0.07',
    'AnyEvent' => '7.05',
    'AnyEvent::DNS::EtcHosts' => '0',
    'App::cpanminus' => '1.6108',
    'App::local::lib::helper' => '0.07',
    'Archive::Extract' => '0',
    'CGI::Expand' => '2.05',
    'Data::Printer' => '0',
    'DBD::Pg' => '0',
    'DBIx::Class' => '0.082810',
    'DBIx::Class::Helpers' => '2.024000',
    'Daemon::Control' => '0.001006',
    'Dancer' => '1.3132',
    'Dancer::Plugin::DBIC' => '0.2001',
    'Dancer::Plugin::Auth::Extensible' => '0.30',
    'Dancer::Plugin::Passphrase' => '2.0.1',
    'Dancer::Session::Cookie' => '0.27',
    'File::ShareDir' => '1.03',
    'File::Slurper' => '0.009',
    'Guard' => '1.022',
    'HTML::Parser' => '3.70',
    'HTTP::Tiny' => '0.029',
    'IO::Socket::SSL' => '2.048',
    'JSON' => '2.90',
    'JSON::XS' => '3.01',
    'List::MoreUtils' => '0.33',
    'MIME::Base64' => '3.13',
    'Module::Find' => '0.12',
    'Module::Load' => '0.32',
    'Moo' => '1.001000',
    'MCE' => '1.703',
    'Net::Domain' => '1.23',
    'Net::DNS' => '0.72',
    'Net::LDAP' => '0',
    'NetAddr::MAC' => '0.93',
    'NetAddr::IP' => '4.068',
    'Opcode' => '1.07',
    'Path::Class' => '0.32',
    'Plack' => '1.0023',
    'Plack::Middleware::Expires' => '0.03',
    'Plack::Middleware::ReverseProxy' => '0.15',
    'Role::Tiny' => '1.002005',
    'Sereal' => '0',
    'Socket6' => '0.23',
    'Starman' => '0.4008',
    'SNMP::Info' => '3.34',
    'SQL::Translator' => '0.11018',
    'Template' => '2.24',
    'Template::Plugin::CSV' => '0.04',
    'Template::Plugin::Number::Format' => '1.02',
    'Term::ReadLine' => '0',
    'Term::UI' => '0',
    'Try::Tiny' => '0',
    'URI' => '0',
    'URL::Encode' => '0.01',
    'YAML' => '0.84',
    'YAML::XS' => '0.41',
    'namespace::clean' => '0.24',
    'version' => '0.9902',
  },
  recommends => {
    'Graph' => '0',
    'GraphViz' => '0',
    'Net::OpenSSH' => '0',
    'Expect' => '0',
  },
  test_requires => {
    'Test::More' => '0.88',
    'Env::Path'  => '0',
  },
  script_files => [
    'bin/nd-import-topology',
    'bin/netdisco-db-deploy',
    'bin/netdisco-deploy',
    'bin/netdisco-do',
    'bin/netdisco-backend-fg',
    'bin/netdisco-backend',
    'bin/netdisco-daemon-fg',
    'bin/netdisco-daemon',
    'bin/netdisco-web-fg',
    'bin/netdisco-web',
    'bin/netdisco-rancid-export',
    'bin/netdisco-sshcollector',
  ],
  share_dir => 'share',
  meta_merge => {
    resources => {
      homepage => 'http://netdisco.org/',
      bugtracker => 'https://github.com/netdisco/netdisco/issues',
      repository => 'https://github.com/netdisco/netdisco',
      MailingList => 'https://lists.sourceforge.net/lists/listinfo/netdisco-users',
      IRC => 'irc://irc.freenode.org/#netdisco',
    },
  },
)->create_build_script;
