package Alien::PGPLOT;

# ABSTRACT: Build and Install the PGPLOT library

use strict;
use warnings;

our $VERSION = 'v5.2.2.4';

use base qw( Alien::Base );

1;

#
# This file is part of Alien-PGPLOT
#
# This software is Copyright (c) 2021 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory metacpan

=head1 NAME

Alien::PGPLOT - Build and Install the PGPLOT library

=head1 VERSION

version v5.2.2.4

=head1 SYNOPSIS

  use Alien::PGPLOT;

=head1 DESCRIPTION

This module finds or builds the I<PGPLOT> library.

=head1 USAGE

Please see L<Alien::Build::Manual::AlienUser> (or equivalently on L<metacpan|https://metacpan.org/pod/distribution/Alien-Build/lib/Alien/Build/Manual/AlienUser.pod>).

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-alien-pgplot@rt.cpan.org  or through the web interface at: https://rt.cpan.org/Public/Dist/Display.html?Name=Alien-PGPLOT

=head2 Source

Source is available at

  https://gitlab.com/djerius/alien-pgplot

and may be cloned from

  https://gitlab.com/djerius/alien-pgplot.git

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2021 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
