use strict;
use warnings;
use Test::More tests => 6;

BEGIN {
use_ok( 'Authen::TOTP' );
}

my $otp = new Authen::TOTP;

ok ( $otp->validate_otp(secret => "12345678901234567890", when => 59, digits => 8, otp => "94287082", tolerance => 1) == 1 );

ok ( $otp->validate_otp(secret => "12345678901234567890", when => 1111111109, digits => 8, otp => "07081804", tolerance => 1) == 1 );

ok ( $otp->validate_otp(secret => "12345678901234567890", when => 1234567890, digits => 8, otp => "89005924", tolerance => 1) == 1 );

ok ( $otp->validate_otp(secret => "12345678901234567890", when => 2000000000, digits => 8, otp => "69279037", tolerance => 1) == 1 );

ok ( $otp->validate_otp(secret => "12345678901234567890", when => 20000000000, digits => 8, otp => "65353130", tolerance => 1) == 1 );

