# Generated by default/object.tt
package Paws::AuditManager::Notification;
  use Moose;
  has AssessmentId => (is => 'ro', isa => 'Str', request_name => 'assessmentId', traits => ['NameInRequest']);
  has AssessmentName => (is => 'ro', isa => 'Str', request_name => 'assessmentName', traits => ['NameInRequest']);
  has ControlSetId => (is => 'ro', isa => 'Str', request_name => 'controlSetId', traits => ['NameInRequest']);
  has ControlSetName => (is => 'ro', isa => 'Str', request_name => 'controlSetName', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has EventTime => (is => 'ro', isa => 'Str', request_name => 'eventTime', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Source => (is => 'ro', isa => 'Str', request_name => 'source', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Notification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Notification object:

  $service_obj->Method(Att1 => { AssessmentId => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Notification object:

  $result = $service_obj->Method(...);
  $result->Att1->AssessmentId

=head1 DESCRIPTION

The notification used to inform a user of an update in AWS Audit
Manager. For example, this includes the notification that is sent when
a control set is delegated for review.

=head1 ATTRIBUTES


=head2 AssessmentId => Str

The identifier for the specified assessment.


=head2 AssessmentName => Str

The name of the related assessment.


=head2 ControlSetId => Str

The identifier for the specified control set.


=head2 ControlSetName => Str

Specifies the name of the control set that the notification is about.


=head2 Description => Str

The description of the notification.


=head2 EventTime => Str

The time when the notification was sent.


=head2 Id => Str

The unique identifier for the notification.


=head2 Source => Str

The sender of the notification.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

