# Generated by default/object.tt
package Paws::WellArchitected::Workload;
  use Moose;
  has AccountIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ArchitecturalDesign => (is => 'ro', isa => 'Str');
  has AwsRegions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Description => (is => 'ro', isa => 'Str');
  has Environment => (is => 'ro', isa => 'Str');
  has ImprovementStatus => (is => 'ro', isa => 'Str');
  has Industry => (is => 'ro', isa => 'Str');
  has IndustryType => (is => 'ro', isa => 'Str');
  has IsReviewOwnerUpdateAcknowledged => (is => 'ro', isa => 'Bool');
  has Lenses => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has NonAwsRegions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Notes => (is => 'ro', isa => 'Str');
  has Owner => (is => 'ro', isa => 'Str');
  has PillarPriorities => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ReviewOwner => (is => 'ro', isa => 'Str');
  has ReviewRestrictionDate => (is => 'ro', isa => 'Str');
  has RiskCounts => (is => 'ro', isa => 'Paws::WellArchitected::RiskCounts');
  has ShareInvitationId => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::WellArchitected::TagMap');
  has UpdatedAt => (is => 'ro', isa => 'Str');
  has WorkloadArn => (is => 'ro', isa => 'Str');
  has WorkloadId => (is => 'ro', isa => 'Str');
  has WorkloadName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WellArchitected::Workload

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WellArchitected::Workload object:

  $service_obj->Method(Att1 => { AccountIds => $value, ..., WorkloadName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WellArchitected::Workload object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountIds

=head1 DESCRIPTION

A workload return object.

=head1 ATTRIBUTES


=head2 AccountIds => ArrayRef[Str|Undef]




=head2 ArchitecturalDesign => Str




=head2 AwsRegions => ArrayRef[Str|Undef]




=head2 Description => Str




=head2 Environment => Str




=head2 ImprovementStatus => Str




=head2 Industry => Str




=head2 IndustryType => Str




=head2 IsReviewOwnerUpdateAcknowledged => Bool

Flag indicating whether the workload owner has acknowledged that the
I<Review owner> field is required.

If a B<Review owner> is not added to the workload within 60 days of
acknowledgement, access to the workload is restricted until an owner is
added.


=head2 Lenses => ArrayRef[Str|Undef]




=head2 NonAwsRegions => ArrayRef[Str|Undef]




=head2 Notes => Str




=head2 Owner => Str




=head2 PillarPriorities => ArrayRef[Str|Undef]




=head2 ReviewOwner => Str




=head2 ReviewRestrictionDate => Str




=head2 RiskCounts => L<Paws::WellArchitected::RiskCounts>




=head2 ShareInvitationId => Str

The ID assigned to the share invitation.


=head2 Tags => L<Paws::WellArchitected::TagMap>

The tags associated with the workload.


=head2 UpdatedAt => Str




=head2 WorkloadArn => Str




=head2 WorkloadId => Str




=head2 WorkloadName => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WellArchitected>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

