# Generated by default/object.tt
package Paws::AuditManager::Framework;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ComplianceType => (is => 'ro', isa => 'Str', request_name => 'complianceType', traits => ['NameInRequest']);
  has ControlSets => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::ControlSet]', request_name => 'controlSets', traits => ['NameInRequest']);
  has ControlSources => (is => 'ro', isa => 'Str', request_name => 'controlSources', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has LastUpdatedBy => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedBy', traits => ['NameInRequest']);
  has Logo => (is => 'ro', isa => 'Str', request_name => 'logo', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::AuditManager::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Framework

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Framework object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Framework object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The file used to structure and automate AWS Audit Manager assessments
for a given compliance standard.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the specified framework.


=head2 ComplianceType => Str

The compliance type that the new custom framework supports, such as CIS
or HIPAA.


=head2 ControlSets => ArrayRef[L<Paws::AuditManager::ControlSet>]

The control sets associated with the framework.


=head2 ControlSources => Str

The sources from which AWS Audit Manager collects evidence for the
control.


=head2 CreatedAt => Str

Specifies when the framework was created.


=head2 CreatedBy => Str

The IAM user or role that created the framework.


=head2 Description => Str

The description of the specified framework.


=head2 Id => Str

The unique identifier for the specified framework.


=head2 LastUpdatedAt => Str

Specifies when the framework was most recently updated.


=head2 LastUpdatedBy => Str

The IAM user or role that most recently updated the framework.


=head2 Logo => Str

The logo associated with the framework.


=head2 Name => Str

The name of the specified framework.


=head2 Tags => L<Paws::AuditManager::TagMap>

The tags associated with the framework.


=head2 Type => Str

The framework type, such as custom or standard.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

