package File::Groups;
#
# ********************
# AUTOGENERATED FILE DO NOT MODIFY
# ********************
#

our $VERSION = '0.1001';



  sub graphics_editor { return File::Groups_graphics_editor }

  sub video { return File::Groups_video }

  sub audio { return File::Groups_audio }

  sub image { return File::Groups_image }

  sub spreadsheet { return File::Groups_spreadsheet }

  sub document { return File::Groups_document }

  sub project_management { return File::Groups_project_management }

  sub presentation { return File::Groups_presentation }

  sub diagramming { return File::Groups_diagramming }

  sub word_processing { return File::Groups_word_processing }



  package File::Groups_graphics_editor;

  sub extensions {
  return $_[1] ? ["ai", "psd", "cdr", "eps", "epsf", "xcf", "ps", "sketch"] : ["ai", "psd", "cdr", "eps", "xcf", "ps", "sketch"]
  }

  sub media_types {
  return $_[1] ? ["application/postscript", "image/vnd.adobe.photoshop", "image/x-xcf"] : ["application/postscript", "image/vnd.adobe.photoshop", "image/x-xcf"]
  }


    sub vector { return File::Groups_graphics_editor_vector }
  
    sub raster { return File::Groups_graphics_editor_raster }
  

  package File::Groups_video;

  sub extensions {
  return $_[1] ? ["asf", "mov", "qt", "movie", "avi", "mpv2", "mp4", "mpe", "mpeg", "mpg", "webm"] : ["asf", "mov", "qt", "movie", "avi", "mp4", "mpeg", "mpg", "webm"]
  }

  sub media_types {
  return $_[1] ? ["video/x-ms-asf", "video/quicktime", "video/x-sgi-movie", "video/x-msvideo", "video/mpeg", "video/mp4", "video/webm"] : ["video/x-ms-asf", "video/quicktime", "video/x-sgi-movie", "video/x-msvideo", "video/mp4", "video/mpeg", "video/webm"]
  }



  package File::Groups_audio;

  sub extensions {
  return $_[1] ? ["au", "aif", "aiff", "aifc", "mp3", "rmi", "mid", "ra", "ram", "snd", "wav", "weba"] : ["au", "aif", "aiff", "aifc", "mp3", "rmi", "mid", "wav", "weba"]
  }

  sub media_types {
  return $_[1] ? ["audio/basic", "audio/x-aiff", "audio/mpeg", "audio/mp3", "audio/mid", "audio/midi", "audio/x-pn-realaudio", "audio/x-realaudio", "audio/x-wav", "audio/wav", "audio/wave", "audio/webm"] : ["audio/basic", "audio/x-aiff", "audio/mpeg", "audio/mp3", "audio/mid", "audio/midi", "audio/x-wav", "audio/wav", "audio/wave", "audio/webm"]
  }



  package File::Groups_image;

  sub extensions {
  return $_[1] ? ["bmp", "dib", "gif", "ico", "jfif", "jpe", "jpeg", "jpg", "pbm", "pgm", "png", "ppm", "rgb", "svg", "tif", "tiff", "webp", "xbm", "xpm"] : ["bmp", "gif", "ico", "jpeg", "jpg", "png", "svg", "tif", "tiff", "webp"]
  }

  sub media_types {
  return $_[1] ? ["image/bmp", "image/x-ms-bmp", "image/gif", "image/x-icon", "image/vnd.microsoft.icon", "image/pipeg", "image/jpeg", "image/x-portable-bitmap", "image/x-portable-graymap", "image/png", "image/x-portable-pixmap", "image/x-rgb", "image/svg+xml", "image/tiff", "image/webp", "image/x-xbitmap", "image/x-xpixmap"] : ["image/bmp", "image/x-ms-bmp", "image/gif", "image/x-icon", "image/vnd.microsoft.icon", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "image/webp"]
  }


    sub raster { return File::Groups_image_raster }
  
    sub web { return File::Groups_image_web }
  
    sub vector { return File::Groups_image_vector }
  

  package File::Groups_spreadsheet;

  sub extensions {
  return $_[1] ? ["csv", "xls", "xlsx", "xlt", "xltx", "xlw", "xla", "xlsm", "xlsb", "xltm", "xlam", "numbers", "ods", "ots", "tsv", "tab"] : ["csv", "xls", "xlsx", "xlt", "xltx", "xlw", "numbers", "ods", "ots", "tsv"]
  }

  sub media_types {
  return $_[1] ? ["text/csv", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-excel.addin.macroenabled.12", "application/vnd.apple.numbers", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "text/tab-separated-values"] : ["text/csv", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.apple.numbers", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "text/tab-separated-values"]
  }


    sub excel { return File::Groups_spreadsheet_excel }
  
    sub numbers { return File::Groups_spreadsheet_numbers }
  
    sub calc { return File::Groups_spreadsheet_calc }
  

  package File::Groups_document;

  sub extensions {
  return $_[1] ? ["csv", "key", "key-tef", "kth", "apxl", "xls", "xlsx", "xlt", "xltx", "xlw", "xla", "xlsm", "xlsb", "xltm", "xlam", "ppt", "pptx", "pps", "ppsx", "ppa", "ppam", "pptm", "ppsm", "potm", "doc", "docx", "dot", "dotx", "dotm", "docm", "word", "w6w", "numbers", "ods", "ots", "odp", "odt", "ott", "oth", "odm", "page", "pdf", "rtf", "tsv", "tab", "txt", "text"] : ["csv", "key", "key-tef", "xls", "xlsx", "xlt", "xltx", "xlw", "ppt", "pptx", "pps", "ppsx", "doc", "docx", "dot", "dotx", "numbers", "ods", "ots", "odp", "odt", "ott", "page", "pdf", "rtf", "tsv", "txt", "text"]
  }

  sub media_types {
  return $_[1] ? ["text/csv", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-excel.addin.macroenabled.12", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.apple.numbers", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.text-master", "application/pdf", "application/rtf", "text/rtf", "text/tab-separated-values", "text/plain"] : ["text/csv", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.apple.numbers", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/pdf", "application/rtf", "text/rtf", "text/tab-separated-values", "text/plain"]
  }


    sub keynote { return File::Groups_document_keynote }
  
    sub excel { return File::Groups_document_excel }
  
    sub powerpoint { return File::Groups_document_powerpoint }
  
    sub word { return File::Groups_document_word }
  
    sub numbers { return File::Groups_document_numbers }
  
    sub calc { return File::Groups_document_calc }
  
    sub impress { return File::Groups_document_impress }
  
    sub writer { return File::Groups_document_writer }
  
    sub pages { return File::Groups_document_pages }
  
    sub pdf { return File::Groups_document_pdf }
  

  package File::Groups_project_management;

  sub extensions {
  return $_[1] ? ["gan", "mpp", "mpt"] : ["gan", "mpp", "mpt"]
  }

  sub media_types {
  return $_[1] ? ["application/vnd.ms-project"] : ["application/vnd.ms-project"]
  }



  package File::Groups_presentation;

  sub extensions {
  return $_[1] ? ["key", "key-tef", "kth", "apxl", "ppt", "pptx", "pps", "ppsx", "ppa", "ppam", "pptm", "ppsm", "potm", "odp"] : ["key", "key-tef", "ppt", "pptx", "pps", "ppsx", "odp"]
  }

  sub media_types {
  return $_[1] ? ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12", "application/vnd.oasis.opendocument.presentation"] : ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.oasis.opendocument.presentation"]
  }


    sub keynote { return File::Groups_presentation_keynote }
  
    sub powerpoint { return File::Groups_presentation_powerpoint }
  
    sub impress { return File::Groups_presentation_impress }
  

  package File::Groups_diagramming;

  sub extensions {
  return $_[1] ? ["vsd", "vst", "vsw", "vss"] : ["vsd", "vst"]
  }

  sub media_types {
  return $_[1] ? ["application/vnd.visio"] : ["application/vnd.visio"]
  }


    sub visio { return File::Groups_diagramming_visio }
  

  package File::Groups_word_processing;

  sub extensions {
  return $_[1] ? ["doc", "docx", "dot", "dotx", "dotm", "docm", "word", "w6w", "odt", "ott", "oth", "odm", "page", "rtf", "txt", "text", "wpd"] : ["doc", "docx", "dot", "dotx", "odt", "ott", "page", "rtf", "txt", "text", "wpd"]
  }

  sub media_types {
  return $_[1] ? ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.text-master", "application/rtf", "text/rtf", "text/plain", "application/vnd.wordperfect"] : ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/rtf", "text/rtf", "text/plain", "application/vnd.wordperfect"]
  }


    sub word { return File::Groups_word_processing_word }
  
    sub writer { return File::Groups_word_processing_writer }
  
    sub pages { return File::Groups_word_processing_pages }
  
    sub word_perfect { return File::Groups_word_processing_word_perfect }
  




    package File::Groups_graphics_editor_vector;

    sub extensions {
    return $_[1] ? ["ai", "cdr", "eps", "epsf", "ps", "sketch"] : ["ai", "cdr", "eps", "ps", "sketch"]
    }
    sub media_types {
    return $_[1] ? ["application/postscript"] : ["application/postscript"]
    }
  
    package File::Groups_graphics_editor_raster;

    sub extensions {
    return $_[1] ? ["psd", "xcf"] : ["psd", "xcf"]
    }
    sub media_types {
    return $_[1] ? ["image/vnd.adobe.photoshop", "image/x-xcf"] : ["image/vnd.adobe.photoshop", "image/x-xcf"]
    }
  



    package File::Groups_image_raster;

    sub extensions {
    return $_[1] ? ["bmp", "dib", "gif", "ico", "jpe", "jpeg", "jpg", "ppm", "tif", "tiff", "webp"] : ["bmp", "gif", "ico", "jpeg", "jpg", "tif", "tiff", "webp"]
    }
    sub media_types {
    return $_[1] ? ["image/bmp", "image/x-ms-bmp", "image/gif", "image/x-icon", "image/vnd.microsoft.icon", "image/jpeg", "image/x-portable-pixmap", "image/tiff", "image/webp"] : ["image/bmp", "image/x-ms-bmp", "image/gif", "image/x-icon", "image/vnd.microsoft.icon", "image/jpeg", "image/tiff", "image/webp"]
    }
  
    package File::Groups_image_web;

    sub extensions {
    return $_[1] ? ["gif", "jpe", "jpeg", "jpg", "png", "svg"] : ["gif", "jpeg", "jpg", "png", "svg"]
    }
    sub media_types {
    return $_[1] ? ["image/gif", "image/jpeg", "image/png", "image/svg+xml"] : ["image/gif", "image/jpeg", "image/png", "image/svg+xml"]
    }
  
    package File::Groups_image_vector;

    sub extensions {
    return $_[1] ? ["svg"] : ["svg"]
    }
    sub media_types {
    return $_[1] ? ["image/svg+xml"] : ["image/svg+xml"]
    }
  

    package File::Groups_spreadsheet_excel;

    sub extensions {
    return $_[1] ? ["xls", "xlsx", "xlt", "xltx", "xlw", "xla", "xlsm", "xlsb", "xltm", "xlam"] : ["xls", "xlsx", "xlt", "xltx", "xlw"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-excel.addin.macroenabled.12"] : ["application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template"]
    }
  
    package File::Groups_spreadsheet_numbers;

    sub extensions {
    return $_[1] ? ["numbers"] : ["numbers"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.apple.numbers"] : ["application/vnd.apple.numbers"]
    }
  
    package File::Groups_spreadsheet_calc;

    sub extensions {
    return $_[1] ? ["ods", "ots"] : ["ods", "ots"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template"] : ["application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template"]
    }
  

    package File::Groups_document_keynote;

    sub extensions {
    return $_[1] ? ["key", "key-tef", "kth", "apxl"] : ["key", "key-tef"]
    }
    sub media_types {
    return $_[1] ? [] : []
    }
  
    package File::Groups_document_excel;

    sub extensions {
    return $_[1] ? ["xls", "xlsx", "xlt", "xltx", "xlw", "xla", "xlsm", "xlsb", "xltm", "xlam"] : ["xls", "xlsx", "xlt", "xltx", "xlw"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-excel.addin.macroenabled.12"] : ["application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template"]
    }
  
    package File::Groups_document_powerpoint;

    sub extensions {
    return $_[1] ? ["ppt", "pptx", "pps", "ppsx", "ppa", "ppam", "pptm", "ppsm", "potm"] : ["ppt", "pptx", "pps", "ppsx"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12"] : ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow"]
    }
  
    package File::Groups_document_word;

    sub extensions {
    return $_[1] ? ["doc", "docx", "dot", "dotx", "dotm", "docm", "word", "w6w"] : ["doc", "docx", "dot", "dotx"]
    }
    sub media_types {
    return $_[1] ? ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12"] : ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template"]
    }
  
    package File::Groups_document_numbers;

    sub extensions {
    return $_[1] ? ["numbers"] : ["numbers"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.apple.numbers"] : ["application/vnd.apple.numbers"]
    }
  
    package File::Groups_document_calc;

    sub extensions {
    return $_[1] ? ["ods", "ots"] : ["ods", "ots"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template"] : ["application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template"]
    }
  
    package File::Groups_document_impress;

    sub extensions {
    return $_[1] ? ["odp"] : ["odp"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.presentation"] : ["application/vnd.oasis.opendocument.presentation"]
    }
  
    package File::Groups_document_writer;

    sub extensions {
    return $_[1] ? ["odt", "ott", "oth", "odm"] : ["odt", "ott"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.text-master"] : ["application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template"]
    }
  
    package File::Groups_document_pages;

    sub extensions {
    return $_[1] ? ["page"] : ["page"]
    }
    sub media_types {
    return $_[1] ? [] : []
    }
  
    package File::Groups_document_pdf;

    sub extensions {
    return $_[1] ? ["pdf"] : ["pdf"]
    }
    sub media_types {
    return $_[1] ? ["application/pdf"] : ["application/pdf"]
    }
  


    package File::Groups_presentation_keynote;

    sub extensions {
    return $_[1] ? ["key", "key-tef", "kth", "apxl"] : ["key", "key-tef"]
    }
    sub media_types {
    return $_[1] ? [] : []
    }
  
    package File::Groups_presentation_powerpoint;

    sub extensions {
    return $_[1] ? ["ppt", "pptx", "pps", "ppsx", "ppa", "ppam", "pptm", "ppsm", "potm"] : ["ppt", "pptx", "pps", "ppsx"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12"] : ["application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow"]
    }
  
    package File::Groups_presentation_impress;

    sub extensions {
    return $_[1] ? ["odp"] : ["odp"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.presentation"] : ["application/vnd.oasis.opendocument.presentation"]
    }
  

    package File::Groups_diagramming_visio;

    sub extensions {
    return $_[1] ? ["vsd", "vst", "vsw", "vss"] : ["vsd", "vst"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.visio"] : ["application/vnd.visio"]
    }
  

    package File::Groups_word_processing_word;

    sub extensions {
    return $_[1] ? ["doc", "docx", "dot", "dotx", "dotm", "docm", "word", "w6w"] : ["doc", "docx", "dot", "dotx"]
    }
    sub media_types {
    return $_[1] ? ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12"] : ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template"]
    }
  
    package File::Groups_word_processing_writer;

    sub extensions {
    return $_[1] ? ["odt", "ott", "oth", "odm"] : ["odt", "ott"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.text-master"] : ["application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template"]
    }
  
    package File::Groups_word_processing_pages;

    sub extensions {
    return $_[1] ? ["page"] : ["page"]
    }
    sub media_types {
    return $_[1] ? [] : []
    }
  
    package File::Groups_word_processing_word_perfect;

    sub extensions {
    return $_[1] ? ["wpd"] : ["wpd"]
    }
    sub media_types {
    return $_[1] ? ["application/vnd.wordperfect"] : ["application/vnd.wordperfect"]
    }
  

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

File::Groups - File extensions and media types, grouped by application and type

=head1 SYNOPSIS

Methods on C<File::Groups> return classes containing a set of media
types and file extensions. These are accessible via the C<media_types> and C<extensions>
methods, which return Array refs of values. By default only commonly used values are returned.
To return all know values pass C<1> to either method, e.g., C<< class->media_types(1) >>

In some cases additional methods can be called on the object to further restrict the set.

Let's look at some examples.

=head2 IMAGES & VIDEO

Retrieve a list of file extensions or media types used by images and video:

 use File::Groups;

 File::Groups->image->extensions;   # ['bmp', 'gif', 'ico', 'jpeg', ... ]
 File::Groups->image->media_types;  # ['image/bmp', 'image/x-ms-bmp', 'image/gif', ... ]
 File::Groups->video->extensions;   # ['asf', 'mov', 'qt', 'movie', ... ]
 File::Groups->video->media_types;  # ['video/x-ms-asf', 'video/quicktime', ... ]

Images can be filtered on by raster, vector, or web:

 File::Groups->image->web->extensions;     # ['gif', 'jpeg', 'jpg', 'png', 'svg', 'webp']
 File::Groups->image->raster->extensions;  # ['bmp', 'gif', 'ico', 'jpeg', 'jpg', 'tif', 'tiff', 'webp']
 File::Groups->image->vector->extensions;  # ['svg']

For a complete list pass C<1> to any of these methods:

 File::Groups->image->web->extensions(1);  # ['bmp', 'dib', 'gif', 'ico', 'jfif', 'jpe', 'jpeg', ... ]

=head2 SPREADSHEETS

Retrieve a list of file extensions or media types used by spreadsheets:

 use File::Groups;

 File::Groups->spreadsheet->extensions;  # ['csv', 'xls', 'xlsx', 'xlt', ... ]
 File::Groups->spreadsheet->media_types; # ['text/csv', 'application/vnd.ms-excel', ... ]

If you only want values specific to Microsoft Excel:

 File::Groups->spreadsheet->excel->extensions;  # ['xls', 'xlsx', 'xlt', 'xltx', 'xlw']
 File::Groups->spreadsheet->excel->media_types; # ['application/vnd.ms-excel', ... ]

Or for OpenOffice Calc:

 File::Groups->spreadsheet->calc->extensions;  # ['ods', 'ots']

By default these only return common extensions, to return all:

  File::Groups->spreadsheet->excel->extensions(1);  # ['xls', 'xlsx', 'xlt', 'xltx', ... ]

=head2 EVERYTHING ELSE

See L<https://github.com/sshaw/file_groups/blob/master/README.md#groups|the list of categories and tags>.

=head1 AUTHOR

Skye Shaw (skye.shaw -AT- gmail)

=head1 COPYRIGHT

Copyright (c) 2020 Skye Shaw. All rights reserved.

=head1 LICENSE

https://opensource.org/licenses/MIT
