use Test::More;
use Data::Dumper;
use lib '.';

use PerlIO::via::YAML;

my $file = 'test.yml';
my $struct = {
	a => "b",
	c => "d"
};

do {
	open my $fh, '>:via(PerlIO::via::YAML)', $file or die $!;

	prints $fh $struct;

	close $fh;

	open my $ih, '<:via(PerlIO::via::YAML)', $file or die $!;

	my $in = load $ih; 

	close $ih;

	is_deeply($in, $struct);
};

do {
	open my $fh, '>:via(YAML)', $file or die $!;

	prints $fh $struct;

	close $fh;

	open my $ih, '<:via(YAML)', $file or die $!;

	my $in = load $ih; 

	close $ih;

	is_deeply($in, $struct);
};


done_testing;
