# created by util/generate at Wed Jun 29 13:27:49 2022
# cpan-security-advisory 539ac7e90a4b6b403a3ae2c067cf21954abedba3
#
package CPAN::Audit::DB;

use strict;
use warnings;

our $VERSION = '20220629.003';

sub db {
    {
          'dists' => {
                       'ActivePerl' => {
                                         'advisories' => [
                                                           {
                                                             'affected_versions' => '5.16.1.1601',
                                                             'cves' => [
                                                                         'CVE-2012-5377'
                                                                       ],
                                                             'description' => 'Untrusted search path vulnerability in the installation functionality in ActivePerl 5.16.1.1601, when installed in the top-level C:\\ directory, allows local users to gain privileges via a Trojan horse DLL in the C:\\Perl\\Site\\bin directory, which is added to the PATH system environment variable, as demonstrated by a Trojan horse wlbsctrl.dll file used by the "IKE and AuthIP IPsec Keying Modules" system service in Windows Vista SP1, Windows Server 2008 SP2, Windows 7 SP1, and Windows 8 Release Preview.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2012-5377',
                                                             'references' => [
                                                                               'https://www.htbridge.com/advisory/HTB23108',
                                                                               'http://osvdb.org/86177'
                                                                             ],
                                                             'reported' => '2012-10-11',
                                                             'severity' => undef
                                                           },
                                                           {
                                                             'affected_versions' => '5.8.8.817',
                                                             'cves' => [
                                                                         'CVE-2006-2856'
                                                                       ],
                                                             'description' => 'ActiveState ActivePerl 5.8.8.817 for Windows configures the site/lib directory with "Users" group permissions for changing files, which allows local users to gain privileges by creating a malicious sitecustomize.pl file in that directory.  NOTE: The provenance of this information is unknown; the details are obtained solely from third party information.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2006-2856',
                                                             'references' => [
                                                                               'http://secunia.com/advisories/20328',
                                                                               'http://www.securityfocus.com/bid/18269',
                                                                               'http://www.osvdb.org/25974',
                                                                               'http://www.vupen.com/english/advisories/2006/2140',
                                                                               'https://exchange.xforce.ibmcloud.com/vulnerabilities/26915'
                                                                             ],
                                                             'reported' => '2006-06-06',
                                                             'severity' => undef
                                                           },
                                                           {
                                                             'affected_versions' => undef,
                                                             'cves' => [
                                                                         'CVE-2004-2286'
                                                                       ],
                                                             'description' => 'Integer overflow in the duplication operator in ActivePerl allows remote attackers to cause a denial of service (crash) and possibly execute arbitrary code via a large multiplier, which may trigger a buffer overflow.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2004-2286',
                                                             'references' => [
                                                                               'http://archives.neohapsis.com/archives/fulldisclosure/2004-05/0878.html',
                                                                               'http://www.securityfocus.com/bid/10380',
                                                                               'https://exchange.xforce.ibmcloud.com/vulnerabilities/16224'
                                                                             ],
                                                             'reported' => '2004-12-31',
                                                             'severity' => undef
                                                           },
                                                           {
                                                             'affected_versions' => '<5.10',
                                                             'cves' => [
                                                                         'CVE-2004-2022'
                                                                       ],
                                                             'description' => 'ActivePerl 5.8.x and others, and Larry Wall\'s Perl 5.6.1 and others, when running on Windows systems, allows attackers to cause a denial of service (crash) and possibly execute arbitrary code via a long argument to the system command, which leads to a stack-based buffer overflow.  NOTE: it is unclear whether this bug is in Perl or the OS API that is used by Perl.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2004-2022',
                                                             'references' => [
                                                                               'http://www.oliverkarow.de/research/ActivePerlSystemBOF.txt',
                                                                               'http://www.perlmonks.org/index.pl?node_id=354145',
                                                                               'http://www.securityfocus.com/bid/10375',
                                                                               'http://archives.neohapsis.com/archives/fulldisclosure/2004-05/0905.html',
                                                                               'http://marc.info/?l=full-disclosure&m=108489112131099&w=2',
                                                                               'http://marc.info/?l=full-disclosure&m=108482796105922&w=2',
                                                                               'http://marc.info/?l=full-disclosure&m=108483058514596&w=2',
                                                                               'http://marc.info/?l=bugtraq&m=108489894009025&w=2',
                                                                               'https://exchange.xforce.ibmcloud.com/vulnerabilities/16169'
                                                                             ],
                                                             'reported' => '2004-12-31',
                                                             'severity' => undef
                                                           },
                                                           {
                                                             'affected_versions' => undef,
                                                             'cves' => [
                                                                         'CVE-2004-0377'
                                                                       ],
                                                             'description' => 'Buffer overflow in the win32_stat function for (1) ActiveState\'s ActivePerl and (2) Larry Wall\'s Perl before 5.8.3 allows local or remote attackers to execute arbitrary commands via filenames that end in a backslash character.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2004-0377',
                                                             'references' => [
                                                                               'http://www.kb.cert.org/vuls/id/722414',
                                                                               'http://lists.grok.org.uk/pipermail/full-disclosure/2004-April/019794.html',
                                                                               'http://public.activestate.com/cgi-bin/perlbrowse?patch=22552',
                                                                               'http://www.idefense.com/application/poi/display?id=93&type=vulnerabilities',
                                                                               'http://marc.info/?l=bugtraq&m=108118694327979&w=2',
                                                                               'https://exchange.xforce.ibmcloud.com/vulnerabilities/15732'
                                                                             ],
                                                             'reported' => '2004-05-04',
                                                             'severity' => undef
                                                           },
                                                           {
                                                             'affected_versions' => '<=5.6.1.629',
                                                             'cves' => [
                                                                         'CVE-2001-0815'
                                                                       ],
                                                             'description' => 'Buffer overflow in PerlIS.dll in Activestate ActivePerl 5.6.1.629 and earlier allows remote attackers to execute arbitrary code via an HTTP request for a long filename that ends in a .pl extension.
',
                                                             'distribution' => 'ActivePerl',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-ActivePerl-2001-0815',
                                                             'references' => [
                                                                               'http://bugs.activestate.com/show_bug.cgi?id=18062',
                                                                               'http://www.securityfocus.com/bid/3526',
                                                                               'http://www.osvdb.org/678',
                                                                               'http://marc.info/?l=bugtraq&m=100583978302585&w=2',
                                                                               'https://exchange.xforce.ibmcloud.com/vulnerabilities/7539'
                                                                             ],
                                                             'reported' => '2001-12-06',
                                                             'severity' => undef
                                                           }
                                                         ],
                                         'main_module' => undef,
                                         'versions' => []
                                       },
                       'Apache-AuthCAS' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<0.5',
                                                                 'cves' => [
                                                                             'CVE-2007-6342'
                                                                           ],
                                                                 'description' => 'A tainted cookie could be sent by a malicious user and it would be used in an SQL query without protection against SQL injection.
',
                                                                 'distribution' => 'Apache-AuthCAS',
                                                                 'fixed_versions' => '>=0.5',
                                                                 'id' => 'CPANSA-Apache-AuthCAS-2007-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Apache-AuthCAS',
                                                                                   'https://cxsecurity.com/issue/WLB-2007120031'
                                                                                 ],
                                                                 'reported' => '2007-12-13',
                                                                 'severity' => 'high'
                                                               }
                                                             ],
                                             'main_module' => 'Apache::AuthCAS',
                                             'versions' => [
                                                             {
                                                               'date' => '2004-09-15T19:17:43',
                                                               'version' => '0.1'
                                                             },
                                                             {
                                                               'date' => '2004-09-15T20:11:40',
                                                               'version' => '0.2'
                                                             },
                                                             {
                                                               'date' => '2004-10-05T22:51:50',
                                                               'version' => '0.3'
                                                             },
                                                             {
                                                               'date' => '2004-10-13T00:45:52',
                                                               'version' => '0.4'
                                                             },
                                                             {
                                                               'date' => '2008-03-23T23:03:16',
                                                               'version' => '0.5'
                                                             }
                                                           ]
                                           },
                       'Apache-AuthenHook' => {
                                                'advisories' => [
                                                                  {
                                                                    'affected_versions' => '>=2.00_04',
                                                                    'cves' => [
                                                                                'CVE-2010-3845'
                                                                              ],
                                                                    'description' => 'libapache-authenhook-perl 2.00-04 stores usernames and passwords in plaintext in the vhost error log.
',
                                                                    'distribution' => 'Apache-AuthenHook',
                                                                    'fixed_versions' => undef,
                                                                    'id' => 'CPANSA-Apache-AuthenHook-2010-3845',
                                                                    'references' => [
                                                                                      'https://rt.cpan.org/Public/Bug/Display.html?id=62040',
                                                                                      'https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=599712',
                                                                                      'http://seclists.org/oss-sec/2010/q4/63'
                                                                                    ],
                                                                    'reported' => '2017-08-08',
                                                                    'severity' => 'critical'
                                                                  }
                                                                ],
                                                'main_module' => undef,
                                                'versions' => [
                                                                {
                                                                  'date' => '2003-06-20T19:05:21',
                                                                  'version' => '2.00_01'
                                                                },
                                                                {
                                                                  'date' => '2004-04-06T01:20:10',
                                                                  'version' => '2.00_03'
                                                                },
                                                                {
                                                                  'date' => '2005-04-14T12:57:55',
                                                                  'version' => '2.00_04'
                                                                }
                                                              ]
                                              },
                       'Apache-SessionX' => {
                                              'advisories' => [
                                                                {
                                                                  'affected_versions' => '<2.01',
                                                                  'cves' => [],
                                                                  'description' => 'Problem in session_id validation, which allows creation of session with invalid ids.
',
                                                                  'distribution' => 'Apache-SessionX',
                                                                  'fixed_versions' => '>=2.01',
                                                                  'id' => 'CPANSA-Apache-SessionX-2005-01',
                                                                  'references' => [
                                                                                    'https://metacpan.org/changes/distribution/Apache-SessionX'
                                                                                  ],
                                                                  'reported' => '2005-11-15'
                                                                }
                                                              ],
                                              'main_module' => 'Apache::SessionX',
                                              'versions' => [
                                                              {
                                                                'date' => '2001-11-20T15:36:53',
                                                                'version' => '2.00'
                                                              },
                                                              {
                                                                'date' => '2003-03-02T14:18:57',
                                                                'version' => '2.00'
                                                              },
                                                              {
                                                                'date' => '2005-11-15T05:21:49',
                                                                'version' => '2.01'
                                                              }
                                                            ]
                                            },
                       'App-Context' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '>-0.01,<=0.968',
                                                              'cves' => [
                                                                          'CVE-2012-6141'
                                                                        ],
                                                              'description' => 'The App::Context module 0.01 through 0.968 for Perl does not properly use the Storable::thaw function, which allows remote attackers to execute arbitrary code via a crafted request to (1) App::Session::Cookie or (2) App::Session::HTMLHidden, which is not properly handled when it is deserialized.
',
                                                              'distribution' => 'App-Context',
                                                              'fixed_versions' => '>0.968',
                                                              'id' => 'CPANSA-App-Context-2012-6141',
                                                              'references' => [
                                                                                'http://seclists.org/oss-sec/2013/q2/318',
                                                                                'https://exchange.xforce.ibmcloud.com/vulnerabilities/84198'
                                                                              ],
                                                              'reported' => '2014-06-04',
                                                              'severity' => undef
                                                            }
                                                          ],
                                          'main_module' => 'App::Context',
                                          'versions' => [
                                                          {
                                                            'date' => '2002-10-10T21:31:39',
                                                            'version' => '0.01'
                                                          },
                                                          {
                                                            'date' => '2004-09-02T21:17:44',
                                                            'version' => '0.90'
                                                          },
                                                          {
                                                            'date' => '2005-01-07T14:02:06',
                                                            'version' => '0.93'
                                                          },
                                                          {
                                                            'date' => '2005-08-09T20:05:02',
                                                            'version' => '0.95'
                                                          },
                                                          {
                                                            'date' => '2006-03-10T04:24:13',
                                                            'version' => '0.96'
                                                          },
                                                          {
                                                            'date' => '2006-03-12T01:30:11',
                                                            'version' => '0.962'
                                                          },
                                                          {
                                                            'date' => '2006-07-25T02:30:21',
                                                            'version' => '0.963'
                                                          },
                                                          {
                                                            'date' => '2006-09-04T19:41:12',
                                                            'version' => '0.964'
                                                          },
                                                          {
                                                            'date' => '2007-04-17T13:33:24',
                                                            'version' => '0.965'
                                                          },
                                                          {
                                                            'date' => '2008-02-27T03:13:41',
                                                            'version' => '0.966'
                                                          },
                                                          {
                                                            'date' => '2008-02-27T14:19:23',
                                                            'version' => '0.9661'
                                                          },
                                                          {
                                                            'date' => '2009-09-11T14:31:52',
                                                            'version' => '0.967'
                                                          },
                                                          {
                                                            'date' => '2010-06-09T21:33:19',
                                                            'version' => '0.968'
                                                          }
                                                        ]
                                        },
                       'App-Github-Email' => {
                                               'advisories' => [
                                                                 {
                                                                   'affected_versions' => '<0.3.3',
                                                                   'cves' => [
                                                                               'CVE-2015-7686'
                                                                             ],
                                                                   'description' => 'Insecure dependency on Email::Address.
',
                                                                   'distribution' => 'App-Github-Email',
                                                                   'fixed_versions' => '>=0.3.3',
                                                                   'id' => 'CPANSA-App-Github-Email-2018-01',
                                                                   'references' => [
                                                                                     'https://metacpan.org/changes/distribution/App-Github-Email',
                                                                                     'https://github.com/faraco/App-Github-Email/commit/b7f052280d1c8ae97bdefc106ca3cbba4aea7213'
                                                                                   ],
                                                                   'reported' => '2018-01-20'
                                                                 }
                                                               ],
                                               'main_module' => 'App::Github::Email',
                                               'versions' => [
                                                               {
                                                                 'date' => '2017-01-16T08:03:02',
                                                                 'version' => '0.0.1'
                                                               },
                                                               {
                                                                 'date' => '2017-01-16T12:56:51',
                                                                 'version' => '0.0.2'
                                                               },
                                                               {
                                                                 'date' => '2017-01-16T17:38:16',
                                                                 'version' => '0.0.3'
                                                               },
                                                               {
                                                                 'date' => '2017-03-11T10:45:23',
                                                                 'version' => '0.0.4'
                                                               },
                                                               {
                                                                 'date' => '2017-04-05T11:19:02',
                                                                 'version' => '0.0.5'
                                                               },
                                                               {
                                                                 'date' => '2017-04-15T17:35:18',
                                                                 'version' => '0.0.6'
                                                               },
                                                               {
                                                                 'date' => '2017-05-19T05:05:24',
                                                                 'version' => '0.0.7'
                                                               },
                                                               {
                                                                 'date' => '2017-12-18T14:11:19',
                                                                 'version' => '0.1.0'
                                                               },
                                                               {
                                                                 'date' => '2017-12-21T08:24:12',
                                                                 'version' => '0.1.1'
                                                               },
                                                               {
                                                                 'date' => '2018-01-15T03:18:05',
                                                                 'version' => '0.2.0'
                                                               },
                                                               {
                                                                 'date' => '2018-01-20T12:55:34',
                                                                 'version' => '0.2.1'
                                                               },
                                                               {
                                                                 'date' => '2018-08-30T16:07:18',
                                                                 'version' => '0.3.1'
                                                               },
                                                               {
                                                                 'date' => '2018-08-30T16:13:54',
                                                                 'version' => '0.3.2'
                                                               },
                                                               {
                                                                 'date' => '2018-08-31T03:49:31',
                                                                 'version' => '0.3.3'
                                                               }
                                                             ]
                                             },
                       'App-Netdisco' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<2.052003',
                                                               'cves' => [
                                                                           'CVE-2022-24785'
                                                                         ],
                                                               'description' => 'Moment.js is a JavaScript date library for parsing, validating, manipulating, and formatting dates. A path traversal vulnerability impacts npm (server) users of Moment.js between versions 1.0.1 and 2.29.1, especially if a user-provided locale string is directly used to switch moment locale. This problem is patched in 2.29.2, and the patch can be applied to all affected versions. As a workaround, sanitize the user-provided locale name before passing it to Moment.js.
',
                                                               'distribution' => 'App-Netdisco',
                                                               'embedded_vulnerability' => {
                                                                                             'distributed_version' => '2.1.0',
                                                                                             'name' => 'moment.js'
                                                                                           },
                                                               'fixed_versions' => '>=2.052005',
                                                               'id' => 'CPANSA-App-Netdisco-2022-24785',
                                                               'references' => [
                                                                                 'https://github.com/moment/moment/commit/4211bfc8f15746be4019bba557e29a7ba83d54c5',
                                                                                 'https://github.com/moment/moment/security/advisories/GHSA-8hfj-j24r-96c4',
                                                                                 'https://www.tenable.com/security/tns-2022-09',
                                                                                 'https://security.netapp.com/advisory/ntap-20220513-0006/'
                                                                               ],
                                                               'reported' => '2022-04-04',
                                                               'reviewed_by' => [
                                                                                  {
                                                                                    'date' => '2022-06-28',
                                                                                    'email' => 'rrwo@cpan.org',
                                                                                    'name' => 'Robert Rothenberg'
                                                                                  }
                                                                                ],
                                                               'severity' => 'high'
                                                             },
                                                             {
                                                               'affected_versions' => '<2.044003',
                                                               'cves' => [
                                                                           'CVE-2019-11358'
                                                                         ],
                                                               'description' => 'jQuery before 3.4.0, as used in Drupal, Backdrop CMS, and other products, mishandles jQuery.extend(true, {}, ...) because of Object.prototype pollution. If an unsanitized source object contained an enumerable __proto__ property, it could extend the native Object.prototype.
',
                                                               'distribution' => 'App-Netdisco',
                                                               'embedded_vulnerability' => {
                                                                                             'distributed_version' => '2.1.0',
                                                                                             'name' => 'jquery'
                                                                                           },
                                                               'fixed_versions' => '>=2.044003',
                                                               'id' => 'CPANSA-App-Netdisco-2019-11358',
                                                               'references' => [
                                                                                 'https://www.drupal.org/sa-core-2019-006',
                                                                                 'https://snyk.io/vuln/SNYK-JS-JQUERY-174006',
                                                                                 'https://github.com/jquery/jquery/pull/4333',
                                                                                 'https://github.com/jquery/jquery/commit/753d591aea698e57d6db58c9f722cd0808619b1b',
                                                                                 'https://blog.jquery.com/2019/04/10/jquery-3-4-0-released/',
                                                                                 'https://backdropcms.org/security/backdrop-sa-core-2019-009',
                                                                                 'https://www.debian.org/security/2019/dsa-4434',
                                                                                 'https://seclists.org/bugtraq/2019/Apr/32',
                                                                                 'http://www.securityfocus.com/bid/108023',
                                                                                 'https://lists.apache.org/thread.html/b736d0784cf02f5a30fbb4c5902762a15ad6d47e17e2c5a17b7d6205@%3Ccommits.airflow.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/08720ef215ee7ab3386c05a1a90a7d1c852bf0706f176a7816bf65fc@%3Ccommits.airflow.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/88fb0362fd40e5b605ea8149f63241537b8b6fb5bfa315391fc5cbb7@%3Ccommits.airflow.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/6097cdbd6f0a337bedd9bb5cc441b2d525ff002a96531de367e4259f@%3Ccommits.airflow.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/5928aa293e39d248266472210c50f176cac1535220f2486e6a7fa844@%3Ccommits.airflow.apache.org%3E',
                                                                                 'https://lists.debian.org/debian-lts-announce/2019/05/msg00006.html',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/5IABSKTYZ5JUGL735UKGXL5YPRYOPUYI/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/4UOAZIFCSZ3ENEFOR5IXX6NFAD3HV7FA/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/KYH3OAGR2RTCHRA5NOKX2TES7SNQMWGO/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/RLXRX23725JL366CNZGJZ7AQQB7LHQ6F/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/WZW27UCJ5CYFL4KFFFMYMIBNMIU2ALG5/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/QV3PKZC3PQCO3273HAT76PAQZFBEO4KP/',
                                                                                 'https://seclists.org/bugtraq/2019/May/18',
                                                                                 'http://packetstormsecurity.com/files/152787/dotCMS-5.1.1-Vulnerable-Dependencies.html',
                                                                                 'http://seclists.org/fulldisclosure/2019/May/13',
                                                                                 'http://seclists.org/fulldisclosure/2019/May/11',
                                                                                 'http://seclists.org/fulldisclosure/2019/May/10',
                                                                                 'https://lists.debian.org/debian-lts-announce/2019/05/msg00029.html',
                                                                                 'http://www.openwall.com/lists/oss-security/2019/06/03/2',
                                                                                 'http://packetstormsecurity.com/files/153237/RetireJS-CORS-Issue-Script-Execution.html',
                                                                                 'https://access.redhat.com/errata/RHSA-2019:1456',
                                                                                 'https://www.debian.org/security/2019/dsa-4460',
                                                                                 'https://seclists.org/bugtraq/2019/Jun/12',
                                                                                 'https://www.oracle.com/technetwork/security-advisory/cpujul2019-5072835.html',
                                                                                 'https://www.privacy-wise.com/mitigating-cve-2019-11358-in-old-versions-of-jquery/',
                                                                                 'http://lists.opensuse.org/opensuse-security-announce/2019-08/msg00006.html',
                                                                                 'https://access.redhat.com/errata/RHBA-2019:1570',
                                                                                 'http://lists.opensuse.org/opensuse-security-announce/2019-08/msg00025.html',
                                                                                 'https://lists.apache.org/thread.html/ba79cf1658741e9f146e4c59b50aee56656ea95d841d358d006c18b6@%3Ccommits.roller.apache.org%3E',
                                                                                 'https://access.redhat.com/errata/RHSA-2019:2587',
                                                                                 'https://security.netapp.com/advisory/ntap-20190919-0001/',
                                                                                 'https://access.redhat.com/errata/RHSA-2019:3023',
                                                                                 'https://access.redhat.com/errata/RHSA-2019:3024',
                                                                                 'https://www.oracle.com/technetwork/security-advisory/cpuoct2019-5072832.html',
                                                                                 'https://lists.apache.org/thread.html/b0656d359c7d40ec9f39c8cc61bca66802ef9a2a12ee199f5b0c1442@%3Cdev.drill.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/519eb0fd45642dcecd9ff74cb3e71c20a4753f7d82e2f07864b5108f@%3Cdev.drill.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/f9bc3e55f4e28d1dcd1a69aae6d53e609a758e34d2869b4d798e13cc@%3Cissues.drill.apache.org%3E',
                                                                                 'https://www.synology.com/security/advisory/Synology_SA_19_19',
                                                                                 'https://lists.apache.org/thread.html/bcce5a9c532b386c68dab2f6b3ce8b0cc9b950ec551766e76391caa3@%3Ccommits.nifi.apache.org%3E',
                                                                                 'https://www.tenable.com/security/tns-2019-08',
                                                                                 'https://www.oracle.com/security-alerts/cpujan2020.html',
                                                                                 'https://lists.apache.org/thread.html/rca37935d661f4689cb4119f1b3b224413b22be161b678e6e6ce0c69b@%3Ccommits.nifi.apache.org%3E',
                                                                                 'https://lists.debian.org/debian-lts-announce/2020/02/msg00024.html',
                                                                                 'http://packetstormsecurity.com/files/156743/OctoberCMS-Insecure-Dependencies.html',
                                                                                 'https://www.tenable.com/security/tns-2020-02',
                                                                                 'https://www.oracle.com/security-alerts/cpuapr2020.html',
                                                                                 'https://lists.apache.org/thread.html/r38f0d1aa3c923c22977fe7376508f030f22e22c1379fbb155bf29766@%3Cdev.syncope.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r7aac081cbddb6baa24b75e74abf0929bf309b176755a53e3ed810355@%3Cdev.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/rac25da84ecdcd36f6de5ad0d255f4e967209bbbebddb285e231da37d@%3Cissues.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r2041a75d3fc09dec55adfd95d598b38d22715303f65c997c054844c9@%3Cissues.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r7e8ebccb7c022e41295f6fdb7b971209b83702339f872ddd8cf8bf73@%3Cissues.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r41b5bfe009c845f67d4f68948cc9419ac2d62e287804aafd72892b08@%3Cissues.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r2baacab6e0acb5a2092eb46ae04fd6c3e8277b4fd79b1ffb7f3254fa@%3Cissues.flink.apache.org%3E',
                                                                                 'https://lists.apache.org/thread.html/r7d64895cc4dff84d0becfc572b20c0e4bf9bfa7b10c6f5f73e783734@%3Cdev.storm.apache.org%3E',
                                                                                 'https://www.oracle.com/security-alerts/cpujul2020.html',
                                                                                 'https://www.oracle.com/security-alerts/cpuoct2020.html',
                                                                                 'https://kb.pulsesecure.net/articles/Pulse_Security_Advisories/SA44601',
                                                                                 'https://www.oracle.com/security-alerts/cpujan2021.html',
                                                                                 'https://www.oracle.com/security-alerts/cpuApr2021.html',
                                                                                 'https://www.oracle.com//security-alerts/cpujul2021.html',
                                                                                 'https://www.oracle.com/security-alerts/cpuoct2021.html',
                                                                                 'https://www.oracle.com/security-alerts/cpujan2022.html'
                                                                               ],
                                                               'reported' => '2019-04-20',
                                                               'reviewed_by' => [
                                                                                  {
                                                                                    'date' => '2022-06-28',
                                                                                    'email' => 'rrwo@cpan.org',
                                                                                    'name' => 'Robert Rothenberg'
                                                                                  }
                                                                                ],
                                                               'severity' => 'medium'
                                                             }
                                                           ],
                                           'main_module' => 'App::Netdisco',
                                           'versions' => [
                                                           {
                                                             'date' => '2012-12-20T21:16:29',
                                                             'version' => '2.00_011'
                                                           },
                                                           {
                                                             'date' => '2012-12-21T08:21:35',
                                                             'version' => '2.00_012'
                                                           },
                                                           {
                                                             'date' => '2013-01-05T16:14:21',
                                                             'version' => '2.00_012'
                                                           },
                                                           {
                                                             'date' => '2013-01-06T01:16:03',
                                                             'version' => '2.00_012'
                                                           },
                                                           {
                                                             'date' => '2013-01-06T02:03:22',
                                                             'version' => '2.00_012'
                                                           },
                                                           {
                                                             'date' => '2013-01-14T22:16:29',
                                                             'version' => '2.00_012'
                                                           },
                                                           {
                                                             'date' => '2013-01-30T13:23:14',
                                                             'version' => '2.004002'
                                                           },
                                                           {
                                                             'date' => '2013-02-09T22:37:41',
                                                             'version' => '2.005000_001'
                                                           },
                                                           {
                                                             'date' => '2013-02-10T21:39:04',
                                                             'version' => '2.005000_001'
                                                           },
                                                           {
                                                             'date' => '2013-03-05T23:03:41',
                                                             'version' => '2.005000_003'
                                                           },
                                                           {
                                                             'date' => '2013-03-05T23:21:44',
                                                             'version' => '2.005000_004'
                                                           },
                                                           {
                                                             'date' => '2013-03-07T21:52:05',
                                                             'version' => '2.006000'
                                                           },
                                                           {
                                                             'date' => '2013-03-17T14:50:06',
                                                             'version' => '2.007000_001'
                                                           },
                                                           {
                                                             'date' => '2013-06-03T19:54:38',
                                                             'version' => '2.007000_002'
                                                           },
                                                           {
                                                             'date' => '2013-06-08T20:22:28',
                                                             'version' => '2.007000_003'
                                                           },
                                                           {
                                                             'date' => '2013-06-09T10:31:46',
                                                             'version' => '2.007000_004'
                                                           },
                                                           {
                                                             'date' => '2013-06-09T13:10:45',
                                                             'version' => '2.007000_005'
                                                           },
                                                           {
                                                             'date' => '2013-06-09T14:45:42',
                                                             'version' => '2.008000'
                                                           },
                                                           {
                                                             'date' => '2013-06-11T12:39:12',
                                                             'version' => '2.008001'
                                                           },
                                                           {
                                                             'date' => '2013-06-11T21:55:59',
                                                             'version' => '2.008002'
                                                           },
                                                           {
                                                             'date' => '2013-06-16T17:29:20',
                                                             'version' => '2.009000_001'
                                                           },
                                                           {
                                                             'date' => '2013-06-17T07:18:07',
                                                             'version' => '2.010000'
                                                           },
                                                           {
                                                             'date' => '2013-06-17T22:10:21',
                                                             'version' => '2.010001_001'
                                                           },
                                                           {
                                                             'date' => '2013-06-20T12:55:28',
                                                             'version' => '2.010001_002'
                                                           },
                                                           {
                                                             'date' => '2013-06-20T12:58:16',
                                                             'version' => '2.010001_003'
                                                           },
                                                           {
                                                             'date' => '2013-07-23T23:02:00',
                                                             'version' => '2.010002'
                                                           },
                                                           {
                                                             'date' => '2013-07-24T22:50:05',
                                                             'version' => '2.010004'
                                                           },
                                                           {
                                                             'date' => '2013-07-29T07:04:27',
                                                             'version' => '2.011000'
                                                           },
                                                           {
                                                             'date' => '2013-08-06T17:37:28',
                                                             'version' => '2.012000'
                                                           },
                                                           {
                                                             'date' => '2013-08-06T17:42:25',
                                                             'version' => '2.012001'
                                                           },
                                                           {
                                                             'date' => '2013-08-07T09:06:31',
                                                             'version' => '2.012002'
                                                           },
                                                           {
                                                             'date' => '2013-08-16T16:28:13',
                                                             'version' => '2.012003_001'
                                                           },
                                                           {
                                                             'date' => '2013-08-16T16:48:37',
                                                             'version' => '2.012004'
                                                           },
                                                           {
                                                             'date' => '2013-08-16T16:51:08',
                                                             'version' => '2.012005'
                                                           },
                                                           {
                                                             'date' => '2013-08-23T05:52:12',
                                                             'version' => '2.012006'
                                                           },
                                                           {
                                                             'date' => '2013-08-23T10:29:04',
                                                             'version' => '2.013000'
                                                           },
                                                           {
                                                             'date' => '2013-08-23T11:34:38',
                                                             'version' => '2.013001'
                                                           },
                                                           {
                                                             'date' => '2013-08-26T21:44:14',
                                                             'version' => '2.014000'
                                                           },
                                                           {
                                                             'date' => '2013-09-05T23:57:20',
                                                             'version' => '2.015000'
                                                           },
                                                           {
                                                             'date' => '2013-09-10T22:33:43',
                                                             'version' => '2.016000'
                                                           },
                                                           {
                                                             'date' => '2013-09-11T21:38:31',
                                                             'version' => '2.016001'
                                                           },
                                                           {
                                                             'date' => '2013-09-11T22:15:54',
                                                             'version' => '2.016002'
                                                           },
                                                           {
                                                             'date' => '2013-09-12T07:28:46',
                                                             'version' => '2.016003'
                                                           },
                                                           {
                                                             'date' => '2013-09-23T19:49:48',
                                                             'version' => '2.017000'
                                                           },
                                                           {
                                                             'date' => '2013-10-06T22:38:36',
                                                             'version' => '2.017001_001'
                                                           },
                                                           {
                                                             'date' => '2013-10-07T20:55:41',
                                                             'version' => '2.017001_002'
                                                           },
                                                           {
                                                             'date' => '2013-10-07T22:36:36',
                                                             'version' => '2.017001_003'
                                                           },
                                                           {
                                                             'date' => '2013-10-08T10:28:21',
                                                             'version' => '2.018000'
                                                           },
                                                           {
                                                             'date' => '2013-10-16T22:57:00',
                                                             'version' => '2.018000_001'
                                                           },
                                                           {
                                                             'date' => '2013-10-22T12:44:58',
                                                             'version' => '2.018000_002'
                                                           },
                                                           {
                                                             'date' => '2013-10-22T13:19:30',
                                                             'version' => '2.019000'
                                                           },
                                                           {
                                                             'date' => '2013-10-22T14:41:32',
                                                             'version' => '2.019001'
                                                           },
                                                           {
                                                             'date' => '2013-10-24T04:57:13',
                                                             'version' => '2.019002'
                                                           },
                                                           {
                                                             'date' => '2013-10-27T03:07:39',
                                                             'version' => '2.019003'
                                                           },
                                                           {
                                                             'date' => '2013-12-08T19:46:22',
                                                             'version' => '2.020000'
                                                           },
                                                           {
                                                             'date' => '2013-12-08T21:49:04',
                                                             'version' => '2.020001'
                                                           },
                                                           {
                                                             'date' => '2013-12-11T15:59:18',
                                                             'version' => '2.020002'
                                                           },
                                                           {
                                                             'date' => '2013-12-29T21:34:57',
                                                             'version' => '2.020003_001'
                                                           },
                                                           {
                                                             'date' => '2014-01-01T23:33:18',
                                                             'version' => '2.020003_002'
                                                           },
                                                           {
                                                             'date' => '2014-01-06T20:49:38',
                                                             'version' => '2.020003_003'
                                                           },
                                                           {
                                                             'date' => '2014-01-12T17:36:59',
                                                             'version' => '2.021000'
                                                           },
                                                           {
                                                             'date' => '2014-01-13T00:42:23',
                                                             'version' => '2.021000_001'
                                                           },
                                                           {
                                                             'date' => '2014-01-13T14:02:33',
                                                             'version' => '2.021000_002'
                                                           },
                                                           {
                                                             'date' => '2014-01-13T18:50:36',
                                                             'version' => '2.021000_004'
                                                           },
                                                           {
                                                             'date' => '2014-01-26T13:49:10',
                                                             'version' => '2.022000'
                                                           },
                                                           {
                                                             'date' => '2014-02-10T21:24:32',
                                                             'version' => '2.023000'
                                                           },
                                                           {
                                                             'date' => '2014-02-14T19:41:51',
                                                             'version' => '2.023001'
                                                           },
                                                           {
                                                             'date' => '2014-02-17T13:23:06',
                                                             'version' => '2.023002'
                                                           },
                                                           {
                                                             'date' => '2014-02-22T19:18:19',
                                                             'version' => '2.024000'
                                                           },
                                                           {
                                                             'date' => '2014-02-25T22:36:15',
                                                             'version' => '2.024001'
                                                           },
                                                           {
                                                             'date' => '2014-02-27T17:39:32',
                                                             'version' => '2.024002'
                                                           },
                                                           {
                                                             'date' => '2014-02-27T17:52:08',
                                                             'version' => '2.024003'
                                                           },
                                                           {
                                                             'date' => '2014-03-02T23:30:02',
                                                             'version' => '2.024003_001'
                                                           },
                                                           {
                                                             'date' => '2014-03-04T22:23:50',
                                                             'version' => '2.024004'
                                                           },
                                                           {
                                                             'date' => '2014-03-28T07:32:33',
                                                             'version' => '2.025000_001'
                                                           },
                                                           {
                                                             'date' => '2014-04-08T18:51:46',
                                                             'version' => '2.025001'
                                                           },
                                                           {
                                                             'date' => '2014-04-10T20:17:35',
                                                             'version' => '2.026000'
                                                           },
                                                           {
                                                             'date' => '2014-04-17T06:01:16',
                                                             'version' => '2.026001_001'
                                                           },
                                                           {
                                                             'date' => '2014-04-18T22:35:47',
                                                             'version' => '2.026001_002'
                                                           },
                                                           {
                                                             'date' => '2014-04-20T22:48:43',
                                                             'version' => '2.026001_003'
                                                           },
                                                           {
                                                             'date' => '2014-04-28T21:01:11',
                                                             'version' => '2.026001_004'
                                                           },
                                                           {
                                                             'date' => '2014-05-03T07:27:54',
                                                             'version' => '2.027001'
                                                           },
                                                           {
                                                             'date' => '2014-05-04T09:01:14',
                                                             'version' => '2.027002'
                                                           },
                                                           {
                                                             'date' => '2014-05-15T07:12:35',
                                                             'version' => '2.027003'
                                                           },
                                                           {
                                                             'date' => '2014-05-15T15:55:07',
                                                             'version' => '2.027004'
                                                           },
                                                           {
                                                             'date' => '2014-05-21T20:21:35',
                                                             'version' => '2.027005_001'
                                                           },
                                                           {
                                                             'date' => '2014-05-27T06:05:59',
                                                             'version' => '2.027006'
                                                           },
                                                           {
                                                             'date' => '2014-05-27T09:45:15',
                                                             'version' => '2.027007'
                                                           },
                                                           {
                                                             'date' => '2014-06-23T12:59:01',
                                                             'version' => '2.027008_001'
                                                           },
                                                           {
                                                             'date' => '2014-07-02T08:20:20',
                                                             'version' => '2.028000'
                                                           },
                                                           {
                                                             'date' => '2014-07-13T17:55:04',
                                                             'version' => '2.028001'
                                                           },
                                                           {
                                                             'date' => '2014-07-13T20:59:54',
                                                             'version' => '2.028002_001'
                                                           },
                                                           {
                                                             'date' => '2014-07-15T16:10:41',
                                                             'version' => '2.028003'
                                                           },
                                                           {
                                                             'date' => '2014-07-16T07:05:29',
                                                             'version' => '2.028004'
                                                           },
                                                           {
                                                             'date' => '2014-07-17T13:25:34',
                                                             'version' => '2.028005'
                                                           },
                                                           {
                                                             'date' => '2014-07-21T08:09:06',
                                                             'version' => '2.028006'
                                                           },
                                                           {
                                                             'date' => '2014-07-22T07:01:44',
                                                             'version' => '2.028008'
                                                           },
                                                           {
                                                             'date' => '2014-07-22T21:40:24',
                                                             'version' => '2.028010'
                                                           },
                                                           {
                                                             'date' => '2014-07-22T21:49:10',
                                                             'version' => '2.028011'
                                                           },
                                                           {
                                                             'date' => '2014-07-22T22:21:11',
                                                             'version' => '2.028012'
                                                           },
                                                           {
                                                             'date' => '2014-07-30T23:57:34',
                                                             'version' => '2.028013'
                                                           },
                                                           {
                                                             'date' => '2014-08-08T06:35:55',
                                                             'version' => '2.029000_001'
                                                           },
                                                           {
                                                             'date' => '2014-08-08T21:43:46',
                                                             'version' => '2.029000_002'
                                                           },
                                                           {
                                                             'date' => '2014-08-10T20:21:10',
                                                             'version' => '2.029001'
                                                           },
                                                           {
                                                             'date' => '2014-08-10T20:37:39',
                                                             'version' => '2.029002'
                                                           },
                                                           {
                                                             'date' => '2014-08-11T15:14:59',
                                                             'version' => '2.029003'
                                                           },
                                                           {
                                                             'date' => '2014-08-11T21:04:08',
                                                             'version' => '2.029004'
                                                           },
                                                           {
                                                             'date' => '2014-08-13T10:48:53',
                                                             'version' => '2.029005'
                                                           },
                                                           {
                                                             'date' => '2014-08-25T16:24:00',
                                                             'version' => '2.029006'
                                                           },
                                                           {
                                                             'date' => '2014-09-12T13:09:36',
                                                             'version' => '2.029007'
                                                           },
                                                           {
                                                             'date' => '2014-09-23T19:32:12',
                                                             'version' => '2.029008'
                                                           },
                                                           {
                                                             'date' => '2014-09-27T10:37:24',
                                                             'version' => '2.029009'
                                                           },
                                                           {
                                                             'date' => '2014-10-07T07:39:18',
                                                             'version' => '2.029010'
                                                           },
                                                           {
                                                             'date' => '2014-10-07T17:50:07',
                                                             'version' => '2.029011'
                                                           },
                                                           {
                                                             'date' => '2014-10-09T16:01:27',
                                                             'version' => '2.029012'
                                                           },
                                                           {
                                                             'date' => '2014-11-14T00:16:10',
                                                             'version' => '2.029013_001'
                                                           },
                                                           {
                                                             'date' => '2014-11-14T23:58:24',
                                                             'version' => '2.029013_002'
                                                           },
                                                           {
                                                             'date' => '2014-11-20T08:04:38',
                                                             'version' => '2.029014'
                                                           },
                                                           {
                                                             'date' => '2015-01-08T11:10:55',
                                                             'version' => '2.030000'
                                                           },
                                                           {
                                                             'date' => '2015-02-04T15:28:08',
                                                             'version' => '2.031000'
                                                           },
                                                           {
                                                             'date' => '2015-02-04T18:45:47',
                                                             'version' => '2.031001'
                                                           },
                                                           {
                                                             'date' => '2015-02-04T19:01:00',
                                                             'version' => '2.031002'
                                                           },
                                                           {
                                                             'date' => '2015-02-04T22:47:46',
                                                             'version' => '2.031003'
                                                           },
                                                           {
                                                             'date' => '2015-02-05T14:19:47',
                                                             'version' => '2.031004'
                                                           },
                                                           {
                                                             'date' => '2015-02-06T10:20:08',
                                                             'version' => '2.031005'
                                                           },
                                                           {
                                                             'date' => '2015-02-15T15:40:46',
                                                             'version' => '2.031006'
                                                           },
                                                           {
                                                             'date' => '2015-02-19T08:51:44',
                                                             'version' => '2.031007'
                                                           },
                                                           {
                                                             'date' => '2015-02-22T09:43:23',
                                                             'version' => '2.031008'
                                                           },
                                                           {
                                                             'date' => '2015-02-25T21:21:31',
                                                             'version' => '2.031009'
                                                           },
                                                           {
                                                             'date' => '2015-02-25T22:12:31',
                                                             'version' => '2.031010'
                                                           },
                                                           {
                                                             'date' => '2015-02-27T08:35:31',
                                                             'version' => '2.031011'
                                                           },
                                                           {
                                                             'date' => '2015-02-28T11:59:22',
                                                             'version' => '2.031012'
                                                           },
                                                           {
                                                             'date' => '2015-03-07T17:12:38',
                                                             'version' => '2.032000_001'
                                                           },
                                                           {
                                                             'date' => '2015-03-24T22:46:31',
                                                             'version' => '2.032001'
                                                           },
                                                           {
                                                             'date' => '2015-04-03T19:21:56',
                                                             'version' => '2.032002'
                                                           },
                                                           {
                                                             'date' => '2015-05-05T19:42:05',
                                                             'version' => '2.032003'
                                                           },
                                                           {
                                                             'date' => '2015-05-17T21:09:24',
                                                             'version' => '2.032004'
                                                           },
                                                           {
                                                             'date' => '2015-05-18T09:25:35',
                                                             'version' => '2.032005'
                                                           },
                                                           {
                                                             'date' => '2015-07-19T11:40:08',
                                                             'version' => '2.032006'
                                                           },
                                                           {
                                                             'date' => '2015-07-30T16:33:06',
                                                             'version' => '2.032007'
                                                           },
                                                           {
                                                             'date' => '2015-08-26T11:27:02',
                                                             'version' => '2.033000'
                                                           },
                                                           {
                                                             'date' => '2015-08-27T14:50:17',
                                                             'version' => '2.033001'
                                                           },
                                                           {
                                                             'date' => '2015-09-29T08:56:31',
                                                             'version' => '2.033002'
                                                           },
                                                           {
                                                             'date' => '2015-10-13T21:37:21',
                                                             'version' => '2.033003'
                                                           },
                                                           {
                                                             'date' => '2015-11-16T21:41:13',
                                                             'version' => '2.033004'
                                                           },
                                                           {
                                                             'date' => '2016-02-02T09:11:15',
                                                             'version' => '2.033005'
                                                           },
                                                           {
                                                             'date' => '2016-03-20T13:17:57',
                                                             'version' => '2.033005'
                                                           },
                                                           {
                                                             'date' => '2016-10-03T15:58:17',
                                                             'version' => '2.034000'
                                                           },
                                                           {
                                                             'date' => '2016-11-20T17:51:25',
                                                             'version' => '2.034001'
                                                           },
                                                           {
                                                             'date' => '2017-01-06T14:35:56',
                                                             'version' => '2.034002'
                                                           },
                                                           {
                                                             'date' => '2017-04-19T20:59:13',
                                                             'version' => '2.035000'
                                                           },
                                                           {
                                                             'date' => '2017-04-19T21:18:39',
                                                             'version' => '2.035001'
                                                           },
                                                           {
                                                             'date' => '2017-04-24T11:50:12',
                                                             'version' => '2.035002'
                                                           },
                                                           {
                                                             'date' => '2017-04-24T13:44:38',
                                                             'version' => '2.035003'
                                                           },
                                                           {
                                                             'date' => '2017-04-25T09:54:37',
                                                             'version' => '2.035004'
                                                           },
                                                           {
                                                             'date' => '2017-04-29T08:13:48',
                                                             'version' => '2.035005'
                                                           },
                                                           {
                                                             'date' => '2017-04-29T08:31:09',
                                                             'version' => '2.035006'
                                                           },
                                                           {
                                                             'date' => '2017-05-17T06:44:07',
                                                             'version' => '2.035999_001'
                                                           },
                                                           {
                                                             'date' => '2017-05-27T14:50:21',
                                                             'version' => '2.035999_002'
                                                           },
                                                           {
                                                             'date' => '2017-05-29T16:22:27',
                                                             'version' => '2.035999_003'
                                                           },
                                                           {
                                                             'date' => '2017-05-30T10:40:20',
                                                             'version' => '2.035999_004'
                                                           },
                                                           {
                                                             'date' => '2017-05-30T11:05:45',
                                                             'version' => '2.035999_005'
                                                           },
                                                           {
                                                             'date' => '2017-05-30T15:03:49',
                                                             'version' => '2.035999_006'
                                                           },
                                                           {
                                                             'date' => '2017-05-30T20:27:22',
                                                             'version' => '2.035999_007'
                                                           },
                                                           {
                                                             'date' => '2017-06-13T06:23:11',
                                                             'version' => '2.035999_008'
                                                           },
                                                           {
                                                             'date' => '2017-06-18T22:37:11',
                                                             'version' => '2.035999_009'
                                                           },
                                                           {
                                                             'date' => '2017-06-19T17:50:27',
                                                             'version' => '2.035999_010'
                                                           },
                                                           {
                                                             'date' => '2017-06-22T07:36:42',
                                                             'version' => '2.036000'
                                                           },
                                                           {
                                                             'date' => '2017-06-22T11:25:23',
                                                             'version' => '2.036001'
                                                           },
                                                           {
                                                             'date' => '2017-06-26T18:58:33',
                                                             'version' => '2.036002'
                                                           },
                                                           {
                                                             'date' => '2017-06-28T15:44:41',
                                                             'version' => '2.036003'
                                                           },
                                                           {
                                                             'date' => '2017-07-02T08:56:33',
                                                             'version' => '2.036004'
                                                           },
                                                           {
                                                             'date' => '2017-07-05T05:07:47',
                                                             'version' => '2.036005'
                                                           },
                                                           {
                                                             'date' => '2017-07-09T13:28:10',
                                                             'version' => '2.036006'
                                                           },
                                                           {
                                                             'date' => '2017-07-12T06:01:03',
                                                             'version' => '2.036007'
                                                           },
                                                           {
                                                             'date' => '2017-07-14T12:52:34',
                                                             'version' => '2.036008'
                                                           },
                                                           {
                                                             'date' => '2017-08-01T09:30:17',
                                                             'version' => '2.036009'
                                                           },
                                                           {
                                                             'date' => '2017-10-08T13:22:48',
                                                             'version' => '2.036010'
                                                           },
                                                           {
                                                             'date' => '2017-10-09T07:01:31',
                                                             'version' => '2.036011'
                                                           },
                                                           {
                                                             'date' => '2017-10-11T17:33:31',
                                                             'version' => '2.036012_001'
                                                           },
                                                           {
                                                             'date' => '2017-11-19T13:49:04',
                                                             'version' => '2.036012_002'
                                                           },
                                                           {
                                                             'date' => '2017-11-28T21:49:40',
                                                             'version' => '2.036012_003'
                                                           },
                                                           {
                                                             'date' => '2017-12-14T21:49:14',
                                                             'version' => '2.037000'
                                                           },
                                                           {
                                                             'date' => '2017-12-14T21:57:42',
                                                             'version' => '2.037001'
                                                           },
                                                           {
                                                             'date' => '2017-12-17T20:22:25',
                                                             'version' => '2.037002'
                                                           },
                                                           {
                                                             'date' => '2017-12-18T17:35:24',
                                                             'version' => '2.037003'
                                                           },
                                                           {
                                                             'date' => '2017-12-21T20:06:32',
                                                             'version' => '2.037004'
                                                           },
                                                           {
                                                             'date' => '2017-12-22T23:46:44',
                                                             'version' => '2.037005'
                                                           },
                                                           {
                                                             'date' => '2017-12-31T09:54:24',
                                                             'version' => '2.038000'
                                                           },
                                                           {
                                                             'date' => '2018-01-02T13:10:42',
                                                             'version' => '2.038001'
                                                           },
                                                           {
                                                             'date' => '2018-01-02T22:07:51',
                                                             'version' => '2.038002_001'
                                                           },
                                                           {
                                                             'date' => '2018-01-04T20:21:13',
                                                             'version' => '2.038002_002'
                                                           },
                                                           {
                                                             'date' => '2018-01-04T22:38:07',
                                                             'version' => '2.038002_003'
                                                           },
                                                           {
                                                             'date' => '2018-01-04T22:53:29',
                                                             'version' => '2.038003'
                                                           },
                                                           {
                                                             'date' => '2018-01-05T17:43:24',
                                                             'version' => '2.038004'
                                                           },
                                                           {
                                                             'date' => '2018-01-05T20:22:23',
                                                             'version' => '2.038005'
                                                           },
                                                           {
                                                             'date' => '2018-01-08T14:14:33',
                                                             'version' => '2.038006'
                                                           },
                                                           {
                                                             'date' => '2018-01-09T09:57:13',
                                                             'version' => '2.038007'
                                                           },
                                                           {
                                                             'date' => '2018-01-09T15:38:57',
                                                             'version' => '2.038008'
                                                           },
                                                           {
                                                             'date' => '2018-01-10T01:16:32',
                                                             'version' => '2.038009'
                                                           },
                                                           {
                                                             'date' => '2018-01-15T11:34:50',
                                                             'version' => '2.038028'
                                                           },
                                                           {
                                                             'date' => '2018-01-23T22:56:08',
                                                             'version' => '2.038031'
                                                           },
                                                           {
                                                             'date' => '2018-01-28T20:04:09',
                                                             'version' => '2.038032'
                                                           },
                                                           {
                                                             'date' => '2018-01-31T15:06:37',
                                                             'version' => '2.038033'
                                                           },
                                                           {
                                                             'date' => '2018-01-31T20:00:58',
                                                             'version' => '2.038034'
                                                           },
                                                           {
                                                             'date' => '2018-02-02T14:54:43',
                                                             'version' => '2.039000'
                                                           },
                                                           {
                                                             'date' => '2018-02-02T18:35:11',
                                                             'version' => '2.039001'
                                                           },
                                                           {
                                                             'date' => '2018-02-07T23:03:50',
                                                             'version' => '2.039002'
                                                           },
                                                           {
                                                             'date' => '2018-02-12T21:11:07',
                                                             'version' => '2.039003'
                                                           },
                                                           {
                                                             'date' => '2018-02-15T08:29:55',
                                                             'version' => '2.039004'
                                                           },
                                                           {
                                                             'date' => '2018-02-15T19:55:25',
                                                             'version' => '2.039005'
                                                           },
                                                           {
                                                             'date' => '2018-02-15T20:17:31',
                                                             'version' => '2.039006'
                                                           },
                                                           {
                                                             'date' => '2018-02-16T08:23:49',
                                                             'version' => '2.039007'
                                                           },
                                                           {
                                                             'date' => '2018-02-22T22:06:19',
                                                             'version' => '2.039008'
                                                           },
                                                           {
                                                             'date' => '2018-02-22T22:23:38',
                                                             'version' => '2.039009'
                                                           },
                                                           {
                                                             'date' => '2018-02-22T22:52:04',
                                                             'version' => '2.039010'
                                                           },
                                                           {
                                                             'date' => '2018-02-25T09:28:46',
                                                             'version' => '2.039011'
                                                           },
                                                           {
                                                             'date' => '2018-03-02T13:12:05',
                                                             'version' => '2.039012'
                                                           },
                                                           {
                                                             'date' => '2018-03-02T14:18:44',
                                                             'version' => '2.039013'
                                                           },
                                                           {
                                                             'date' => '2018-03-04T09:58:06',
                                                             'version' => '2.039014'
                                                           },
                                                           {
                                                             'date' => '2018-03-05T23:01:48',
                                                             'version' => '2.039015'
                                                           },
                                                           {
                                                             'date' => '2018-03-19T23:12:52',
                                                             'version' => '2.039016'
                                                           },
                                                           {
                                                             'date' => '2018-03-20T10:12:42',
                                                             'version' => '2.039017'
                                                           },
                                                           {
                                                             'date' => '2018-03-22T21:46:51',
                                                             'version' => '2.039018'
                                                           },
                                                           {
                                                             'date' => '2018-03-23T09:55:03',
                                                             'version' => '2.039019'
                                                           },
                                                           {
                                                             'date' => '2018-03-26T21:59:24',
                                                             'version' => '2.039020'
                                                           },
                                                           {
                                                             'date' => '2018-04-10T20:47:57',
                                                             'version' => '2.039021'
                                                           },
                                                           {
                                                             'date' => '2018-04-18T21:24:35',
                                                             'version' => '2.039022'
                                                           },
                                                           {
                                                             'date' => '2018-04-19T07:27:07',
                                                             'version' => '2.039023'
                                                           },
                                                           {
                                                             'date' => '2018-04-22T17:54:24',
                                                             'version' => '2.039024'
                                                           },
                                                           {
                                                             'date' => '2018-04-27T12:27:18',
                                                             'version' => '2.039025'
                                                           },
                                                           {
                                                             'date' => '2018-04-28T12:11:41',
                                                             'version' => '2.039026'
                                                           },
                                                           {
                                                             'date' => '2018-04-28T21:16:54',
                                                             'version' => '2.039027'
                                                           },
                                                           {
                                                             'date' => '2018-05-05T15:29:52',
                                                             'version' => '2.039028'
                                                           },
                                                           {
                                                             'date' => '2018-05-09T05:55:14',
                                                             'version' => '2.039029'
                                                           },
                                                           {
                                                             'date' => '2018-05-09T06:00:13',
                                                             'version' => '2.039030'
                                                           },
                                                           {
                                                             'date' => '2018-06-17T20:58:47',
                                                             'version' => '2.039031'
                                                           },
                                                           {
                                                             'date' => '2018-10-19T14:38:26',
                                                             'version' => '2.039032'
                                                           },
                                                           {
                                                             'date' => '2018-10-19T20:36:53',
                                                             'version' => '2.039033'
                                                           },
                                                           {
                                                             'date' => '2018-12-28T17:07:03',
                                                             'version' => '2.040000'
                                                           },
                                                           {
                                                             'date' => '2018-12-30T10:53:04',
                                                             'version' => '2.040001'
                                                           },
                                                           {
                                                             'date' => '2018-12-30T10:59:07',
                                                             'version' => '2.040002'
                                                           },
                                                           {
                                                             'date' => '2019-01-18T07:10:03',
                                                             'version' => '2.040003'
                                                           },
                                                           {
                                                             'date' => '2019-03-03T14:56:07',
                                                             'version' => '2.040004'
                                                           },
                                                           {
                                                             'date' => '2019-03-04T10:02:25',
                                                             'version' => '2.040005'
                                                           },
                                                           {
                                                             'date' => '2019-03-04T12:04:34',
                                                             'version' => '2.040006'
                                                           },
                                                           {
                                                             'date' => '2019-03-06T18:44:33',
                                                             'version' => '2.040007'
                                                           },
                                                           {
                                                             'date' => '2019-03-12T19:59:49',
                                                             'version' => '2.041000'
                                                           },
                                                           {
                                                             'date' => '2019-03-15T05:34:08',
                                                             'version' => '2.041001'
                                                           },
                                                           {
                                                             'date' => '2019-03-17T09:37:27',
                                                             'version' => '2.041002'
                                                           },
                                                           {
                                                             'date' => '2019-03-17T20:32:01',
                                                             'version' => '2.042000'
                                                           },
                                                           {
                                                             'date' => '2019-03-18T21:28:43',
                                                             'version' => '2.042001'
                                                           },
                                                           {
                                                             'date' => '2019-03-20T12:26:14',
                                                             'version' => '2.042002'
                                                           },
                                                           {
                                                             'date' => '2019-03-21T16:19:51',
                                                             'version' => '2.042003'
                                                           },
                                                           {
                                                             'date' => '2019-03-28T23:00:19',
                                                             'version' => '2.042004'
                                                           },
                                                           {
                                                             'date' => '2019-04-03T13:56:55',
                                                             'version' => '2.042005'
                                                           },
                                                           {
                                                             'date' => '2019-04-16T16:48:15',
                                                             'version' => '2.042006'
                                                           },
                                                           {
                                                             'date' => '2019-04-28T19:57:19',
                                                             'version' => '2.042007'
                                                           },
                                                           {
                                                             'date' => '2019-04-30T10:51:06',
                                                             'version' => '2.042008'
                                                           },
                                                           {
                                                             'date' => '2019-05-30T06:13:10',
                                                             'version' => '2.042009'
                                                           },
                                                           {
                                                             'date' => '2019-06-02T06:55:13',
                                                             'version' => '2.042010'
                                                           },
                                                           {
                                                             'date' => '2019-09-03T19:27:26',
                                                             'version' => '2.043000'
                                                           },
                                                           {
                                                             'date' => '2019-09-04T12:36:05',
                                                             'version' => '2.043001'
                                                           },
                                                           {
                                                             'date' => '2019-09-23T13:58:04',
                                                             'version' => '2.044000'
                                                           },
                                                           {
                                                             'date' => '2019-09-26T14:01:50',
                                                             'version' => '2.044001'
                                                           },
                                                           {
                                                             'date' => '2019-10-01T09:43:52',
                                                             'version' => '2.044002'
                                                           },
                                                           {
                                                             'date' => '2019-10-15T17:57:05',
                                                             'version' => '2.044003'
                                                           },
                                                           {
                                                             'date' => '2019-10-30T19:52:42',
                                                             'version' => '2.044004'
                                                           },
                                                           {
                                                             'date' => '2020-01-19T15:31:55',
                                                             'version' => '2.044005'
                                                           },
                                                           {
                                                             'date' => '2020-01-22T21:20:09',
                                                             'version' => '2.044006'
                                                           },
                                                           {
                                                             'date' => '2020-01-22T21:25:34',
                                                             'version' => '2.044007'
                                                           },
                                                           {
                                                             'date' => '2020-01-23T18:44:49',
                                                             'version' => '2.044008'
                                                           },
                                                           {
                                                             'date' => '2020-01-23T18:48:48',
                                                             'version' => '2.044009'
                                                           },
                                                           {
                                                             'date' => '2020-01-25T18:09:41',
                                                             'version' => '2.044010'
                                                           },
                                                           {
                                                             'date' => '2020-01-26T21:46:22',
                                                             'version' => '2.044011'
                                                           },
                                                           {
                                                             'date' => '2020-02-01T13:27:10',
                                                             'version' => '2.044012'
                                                           },
                                                           {
                                                             'date' => '2020-02-04T21:35:18',
                                                             'version' => '2.044013'
                                                           },
                                                           {
                                                             'date' => '2020-02-09T10:03:07',
                                                             'version' => '2.044014'
                                                           },
                                                           {
                                                             'date' => '2020-02-12T16:56:14',
                                                             'version' => '2.044015'
                                                           },
                                                           {
                                                             'date' => '2020-04-15T20:25:36',
                                                             'version' => '2.045000'
                                                           },
                                                           {
                                                             'date' => '2020-04-18T08:50:13',
                                                             'version' => '2.045001'
                                                           },
                                                           {
                                                             'date' => '2020-04-19T17:03:54',
                                                             'version' => '2.045002'
                                                           },
                                                           {
                                                             'date' => '2020-05-15T11:02:33',
                                                             'version' => '2.045003'
                                                           },
                                                           {
                                                             'date' => '2020-05-18T11:34:20',
                                                             'version' => '2.045005'
                                                           },
                                                           {
                                                             'date' => '2020-05-24T18:43:31',
                                                             'version' => '2.045006'
                                                           },
                                                           {
                                                             'date' => '2020-06-05T08:11:31',
                                                             'version' => '2.045007'
                                                           },
                                                           {
                                                             'date' => '2020-07-08T21:29:53',
                                                             'version' => '2.046000'
                                                           },
                                                           {
                                                             'date' => '2020-07-10T21:30:48',
                                                             'version' => '2.046001'
                                                           },
                                                           {
                                                             'date' => '2020-08-07T10:02:15',
                                                             'version' => '2.046002'
                                                           },
                                                           {
                                                             'date' => '2020-10-17T12:15:43',
                                                             'version' => '2.046003'
                                                           },
                                                           {
                                                             'date' => '2020-10-17T13:29:56',
                                                             'version' => '2.046004'
                                                           },
                                                           {
                                                             'date' => '2020-10-17T13:40:12',
                                                             'version' => '2.046005'
                                                           },
                                                           {
                                                             'date' => '2020-10-31T11:15:17',
                                                             'version' => '2.046006'
                                                           },
                                                           {
                                                             'date' => '2020-12-23T11:58:41',
                                                             'version' => '2.047000'
                                                           },
                                                           {
                                                             'date' => '2020-12-29T13:08:42',
                                                             'version' => '2.047001'
                                                           },
                                                           {
                                                             'date' => '2020-12-30T20:42:02',
                                                             'version' => '2.047002'
                                                           },
                                                           {
                                                             'date' => '2021-02-14T14:05:50',
                                                             'version' => '2.047003'
                                                           },
                                                           {
                                                             'date' => '2021-02-15T22:13:51',
                                                             'version' => '2.047004'
                                                           },
                                                           {
                                                             'date' => '2021-02-24T10:48:16',
                                                             'version' => '2.047005'
                                                           },
                                                           {
                                                             'date' => '2021-07-14T11:34:50',
                                                             'version' => '2.047006'
                                                           },
                                                           {
                                                             'date' => '2021-07-14T12:15:22',
                                                             'version' => '2.047007'
                                                           },
                                                           {
                                                             'date' => '2021-07-21T08:54:04',
                                                             'version' => '2.047008'
                                                           },
                                                           {
                                                             'date' => '2021-08-14T12:38:48',
                                                             'version' => '2.048000'
                                                           },
                                                           {
                                                             'date' => '2021-08-22T13:29:25',
                                                             'version' => '2.049000'
                                                           },
                                                           {
                                                             'date' => '2021-08-22T19:32:21',
                                                             'version' => '2.049001'
                                                           },
                                                           {
                                                             'date' => '2021-09-03T05:26:59',
                                                             'version' => '2.049002'
                                                           },
                                                           {
                                                             'date' => '2021-09-03T07:11:01',
                                                             'version' => '2.049003'
                                                           },
                                                           {
                                                             'date' => '2021-09-03T20:36:58',
                                                             'version' => '2.049004'
                                                           },
                                                           {
                                                             'date' => '2021-09-09T07:52:58',
                                                             'version' => '2.049005'
                                                           },
                                                           {
                                                             'date' => '2021-10-03T07:55:21',
                                                             'version' => '2.049006'
                                                           },
                                                           {
                                                             'date' => '2021-10-05T16:38:38',
                                                             'version' => '2.049007'
                                                           },
                                                           {
                                                             'date' => '2021-10-06T15:53:00',
                                                             'version' => '2.049008'
                                                           },
                                                           {
                                                             'date' => '2021-10-06T21:33:32',
                                                             'version' => '2.049009'
                                                           },
                                                           {
                                                             'date' => '2021-10-11T20:34:00',
                                                             'version' => '2.049010'
                                                           },
                                                           {
                                                             'date' => '2021-10-12T07:43:57',
                                                             'version' => '2.049011'
                                                           },
                                                           {
                                                             'date' => '2021-10-12T12:28:03',
                                                             'version' => '2.050000'
                                                           },
                                                           {
                                                             'date' => '2021-10-12T14:28:01',
                                                             'version' => '2.050001'
                                                           },
                                                           {
                                                             'date' => '2021-10-19T08:13:11',
                                                             'version' => '2.050003'
                                                           },
                                                           {
                                                             'date' => '2021-11-14T19:39:02',
                                                             'version' => '2.051001'
                                                           },
                                                           {
                                                             'date' => '2021-11-23T16:10:12',
                                                             'version' => '2.051002'
                                                           },
                                                           {
                                                             'date' => '2021-11-24T13:15:54',
                                                             'version' => '2.051003'
                                                           },
                                                           {
                                                             'date' => '2021-11-25T11:53:35',
                                                             'version' => '2.051004'
                                                           },
                                                           {
                                                             'date' => '2021-11-25T20:20:22',
                                                             'version' => '2.051005'
                                                           },
                                                           {
                                                             'date' => '2021-11-30T05:19:10',
                                                             'version' => '2.052000'
                                                           },
                                                           {
                                                             'date' => '2022-02-01T20:51:26',
                                                             'version' => '2.052001'
                                                           },
                                                           {
                                                             'date' => '2022-02-28T18:14:51',
                                                             'version' => '2.052002'
                                                           },
                                                           {
                                                             'date' => '2022-04-13T19:12:04',
                                                             'version' => '2.052003'
                                                           },
                                                           {
                                                             'date' => '2022-04-22T08:58:41',
                                                             'version' => '2.052005'
                                                           },
                                                           {
                                                             'date' => '2022-05-17T21:06:21',
                                                             'version' => '2.052006'
                                                           },
                                                           {
                                                             'date' => '2022-06-03T21:24:35',
                                                             'version' => '2.052007'
                                                           }
                                                         ]
                                         },
                       'App-cpanminus' => {
                                            'advisories' => [
                                                              {
                                                                'affected_versions' => '>=1.7044',
                                                                'cves' => [
                                                                            'CVE-2020-16154'
                                                                          ],
                                                                'description' => 'The App::cpanminus package 1.7044 for Perl allows Signature Verification Bypass.
',
                                                                'distribution' => 'App-cpanminus',
                                                                'fixed_versions' => undef,
                                                                'id' => 'CPANSA-App-cpanminus-2020-01',
                                                                'references' => [
                                                                                  'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/DENFY4CRTIZL5WYYUYUM4VKCJNXO4QIW/',
                                                                                  'https://metacpan.org/pod/App::cpanminus',
                                                                                  'https://blog.hackeriet.no/cpan-signature-verification-vulnerabilities/'
                                                                                ],
                                                                'reported' => '2020-07-30'
                                                              }
                                                            ],
                                            'main_module' => 'App::cpanminus',
                                            'versions' => [
                                                            {
                                                              'date' => '2010-02-20T02:27:00',
                                                              'version' => '0.01'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T03:14:10',
                                                              'version' => '0.02'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T03:39:56',
                                                              'version' => '0.03'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T05:04:01',
                                                              'version' => '0.04'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T05:16:03',
                                                              'version' => '0.05'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T05:48:44',
                                                              'version' => '0.06'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T20:20:08',
                                                              'version' => '0.07'
                                                            },
                                                            {
                                                              'date' => '2010-02-20T23:41:01',
                                                              'version' => '0.08'
                                                            },
                                                            {
                                                              'date' => '2010-02-21T07:48:49',
                                                              'version' => '0.09'
                                                            },
                                                            {
                                                              'date' => '2010-02-23T20:52:46',
                                                              'version' => '0.99_01'
                                                            },
                                                            {
                                                              'date' => '2010-02-24T06:20:33',
                                                              'version' => '0.99_02'
                                                            },
                                                            {
                                                              'date' => '2010-02-24T07:05:47',
                                                              'version' => '0.99_03'
                                                            },
                                                            {
                                                              'date' => '2010-02-25T17:20:05',
                                                              'version' => '0.99_04'
                                                            },
                                                            {
                                                              'date' => '2010-02-25T22:42:22',
                                                              'version' => '0.99_05'
                                                            },
                                                            {
                                                              'date' => '2010-02-25T22:51:43',
                                                              'version' => '0.99_06'
                                                            },
                                                            {
                                                              'date' => '2010-02-28T05:14:30',
                                                              'version' => '0.99_07'
                                                            },
                                                            {
                                                              'date' => '2010-03-01T05:59:15',
                                                              'version' => '0.9910'
                                                            },
                                                            {
                                                              'date' => '2010-03-02T00:29:51',
                                                              'version' => '0.9911'
                                                            },
                                                            {
                                                              'date' => '2010-03-03T02:55:22',
                                                              'version' => '0.9912'
                                                            },
                                                            {
                                                              'date' => '2010-03-03T03:21:59',
                                                              'version' => '0.9913'
                                                            },
                                                            {
                                                              'date' => '2010-03-04T08:42:03',
                                                              'version' => '0.9914'
                                                            },
                                                            {
                                                              'date' => '2010-03-04T09:58:11',
                                                              'version' => '0.9915'
                                                            },
                                                            {
                                                              'date' => '2010-03-04T19:35:22',
                                                              'version' => '0.9916'
                                                            },
                                                            {
                                                              'date' => '2010-03-09T13:58:32',
                                                              'version' => '0.9917'
                                                            },
                                                            {
                                                              'date' => '2010-03-10T02:26:03',
                                                              'version' => '0.9918'
                                                            },
                                                            {
                                                              'date' => '2010-03-10T02:41:31',
                                                              'version' => '0.9919'
                                                            },
                                                            {
                                                              'date' => '2010-03-10T09:49:22',
                                                              'version' => '0.99_20'
                                                            },
                                                            {
                                                              'date' => '2010-03-10T15:03:38',
                                                              'version' => '0.9921'
                                                            },
                                                            {
                                                              'date' => '2010-03-11T02:01:28',
                                                              'version' => '0.9922'
                                                            },
                                                            {
                                                              'date' => '2010-03-16T00:07:01',
                                                              'version' => '0.9923'
                                                            },
                                                            {
                                                              'date' => '2010-03-22T05:05:33',
                                                              'version' => '0.99_24'
                                                            },
                                                            {
                                                              'date' => '2010-03-23T02:54:44',
                                                              'version' => '0.99_25'
                                                            },
                                                            {
                                                              'date' => '2010-03-23T03:24:34',
                                                              'version' => '0.99_26'
                                                            },
                                                            {
                                                              'date' => '2010-03-23T18:24:55',
                                                              'version' => '0.9927'
                                                            },
                                                            {
                                                              'date' => '2010-03-26T05:09:12',
                                                              'version' => '0.9928'
                                                            },
                                                            {
                                                              'date' => '2010-03-27T04:42:41',
                                                              'version' => '0.9929'
                                                            },
                                                            {
                                                              'date' => '2010-03-30T21:29:41',
                                                              'version' => '0.9930'
                                                            },
                                                            {
                                                              'date' => '2010-04-05T01:18:12',
                                                              'version' => '0.9931'
                                                            },
                                                            {
                                                              'date' => '2010-04-05T23:28:11',
                                                              'version' => '0.9932'
                                                            },
                                                            {
                                                              'date' => '2010-04-11T07:51:27',
                                                              'version' => '0.99_33'
                                                            },
                                                            {
                                                              'date' => '2010-04-11T11:55:44',
                                                              'version' => '0.9934'
                                                            },
                                                            {
                                                              'date' => '2010-04-12T11:09:47',
                                                              'version' => '0.999_01'
                                                            },
                                                            {
                                                              'date' => '2010-04-13T07:11:08',
                                                              'version' => '0.999_02'
                                                            },
                                                            {
                                                              'date' => '2010-04-14T09:29:25',
                                                              'version' => '0.999_03'
                                                            },
                                                            {
                                                              'date' => '2010-04-14T09:30:52',
                                                              'version' => '0.9935'
                                                            },
                                                            {
                                                              'date' => '2010-04-19T06:23:01',
                                                              'version' => '0.999_04'
                                                            },
                                                            {
                                                              'date' => '2010-04-21T11:40:46',
                                                              'version' => '0.999_05'
                                                            },
                                                            {
                                                              'date' => '2010-04-21T11:53:47',
                                                              'version' => '0.9936'
                                                            },
                                                            {
                                                              'date' => '2010-04-24T08:23:24',
                                                              'version' => '1.0000'
                                                            },
                                                            {
                                                              'date' => '2010-04-24T08:26:40',
                                                              'version' => '1.0001'
                                                            },
                                                            {
                                                              'date' => '2010-05-02T03:51:09',
                                                              'version' => '1.0002'
                                                            },
                                                            {
                                                              'date' => '2010-05-04T23:16:18',
                                                              'version' => '1.0003'
                                                            },
                                                            {
                                                              'date' => '2010-05-14T23:10:54',
                                                              'version' => '1.0004'
                                                            },
                                                            {
                                                              'date' => '2010-07-02T23:39:32',
                                                              'version' => '1.0005'
                                                            },
                                                            {
                                                              'date' => '2010-07-02T23:54:14',
                                                              'version' => '1.0006'
                                                            },
                                                            {
                                                              'date' => '2010-07-30T19:55:47',
                                                              'version' => '1.0010'
                                                            },
                                                            {
                                                              'date' => '2010-08-18T23:42:36',
                                                              'version' => '1.0011'
                                                            },
                                                            {
                                                              'date' => '2010-08-20T19:58:19',
                                                              'version' => '1.0012'
                                                            },
                                                            {
                                                              'date' => '2010-09-12T19:54:17',
                                                              'version' => '1.0013'
                                                            },
                                                            {
                                                              'date' => '2010-09-21T19:43:20',
                                                              'version' => '1.0014'
                                                            },
                                                            {
                                                              'date' => '2010-09-24T23:52:00',
                                                              'version' => '1.0015'
                                                            },
                                                            {
                                                              'date' => '2010-11-12T07:57:33',
                                                              'version' => '1.1000'
                                                            },
                                                            {
                                                              'date' => '2010-11-12T20:37:49',
                                                              'version' => '1.1001'
                                                            },
                                                            {
                                                              'date' => '2010-11-17T02:28:44',
                                                              'version' => '1.1002'
                                                            },
                                                            {
                                                              'date' => '2010-11-25T09:18:34',
                                                              'version' => '1.1003'
                                                            },
                                                            {
                                                              'date' => '2010-11-30T18:07:12',
                                                              'version' => '1.1004'
                                                            },
                                                            {
                                                              'date' => '2010-12-14T23:08:40',
                                                              'version' => '1.1005'
                                                            },
                                                            {
                                                              'date' => '2010-12-16T19:32:01',
                                                              'version' => '1.1006'
                                                            },
                                                            {
                                                              'date' => '2011-01-18T17:40:16',
                                                              'version' => '1.1007'
                                                            },
                                                            {
                                                              'date' => '2011-01-18T20:54:34',
                                                              'version' => '1.19_01'
                                                            },
                                                            {
                                                              'date' => '2011-01-18T22:11:52',
                                                              'version' => '1.19_02'
                                                            },
                                                            {
                                                              'date' => '2011-01-26T22:08:11',
                                                              'version' => '1.1008'
                                                            },
                                                            {
                                                              'date' => '2011-02-16T18:11:52',
                                                              'version' => '1.2000'
                                                            },
                                                            {
                                                              'date' => '2011-02-16T18:55:46',
                                                              'version' => '1.2001'
                                                            },
                                                            {
                                                              'date' => '2011-03-01T02:59:25',
                                                              'version' => '1.29_01'
                                                            },
                                                            {
                                                              'date' => '2011-03-02T00:09:00',
                                                              'version' => '1.29_02'
                                                            },
                                                            {
                                                              'date' => '2011-03-02T22:41:40',
                                                              'version' => '1.3000'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T02:35:03',
                                                              'version' => '1.3001'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T03:54:53',
                                                              'version' => '1.30_02'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T08:32:56',
                                                              'version' => '1.30_03'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T08:53:22',
                                                              'version' => '1.30_04'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T09:41:34',
                                                              'version' => '1.30_05'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T22:57:43',
                                                              'version' => '1.30_06'
                                                            },
                                                            {
                                                              'date' => '2011-03-04T23:20:45',
                                                              'version' => '1.30_07'
                                                            },
                                                            {
                                                              'date' => '2011-03-05T00:07:44',
                                                              'version' => '1.30_08'
                                                            },
                                                            {
                                                              'date' => '2011-03-05T02:16:54',
                                                              'version' => '1.30_09'
                                                            },
                                                            {
                                                              'date' => '2011-03-05T22:57:38',
                                                              'version' => '1.30_10'
                                                            },
                                                            {
                                                              'date' => '2011-03-06T09:37:36',
                                                              'version' => '1.30_11'
                                                            },
                                                            {
                                                              'date' => '2011-03-07T03:00:09',
                                                              'version' => '1.30_12'
                                                            },
                                                            {
                                                              'date' => '2011-03-07T18:54:03',
                                                              'version' => '1.30_13'
                                                            },
                                                            {
                                                              'date' => '2011-03-08T09:11:33',
                                                              'version' => '1.4000'
                                                            },
                                                            {
                                                              'date' => '2011-03-08T18:11:57',
                                                              'version' => '1.4001'
                                                            },
                                                            {
                                                              'date' => '2011-03-09T01:57:18',
                                                              'version' => '1.4002'
                                                            },
                                                            {
                                                              'date' => '2011-03-10T02:15:19',
                                                              'version' => '1.4003'
                                                            },
                                                            {
                                                              'date' => '2011-03-10T18:09:34',
                                                              'version' => '1.4004'
                                                            },
                                                            {
                                                              'date' => '2011-05-11T19:49:38',
                                                              'version' => '1.4005'
                                                            },
                                                            {
                                                              'date' => '2011-05-16T17:17:29',
                                                              'version' => '1.4006'
                                                            },
                                                            {
                                                              'date' => '2011-05-17T17:54:45',
                                                              'version' => '1.4007'
                                                            },
                                                            {
                                                              'date' => '2011-06-16T01:00:00',
                                                              'version' => '1.4008'
                                                            },
                                                            {
                                                              'date' => '2011-06-26T17:59:17',
                                                              'version' => '1.49_01'
                                                            },
                                                            {
                                                              'date' => '2011-10-12T09:57:03',
                                                              'version' => '1.49_02'
                                                            },
                                                            {
                                                              'date' => '2011-10-13T06:40:49',
                                                              'version' => '1.5000'
                                                            },
                                                            {
                                                              'date' => '2011-10-13T15:21:16',
                                                              'version' => '1.5001'
                                                            },
                                                            {
                                                              'date' => '2011-10-18T00:13:36',
                                                              'version' => '1.5002'
                                                            },
                                                            {
                                                              'date' => '2011-10-19T07:31:10',
                                                              'version' => '1.5003'
                                                            },
                                                            {
                                                              'date' => '2011-11-08T22:29:31',
                                                              'version' => '1.5004'
                                                            },
                                                            {
                                                              'date' => '2011-11-22T21:31:21',
                                                              'version' => '1.5005'
                                                            },
                                                            {
                                                              'date' => '2011-11-29T19:49:42',
                                                              'version' => '1.5006'
                                                            },
                                                            {
                                                              'date' => '2011-12-20T18:18:50',
                                                              'version' => '1.5007'
                                                            },
                                                            {
                                                              'date' => '2012-03-18T01:23:40',
                                                              'version' => '1.5008'
                                                            },
                                                            {
                                                              'date' => '2012-03-30T16:45:43',
                                                              'version' => '1.5009'
                                                            },
                                                            {
                                                              'date' => '2012-03-31T11:01:47',
                                                              'version' => '1.5010'
                                                            },
                                                            {
                                                              'date' => '2012-04-12T09:59:39',
                                                              'version' => '1.5011'
                                                            },
                                                            {
                                                              'date' => '2012-05-11T03:50:22',
                                                              'version' => '1.5012'
                                                            },
                                                            {
                                                              'date' => '2012-05-12T03:18:19',
                                                              'version' => '1.5013'
                                                            },
                                                            {
                                                              'date' => '2012-06-13T01:34:12',
                                                              'version' => '1.5014'
                                                            },
                                                            {
                                                              'date' => '2012-06-24T22:37:49',
                                                              'version' => '1.5015'
                                                            },
                                                            {
                                                              'date' => '2012-07-17T19:02:48',
                                                              'version' => '1.5016'
                                                            },
                                                            {
                                                              'date' => '2012-07-18T15:41:26',
                                                              'version' => '1.5017'
                                                            },
                                                            {
                                                              'date' => '2012-09-19T05:42:19',
                                                              'version' => '1.5018'
                                                            },
                                                            {
                                                              'date' => '2012-12-22T17:22:02',
                                                              'version' => '1.5019'
                                                            },
                                                            {
                                                              'date' => '2013-01-29T18:32:26',
                                                              'version' => '1.5020'
                                                            },
                                                            {
                                                              'date' => '2013-01-31T08:45:31',
                                                              'version' => '1.5021'
                                                            },
                                                            {
                                                              'date' => '2013-01-31T18:07:46',
                                                              'version' => '1.59_01'
                                                            },
                                                            {
                                                              'date' => '2013-02-01T03:12:10',
                                                              'version' => '1.59_02'
                                                            },
                                                            {
                                                              'date' => '2013-02-01T18:54:58',
                                                              'version' => '1.59_03'
                                                            },
                                                            {
                                                              'date' => '2013-02-03T17:07:16',
                                                              'version' => '1.59_04'
                                                            },
                                                            {
                                                              'date' => '2013-02-04T19:52:48',
                                                              'version' => '1.59_05'
                                                            },
                                                            {
                                                              'date' => '2013-02-05T20:40:30',
                                                              'version' => '1.59_06'
                                                            },
                                                            {
                                                              'date' => '2013-02-06T19:17:51',
                                                              'version' => '1.59_07'
                                                            },
                                                            {
                                                              'date' => '2013-02-06T19:32:27',
                                                              'version' => '1.59_08'
                                                            },
                                                            {
                                                              'date' => '2013-02-07T09:59:04',
                                                              'version' => '1.59_09'
                                                            },
                                                            {
                                                              'date' => '2013-02-08T00:29:16',
                                                              'version' => '1.59_10'
                                                            },
                                                            {
                                                              'date' => '2013-02-11T22:12:12',
                                                              'version' => '1.59_11'
                                                            },
                                                            {
                                                              'date' => '2013-02-14T02:15:12',
                                                              'version' => '1.59_12'
                                                            },
                                                            {
                                                              'date' => '2013-02-25T20:16:34',
                                                              'version' => '1.59_13'
                                                            },
                                                            {
                                                              'date' => '2013-02-26T17:57:00',
                                                              'version' => '1.6000'
                                                            },
                                                            {
                                                              'date' => '2013-02-27T01:04:54',
                                                              'version' => '1.6001'
                                                            },
                                                            {
                                                              'date' => '2013-02-27T20:13:45',
                                                              'version' => '1.6002'
                                                            },
                                                            {
                                                              'date' => '2013-03-08T19:03:47',
                                                              'version' => '1.6003'
                                                            },
                                                            {
                                                              'date' => '2013-03-08T19:32:25',
                                                              'version' => '1.6004'
                                                            },
                                                            {
                                                              'date' => '2013-03-08T19:48:06',
                                                              'version' => '1.6005'
                                                            },
                                                            {
                                                              'date' => '2013-03-14T06:00:27',
                                                              'version' => '1.6006'
                                                            },
                                                            {
                                                              'date' => '2013-03-17T21:34:17',
                                                              'version' => '1.6007'
                                                            },
                                                            {
                                                              'date' => '2013-03-19T17:03:36',
                                                              'version' => '1.6008'
                                                            },
                                                            {
                                                              'date' => '2013-03-25T04:10:51',
                                                              'version' => '1.6100'
                                                            },
                                                            {
                                                              'date' => '2013-03-25T20:41:37',
                                                              'version' => '1.6101'
                                                            },
                                                            {
                                                              'date' => '2013-03-28T00:16:09',
                                                              'version' => '1.6102'
                                                            },
                                                            {
                                                              'date' => '2013-03-30T21:36:49',
                                                              'version' => '1.6103'
                                                            },
                                                            {
                                                              'date' => '2013-04-03T01:04:42',
                                                              'version' => '1.6104'
                                                            },
                                                            {
                                                              'date' => '2013-04-05T05:17:38',
                                                              'version' => '1.6105'
                                                            },
                                                            {
                                                              'date' => '2013-04-06T21:19:18',
                                                              'version' => '1.6106'
                                                            },
                                                            {
                                                              'date' => '2013-04-07T04:19:16',
                                                              'version' => '1.6107'
                                                            },
                                                            {
                                                              'date' => '2013-04-13T06:32:52',
                                                              'version' => '1.6108'
                                                            },
                                                            {
                                                              'date' => '2013-04-13T11:48:43',
                                                              'version' => '1.6190'
                                                            },
                                                            {
                                                              'date' => '2013-04-14T03:09:40',
                                                              'version' => '1.6191'
                                                            },
                                                            {
                                                              'date' => '2013-04-14T08:17:32',
                                                              'version' => '1.6192'
                                                            },
                                                            {
                                                              'date' => '2013-04-15T07:37:08',
                                                              'version' => '1.6193'
                                                            },
                                                            {
                                                              'date' => '2013-04-15T07:42:51',
                                                              'version' => '1.6900'
                                                            },
                                                            {
                                                              'date' => '2013-04-21T00:50:44',
                                                              'version' => '1.6901'
                                                            },
                                                            {
                                                              'date' => '2013-04-21T01:06:02',
                                                              'version' => '1.6109'
                                                            },
                                                            {
                                                              'date' => '2013-04-21T01:18:10',
                                                              'version' => '1.6902'
                                                            },
                                                            {
                                                              'date' => '2013-04-22T01:07:09',
                                                              'version' => '1.6903'
                                                            },
                                                            {
                                                              'date' => '2013-04-24T02:24:37',
                                                              'version' => '1.6904'
                                                            },
                                                            {
                                                              'date' => '2013-04-24T03:05:21',
                                                              'version' => '1.6905'
                                                            },
                                                            {
                                                              'date' => '2013-04-25T06:20:23',
                                                              'version' => '1.6906'
                                                            },
                                                            {
                                                              'date' => '2013-04-26T18:40:08',
                                                              'version' => '1.6907'
                                                            },
                                                            {
                                                              'date' => '2013-04-27T01:12:17',
                                                              'version' => '1.6908'
                                                            },
                                                            {
                                                              'date' => '2013-04-29T08:49:53',
                                                              'version' => '1.6909'
                                                            },
                                                            {
                                                              'date' => '2013-05-03T07:29:32',
                                                              'version' => '1.6910'
                                                            },
                                                            {
                                                              'date' => '2013-05-04T20:28:02',
                                                              'version' => '1.6911'
                                                            },
                                                            {
                                                              'date' => '2013-05-06T20:59:52',
                                                              'version' => '1.6912'
                                                            },
                                                            {
                                                              'date' => '2013-05-10T00:05:10',
                                                              'version' => '1.6913'
                                                            },
                                                            {
                                                              'date' => '2013-05-12T23:03:52',
                                                              'version' => '1.6914'
                                                            },
                                                            {
                                                              'date' => '2013-05-16T02:01:33',
                                                              'version' => '1.6915'
                                                            },
                                                            {
                                                              'date' => '2013-06-04T10:55:37',
                                                              'version' => '1.6916'
                                                            },
                                                            {
                                                              'date' => '2013-06-05T01:07:33',
                                                              'version' => '1.6917'
                                                            },
                                                            {
                                                              'date' => '2013-06-10T20:03:21',
                                                              'version' => '1.6918'
                                                            },
                                                            {
                                                              'date' => '2013-06-12T15:33:22',
                                                              'version' => '1.6919'
                                                            },
                                                            {
                                                              'date' => '2013-06-14T21:09:54',
                                                              'version' => '1.6920'
                                                            },
                                                            {
                                                              'date' => '2013-06-18T10:19:43',
                                                              'version' => '1.6921'
                                                            },
                                                            {
                                                              'date' => '2013-06-19T20:57:09',
                                                              'version' => '1.6922'
                                                            },
                                                            {
                                                              'date' => '2013-07-04T05:17:11',
                                                              'version' => '1.6923'
                                                            },
                                                            {
                                                              'date' => '2013-07-16T18:38:21',
                                                              'version' => '1.6924'
                                                            },
                                                            {
                                                              'date' => '2013-07-20T05:08:06',
                                                              'version' => '1.6925'
                                                            },
                                                            {
                                                              'date' => '2013-07-20T16:03:14',
                                                              'version' => '1.6926'
                                                            },
                                                            {
                                                              'date' => '2013-07-23T07:45:33',
                                                              'version' => '1.6927'
                                                            },
                                                            {
                                                              'date' => '2013-07-23T21:07:02',
                                                              'version' => '1.6928'
                                                            },
                                                            {
                                                              'date' => '2013-07-24T18:46:29',
                                                              'version' => '1.6929'
                                                            },
                                                            {
                                                              'date' => '2013-07-24T20:48:14',
                                                              'version' => '1.6930'
                                                            },
                                                            {
                                                              'date' => '2013-07-24T21:51:33',
                                                              'version' => '1.6931'
                                                            },
                                                            {
                                                              'date' => '2013-07-24T22:29:04',
                                                              'version' => '1.6932'
                                                            },
                                                            {
                                                              'date' => '2013-07-25T16:58:24',
                                                              'version' => '1.6933'
                                                            },
                                                            {
                                                              'date' => '2013-07-26T23:17:21',
                                                              'version' => '1.6934'
                                                            },
                                                            {
                                                              'date' => '2013-07-31T18:36:57',
                                                              'version' => '1.6935'
                                                            },
                                                            {
                                                              'date' => '2013-08-05T04:37:54',
                                                              'version' => '1.6936'
                                                            },
                                                            {
                                                              'date' => '2013-08-06T01:55:29',
                                                              'version' => '1.6937'
                                                            },
                                                            {
                                                              'date' => '2013-08-06T06:12:45',
                                                              'version' => '1.6938'
                                                            },
                                                            {
                                                              'date' => '2013-08-06T09:55:55',
                                                              'version' => '1.6939'
                                                            },
                                                            {
                                                              'date' => '2013-08-08T19:36:34',
                                                              'version' => '1.6940'
                                                            },
                                                            {
                                                              'date' => '2013-08-20T18:32:44',
                                                              'version' => '1.6941'
                                                            },
                                                            {
                                                              'date' => '2013-08-27T18:11:47',
                                                              'version' => '1.6942'
                                                            },
                                                            {
                                                              'date' => '2013-09-03T23:40:37',
                                                              'version' => '1.6943'
                                                            },
                                                            {
                                                              'date' => '2013-09-04T22:02:21',
                                                              'version' => '1.7000'
                                                            },
                                                            {
                                                              'date' => '2013-09-08T20:12:16',
                                                              'version' => '1.7001'
                                                            },
                                                            {
                                                              'date' => '2013-09-19T05:31:34',
                                                              'version' => '1.7100'
                                                            },
                                                            {
                                                              'date' => '2013-09-19T11:15:59',
                                                              'version' => '1.7101'
                                                            },
                                                            {
                                                              'date' => '2013-09-20T04:33:50',
                                                              'version' => '1.7102'
                                                            },
                                                            {
                                                              'date' => '2014-04-27T05:46:31',
                                                              'version' => '1.7002'
                                                            },
                                                            {
                                                              'date' => '2014-04-27T15:11:46',
                                                              'version' => '1.7003'
                                                            },
                                                            {
                                                              'date' => '2014-04-27T16:23:35',
                                                              'version' => '1.7004'
                                                            },
                                                            {
                                                              'date' => '2014-09-02T04:00:49',
                                                              'version' => '1.7005'
                                                            },
                                                            {
                                                              'date' => '2014-09-02T06:27:35',
                                                              'version' => '1.7006'
                                                            },
                                                            {
                                                              'date' => '2014-09-05T12:04:41',
                                                              'version' => '1.7005'
                                                            },
                                                            {
                                                              'date' => '2014-09-05T22:45:37',
                                                              'version' => '1.7006'
                                                            },
                                                            {
                                                              'date' => '2014-09-09T16:26:54',
                                                              'version' => '1.7007'
                                                            },
                                                            {
                                                              'date' => '2014-09-10T08:19:24',
                                                              'version' => '1.7008'
                                                            },
                                                            {
                                                              'date' => '2014-09-10T08:44:00',
                                                              'version' => '1.7009'
                                                            },
                                                            {
                                                              'date' => '2014-09-17T09:28:23',
                                                              'version' => '1.7010'
                                                            },
                                                            {
                                                              'date' => '2014-09-22T06:08:51',
                                                              'version' => '1.7011'
                                                            },
                                                            {
                                                              'date' => '2014-09-27T02:29:33',
                                                              'version' => '1.7012'
                                                            },
                                                            {
                                                              'date' => '2014-10-07T06:52:45',
                                                              'version' => '1.7013'
                                                            },
                                                            {
                                                              'date' => '2014-10-08T03:54:02',
                                                              'version' => '1.7014'
                                                            },
                                                            {
                                                              'date' => '2014-11-14T21:14:40',
                                                              'version' => '1.7015'
                                                            },
                                                            {
                                                              'date' => '2014-11-16T19:47:26',
                                                              'version' => '1.7016'
                                                            },
                                                            {
                                                              'date' => '2014-11-25T22:01:56',
                                                              'version' => '1.7017'
                                                            },
                                                            {
                                                              'date' => '2014-11-25T22:08:49',
                                                              'version' => '1.7018'
                                                            },
                                                            {
                                                              'date' => '2014-12-04T20:52:24',
                                                              'version' => '1.7019'
                                                            },
                                                            {
                                                              'date' => '2014-12-09T01:54:37',
                                                              'version' => '1.7020'
                                                            },
                                                            {
                                                              'date' => '2014-12-12T05:43:01',
                                                              'version' => '1.7021'
                                                            },
                                                            {
                                                              'date' => '2014-12-13T00:42:15',
                                                              'version' => '1.7022'
                                                            },
                                                            {
                                                              'date' => '2015-01-04T23:00:30',
                                                              'version' => '1.7023'
                                                            },
                                                            {
                                                              'date' => '2015-01-12T21:32:45',
                                                              'version' => '1.7024'
                                                            },
                                                            {
                                                              'date' => '2015-02-07T06:59:17',
                                                              'version' => '1.7025'
                                                            },
                                                            {
                                                              'date' => '2015-02-14T01:12:18',
                                                              'version' => '1.7026'
                                                            },
                                                            {
                                                              'date' => '2015-02-14T20:15:20',
                                                              'version' => '1.7027'
                                                            },
                                                            {
                                                              'date' => '2015-04-17T17:24:16',
                                                              'version' => '1.7028'
                                                            },
                                                            {
                                                              'date' => '2015-04-18T22:16:17',
                                                              'version' => '1.7029'
                                                            },
                                                            {
                                                              'date' => '2015-04-19T12:15:59',
                                                              'version' => '1.7030'
                                                            },
                                                            {
                                                              'date' => '2015-04-22T21:14:17',
                                                              'version' => '1.7031'
                                                            },
                                                            {
                                                              'date' => '2015-04-30T01:52:49',
                                                              'version' => '1.7032'
                                                            },
                                                            {
                                                              'date' => '2015-05-02T00:18:54',
                                                              'version' => '1.7033'
                                                            },
                                                            {
                                                              'date' => '2015-05-07T21:21:07',
                                                              'version' => '1.7034'
                                                            },
                                                            {
                                                              'date' => '2015-06-05T17:51:53',
                                                              'version' => '1.7035'
                                                            },
                                                            {
                                                              'date' => '2015-06-06T05:08:20',
                                                              'version' => '1.7036'
                                                            },
                                                            {
                                                              'date' => '2015-06-18T21:38:47',
                                                              'version' => '1.7037'
                                                            },
                                                            {
                                                              'date' => '2015-06-23T01:05:25',
                                                              'version' => '1.7038'
                                                            },
                                                            {
                                                              'date' => '2015-06-29T01:06:18',
                                                              'version' => '1.7039'
                                                            },
                                                            {
                                                              'date' => '2016-01-07T19:29:19',
                                                              'version' => '1.7040'
                                                            },
                                                            {
                                                              'date' => '2016-05-08T18:29:30',
                                                              'version' => '1.7041'
                                                            },
                                                            {
                                                              'date' => '2016-05-24T07:49:34',
                                                              'version' => '1.7042'
                                                            },
                                                            {
                                                              'date' => '2017-04-03T03:57:15',
                                                              'version' => '1.7043'
                                                            },
                                                            {
                                                              'date' => '2018-04-19T11:54:56',
                                                              'version' => '1.7044'
                                                            },
                                                            {
                                                              'date' => '2018-04-20T12:17:48',
                                                              'version' => '1.7900'
                                                            },
                                                            {
                                                              'date' => '2018-04-20T12:20:35',
                                                              'version' => '1.7901'
                                                            },
                                                            {
                                                              'date' => '2018-04-20T12:43:24',
                                                              'version' => '1.7902'
                                                            },
                                                            {
                                                              'date' => '2018-04-20T14:54:30',
                                                              'version' => '1.7903'
                                                            },
                                                            {
                                                              'date' => '2018-04-20T21:22:56',
                                                              'version' => '1.7904'
                                                            },
                                                            {
                                                              'date' => '2018-04-21T09:40:47',
                                                              'version' => '1.7905'
                                                            },
                                                            {
                                                              'date' => '2018-04-21T10:57:20',
                                                              'version' => '1.9015'
                                                            },
                                                            {
                                                              'date' => '2018-04-21T11:17:58',
                                                              'version' => '1.9016'
                                                            },
                                                            {
                                                              'date' => '2018-04-21T17:31:13',
                                                              'version' => '1.9017'
                                                            },
                                                            {
                                                              'date' => '2018-04-22T13:54:32',
                                                              'version' => '1.9018'
                                                            },
                                                            {
                                                              'date' => '2018-04-25T09:27:31',
                                                              'version' => '1.7906'
                                                            },
                                                            {
                                                              'date' => '2018-04-26T11:36:59',
                                                              'version' => '1.7907'
                                                            },
                                                            {
                                                              'date' => '2022-01-27T03:05:02',
                                                              'version' => '1.7045'
                                                            },
                                                            {
                                                              'date' => '2022-04-27T06:01:26',
                                                              'version' => '1.7046'
                                                            }
                                                          ]
                                          },
                       'App-revealup' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<=0.22',
                                                               'cves' => [
                                                                           'CVE-2022-0776'
                                                                         ],
                                                               'description' => 'Cross-site Scripting (XSS) - DOM in GitHub repository hakimel/reveal.js prior to 4.3.0.
',
                                                               'distribution' => 'App-revealup',
                                                               'embedded_vulnerability' => {
                                                                                             'distributed_version' => '3.9.2',
                                                                                             'name' => 'revealjs'
                                                                                           },
                                                               'fixed_versions' => '>=0.23',
                                                               'id' => 'CPANSA-App-revealup-2022-0776',
                                                               'references' => [
                                                                                 'https://github.com/hakimel/reveal.js/commit/32cdd3b1872ba8e2267c9e87ae216cb55f40f4d2',
                                                                                 'https://huntr.dev/bounties/be2b7ee4-f487-42e1-874a-6bcc410e4001',
                                                                                 'https://github.com/yusukebe/App-revealup/issues/12#issuecomment-1169417411',
                                                                                 'https://github.com/yusukebe/App-revealup/commit/c8fea67994b1aa6d734066bff9ada4e834b09cb7'
                                                                               ],
                                                               'reported' => '2022-03-01',
                                                               'reviewed_by' => [
                                                                                  {
                                                                                    'date' => '2022-06-29',
                                                                                    'email' => 'rrwo@cpan.org',
                                                                                    'name' => 'Robert Rothenberg'
                                                                                  }
                                                                                ],
                                                               'severity' => 'medium'
                                                             },
                                                             {
                                                               'affected_versions' => '<=0.20',
                                                               'cves' => [
                                                                           'CVE-2020-8127'
                                                                         ],
                                                               'description' => 'Insufficient validation in cross-origin communication (postMessage) in reveal.js version 3.9.1 and earlier allow attackers to perform cross-site scripting attacks.
',
                                                               'distribution' => 'App-revealup',
                                                               'embedded_vulnerability' => {
                                                                                             'distributed_version' => '3.1.0',
                                                                                             'name' => 'revealjs'
                                                                                           },
                                                               'fixed_versions' => '>=0.21',
                                                               'id' => 'CPANSA-App-revealup-2020-8127',
                                                               'references' => [
                                                                                 'https://hackerone.com/reports/691977'
                                                                               ],
                                                               'reported' => '2020-02-28',
                                                               'reviewed_by' => [
                                                                                  {
                                                                                    'date' => '2022-06-29',
                                                                                    'email' => 'rrwo@cpan.org',
                                                                                    'name' => 'Robert Rothenberg'
                                                                                  }
                                                                                ],
                                                               'severity' => 'medium'
                                                             }
                                                           ],
                                           'main_module' => 'App::revealup',
                                           'versions' => [
                                                           {
                                                             'date' => '2014-05-25T10:34:08',
                                                             'version' => '0.01'
                                                           },
                                                           {
                                                             'date' => '2014-05-25T11:39:22',
                                                             'version' => '0.02'
                                                           },
                                                           {
                                                             'date' => '2014-06-06T08:03:43',
                                                             'version' => '0.03'
                                                           },
                                                           {
                                                             'date' => '2014-06-06T22:08:16',
                                                             'version' => '0.04'
                                                           },
                                                           {
                                                             'date' => '2014-06-11T05:44:23',
                                                             'version' => '0.05'
                                                           },
                                                           {
                                                             'date' => '2014-06-11T06:22:41',
                                                             'version' => '0.06'
                                                           },
                                                           {
                                                             'date' => '2014-06-11T11:27:29',
                                                             'version' => '0.07'
                                                           },
                                                           {
                                                             'date' => '2014-06-16T01:22:48',
                                                             'version' => '0.08'
                                                           },
                                                           {
                                                             'date' => '2014-06-17T02:53:12',
                                                             'version' => '0.09'
                                                           },
                                                           {
                                                             'date' => '2014-07-05T21:47:41',
                                                             'version' => '0.10'
                                                           },
                                                           {
                                                             'date' => '2014-07-05T21:54:30',
                                                             'version' => '0.11'
                                                           },
                                                           {
                                                             'date' => '2014-09-03T20:57:24',
                                                             'version' => '0.12'
                                                           },
                                                           {
                                                             'date' => '2014-09-16T03:40:03',
                                                             'version' => '0.13'
                                                           },
                                                           {
                                                             'date' => '2014-11-07T16:32:52',
                                                             'version' => '0.14'
                                                           },
                                                           {
                                                             'date' => '2014-11-24T06:40:45',
                                                             'version' => '0.15'
                                                           },
                                                           {
                                                             'date' => '2014-12-19T06:25:32',
                                                             'version' => '0.16'
                                                           },
                                                           {
                                                             'date' => '2014-12-19T20:12:33',
                                                             'version' => '0.17'
                                                           },
                                                           {
                                                             'date' => '2014-12-21T22:32:08',
                                                             'version' => '0.18'
                                                           },
                                                           {
                                                             'date' => '2014-12-21T22:43:49',
                                                             'version' => '0.19'
                                                           },
                                                           {
                                                             'date' => '2015-07-07T15:34:28',
                                                             'version' => '0.20'
                                                           },
                                                           {
                                                             'date' => '2015-08-28T12:57:12',
                                                             'version' => '0.21'
                                                           },
                                                           {
                                                             'date' => '2020-02-06T12:53:05',
                                                             'version' => '0.22'
                                                           },
                                                           {
                                                             'date' => '2022-06-29T00:31:20',
                                                             'version' => '0.23'
                                                           }
                                                         ]
                                         },
                       'Archive-Tar' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<2.28',
                                                              'cves' => [
                                                                          'CVE-2018-12015'
                                                                        ],
                                                              'description' => 'In Perl through 5.26.2, the Archive::Tar module allows remote attackers to bypass a directory-traversal protection mechanism, and overwrite arbitrary files, via an archive file containing a symlink and a regular file with the same name.
',
                                                              'distribution' => 'Archive-Tar',
                                                              'id' => 'CPANSA-Archive-Tar-2018-01',
                                                              'references' => [
                                                                                'https://security-tracker.debian.org/tracker/CVE-2018-12015',
                                                                                'https://github.com/jib/archive-tar-new/commit/ae65651eab053fc6dc4590dbb863a268215c1fc5'
                                                                              ],
                                                              'reported' => '2018-06-12',
                                                              'severity' => 'medium'
                                                            },
                                                            {
                                                              'affected_versions' => '<=1.36',
                                                              'cves' => [
                                                                          'CVE-2007-4829'
                                                                        ],
                                                              'description' => 'Directory traversal vulnerability in the Archive::Tar Perl module 1.36 and earlier allows user-assisted remote attackers to overwrite arbitrary files via a TAR archive that contains a file whose name is an absolute path or has ".." sequences.
',
                                                              'distribution' => 'Archive-Tar',
                                                              'fixed_versions' => '>1.36',
                                                              'id' => 'CPANSA-Archive-Tar-2007-4829',
                                                              'references' => [
                                                                                'http://rt.cpan.org/Public/Bug/Display.html?id=29517',
                                                                                'https://bugzilla.redhat.com/show_bug.cgi?id=295021',
                                                                                'http://rt.cpan.org/Public/Bug/Display.html?id=30380',
                                                                                'https://issues.rpath.com/browse/RPL-1716',
                                                                                'http://www.securityfocus.com/bid/26355',
                                                                                'http://secunia.com/advisories/27539',
                                                                                'http://osvdb.org/40410',
                                                                                'http://www.ubuntu.com/usn/usn-700-1',
                                                                                'http://secunia.com/advisories/33314',
                                                                                'http://www.ubuntu.com/usn/usn-700-2',
                                                                                'http://www.gentoo.org/security/en/glsa/glsa-200812-10.xml',
                                                                                'http://secunia.com/advisories/33116',
                                                                                'http://www.vupen.com/english/advisories/2007/3755',
                                                                                'https://exchange.xforce.ibmcloud.com/vulnerabilities/38285',
                                                                                'https://oval.cisecurity.org/repository/search/definition/oval%3Aorg.mitre.oval%3Adef%3A11658'
                                                                              ],
                                                              'reported' => '2007-11-02',
                                                              'severity' => undef
                                                            }
                                                          ],
                                          'main_module' => 'Archive::Tar',
                                          'versions' => [
                                                          {
                                                            'date' => '1998-02-02T06:13:59',
                                                            'version' => '0.071'
                                                          },
                                                          {
                                                            'date' => '1998-04-10T17:07:35',
                                                            'version' => '0.072'
                                                          },
                                                          {
                                                            'date' => '1998-07-30T00:56:03',
                                                            'version' => '0.08'
                                                          },
                                                          {
                                                            'date' => '1999-01-10T02:22:23',
                                                            'version' => '0.20'
                                                          },
                                                          {
                                                            'date' => '1999-02-02T19:01:41',
                                                            'version' => '0.21'
                                                          },
                                                          {
                                                            'date' => '2000-04-28T00:37:46',
                                                            'version' => '0.22'
                                                          },
                                                          {
                                                            'date' => '2003-01-21T23:07:30',
                                                            'version' => '0.23'
                                                          },
                                                          {
                                                            'date' => '2003-03-18T17:08:50',
                                                            'version' => '0.99_01'
                                                          },
                                                          {
                                                            'date' => '2003-03-26T14:57:35',
                                                            'version' => '0.99_02'
                                                          },
                                                          {
                                                            'date' => '2003-04-28T16:01:24',
                                                            'version' => '0.99_03'
                                                          },
                                                          {
                                                            'date' => '2003-04-28T16:57:58',
                                                            'version' => '0.99_04'
                                                          },
                                                          {
                                                            'date' => '2003-04-30T12:52:19',
                                                            'version' => '0.99_05'
                                                          },
                                                          {
                                                            'date' => '2003-05-05T12:06:35',
                                                            'version' => '0.99_06'
                                                          },
                                                          {
                                                            'date' => '2003-05-31T09:27:33',
                                                            'version' => '1.00'
                                                          },
                                                          {
                                                            'date' => '2003-06-08T10:46:56',
                                                            'version' => '1.01'
                                                          },
                                                          {
                                                            'date' => '2003-06-12T09:47:58',
                                                            'version' => '1.02'
                                                          },
                                                          {
                                                            'date' => '2003-06-26T12:52:19',
                                                            'version' => '1.03'
                                                          },
                                                          {
                                                            'date' => '2003-07-27T17:07:50',
                                                            'version' => '1.04'
                                                          },
                                                          {
                                                            'date' => '2003-08-25T13:38:44',
                                                            'version' => '1.05'
                                                          },
                                                          {
                                                            'date' => '2003-10-15T14:35:12',
                                                            'version' => '1.06'
                                                          },
                                                          {
                                                            'date' => '2003-10-17T11:42:14',
                                                            'version' => '1.07'
                                                          },
                                                          {
                                                            'date' => '2004-01-05T12:59:23',
                                                            'version' => '1.08'
                                                          },
                                                          {
                                                            'date' => '2004-05-22T12:32:02',
                                                            'version' => '1.09'
                                                          },
                                                          {
                                                            'date' => '2004-06-11T19:24:06',
                                                            'version' => '1.10'
                                                          },
                                                          {
                                                            'date' => '2004-11-09T16:12:40',
                                                            'version' => '1.20'
                                                          },
                                                          {
                                                            'date' => '2004-11-10T16:04:13',
                                                            'version' => '1.21'
                                                          },
                                                          {
                                                            'date' => '2004-11-21T10:09:52',
                                                            'version' => '1.22'
                                                          },
                                                          {
                                                            'date' => '2004-12-03T15:53:06',
                                                            'version' => '1.23'
                                                          },
                                                          {
                                                            'date' => '2005-05-03T13:11:19',
                                                            'version' => '1.24'
                                                          },
                                                          {
                                                            'date' => '2005-08-20T10:14:40',
                                                            'version' => '1.25'
                                                          },
                                                          {
                                                            'date' => '2005-08-22T09:29:53',
                                                            'version' => '1.26'
                                                          },
                                                          {
                                                            'date' => '2006-01-19T13:31:53',
                                                            'version' => '1.28'
                                                          },
                                                          {
                                                            'date' => '2006-03-03T13:56:20',
                                                            'version' => '1.29'
                                                          },
                                                          {
                                                            'date' => '2006-08-02T15:00:41',
                                                            'version' => '1.30'
                                                          },
                                                          {
                                                            'date' => '2007-05-18T12:18:49',
                                                            'version' => '1.31'
                                                          },
                                                          {
                                                            'date' => '2007-05-25T09:32:48',
                                                            'version' => '1.32'
                                                          },
                                                          {
                                                            'date' => '2007-08-15T14:20:33',
                                                            'version' => '1.34'
                                                          },
                                                          {
                                                            'date' => '2007-09-16T09:13:21',
                                                            'version' => '1.36'
                                                          },
                                                          {
                                                            'date' => '2007-11-11T11:59:00',
                                                            'version' => '1.37_01'
                                                          },
                                                          {
                                                            'date' => '2007-12-24T11:02:07',
                                                            'version' => '1.38'
                                                          },
                                                          {
                                                            'date' => '2008-08-22T16:33:49',
                                                            'version' => '1.39_01'
                                                          },
                                                          {
                                                            'date' => '2008-08-25T03:56:58',
                                                            'version' => '1.39_02'
                                                          },
                                                          {
                                                            'date' => '2008-08-25T22:07:56',
                                                            'version' => '1.39_03'
                                                          },
                                                          {
                                                            'date' => '2008-09-08T12:14:37',
                                                            'version' => '1.39_04'
                                                          },
                                                          {
                                                            'date' => '2008-10-13T13:42:10',
                                                            'version' => '1.40'
                                                          },
                                                          {
                                                            'date' => '2008-12-13T17:10:15',
                                                            'version' => '1.42'
                                                          },
                                                          {
                                                            'date' => '2009-01-19T17:08:08',
                                                            'version' => '1.44'
                                                          },
                                                          {
                                                            'date' => '2009-03-05T16:10:06',
                                                            'version' => '1.46'
                                                          },
                                                          {
                                                            'date' => '2009-04-20T17:07:30',
                                                            'version' => '1.48'
                                                          },
                                                          {
                                                            'date' => '2009-06-12T12:01:54',
                                                            'version' => '1.50'
                                                          },
                                                          {
                                                            'date' => '2009-06-13T11:29:50',
                                                            'version' => '1.52'
                                                          },
                                                          {
                                                            'date' => '2009-09-10T12:13:03',
                                                            'version' => '1.54'
                                                          },
                                                          {
                                                            'date' => '2010-02-03T14:40:15',
                                                            'version' => '1.56'
                                                          },
                                                          {
                                                            'date' => '2010-02-17T21:47:16',
                                                            'version' => '1.58'
                                                          },
                                                          {
                                                            'date' => '2010-04-23T14:12:31',
                                                            'version' => '1.60'
                                                          },
                                                          {
                                                            'date' => '2010-06-28T21:02:59',
                                                            'version' => '1.62'
                                                          },
                                                          {
                                                            'date' => '2010-07-09T11:04:45',
                                                            'version' => '1.64'
                                                          },
                                                          {
                                                            'date' => '2010-07-26T08:44:00',
                                                            'version' => '1.66'
                                                          },
                                                          {
                                                            'date' => '2010-08-17T16:06:19',
                                                            'version' => '1.68'
                                                          },
                                                          {
                                                            'date' => '2010-11-15T22:02:53',
                                                            'version' => '1.70'
                                                          },
                                                          {
                                                            'date' => '2010-11-18T19:22:01',
                                                            'version' => '1.72'
                                                          },
                                                          {
                                                            'date' => '2010-12-18T21:19:51',
                                                            'version' => '1.74'
                                                          },
                                                          {
                                                            'date' => '2011-01-07T22:27:40',
                                                            'version' => '1.76'
                                                          },
                                                          {
                                                            'date' => '2011-09-08T22:13:33',
                                                            'version' => '1.78'
                                                          },
                                                          {
                                                            'date' => '2011-10-13T10:25:39',
                                                            'version' => '1.80'
                                                          },
                                                          {
                                                            'date' => '2011-11-21T12:14:43',
                                                            'version' => '1.82'
                                                          },
                                                          {
                                                            'date' => '2012-03-03T00:00:05',
                                                            'version' => '1.84'
                                                          },
                                                          {
                                                            'date' => '2012-05-24T11:38:09',
                                                            'version' => '1.86'
                                                          },
                                                          {
                                                            'date' => '2012-06-01T11:06:25',
                                                            'version' => '1.88'
                                                          },
                                                          {
                                                            'date' => '2012-09-05T18:19:00',
                                                            'version' => '1.90'
                                                          },
                                                          {
                                                            'date' => '2013-06-18T15:13:27',
                                                            'version' => '1.92'
                                                          },
                                                          {
                                                            'date' => '2013-10-22T14:28:22',
                                                            'version' => '0.93_01'
                                                          },
                                                          {
                                                            'date' => '2013-10-22T14:36:08',
                                                            'version' => '1.93_02'
                                                          },
                                                          {
                                                            'date' => '2013-10-24T18:02:48',
                                                            'version' => '1.94'
                                                          },
                                                          {
                                                            'date' => '2013-10-24T19:10:34',
                                                            'version' => '1.96'
                                                          },
                                                          {
                                                            'date' => '2014-06-14T17:12:02',
                                                            'version' => '1.98'
                                                          },
                                                          {
                                                            'date' => '2014-06-15T14:59:24',
                                                            'version' => '2.00'
                                                          },
                                                          {
                                                            'date' => '2014-09-14T18:03:23',
                                                            'version' => '2.02'
                                                          },
                                                          {
                                                            'date' => '2014-12-14T20:13:33',
                                                            'version' => '2.04'
                                                          },
                                                          {
                                                            'date' => '2016-04-24T14:05:11',
                                                            'version' => '2.06'
                                                          },
                                                          {
                                                            'date' => '2016-05-12T08:57:35',
                                                            'version' => '2.08'
                                                          },
                                                          {
                                                            'date' => '2016-07-27T12:40:29',
                                                            'version' => '2.10'
                                                          },
                                                          {
                                                            'date' => '2016-10-16T11:27:58',
                                                            'version' => '2.12'
                                                          },
                                                          {
                                                            'date' => '2016-10-20T12:38:57',
                                                            'version' => '2.14'
                                                          },
                                                          {
                                                            'date' => '2016-11-01T19:19:36',
                                                            'version' => '2.16'
                                                          },
                                                          {
                                                            'date' => '2016-11-07T13:36:15',
                                                            'version' => '2.18'
                                                          },
                                                          {
                                                            'date' => '2016-12-15T10:54:40',
                                                            'version' => '2.20'
                                                          },
                                                          {
                                                            'date' => '2016-12-16T09:46:28',
                                                            'version' => '2.22'
                                                          },
                                                          {
                                                            'date' => '2016-12-16T15:27:38',
                                                            'version' => '2.24'
                                                          },
                                                          {
                                                            'date' => '2017-05-12T12:46:05',
                                                            'version' => '2.26'
                                                          },
                                                          {
                                                            'date' => '2018-06-08T10:57:04',
                                                            'version' => '2.28'
                                                          },
                                                          {
                                                            'date' => '2018-06-19T11:55:28',
                                                            'version' => '2.30'
                                                          },
                                                          {
                                                            'date' => '2018-09-13T07:17:10',
                                                            'version' => '2.32'
                                                          },
                                                          {
                                                            'date' => '2020-02-01T16:41:47',
                                                            'version' => '2.34'
                                                          },
                                                          {
                                                            'date' => '2020-02-02T13:34:34',
                                                            'version' => '2.36'
                                                          },
                                                          {
                                                            'date' => '2020-06-25T07:51:56',
                                                            'version' => '2.38'
                                                          },
                                                          {
                                                            'date' => '2021-07-27T09:51:54',
                                                            'version' => '2.40'
                                                          }
                                                        ]
                                        },
                       'Archive-Zip' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<1.61',
                                                              'cves' => [
                                                                          'CVE-2018-10860'
                                                                        ],
                                                              'description' => 'perl-archive-zip is vulnerable to a directory traversal in Archive::Zip. It was found that the Archive::Zip module did not properly sanitize paths while extracting zip files. An attacker able to provide a specially crafted archive for processing could use this flaw to write or overwrite arbitrary files in the context of the perl interpreter.
',
                                                              'distribution' => 'Archive-Zip',
                                                              'id' => 'CPANSA-Archive-Zip-2018-01',
                                                              'references' => [
                                                                                'https://security-tracker.debian.org/tracker/CVE-2018-10860',
                                                                                'https://github.com/redhotpenguin/perl-Archive-Zip/pull/33'
                                                                              ],
                                                              'reported' => '2018-06-28',
                                                              'severity' => 'medium'
                                                            },
                                                            {
                                                              'affected_versions' => '<1.14',
                                                              'cves' => [
                                                                          'CVE-2004-1096'
                                                                        ],
                                                              'description' => 'Archive::Zip Perl module before 1.14, when used by antivirus programs such as amavisd-new, allows remote attackers to bypass antivirus protection via a compressed file with both local and global headers set to zero, which does not prevent the compressed file from being opened on a target system.
',
                                                              'distribution' => 'Archive-Zip',
                                                              'fixed_versions' => undef,
                                                              'id' => 'CPANSA-Archive-Zip-2004-1096',
                                                              'references' => [
                                                                                'http://www.securityfocus.com/bid/11448',
                                                                                'http://www.gentoo.org/security/en/glsa/glsa-200410-31.xml',
                                                                                'http://www.idefense.com/application/poi/display?id=153&type=vulnerabilities&flashstatus=true',
                                                                                'http://www.kb.cert.org/vuls/id/492545',
                                                                                'http://secunia.com/advisories/13038/',
                                                                                'http://www.mandriva.com/security/advisories?name=MDKSA-2004:118',
                                                                                'https://exchange.xforce.ibmcloud.com/vulnerabilities/17761'
                                                                              ],
                                                              'reported' => '2005-01-10',
                                                              'severity' => undef
                                                            }
                                                          ],
                                          'main_module' => 'Archive::Zip',
                                          'versions' => [
                                                          {
                                                            'date' => '2000-03-22T00:10:21',
                                                            'version' => '0.06'
                                                          },
                                                          {
                                                            'date' => '2000-03-29T17:03:46',
                                                            'version' => '0.07'
                                                          },
                                                          {
                                                            'date' => '2000-06-16T16:48:41',
                                                            'version' => '0.09'
                                                          },
                                                          {
                                                            'date' => '2000-08-08T20:56:31',
                                                            'version' => '0.10'
                                                          },
                                                          {
                                                            'date' => '2001-01-17T08:06:58',
                                                            'version' => '0.11'
                                                          },
                                                          {
                                                            'date' => '2002-04-22T15:32:49',
                                                            'version' => '1.00'
                                                          },
                                                          {
                                                            'date' => '2002-05-11T02:45:20',
                                                            'version' => '1.01'
                                                          },
                                                          {
                                                            'date' => '2002-08-24T00:19:19',
                                                            'version' => '1.02'
                                                          },
                                                          {
                                                            'date' => '2002-09-03T04:40:33',
                                                            'version' => '1.03'
                                                          },
                                                          {
                                                            'date' => '2002-09-11T15:17:37',
                                                            'version' => '1.04'
                                                          },
                                                          {
                                                            'date' => '2002-09-11T19:35:26',
                                                            'version' => '1.05'
                                                          },
                                                          {
                                                            'date' => '2003-07-17T18:18:14',
                                                            'version' => '1.06'
                                                          },
                                                          {
                                                            'date' => '2003-10-20T13:59:00',
                                                            'version' => '1.07'
                                                          },
                                                          {
                                                            'date' => '2003-10-21T17:04:03',
                                                            'version' => '1.08'
                                                          },
                                                          {
                                                            'date' => '2003-11-27T18:02:03',
                                                            'version' => '1.09'
                                                          },
                                                          {
                                                            'date' => '2004-03-25T14:39:05',
                                                            'version' => '1.10'
                                                          },
                                                          {
                                                            'date' => '2004-07-05T23:25:19',
                                                            'version' => '1_11'
                                                          },
                                                          {
                                                            'date' => '2004-07-08T17:31:27',
                                                            'version' => '1.11'
                                                          },
                                                          {
                                                            'date' => '2004-07-08T19:14:46',
                                                            'version' => '1.12'
                                                          },
                                                          {
                                                            'date' => '2004-07-27T22:50:39',
                                                            'version' => '1.12_02'
                                                          },
                                                          {
                                                            'date' => '2004-07-29T15:15:49',
                                                            'version' => '1.12_03'
                                                          },
                                                          {
                                                            'date' => '2004-08-23T15:39:23',
                                                            'version' => '1.13'
                                                          },
                                                          {
                                                            'date' => '2004-10-21T15:28:12',
                                                            'version' => '1.14'
                                                          },
                                                          {
                                                            'date' => '2005-03-10T04:34:04',
                                                            'version' => '1.15_01'
                                                          },
                                                          {
                                                            'date' => '2005-03-12T15:29:48',
                                                            'version' => '1.15_02'
                                                          },
                                                          {
                                                            'date' => '2005-06-22T18:29:34',
                                                            'version' => '1.15'
                                                          },
                                                          {
                                                            'date' => '2005-07-04T17:55:17',
                                                            'version' => '1.16'
                                                          },
                                                          {
                                                            'date' => '2006-04-30T03:53:15',
                                                            'version' => '1.17_01'
                                                          },
                                                          {
                                                            'date' => '2006-05-07T02:49:30',
                                                            'version' => '1.17_02'
                                                          },
                                                          {
                                                            'date' => '2006-09-15T15:56:10',
                                                            'version' => '1.17_03'
                                                          },
                                                          {
                                                            'date' => '2006-10-24T15:06:32',
                                                            'version' => '1.17_05'
                                                          },
                                                          {
                                                            'date' => '2006-10-25T12:24:52',
                                                            'version' => '1.18'
                                                          },
                                                          {
                                                            'date' => '2007-06-05T01:50:42',
                                                            'version' => '1.20'
                                                          },
                                                          {
                                                            'date' => '2007-11-01T02:59:20',
                                                            'version' => '1.21'
                                                          },
                                                          {
                                                            'date' => '2007-11-02T01:52:47',
                                                            'version' => '1.22'
                                                          },
                                                          {
                                                            'date' => '2007-11-07T13:04:41',
                                                            'version' => '1.23'
                                                          },
                                                          {
                                                            'date' => '2008-08-23T23:35:50',
                                                            'version' => '1.24'
                                                          },
                                                          {
                                                            'date' => '2008-10-10T05:28:17',
                                                            'version' => '1.25'
                                                          },
                                                          {
                                                            'date' => '2008-10-12T14:13:05',
                                                            'version' => '1.26'
                                                          },
                                                          {
                                                            'date' => '2008-12-16T13:23:21',
                                                            'version' => '1.27_01'
                                                          },
                                                          {
                                                            'date' => '2009-06-16T10:09:03',
                                                            'version' => '1.28'
                                                          },
                                                          {
                                                            'date' => '2009-06-29T13:27:17',
                                                            'version' => '1.29'
                                                          },
                                                          {
                                                            'date' => '2009-06-30T14:13:29',
                                                            'version' => '1.30'
                                                          },
                                                          {
                                                            'date' => '2010-03-05T05:11:20',
                                                            'version' => '1.31_01'
                                                          },
                                                          {
                                                            'date' => '2011-03-08T15:52:02',
                                                            'version' => '1.31_02'
                                                          },
                                                          {
                                                            'date' => '2011-08-23T03:42:14',
                                                            'version' => '1.31_03'
                                                          },
                                                          {
                                                            'date' => '2012-01-23T06:28:16',
                                                            'version' => '1.31_04'
                                                          },
                                                          {
                                                            'date' => '2013-11-09T00:05:06',
                                                            'version' => '1.32'
                                                          },
                                                          {
                                                            'date' => '2013-11-10T03:50:45',
                                                            'version' => '1.33'
                                                          },
                                                          {
                                                            'date' => '2013-12-02T22:16:54',
                                                            'version' => '1.34'
                                                          },
                                                          {
                                                            'date' => '2013-12-30T19:16:52',
                                                            'version' => '1.35'
                                                          },
                                                          {
                                                            'date' => '2013-12-30T22:12:14',
                                                            'version' => '1.36'
                                                          },
                                                          {
                                                            'date' => '2014-01-13T18:32:19',
                                                            'version' => '1.37'
                                                          },
                                                          {
                                                            'date' => '2014-09-02T23:23:11',
                                                            'version' => '1.38'
                                                          },
                                                          {
                                                            'date' => '2014-10-22T04:17:15',
                                                            'version' => '1.39'
                                                          },
                                                          {
                                                            'date' => '2015-01-05T05:58:46',
                                                            'version' => '1.40'
                                                          },
                                                          {
                                                            'date' => '2015-01-10T02:47:42',
                                                            'version' => '1.41'
                                                          },
                                                          {
                                                            'date' => '2015-01-12T00:46:36',
                                                            'version' => '1.42'
                                                          },
                                                          {
                                                            'date' => '2015-01-15T06:37:32',
                                                            'version' => '1.43'
                                                          },
                                                          {
                                                            'date' => '2015-01-24T06:12:21',
                                                            'version' => '1.44'
                                                          },
                                                          {
                                                            'date' => '2015-01-27T07:51:17',
                                                            'version' => '1.45'
                                                          },
                                                          {
                                                            'date' => '2015-03-25T05:19:23',
                                                            'version' => '1.46'
                                                          },
                                                          {
                                                            'date' => '2015-06-17T18:26:02',
                                                            'version' => '1.47'
                                                          },
                                                          {
                                                            'date' => '2015-06-18T21:13:37',
                                                            'version' => '1.48'
                                                          },
                                                          {
                                                            'date' => '2015-07-31T19:01:40',
                                                            'version' => '1.49'
                                                          },
                                                          {
                                                            'date' => '2015-08-26T00:11:35',
                                                            'version' => '1.50'
                                                          },
                                                          {
                                                            'date' => '2015-09-22T06:03:54',
                                                            'version' => '1.51'
                                                          },
                                                          {
                                                            'date' => '2015-09-23T17:43:44',
                                                            'version' => '1.53'
                                                          },
                                                          {
                                                            'date' => '2015-12-04T19:36:41',
                                                            'version' => '1.55'
                                                          },
                                                          {
                                                            'date' => '2015-12-17T18:29:06',
                                                            'version' => '1.56'
                                                          },
                                                          {
                                                            'date' => '2016-04-01T18:06:36',
                                                            'version' => '1.57'
                                                          },
                                                          {
                                                            'date' => '2016-08-02T17:50:20',
                                                            'version' => '1.58'
                                                          },
                                                          {
                                                            'date' => '2016-08-11T20:09:16',
                                                            'version' => '1.59'
                                                          },
                                                          {
                                                            'date' => '2017-12-19T18:44:16',
                                                            'version' => '1.60'
                                                          },
                                                          {
                                                            'date' => '2018-08-19T03:35:10',
                                                            'version' => '1.61'
                                                          },
                                                          {
                                                            'date' => '2018-08-20T03:29:01',
                                                            'version' => '1.62'
                                                          },
                                                          {
                                                            'date' => '2018-08-22T15:42:15',
                                                            'version' => '1.63'
                                                          },
                                                          {
                                                            'date' => '2018-09-12T15:50:29',
                                                            'version' => '1.64'
                                                          },
                                                          {
                                                            'date' => '2019-09-08T05:20:03',
                                                            'version' => '1.65'
                                                          },
                                                          {
                                                            'date' => '2019-09-17T04:37:32',
                                                            'version' => '1.66'
                                                          },
                                                          {
                                                            'date' => '2019-10-07T04:30:05',
                                                            'version' => '1.67'
                                                          },
                                                          {
                                                            'date' => '2020-03-12T17:59:46',
                                                            'version' => '1.68'
                                                          }
                                                        ]
                                        },
                       'Batch-BatchRun' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '>=1.03',
                                                                 'cves' => [
                                                                             'CVE-2011-4117'
                                                                           ],
                                                                 'description' => 'The Batch::BatchRun module 1.03 for Perl does not properly handle temporary files.
',
                                                                 'distribution' => 'Batch-BatchRun',
                                                                 'fixed_versions' => undef,
                                                                 'id' => 'CPANSA-Batch-BatchRun-2011-4117',
                                                                 'references' => [
                                                                                   'http://www.openwall.com/lists/oss-security/2011/11/04/2',
                                                                                   'http://www.openwall.com/lists/oss-security/2011/11/04/4',
                                                                                   'https://rt.cpan.org/Public/Bug/Display.html?id=69594'
                                                                                 ],
                                                                 'reported' => '2020-01-31',
                                                                 'severity' => 'high'
                                                               }
                                                             ],
                                             'main_module' => undef,
                                             'versions' => []
                                           },
                       'CBOR-XS' => {
                                      'advisories' => [
                                                        {
                                                          'affected_versions' => '<1.7',
                                                          'cves' => [],
                                                          'description' => 'An out-of bound sharedref or stringref index could cause an out of bounds access - might be exploitable. A decoding error during indefinite array or hash decoding could cause an endless loop.
',
                                                          'distribution' => 'CBOR-XS',
                                                          'fixed_versions' => '>=1.7',
                                                          'id' => 'CPANSA-CBOR-XS-2017-01',
                                                          'references' => [
                                                                            'https://metacpan.org/dist/CBOR-XS/changes'
                                                                          ],
                                                          'reported' => '2017-07-27',
                                                          'severity' => undef
                                                        }
                                                      ],
                                      'main_module' => 'CBOR::XS',
                                      'versions' => [
                                                      {
                                                        'date' => '2013-10-25T23:10:42',
                                                        'version' => '0.01'
                                                      },
                                                      {
                                                        'date' => '2013-10-26T11:09:56',
                                                        'version' => '0.02'
                                                      },
                                                      {
                                                        'date' => '2013-10-26T23:04:01',
                                                        'version' => '0.03'
                                                      },
                                                      {
                                                        'date' => '2013-10-27T22:48:22',
                                                        'version' => '0.04'
                                                      },
                                                      {
                                                        'date' => '2013-10-28T21:28:30',
                                                        'version' => '0.05'
                                                      },
                                                      {
                                                        'date' => '2013-10-29T15:57:13',
                                                        'version' => '0.06'
                                                      },
                                                      {
                                                        'date' => '2013-10-29T22:05:30',
                                                        'version' => '0.07'
                                                      },
                                                      {
                                                        'date' => '2013-10-30T10:11:46',
                                                        'version' => '0.08'
                                                      },
                                                      {
                                                        'date' => '2013-11-22T16:19:26',
                                                        'version' => '0.09'
                                                      },
                                                      {
                                                        'date' => '2013-11-28T16:09:19',
                                                        'version' => '1.0'
                                                      },
                                                      {
                                                        'date' => '2013-11-30T18:42:59',
                                                        'version' => '1.1'
                                                      },
                                                      {
                                                        'date' => '2013-12-01T17:11:47',
                                                        'version' => '1.11'
                                                      },
                                                      {
                                                        'date' => '2013-12-03T10:25:03',
                                                        'version' => '1.12'
                                                      },
                                                      {
                                                        'date' => '2013-12-10T21:07:58',
                                                        'version' => '1.2'
                                                      },
                                                      {
                                                        'date' => '2014-01-05T14:25:36',
                                                        'version' => '1.25'
                                                      },
                                                      {
                                                        'date' => '2014-10-25T06:37:38',
                                                        'version' => '1.26'
                                                      },
                                                      {
                                                        'date' => '2015-04-27T20:22:15',
                                                        'version' => '1.3'
                                                      },
                                                      {
                                                        'date' => '2016-02-08T04:38:25',
                                                        'version' => '1.4'
                                                      },
                                                      {
                                                        'date' => '2016-02-25T14:23:47',
                                                        'version' => '1.41'
                                                      },
                                                      {
                                                        'date' => '2016-04-27T09:40:38',
                                                        'version' => '1.5'
                                                      },
                                                      {
                                                        'date' => '2016-12-07T14:14:49',
                                                        'version' => '1.6'
                                                      },
                                                      {
                                                        'date' => '2017-06-27T02:03:48',
                                                        'version' => '1.7'
                                                      },
                                                      {
                                                        'date' => '2018-11-15T19:53:50',
                                                        'version' => '1.71'
                                                      },
                                                      {
                                                        'date' => '2020-11-29T21:36:13',
                                                        'version' => '1.8'
                                                      },
                                                      {
                                                        'date' => '2020-11-30T18:31:32',
                                                        'version' => '1.81'
                                                      },
                                                      {
                                                        'date' => '2020-12-01T01:50:49',
                                                        'version' => '1.82'
                                                      },
                                                      {
                                                        'date' => '2020-12-08T08:30:59',
                                                        'version' => '1.83'
                                                      },
                                                      {
                                                        'date' => '2021-10-21T01:16:11',
                                                        'version' => '1.84'
                                                      },
                                                      {
                                                        'date' => '2021-10-23T03:00:48',
                                                        'version' => '1.85'
                                                      },
                                                      {
                                                        'date' => '2021-11-04T16:50:24',
                                                        'version' => '1.86'
                                                      }
                                                    ]
                                    },
                       'CGI' => {
                                  'advisories' => [
                                                    {
                                                      'affected_versions' => '<3.63',
                                                      'cves' => [
                                                                  'CVE-2012-5526'
                                                                ],
                                                      'description' => 'CGI.pm module before 3.63 for Perl does not properly escape newlines in (1) Set-Cookie or (2) P3P headers, which might allow remote attackers to inject arbitrary headers into responses from applications that use CGI.pm.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.63',
                                                      'id' => 'CPANSA-CGI-2012-5526',
                                                      'references' => [
                                                                        'http://www.securityfocus.com/bid/56562',
                                                                        'http://www.openwall.com/lists/oss-security/2012/11/15/6',
                                                                        'https://github.com/markstos/CGI.pm/pull/23',
                                                                        'http://www.securitytracker.com/id?1027780',
                                                                        'http://cpansearch.perl.org/src/MARKSTOS/CGI.pm-3.63/Changes',
                                                                        'http://secunia.com/advisories/51457',
                                                                        'http://www.ubuntu.com/usn/USN-1643-1',
                                                                        'http://www.debian.org/security/2012/dsa-2586',
                                                                        'http://rhn.redhat.com/errata/RHSA-2013-0685.html',
                                                                        'http://secunia.com/advisories/55314',
                                                                        'http://www.oracle.com/technetwork/topics/security/ovmbulletinjul2016-3090546.html',
                                                                        'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10735',
                                                                        'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10705',
                                                                        'https://exchange.xforce.ibmcloud.com/vulnerabilities/80098'
                                                                      ],
                                                      'reported' => '2012-11-21',
                                                      'severity' => undef
                                                    },
                                                    {
                                                      'affected_versions' => '<3.56',
                                                      'cves' => [
                                                                  'CVE-2011-2766'
                                                                ],
                                                      'description' => 'Usage of deprecated FCGI.pm API.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.56',
                                                      'id' => 'CPANSA-CGI-2011-2766',
                                                      'references' => [
                                                                        'https://rt.cpan.org/Public/Bug/Display.html?id=68380',
                                                                        'http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2011-2766'
                                                                      ],
                                                      'reported' => '2011-11-08'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.50',
                                                      'description' => 'Non-random MIME boundary.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.50',
                                                      'id' => 'CPANSA-CGI-2010-02',
                                                      'reported' => '2010-11-08'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.49',
                                                      'description' => 'Newlines in headers.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.49',
                                                      'id' => 'CPANSA-CGI-2010-01',
                                                      'reported' => '2010-02-05'
                                                    },
                                                    {
                                                      'affected_versions' => '<3.50',
                                                      'cves' => [
                                                                  'CVE-2010-4411'
                                                                ],
                                                      'description' => 'Unspecified vulnerability in CGI.pm 3.50 and earlier allows remote attackers to inject arbitrary HTTP headers and conduct HTTP response splitting attacks via unknown vectors.  NOTE: this issue exists because of an incomplete fix for CVE-2010-2761.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.50',
                                                      'id' => 'CPANSA-CGI-2010-4411',
                                                      'references' => [
                                                                        'http://openwall.com/lists/oss-security/2010/12/01/3',
                                                                        'http://www.mandriva.com/security/advisories?name=MDVSA-2011:008',
                                                                        'http://www.vupen.com/english/advisories/2011/0106',
                                                                        'http://www.bugzilla.org/security/3.2.9/',
                                                                        'http://secunia.com/advisories/43033',
                                                                        'https://bugzilla.mozilla.org/show_bug.cgi?id=591165',
                                                                        'http://www.vupen.com/english/advisories/2011/0207',
                                                                        'http://www.vupen.com/english/advisories/2011/0271',
                                                                        'http://www.vupen.com/english/advisories/2011/0212',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053665.html',
                                                                        'http://secunia.com/advisories/43068',
                                                                        'http://lists.opensuse.org/opensuse-security-announce/2011-01/msg00006.html',
                                                                        'http://secunia.com/advisories/43165',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053678.html',
                                                                        'http://lists.opensuse.org/opensuse-security-announce/2011-04/msg00000.html'
                                                                      ],
                                                      'reported' => '2010-12-06',
                                                      'severity' => undef
                                                    },
                                                    {
                                                      'affected_versions' => '<3.50',
                                                      'cves' => [
                                                                  'CVE-2010-2761'
                                                                ],
                                                      'description' => 'The multipart_init function in (1) CGI.pm before 3.50 and (2) Simple.pm in CGI::Simple 1.112 and earlier uses a hardcoded value of the MIME boundary string in multipart/x-mixed-replace content, which allows remote attackers to inject arbitrary HTTP headers and conduct HTTP response splitting attacks via crafted input that contains this value, a different vulnerability than CVE-2010-3172.
',
                                                      'distribution' => 'CGI',
                                                      'fixed_versions' => '>=3.50',
                                                      'id' => 'CPANSA-CGI-2010-2761',
                                                      'references' => [
                                                                        'https://github.com/AndyA/CGI--Simple/commit/e4942b871a26c1317a175a91ebb7262eea59b380',
                                                                        'http://cpansearch.perl.org/src/LDS/CGI.pm-3.50/Changes',
                                                                        'http://openwall.com/lists/oss-security/2010/12/01/1',
                                                                        'http://www.nntp.perl.org/group/perl.perl5.changes/2010/11/msg28043.html',
                                                                        'http://perl5.git.perl.org/perl.git/blobdiff/a0b94c2432b1d8c20653453a0f6970cb10f59aec..84601d63a7e34958da47dad1e61e27cb3bd467d1:/cpan/CGI/lib/CGI.pm',
                                                                        'http://perl5.git.perl.org/perl.git/commit/84601d63a7e34958da47dad1e61e27cb3bd467d1',
                                                                        'http://openwall.com/lists/oss-security/2010/12/01/2',
                                                                        'http://openwall.com/lists/oss-security/2010/12/01/3',
                                                                        'https://bugzilla.mozilla.org/show_bug.cgi?id=600464',
                                                                        'http://osvdb.org/69588',
                                                                        'http://osvdb.org/69589',
                                                                        'http://lists.opensuse.org/opensuse-security-announce/2011-01/msg00003.html',
                                                                        'http://www.mandriva.com/security/advisories?name=MDVSA-2010:237',
                                                                        'http://www.vupen.com/english/advisories/2011/0076',
                                                                        'http://www.mandriva.com/security/advisories?name=MDVSA-2010:250',
                                                                        'http://secunia.com/advisories/42877',
                                                                        'https://bugzilla.mozilla.org/show_bug.cgi?id=591165',
                                                                        'http://www.vupen.com/english/advisories/2011/0207',
                                                                        'http://www.bugzilla.org/security/3.2.9/',
                                                                        'http://secunia.com/advisories/43033',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-January/053591.html',
                                                                        'http://secunia.com/advisories/43147',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-January/053576.html',
                                                                        'http://www.vupen.com/english/advisories/2011/0249',
                                                                        'http://www.vupen.com/english/advisories/2011/0271',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053678.html',
                                                                        'http://www.vupen.com/english/advisories/2011/0212',
                                                                        'http://lists.opensuse.org/opensuse-security-announce/2011-01/msg00006.html',
                                                                        'http://secunia.com/advisories/43165',
                                                                        'http://secunia.com/advisories/43068',
                                                                        'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053665.html',
                                                                        'http://www.redhat.com/support/errata/RHSA-2011-1797.html',
                                                                        'http://lists.opensuse.org/opensuse-security-announce/2011-04/msg00000.html',
                                                                        'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10735',
                                                                        'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10705'
                                                                      ],
                                                      'reported' => '2010-12-06',
                                                      'severity' => undef
                                                    }
                                                  ],
                                  'main_module' => 'CGI',
                                  'versions' => [
                                                  {
                                                    'date' => '1995-11-25T09:21:00',
                                                    'version' => '2.10'
                                                  },
                                                  {
                                                    'date' => '1995-12-28T09:08:00',
                                                    'version' => '2.13'
                                                  },
                                                  {
                                                    'date' => '1996-05-22T22:30:00',
                                                    'version' => '2.20'
                                                  },
                                                  {
                                                    'date' => '1996-05-31T05:31:00',
                                                    'version' => '2.21'
                                                  },
                                                  {
                                                    'date' => '1996-08-07T09:24:00',
                                                    'version' => '2.22'
                                                  },
                                                  {
                                                    'date' => '1996-08-14T08:17:00',
                                                    'version' => '2.23'
                                                  },
                                                  {
                                                    'date' => '1996-08-21T09:09:00',
                                                    'version' => '2.24'
                                                  },
                                                  {
                                                    'date' => '1996-09-10T14:23:00',
                                                    'version' => '2.25'
                                                  },
                                                  {
                                                    'date' => '1996-10-22T11:17:00',
                                                    'version' => '2.26'
                                                  },
                                                  {
                                                    'date' => '1996-10-24T18:21:00',
                                                    'version' => '2.27'
                                                  },
                                                  {
                                                    'date' => '1996-12-02T11:48:00',
                                                    'version' => '2.28'
                                                  },
                                                  {
                                                    'date' => '1996-12-09T13:39:00',
                                                    'version' => '2.29'
                                                  },
                                                  {
                                                    'date' => '1997-01-02T16:40:00',
                                                    'version' => '2.30'
                                                  },
                                                  {
                                                    'date' => '1997-02-15T15:36:00',
                                                    'version' => '2.31'
                                                  },
                                                  {
                                                    'date' => '1997-03-25T08:58:00',
                                                    'version' => '2.32'
                                                  },
                                                  {
                                                    'date' => '1997-04-04T20:45:00',
                                                    'version' => '2.33'
                                                  },
                                                  {
                                                    'date' => '1997-04-10T15:41:00',
                                                    'version' => '2.34'
                                                  },
                                                  {
                                                    'date' => '1997-04-20T18:29:00',
                                                    'version' => '2.35'
                                                  },
                                                  {
                                                    'date' => '1997-05-09T09:33:00',
                                                    'version' => '2.36'
                                                  },
                                                  {
                                                    'date' => '1997-08-29T04:42:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-09-15T17:51:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-10-01T04:15:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-10-12T07:10:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-11-23T11:37:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1997-12-20T09:57:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-16T12:22:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-19T11:34:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-26T11:00:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-01-29T19:48:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-02T13:37:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-05T08:25:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-09T13:58:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-16T16:21:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-23T08:33:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-02-24T16:52:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-03-13T15:33:00',
                                                    'version' => '2.37'
                                                  },
                                                  {
                                                    'date' => '1998-03-22T21:12:00',
                                                    'version' => '2.38'
                                                  },
                                                  {
                                                    'date' => '1998-03-24T22:37:08',
                                                    'version' => '2.39'
                                                  },
                                                  {
                                                    'date' => '1998-05-20T09:17:00',
                                                    'version' => '2.40'
                                                  },
                                                  {
                                                    'date' => '1998-05-28T15:03:00',
                                                    'version' => '2.41'
                                                  },
                                                  {
                                                    'date' => '1998-06-09T09:00:00',
                                                    'version' => '2.42'
                                                  },
                                                  {
                                                    'date' => '1998-10-14T19:06:31',
                                                    'version' => '2.43'
                                                  },
                                                  {
                                                    'date' => '1998-11-24T19:41:41',
                                                    'version' => '2.44'
                                                  },
                                                  {
                                                    'date' => '1998-11-26T11:07:27',
                                                    'version' => '2.45'
                                                  },
                                                  {
                                                    'date' => '1998-12-06T10:22:46',
                                                    'version' => '2.46'
                                                  },
                                                  {
                                                    'date' => '1999-02-18T03:50:16',
                                                    'version' => '2.47'
                                                  },
                                                  {
                                                    'date' => '1999-02-19T14:10:25',
                                                    'version' => '2.48'
                                                  },
                                                  {
                                                    'date' => '1999-02-23T22:00:33',
                                                    'version' => '2.49'
                                                  },
                                                  {
                                                    'date' => '1999-06-08T15:13:15',
                                                    'version' => '2.52'
                                                  },
                                                  {
                                                    'date' => '1999-06-09T14:56:06',
                                                    'version' => '2.53'
                                                  },
                                                  {
                                                    'date' => '1999-08-09T14:18:33',
                                                    'version' => '2.54'
                                                  },
                                                  {
                                                    'date' => '1999-08-31T17:11:00',
                                                    'version' => '2.55'
                                                  },
                                                  {
                                                    'date' => '1999-09-13T21:11:51',
                                                    'version' => '2.56'
                                                  },
                                                  {
                                                    'date' => '2000-03-23T23:00:12',
                                                    'version' => '2.58'
                                                  },
                                                  {
                                                    'date' => '2000-03-24T12:31:52',
                                                    'version' => '2.59'
                                                  },
                                                  {
                                                    'date' => '2000-03-27T22:11:34',
                                                    'version' => '2.60'
                                                  },
                                                  {
                                                    'date' => '2000-03-28T02:50:18',
                                                    'version' => '2.61'
                                                  },
                                                  {
                                                    'date' => '2000-03-28T21:38:03',
                                                    'version' => '2.62'
                                                  },
                                                  {
                                                    'date' => '2000-04-10T15:19:54',
                                                    'version' => '2.63'
                                                  },
                                                  {
                                                    'date' => '2000-04-11T15:25:13',
                                                    'version' => '2.64'
                                                  },
                                                  {
                                                    'date' => '2000-04-11T15:55:40',
                                                    'version' => '2.65'
                                                  },
                                                  {
                                                    'date' => '2000-04-12T20:16:46',
                                                    'version' => '2.66'
                                                  },
                                                  {
                                                    'date' => '2000-05-16T01:38:08',
                                                    'version' => '2.67'
                                                  },
                                                  {
                                                    'date' => '2000-05-18T17:55:55',
                                                    'version' => '2.68'
                                                  },
                                                  {
                                                    'date' => '2000-07-28T03:06:11',
                                                    'version' => '2.69'
                                                  },
                                                  {
                                                    'date' => '2000-08-04T19:37:27',
                                                    'version' => '2.70'
                                                  },
                                                  {
                                                    'date' => '2000-08-13T16:09:25',
                                                    'version' => '2.71'
                                                  },
                                                  {
                                                    'date' => '2000-08-20T17:35:50',
                                                    'version' => '2.72'
                                                  },
                                                  {
                                                    'date' => '2000-08-24T13:33:37',
                                                    'version' => '3.'
                                                  },
                                                  {
                                                    'date' => '2000-09-13T02:55:51',
                                                    'version' => '2.73'
                                                  },
                                                  {
                                                    'date' => '2000-09-13T16:35:14',
                                                    'version' => '2.74'
                                                  },
                                                  {
                                                    'date' => '2001-02-02T15:43:07',
                                                    'version' => '2.75'
                                                  },
                                                  {
                                                    'date' => '2001-02-02T15:50:53',
                                                    'version' => '2.751'
                                                  },
                                                  {
                                                    'date' => '2001-02-04T23:49:27',
                                                    'version' => '2.752'
                                                  },
                                                  {
                                                    'date' => '2001-03-12T17:00:13',
                                                    'version' => '2.753'
                                                  },
                                                  {
                                                    'date' => '2001-06-15T15:33:28',
                                                    'version' => '3.02'
                                                  },
                                                  {
                                                    'date' => '2001-06-29T14:47:39',
                                                    'version' => '3.02_'
                                                  },
                                                  {
                                                    'date' => '2001-07-05T16:13:55',
                                                    'version' => '3.03_01'
                                                  },
                                                  {
                                                    'date' => '2001-07-26T21:29:22',
                                                    'version' => '2.76'
                                                  },
                                                  {
                                                    'date' => '2001-08-07T12:33:22',
                                                    'version' => '2.77'
                                                  },
                                                  {
                                                    'date' => '2001-09-26T02:26:36',
                                                    'version' => '2.78'
                                                  },
                                                  {
                                                    'date' => '2001-12-09T21:39:11',
                                                    'version' => '2.79'
                                                  },
                                                  {
                                                    'date' => '2002-01-12T02:47:17',
                                                    'version' => '2.80'
                                                  },
                                                  {
                                                    'date' => '2002-04-10T19:39:49',
                                                    'version' => '2.81'
                                                  },
                                                  {
                                                    'date' => '2002-09-11T12:27:48',
                                                    'version' => '2.84'
                                                  },
                                                  {
                                                    'date' => '2002-09-11T14:01:02',
                                                    'version' => '2.85'
                                                  },
                                                  {
                                                    'date' => '2002-09-12T03:58:40',
                                                    'version' => '2.86'
                                                  },
                                                  {
                                                    'date' => '2002-10-07T02:00:58',
                                                    'version' => '2.87'
                                                  },
                                                  {
                                                    'date' => '2002-10-14T13:58:09',
                                                    'version' => '2.88'
                                                  },
                                                  {
                                                    'date' => '2002-10-16T17:50:26',
                                                    'version' => '2.89'
                                                  },
                                                  {
                                                    'date' => '2002-11-22T23:03:39',
                                                    'version' => 0
                                                  },
                                                  {
                                                    'date' => '2003-02-10T20:11:57',
                                                    'version' => '2.90'
                                                  },
                                                  {
                                                    'date' => '2003-02-11T14:15:15',
                                                    'version' => '2.91'
                                                  },
                                                  {
                                                    'date' => '2003-04-28T00:44:10',
                                                    'version' => '2.92'
                                                  },
                                                  {
                                                    'date' => '2003-04-28T13:37:43',
                                                    'version' => '2.93'
                                                  },
                                                  {
                                                    'date' => '2003-06-09T12:15:29',
                                                    'version' => '2.94'
                                                  },
                                                  {
                                                    'date' => '2003-06-13T02:35:42',
                                                    'version' => '2.95'
                                                  },
                                                  {
                                                    'date' => '2003-06-16T18:42:38',
                                                    'version' => '2.96'
                                                  },
                                                  {
                                                    'date' => '2003-06-17T23:32:52',
                                                    'version' => '2.97'
                                                  },
                                                  {
                                                    'date' => '2003-07-16T17:06:29',
                                                    'version' => '2.98'
                                                  },
                                                  {
                                                    'date' => '2003-08-01T14:43:54',
                                                    'version' => '2.99'
                                                  },
                                                  {
                                                    'date' => '2003-08-18T17:51:48',
                                                    'version' => '3.00'
                                                  },
                                                  {
                                                    'date' => '2003-12-10T17:05:47',
                                                    'version' => '3.01'
                                                  },
                                                  {
                                                    'date' => '2004-01-13T16:34:47',
                                                    'version' => '3.03'
                                                  },
                                                  {
                                                    'date' => '2004-01-19T12:44:30',
                                                    'version' => '3.04'
                                                  },
                                                  {
                                                    'date' => '2004-04-12T20:39:57',
                                                    'version' => '3.05'
                                                  },
                                                  {
                                                    'date' => '2005-03-09T21:06:46',
                                                    'version' => '3.06'
                                                  },
                                                  {
                                                    'date' => '2005-03-14T16:34:03',
                                                    'version' => '3.07'
                                                  },
                                                  {
                                                    'date' => '2005-04-20T15:31:11',
                                                    'version' => '3.08'
                                                  },
                                                  {
                                                    'date' => '2005-05-05T20:16:55',
                                                    'version' => '3.09'
                                                  },
                                                  {
                                                    'date' => '2005-05-13T21:48:46',
                                                    'version' => '3.10'
                                                  },
                                                  {
                                                    'date' => '2005-08-03T21:17:14',
                                                    'version' => '3.11'
                                                  },
                                                  {
                                                    'date' => '2005-12-04T16:46:53',
                                                    'version' => '3.12'
                                                  },
                                                  {
                                                    'date' => '2005-12-05T13:54:26',
                                                    'version' => '3.13'
                                                  },
                                                  {
                                                    'date' => '2005-12-06T22:14:19',
                                                    'version' => '3.14'
                                                  },
                                                  {
                                                    'date' => '2005-12-07T20:16:49',
                                                    'version' => '3.15'
                                                  },
                                                  {
                                                    'date' => '2006-02-08T18:50:56',
                                                    'version' => '3.16'
                                                  },
                                                  {
                                                    'date' => '2006-02-24T19:04:58',
                                                    'version' => '3.17'
                                                  },
                                                  {
                                                    'date' => '2006-04-17T13:56:06',
                                                    'version' => '3.19'
                                                  },
                                                  {
                                                    'date' => '2006-04-23T14:27:55',
                                                    'version' => '3.20'
                                                  },
                                                  {
                                                    'date' => '2006-08-21T19:12:36',
                                                    'version' => '3.21'
                                                  },
                                                  {
                                                    'date' => '2006-08-23T15:24:41',
                                                    'version' => '3.22'
                                                  },
                                                  {
                                                    'date' => '2006-08-24T11:53:26',
                                                    'version' => '3.23'
                                                  },
                                                  {
                                                    'date' => '2006-09-28T17:09:45',
                                                    'version' => '3.25'
                                                  },
                                                  {
                                                    'date' => '2007-02-27T15:42:54',
                                                    'version' => '3.27'
                                                  },
                                                  {
                                                    'date' => '2007-03-29T15:38:01',
                                                    'version' => '3.28'
                                                  },
                                                  {
                                                    'date' => '2007-04-16T17:00:18',
                                                    'version' => '3.29'
                                                  },
                                                  {
                                                    'date' => '2007-11-30T19:06:19',
                                                    'version' => '3.31'
                                                  },
                                                  {
                                                    'date' => '2007-12-27T18:41:32',
                                                    'version' => '3.32'
                                                  },
                                                  {
                                                    'date' => '2008-01-03T15:03:17',
                                                    'version' => '3.33'
                                                  },
                                                  {
                                                    'date' => '2008-03-18T16:04:41',
                                                    'version' => '3.34'
                                                  },
                                                  {
                                                    'date' => '2008-03-27T14:26:48',
                                                    'version' => '3.35'
                                                  },
                                                  {
                                                    'date' => '2008-04-23T13:09:44',
                                                    'version' => '3.37'
                                                  },
                                                  {
                                                    'date' => '2008-06-25T14:58:32',
                                                    'version' => '3.38'
                                                  },
                                                  {
                                                    'date' => '2008-07-29T15:01:52',
                                                    'version' => '3.39'
                                                  },
                                                  {
                                                    'date' => '2008-08-06T18:21:51',
                                                    'version' => '3.40'
                                                  },
                                                  {
                                                    'date' => '2008-08-26T13:56:27',
                                                    'version' => '3.41'
                                                  },
                                                  {
                                                    'date' => '2008-09-08T14:15:41',
                                                    'version' => '3.42'
                                                  },
                                                  {
                                                    'date' => '2009-04-06T18:35:19',
                                                    'version' => '3.43'
                                                  },
                                                  {
                                                    'date' => '2009-07-30T16:34:17',
                                                    'version' => '3.44'
                                                  },
                                                  {
                                                    'date' => '2009-08-14T13:37:12',
                                                    'version' => '3.45'
                                                  },
                                                  {
                                                    'date' => '2009-09-09T15:39:42',
                                                    'version' => '3.46'
                                                  },
                                                  {
                                                    'date' => '2009-09-09T20:03:01',
                                                    'version' => '3.47'
                                                  },
                                                  {
                                                    'date' => '2009-09-25T15:07:03',
                                                    'version' => '3.48'
                                                  },
                                                  {
                                                    'date' => '2010-02-05T16:24:53',
                                                    'version' => '3.49'
                                                  },
                                                  {
                                                    'date' => '2010-11-08T21:53:26',
                                                    'version' => '3.50'
                                                  },
                                                  {
                                                    'date' => '2011-01-05T18:28:41',
                                                    'version' => '3.51'
                                                  },
                                                  {
                                                    'date' => '2011-01-25T04:30:05',
                                                    'version' => '3.52'
                                                  },
                                                  {
                                                    'date' => '2011-04-25T23:01:21',
                                                    'version' => '3.53'
                                                  },
                                                  {
                                                    'date' => '2011-04-28T14:36:41',
                                                    'version' => '3.54'
                                                  },
                                                  {
                                                    'date' => '2011-06-03T15:39:16',
                                                    'version' => '3.55'
                                                  },
                                                  {
                                                    'date' => '2011-11-09T02:00:20',
                                                    'version' => '3.56'
                                                  },
                                                  {
                                                    'date' => '2011-11-09T15:59:18',
                                                    'version' => '3.57'
                                                  },
                                                  {
                                                    'date' => '2011-11-12T03:36:07',
                                                    'version' => '3.58'
                                                  },
                                                  {
                                                    'date' => '2011-12-30T13:35:35',
                                                    'version' => '3.59'
                                                  },
                                                  {
                                                    'date' => '2012-08-16T03:21:13',
                                                    'version' => '3.60'
                                                  },
                                                  {
                                                    'date' => '2012-11-03T02:10:42',
                                                    'version' => '3.61'
                                                  },
                                                  {
                                                    'date' => '2012-11-10T01:40:50',
                                                    'version' => '3.62'
                                                  },
                                                  {
                                                    'date' => '2012-11-14T23:45:29',
                                                    'version' => '3.63'
                                                  },
                                                  {
                                                    'date' => '2013-11-24T01:22:00',
                                                    'version' => '3.64'
                                                  },
                                                  {
                                                    'date' => '2014-02-12T03:13:58',
                                                    'version' => '3.65'
                                                  },
                                                  {
                                                    'date' => '2014-05-15T12:59:58',
                                                    'version' => '3.65_01'
                                                  },
                                                  {
                                                    'date' => '2014-05-16T11:43:33',
                                                    'version' => '3.65_02'
                                                  },
                                                  {
                                                    'date' => '2014-05-20T12:31:46',
                                                    'version' => '3.65_03'
                                                  },
                                                  {
                                                    'date' => '2014-05-22T19:58:14',
                                                    'version' => '4.00'
                                                  },
                                                  {
                                                    'date' => '2014-05-27T13:13:51',
                                                    'version' => '4.01'
                                                  },
                                                  {
                                                    'date' => '2014-06-09T13:55:49',
                                                    'version' => '4.02'
                                                  },
                                                  {
                                                    'date' => '2014-07-02T14:53:06',
                                                    'version' => '4.03'
                                                  },
                                                  {
                                                    'date' => '2014-07-28T18:30:34',
                                                    'version' => '4.03_01'
                                                  },
                                                  {
                                                    'date' => '2014-07-30T14:26:40',
                                                    'version' => '4.03_02'
                                                  },
                                                  {
                                                    'date' => '2014-08-13T11:40:14',
                                                    'version' => '4.03_03'
                                                  },
                                                  {
                                                    'date' => '2014-09-04T14:42:14',
                                                    'version' => '4.04'
                                                  },
                                                  {
                                                    'date' => '2014-09-20T16:08:55',
                                                    'version' => '4.04_01'
                                                  },
                                                  {
                                                    'date' => '2014-09-28T19:57:05',
                                                    'version' => '4.04_02'
                                                  },
                                                  {
                                                    'date' => '2014-09-29T09:50:07',
                                                    'version' => '4.04_03'
                                                  },
                                                  {
                                                    'date' => '2014-10-06T12:01:14',
                                                    'version' => '4.04_04'
                                                  },
                                                  {
                                                    'date' => '2014-10-06T12:24:10',
                                                    'version' => '4.04_05'
                                                  },
                                                  {
                                                    'date' => '2014-10-08T07:42:49',
                                                    'version' => '4.05'
                                                  },
                                                  {
                                                    'date' => '2014-10-10T11:35:49',
                                                    'version' => '4.06'
                                                  },
                                                  {
                                                    'date' => '2014-10-12T16:29:35',
                                                    'version' => '4.07'
                                                  },
                                                  {
                                                    'date' => '2014-10-18T11:00:38',
                                                    'version' => '4.08'
                                                  },
                                                  {
                                                    'date' => '2014-10-21T07:33:36',
                                                    'version' => '4.09'
                                                  },
                                                  {
                                                    'date' => '2014-11-25T21:06:50',
                                                    'version' => '4.09_01'
                                                  },
                                                  {
                                                    'date' => '2014-11-27T12:53:51',
                                                    'version' => '4.10'
                                                  },
                                                  {
                                                    'date' => '2014-11-30T12:12:26',
                                                    'version' => '4.10_01'
                                                  },
                                                  {
                                                    'date' => '2014-12-03T07:25:15',
                                                    'version' => '4.11'
                                                  },
                                                  {
                                                    'date' => '2014-12-18T08:35:52',
                                                    'version' => '4.12'
                                                  },
                                                  {
                                                    'date' => '2014-12-18T09:21:52',
                                                    'version' => '4.13'
                                                  },
                                                  {
                                                    'date' => '2015-02-12T14:19:13',
                                                    'version' => '4.13_01'
                                                  },
                                                  {
                                                    'date' => '2015-02-13T08:01:29',
                                                    'version' => '4.13_02'
                                                  },
                                                  {
                                                    'date' => '2015-03-01T13:28:25',
                                                    'version' => '4.13_03'
                                                  },
                                                  {
                                                    'date' => '2015-03-08T16:09:21',
                                                    'version' => '4.13_04'
                                                  },
                                                  {
                                                    'date' => '2015-03-25T17:55:15',
                                                    'version' => '4.13_05'
                                                  },
                                                  {
                                                    'date' => '2015-04-01T06:51:57',
                                                    'version' => '4.14'
                                                  },
                                                  {
                                                    'date' => '2015-04-17T14:27:39',
                                                    'version' => '4.14_01'
                                                  },
                                                  {
                                                    'date' => '2015-04-20T07:15:45',
                                                    'version' => '4.15'
                                                  },
                                                  {
                                                    'date' => '2015-05-29T14:48:42',
                                                    'version' => '4.20'
                                                  },
                                                  {
                                                    'date' => '2015-06-22T07:50:02',
                                                    'version' => '4.21'
                                                  },
                                                  {
                                                    'date' => '2015-10-16T09:46:31',
                                                    'version' => '4.22'
                                                  },
                                                  {
                                                    'date' => '2015-12-20T18:33:35',
                                                    'version' => '4.24'
                                                  },
                                                  {
                                                    'date' => '2015-12-21T09:29:19',
                                                    'version' => '4.25'
                                                  },
                                                  {
                                                    'date' => '2016-02-04T16:37:12',
                                                    'version' => '4.26'
                                                  },
                                                  {
                                                    'date' => '2016-03-02T08:03:46',
                                                    'version' => '4.27'
                                                  },
                                                  {
                                                    'date' => '2016-03-14T07:21:48',
                                                    'version' => '4.28'
                                                  },
                                                  {
                                                    'date' => '2016-05-22T12:23:19',
                                                    'version' => '4.28_01'
                                                  },
                                                  {
                                                    'date' => '2016-05-22T12:54:23',
                                                    'version' => '4.28_02'
                                                  },
                                                  {
                                                    'date' => '2016-05-23T08:25:25',
                                                    'version' => '4.28_03'
                                                  },
                                                  {
                                                    'date' => '2016-06-09T12:01:20',
                                                    'version' => '4.29'
                                                  },
                                                  {
                                                    'date' => '2016-06-09T12:11:54',
                                                    'version' => '4.30'
                                                  },
                                                  {
                                                    'date' => '2016-06-14T07:14:00',
                                                    'version' => '4.31'
                                                  },
                                                  {
                                                    'date' => '2016-07-19T07:05:46',
                                                    'version' => '4.32'
                                                  },
                                                  {
                                                    'date' => '2016-09-16T09:47:49',
                                                    'version' => '4.33'
                                                  },
                                                  {
                                                    'date' => '2016-10-13T11:58:55',
                                                    'version' => '4.34'
                                                  },
                                                  {
                                                    'date' => '2016-10-13T13:56:21',
                                                    'version' => '4.35'
                                                  },
                                                  {
                                                    'date' => '2017-03-29T08:56:26',
                                                    'version' => '4.35_01'
                                                  },
                                                  {
                                                    'date' => '2017-04-06T14:42:12',
                                                    'version' => '4.36'
                                                  },
                                                  {
                                                    'date' => '2017-11-01T10:17:40',
                                                    'version' => '4.37'
                                                  },
                                                  {
                                                    'date' => '2017-12-01T08:41:02',
                                                    'version' => '4.38'
                                                  },
                                                  {
                                                    'date' => '2018-08-13T15:57:52',
                                                    'version' => '4.39'
                                                  },
                                                  {
                                                    'date' => '2018-08-15T08:39:39',
                                                    'version' => '4.40'
                                                  },
                                                  {
                                                    'date' => '2019-03-26T15:58:49',
                                                    'version' => '4.41'
                                                  },
                                                  {
                                                    'date' => '2019-03-26T16:33:27',
                                                    'version' => '4.42'
                                                  },
                                                  {
                                                    'date' => '2019-05-01T14:28:45',
                                                    'version' => '4.43'
                                                  },
                                                  {
                                                    'date' => '2019-06-03T09:00:55',
                                                    'version' => '4.44'
                                                  },
                                                  {
                                                    'date' => '2020-01-13T07:03:55',
                                                    'version' => '4.45'
                                                  },
                                                  {
                                                    'date' => '2020-02-03T14:49:22',
                                                    'version' => '4.46'
                                                  },
                                                  {
                                                    'date' => '2020-05-01T13:01:44',
                                                    'version' => '4.47'
                                                  },
                                                  {
                                                    'date' => '2020-06-02T08:22:41',
                                                    'version' => '4.48'
                                                  },
                                                  {
                                                    'date' => '2020-06-08T09:46:25',
                                                    'version' => '4.49'
                                                  },
                                                  {
                                                    'date' => '2020-06-22T07:35:25',
                                                    'version' => '4.50'
                                                  },
                                                  {
                                                    'date' => '2020-10-05T06:14:39',
                                                    'version' => '4.51'
                                                  },
                                                  {
                                                    'date' => '2021-05-04T08:02:27',
                                                    'version' => '4.52'
                                                  },
                                                  {
                                                    'date' => '2021-06-03T06:45:55',
                                                    'version' => '4.53'
                                                  },
                                                  {
                                                    'date' => '2022-02-03T07:52:34',
                                                    'version' => '4.54'
                                                  }
                                                ]
                                },
                       'CGI-Application' => {
                                              'advisories' => [
                                                                {
                                                                  'affected_versions' => '<4.50_51',
                                                                  'cves' => [
                                                                              'CVE-2013-7329'
                                                                            ],
                                                                  'description' => 'The CGI::Application module before 4.50_50 and 4.50_51 for Perl, when run modes are not specified, allows remote attackers to obtain sensitive information (web queries and environment details) via vectors related to the dump_html function.
',
                                                                  'distribution' => 'CGI-Application',
                                                                  'fixed_versions' => undef,
                                                                  'id' => 'CPANSA-CGI-Application-2013-7329',
                                                                  'references' => [
                                                                                    'https://github.com/markstos/CGI--Application/pull/15',
                                                                                    'http://openwall.com/lists/oss-security/2014/02/19/11',
                                                                                    'http://lists.fedoraproject.org/pipermail/package-announce/2014-March/129436.html',
                                                                                    'http://lists.fedoraproject.org/pipermail/package-announce/2014-March/129444.html',
                                                                                    'https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=739505',
                                                                                    'http://www.securityfocus.com/bid/65687',
                                                                                    'https://rt.cpan.org/Public/Bug/Display.html?id=84403',
                                                                                    'https://bugzilla.redhat.com/show_bug.cgi?id=1067180',
                                                                                    'https://exchange.xforce.ibmcloud.com/vulnerabilities/91735'
                                                                                  ],
                                                                  'reported' => '2014-10-06',
                                                                  'severity' => undef
                                                                }
                                                              ],
                                              'main_module' => 'CGI::Application',
                                              'versions' => [
                                                              {
                                                                'date' => '2000-07-11T04:23:51',
                                                                'version' => '1.0'
                                                              },
                                                              {
                                                                'date' => '2000-07-12T15:21:41',
                                                                'version' => '1.1'
                                                              },
                                                              {
                                                                'date' => '2000-07-18T21:11:44',
                                                                'version' => '1.2'
                                                              },
                                                              {
                                                                'date' => '2001-05-21T12:03:59',
                                                                'version' => '1.3'
                                                              },
                                                              {
                                                                'date' => '2001-05-28T18:29:06',
                                                                'version' => '1.31'
                                                              },
                                                              {
                                                                'date' => '2001-06-25T03:17:50',
                                                                'version' => '2.0'
                                                              },
                                                              {
                                                                'date' => '2001-08-11T22:18:28',
                                                                'version' => '2.1'
                                                              },
                                                              {
                                                                'date' => '2002-05-06T03:21:57',
                                                                'version' => '2.2'
                                                              },
                                                              {
                                                                'date' => '2002-05-06T11:57:30',
                                                                'version' => '2.3'
                                                              },
                                                              {
                                                                'date' => '2002-05-27T01:01:18',
                                                                'version' => '2.4'
                                                              },
                                                              {
                                                                'date' => '2002-07-18T11:59:16',
                                                                'version' => '2.5'
                                                              },
                                                              {
                                                                'date' => '2002-10-07T13:03:27',
                                                                'version' => '2.6'
                                                              },
                                                              {
                                                                'date' => '2003-02-01T13:52:45',
                                                                'version' => '3.0'
                                                              },
                                                              {
                                                                'date' => '2003-06-02T13:01:50',
                                                                'version' => '3.1'
                                                              },
                                                              {
                                                                'date' => '2004-02-04T03:23:56',
                                                                'version' => '3.2'
                                                              },
                                                              {
                                                                'date' => '2004-02-04T15:53:56',
                                                                'version' => '3.2'
                                                              },
                                                              {
                                                                'date' => '2004-02-14T01:47:53',
                                                                'version' => '3.22'
                                                              },
                                                              {
                                                                'date' => '2004-09-26T19:22:20',
                                                                'version' => '3.30'
                                                              },
                                                              {
                                                                'date' => '2004-09-26T19:35:26',
                                                                'version' => '3.31'
                                                              },
                                                              {
                                                                'date' => '2005-03-19T14:42:14',
                                                                'version' => '4.0_2'
                                                              },
                                                              {
                                                                'date' => '2005-06-07T03:25:55',
                                                                'version' => '4.0_4'
                                                              },
                                                              {
                                                                'date' => '2005-06-11T04:00:57',
                                                                'version' => '4.0'
                                                              },
                                                              {
                                                                'date' => '2005-06-13T19:15:12',
                                                                'version' => '4.01_01'
                                                              },
                                                              {
                                                                'date' => '2005-06-14T14:37:30',
                                                                'version' => '4.01'
                                                              },
                                                              {
                                                                'date' => '2005-07-24T19:08:18',
                                                                'version' => '4.02_1'
                                                              },
                                                              {
                                                                'date' => '2005-07-31T03:11:25',
                                                                'version' => '4.02'
                                                              },
                                                              {
                                                                'date' => '2005-08-04T23:45:52',
                                                                'version' => '4.03'
                                                              },
                                                              {
                                                                'date' => '2005-09-01T02:54:00',
                                                                'version' => '4.04_01'
                                                              },
                                                              {
                                                                'date' => '2005-09-09T01:12:21',
                                                                'version' => '4.04_02'
                                                              },
                                                              {
                                                                'date' => '2005-10-12T02:12:18',
                                                                'version' => '4.04'
                                                              },
                                                              {
                                                                'date' => '2006-03-02T01:58:41',
                                                                'version' => '4.05'
                                                              },
                                                              {
                                                                'date' => '2006-04-13T02:34:40',
                                                                'version' => '4.06'
                                                              },
                                                              {
                                                                'date' => '2006-07-02T05:05:34',
                                                                'version' => '4.07_01'
                                                              },
                                                              {
                                                                'date' => '2007-10-31T23:34:31',
                                                                'version' => '4.07_02'
                                                              },
                                                              {
                                                                'date' => '2008-06-16T20:09:18',
                                                                'version' => '4.07_03'
                                                              },
                                                              {
                                                                'date' => '2008-06-18T03:30:33',
                                                                'version' => '4.10'
                                                              },
                                                              {
                                                                'date' => '2008-08-10T15:36:00',
                                                                'version' => '4.11'
                                                              },
                                                              {
                                                                'date' => '2008-09-27T04:18:05',
                                                                'version' => '4.11'
                                                              },
                                                              {
                                                                'date' => '2008-11-02T00:43:18',
                                                                'version' => '4.11'
                                                              },
                                                              {
                                                                'date' => '2009-01-03T16:13:59',
                                                                'version' => '4.21'
                                                              },
                                                              {
                                                                'date' => '2009-07-30T01:35:48',
                                                                'version' => '4.30'
                                                              },
                                                              {
                                                                'date' => '2009-07-30T01:42:34',
                                                                'version' => '4.31'
                                                              },
                                                              {
                                                                'date' => '2010-02-14T00:33:00',
                                                                'version' => '4.32_1'
                                                              },
                                                              {
                                                                'date' => '2011-06-16T17:07:16',
                                                                'version' => '4.50'
                                                              },
                                                              {
                                                                'date' => '2015-01-23T12:19:21',
                                                                'version' => '4.50_50'
                                                              },
                                                              {
                                                                'date' => '2015-07-18T12:57:01',
                                                                'version' => '4.50_51'
                                                              },
                                                              {
                                                                'date' => '2018-02-28T13:57:05',
                                                                'version' => '4.60'
                                                              },
                                                              {
                                                                'date' => '2018-03-01T13:29:17',
                                                                'version' => '4.60_1'
                                                              },
                                                              {
                                                                'date' => '2018-03-02T09:20:24',
                                                                'version' => '4.61'
                                                              }
                                                            ]
                                            },
                       'CGI-Application-Dispatch' => {
                                                       'advisories' => [
                                                                         {
                                                                           'affected_versions' => '<1.02',
                                                                           'cves' => [],
                                                                           'description' => 'Untainted module names.
',
                                                                           'distribution' => 'CGI-Application-Dispatch',
                                                                           'fixed_versions' => '>=1.02',
                                                                           'id' => 'CPANSA-CGI-Application-Dispatch-2005-001',
                                                                           'references' => [
                                                                                             'https://metacpan.org/changes/distribution/CGI-Application-Dispatch'
                                                                                           ],
                                                                           'reported' => '2005-01-20'
                                                                         }
                                                                       ],
                                                       'main_module' => 'CGI::Application::Dispatch',
                                                       'versions' => [
                                                                       {
                                                                         'date' => '2004-09-13T01:35:58',
                                                                         'version' => '0.01'
                                                                       },
                                                                       {
                                                                         'date' => '2004-10-19T18:26:01',
                                                                         'version' => '0.02'
                                                                       },
                                                                       {
                                                                         'date' => '2004-10-29T16:53:40',
                                                                         'version' => '0.03'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-06T15:34:49',
                                                                         'version' => '1.00'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-08T12:42:00',
                                                                         'version' => '1.01'
                                                                       },
                                                                       {
                                                                         'date' => '2005-01-20T14:43:28',
                                                                         'version' => '1.02'
                                                                       },
                                                                       {
                                                                         'date' => '2005-03-04T16:28:16',
                                                                         'version' => '1.03'
                                                                       },
                                                                       {
                                                                         'date' => '2005-07-12T21:44:54',
                                                                         'version' => '1.04'
                                                                       },
                                                                       {
                                                                         'date' => '2006-01-12T15:56:53',
                                                                         'version' => '2.00_02'
                                                                       },
                                                                       {
                                                                         'date' => '2006-02-06T15:50:52',
                                                                         'version' => '2.00_03'
                                                                       },
                                                                       {
                                                                         'date' => '2006-02-14T15:41:25',
                                                                         'version' => '2.00_04'
                                                                       },
                                                                       {
                                                                         'date' => '2006-04-12T14:18:22',
                                                                         'version' => '2.00_05'
                                                                       },
                                                                       {
                                                                         'date' => '2006-06-27T04:29:04',
                                                                         'version' => '2.00_06'
                                                                       },
                                                                       {
                                                                         'date' => '2006-07-03T15:52:12',
                                                                         'version' => '2.00'
                                                                       },
                                                                       {
                                                                         'date' => '2006-08-14T14:14:10',
                                                                         'version' => '2.01'
                                                                       },
                                                                       {
                                                                         'date' => '2006-08-17T14:57:55',
                                                                         'version' => '2.02'
                                                                       },
                                                                       {
                                                                         'date' => '2006-09-30T02:13:40',
                                                                         'version' => '2.03'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-03T18:12:57',
                                                                         'version' => '2.10_01'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-11T18:55:41',
                                                                         'version' => '2.10_02'
                                                                       },
                                                                       {
                                                                         'date' => '2007-01-15T14:08:30',
                                                                         'version' => '2.10'
                                                                       },
                                                                       {
                                                                         'date' => '2007-12-28T20:23:49',
                                                                         'version' => '2.11'
                                                                       },
                                                                       {
                                                                         'date' => '2007-12-31T20:43:51',
                                                                         'version' => '2.12_01'
                                                                       },
                                                                       {
                                                                         'date' => '2008-01-03T14:39:57',
                                                                         'version' => '2.12'
                                                                       },
                                                                       {
                                                                         'date' => '2008-03-08T18:33:34',
                                                                         'version' => '2.13_01'
                                                                       },
                                                                       {
                                                                         'date' => '2008-03-11T16:41:27',
                                                                         'version' => '2.13_02'
                                                                       },
                                                                       {
                                                                         'date' => '2008-09-17T00:44:02',
                                                                         'version' => '2.13'
                                                                       },
                                                                       {
                                                                         'date' => '2008-11-03T01:33:21',
                                                                         'version' => '2.14'
                                                                       },
                                                                       {
                                                                         'date' => '2008-12-04T16:00:05',
                                                                         'version' => '2.15'
                                                                       },
                                                                       {
                                                                         'date' => '2009-03-24T02:03:51',
                                                                         'version' => '2.16'
                                                                       },
                                                                       {
                                                                         'date' => '2009-12-30T19:06:27',
                                                                         'version' => '2.17'
                                                                       },
                                                                       {
                                                                         'date' => '2011-01-05T03:42:59',
                                                                         'version' => '2.18'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-16T17:42:14',
                                                                         'version' => '3.00'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-24T02:53:20',
                                                                         'version' => '3.01'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-24T22:33:01',
                                                                         'version' => '3.02'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-26T03:52:14',
                                                                         'version' => '3.03'
                                                                       },
                                                                       {
                                                                         'date' => '2011-06-29T13:45:53',
                                                                         'version' => '3.04'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-07T22:21:15',
                                                                         'version' => '3.05'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-09T15:29:58',
                                                                         'version' => '3.06'
                                                                       },
                                                                       {
                                                                         'date' => '2011-09-09T17:32:11',
                                                                         'version' => '3.07'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-03T04:04:19',
                                                                         'version' => '3.10'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-14T01:02:58',
                                                                         'version' => '3.11'
                                                                       },
                                                                       {
                                                                         'date' => '2012-09-14T01:19:52',
                                                                         'version' => '3.12'
                                                                       }
                                                                     ]
                                                     },
                       'CGI-Application-Plugin-AutoRunmode' => {
                                                                 'advisories' => [
                                                                                   {
                                                                                     'affected_versions' => '<0.04',
                                                                                     'cves' => [],
                                                                                     'description' => 'Non-word characters are allowed in runmode name.
',
                                                                                     'distribution' => 'CGI-Application-Plugin-AutoRunmode',
                                                                                     'fixed_versions' => '>=0.04',
                                                                                     'id' => 'CPANSA-CGI-Application-Plugin-AutoRunmode-2005-01',
                                                                                     'references' => [
                                                                                                       'https://metacpan.org/changes/distribution/CGI-Application-Plugin-AutoRunmode'
                                                                                                     ],
                                                                                     'reported' => '2005-03-04'
                                                                                   }
                                                                                 ],
                                                                 'main_module' => 'CGI::Application::Plugin::AutoRunmode',
                                                                 'versions' => [
                                                                                 {
                                                                                   'date' => '2005-03-04T06:59:51',
                                                                                   'version' => '0.04'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-03-10T07:22:55',
                                                                                   'version' => '0.05'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-06-15T10:20:17',
                                                                                   'version' => '0.06'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-06-18T02:09:08',
                                                                                   'version' => '0.07'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-07-17T00:49:10',
                                                                                   'version' => '0.08'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-09-22T12:31:22',
                                                                                   'version' => '0.09'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-10-16T00:17:47',
                                                                                   'version' => '0.10'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-10-18T13:23:50',
                                                                                   'version' => '0.11'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2005-11-03T01:10:37',
                                                                                   'version' => '0.12'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-04-08T07:18:44',
                                                                                   'version' => '0.13'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-05-21T05:04:48',
                                                                                   'version' => '0.14'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2006-12-17T07:46:24',
                                                                                   'version' => '0.15'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-02-14T09:16:39',
                                                                                   'version' => '0.16'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-05-21T04:24:45',
                                                                                   'version' => '0.17'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2011-02-18T09:23:15',
                                                                                   'version' => '0.18'
                                                                                 }
                                                                               ]
                                                               },
                       'CGI-Application-Plugin-RunmodeDeclare' => {
                                                                    'advisories' => [
                                                                                      {
                                                                                        'affected_versions' => '<0.03',
                                                                                        'cves' => [],
                                                                                        'description' => 'Wrong order of arguments.
',
                                                                                        'distribution' => 'CGI-Application-Plugin-RunmodeDeclare',
                                                                                        'fixed_versions' => '>=0.03',
                                                                                        'id' => 'CPANSA-CGI-Application-Plugin-RunmodeDeclare-2008-01',
                                                                                        'references' => [
                                                                                                          'https://metacpan.org/changes/distribution/CGI-Application-Plugin-RunmodeDeclare'
                                                                                                        ],
                                                                                        'reported' => '2008-10-20'
                                                                                      }
                                                                                    ],
                                                                    'main_module' => 'CGI::Application::Plugin::RunmodeDeclare',
                                                                    'versions' => [
                                                                                    {
                                                                                      'date' => '2008-09-26T19:59:14',
                                                                                      'version' => '0.01'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-09-26T21:37:11',
                                                                                      'version' => '0.02'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-19T23:22:06',
                                                                                      'version' => '0.03'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-23T14:18:23',
                                                                                      'version' => '0.03_01'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-24T13:32:43',
                                                                                      'version' => '0.03_02'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-24T16:20:27',
                                                                                      'version' => '0.03_03'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T10:54:25',
                                                                                      'version' => '0.04'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T11:46:28',
                                                                                      'version' => '0.05'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2008-10-25T16:39:34',
                                                                                      'version' => '0.06'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2009-01-10T02:32:39',
                                                                                      'version' => '0.07'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2009-05-17T22:29:18',
                                                                                      'version' => '0.08'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2010-01-07T13:24:09',
                                                                                      'version' => '0.09'
                                                                                    },
                                                                                    {
                                                                                      'date' => '2012-02-10T00:53:54',
                                                                                      'version' => '0.10'
                                                                                    }
                                                                                  ]
                                                                  },
                       'CGI-Auth-Basic' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<1.11',
                                                                 'cves' => [],
                                                                 'description' => 'TBD
',
                                                                 'distribution' => 'CGI-Auth-Basic',
                                                                 'fixed_versions' => '>=1.11',
                                                                 'id' => 'CPANSA-CGI-Auth-Basic-2007-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/CGI-Auth-Basic'
                                                                                 ],
                                                                 'reported' => '2007-12-30'
                                                               }
                                                             ],
                                             'main_module' => 'CGI::Auth::Basic',
                                             'versions' => [
                                                             {
                                                               'date' => '2004-02-21T14:58:09',
                                                               'version' => '1.0'
                                                             },
                                                             {
                                                               'date' => '2004-08-31T13:29:28',
                                                               'version' => '1.01'
                                                             },
                                                             {
                                                               'date' => '2004-11-07T03:34:32',
                                                               'version' => '1.02'
                                                             },
                                                             {
                                                               'date' => '2006-06-18T01:12:15',
                                                               'version' => '1.10'
                                                             },
                                                             {
                                                               'date' => '2007-12-30T20:53:33',
                                                               'version' => '1.11'
                                                             },
                                                             {
                                                               'date' => '2009-04-18T04:22:51',
                                                               'version' => '1.20'
                                                             },
                                                             {
                                                               'date' => '2009-04-23T17:00:50',
                                                               'version' => '1.21'
                                                             },
                                                             {
                                                               'date' => '2009-04-24T15:07:48',
                                                               'version' => '1.21'
                                                             },
                                                             {
                                                               'date' => '2012-08-27T01:50:53',
                                                               'version' => '1.22'
                                                             },
                                                             {
                                                               'date' => '2015-01-21T00:26:01',
                                                               'version' => '1.23'
                                                             },
                                                             {
                                                               'date' => '2018-12-23T21:03:03',
                                                               'version' => '1.24'
                                                             }
                                                           ]
                                           },
                       'CGI-Session' => {
                                          'advisories' => [
                                                            {
                                                              'affected_versions' => '<4.10',
                                                              'cves' => [
                                                                          'CVE-2006-1279'
                                                                        ],
                                                              'description' => 'CGI::Session 4.03-1 allows local users to overwrite arbitrary files via a symlink attack on temporary files used by (1) Driver::File, (2) Driver::db_file, and possibly (3) Driver::sqlite.
',
                                                              'distribution' => 'CGI-Session',
                                                              'fixed_versions' => undef,
                                                              'id' => 'CPANSA-CGI-Session-2006-1279',
                                                              'references' => [
                                                                                'http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=356555',
                                                                                'http://secunia.com/advisories/19211',
                                                                                'http://www.securityfocus.com/bid/17177',
                                                                                'http://www.osvdb.org/23865',
                                                                                'http://www.vupen.com/english/advisories/2006/0946',
                                                                                'https://exchange.xforce.ibmcloud.com/vulnerabilities/25285'
                                                                              ],
                                                              'reported' => '2006-03-19',
                                                              'severity' => undef
                                                            },
                                                            {
                                                              'affected_versions' => '<4.12',
                                                              'cves' => [],
                                                              'description' => 'possible SQL injection attack
',
                                                              'distribution' => 'CGI-Session',
                                                              'fixed_versions' => '>=4.12',
                                                              'id' => 'CPANSA-CGI-Session-2006-01',
                                                              'references' => [
                                                                                'https://rt.cpan.org/Public/Bug/Display.html?id=18578'
                                                                              ],
                                                              'reported' => '2006-04-06',
                                                              'severity' => undef
                                                            }
                                                          ],
                                          'main_module' => 'CGI::Session',
                                          'versions' => [
                                                          {
                                                            'date' => '2001-10-30T08:59:10',
                                                            'version' => '0.01'
                                                          },
                                                          {
                                                            'date' => '2002-05-10T12:04:15',
                                                            'version' => '2.0'
                                                          },
                                                          {
                                                            'date' => '2002-05-10T17:38:46',
                                                            'version' => '2.1'
                                                          },
                                                          {
                                                            'date' => '2002-05-14T18:21:39',
                                                            'version' => '2.2'
                                                          },
                                                          {
                                                            'date' => '2002-05-17T18:02:23',
                                                            'version' => '2.4'
                                                          },
                                                          {
                                                            'date' => '2002-05-27T09:52:46',
                                                            'version' => '2.7'
                                                          },
                                                          {
                                                            'date' => '2002-06-06T08:08:21',
                                                            'version' => '2.9'
                                                          },
                                                          {
                                                            'date' => '2002-06-06T08:36:26',
                                                            'version' => '2.91'
                                                          },
                                                          {
                                                            'date' => '2002-06-18T18:15:57',
                                                            'version' => '2.92'
                                                          },
                                                          {
                                                            'date' => '2002-08-26T08:23:54',
                                                            'version' => '2.94'
                                                          },
                                                          {
                                                            'date' => '2002-11-27T07:20:47',
                                                            'version' => '3.1'
                                                          },
                                                          {
                                                            'date' => '2002-11-27T12:27:59',
                                                            'version' => '3.2'
                                                          },
                                                          {
                                                            'date' => '2002-11-28T03:19:31',
                                                            'version' => 'v3.2.2.1'
                                                          },
                                                          {
                                                            'date' => '2002-11-28T03:26:41',
                                                            'version' => '3.3'
                                                          },
                                                          {
                                                            'date' => '2002-11-28T03:44:39',
                                                            'version' => '3.4'
                                                          },
                                                          {
                                                            'date' => '2002-11-28T06:55:29',
                                                            'version' => '3.5'
                                                          },
                                                          {
                                                            'date' => '2002-11-28T17:12:32',
                                                            'version' => '3.6'
                                                          },
                                                          {
                                                            'date' => '2002-11-29T21:29:53',
                                                            'version' => '3.7'
                                                          },
                                                          {
                                                            'date' => '2002-12-03T16:26:55',
                                                            'version' => '3.8'
                                                          },
                                                          {
                                                            'date' => '2002-12-04T07:37:02',
                                                            'version' => '3.9'
                                                          },
                                                          {
                                                            'date' => '2002-12-09T09:02:18',
                                                            'version' => '3.10'
                                                          },
                                                          {
                                                            'date' => '2002-12-09T20:09:24',
                                                            'version' => '3.11'
                                                          },
                                                          {
                                                            'date' => '2003-03-09T11:26:21',
                                                            'version' => '3.91'
                                                          },
                                                          {
                                                            'date' => '2003-03-10T02:42:16',
                                                            'version' => '3.92'
                                                          },
                                                          {
                                                            'date' => '2003-03-14T13:21:20',
                                                            'version' => '3.93'
                                                          },
                                                          {
                                                            'date' => '2003-05-02T20:12:40',
                                                            'version' => '3.94'
                                                          },
                                                          {
                                                            'date' => '2003-07-26T13:51:31',
                                                            'version' => '3.95'
                                                          },
                                                          {
                                                            'date' => '2005-02-09T08:35:23',
                                                            'version' => '4.00_01'
                                                          },
                                                          {
                                                            'date' => '2005-02-09T09:54:17',
                                                            'version' => '4.00_02'
                                                          },
                                                          {
                                                            'date' => '2005-02-11T08:23:00',
                                                            'version' => '4.00_03'
                                                          },
                                                          {
                                                            'date' => '2005-02-17T03:24:21',
                                                            'version' => '4.00_04'
                                                          },
                                                          {
                                                            'date' => '2005-02-22T17:56:43',
                                                            'version' => '4.00_05'
                                                          },
                                                          {
                                                            'date' => '2005-02-24T18:46:45',
                                                            'version' => '4.00_06'
                                                          },
                                                          {
                                                            'date' => '2005-03-13T19:18:37',
                                                            'version' => '4.00_07'
                                                          },
                                                          {
                                                            'date' => '2005-03-15T16:48:17',
                                                            'version' => '4.00_08'
                                                          },
                                                          {
                                                            'date' => '2005-07-22T02:00:21',
                                                            'version' => '4.00_09'
                                                          },
                                                          {
                                                            'date' => '2005-09-01T05:57:49',
                                                            'version' => '4.00'
                                                          },
                                                          {
                                                            'date' => '2005-09-01T16:25:46',
                                                            'version' => '4.01'
                                                          },
                                                          {
                                                            'date' => '2005-09-02T15:51:20',
                                                            'version' => '4.02'
                                                          },
                                                          {
                                                            'date' => '2005-09-24T02:12:22',
                                                            'version' => '4.02_01'
                                                          },
                                                          {
                                                            'date' => '2005-10-05T23:22:54',
                                                            'version' => '4.03'
                                                          },
                                                          {
                                                            'date' => '2006-03-02T03:00:28',
                                                            'version' => '4.04'
                                                          },
                                                          {
                                                            'date' => '2006-03-04T00:08:26',
                                                            'version' => '4.05'
                                                          },
                                                          {
                                                            'date' => '2006-03-09T03:13:06',
                                                            'version' => '4.06'
                                                          },
                                                          {
                                                            'date' => '2006-03-09T12:09:28',
                                                            'version' => '4.07'
                                                          },
                                                          {
                                                            'date' => '2006-03-16T02:38:25',
                                                            'version' => '4.08'
                                                          },
                                                          {
                                                            'date' => '2006-03-17T04:08:57',
                                                            'version' => '4.09'
                                                          },
                                                          {
                                                            'date' => '2006-03-28T07:00:52',
                                                            'version' => '4.10'
                                                          },
                                                          {
                                                            'date' => '2006-04-03T19:33:30',
                                                            'version' => '4.11'
                                                          },
                                                          {
                                                            'date' => '2006-04-07T14:34:06',
                                                            'version' => '4.12'
                                                          },
                                                          {
                                                            'date' => '2006-04-12T17:05:18',
                                                            'version' => '4.13'
                                                          },
                                                          {
                                                            'date' => '2006-06-11T11:36:57',
                                                            'version' => '4.14'
                                                          },
                                                          {
                                                            'date' => '2006-11-24T14:10:38',
                                                            'version' => '4.20_1'
                                                          },
                                                          {
                                                            'date' => '2006-12-05T02:08:37',
                                                            'version' => '4.20'
                                                          },
                                                          {
                                                            'date' => '2008-03-22T02:42:57',
                                                            'version' => '4.29_1'
                                                          },
                                                          {
                                                            'date' => '2008-03-28T01:45:56',
                                                            'version' => '4.29_2'
                                                          },
                                                          {
                                                            'date' => '2008-04-26T01:31:34',
                                                            'version' => '4.30'
                                                          },
                                                          {
                                                            'date' => '2008-06-16T14:44:06',
                                                            'version' => '4.31'
                                                          },
                                                          {
                                                            'date' => '2008-06-17T21:35:03',
                                                            'version' => '4.32'
                                                          },
                                                          {
                                                            'date' => '2008-07-08T01:27:59',
                                                            'version' => '4.33'
                                                          },
                                                          {
                                                            'date' => '2008-07-13T02:39:59',
                                                            'version' => '4.34'
                                                          },
                                                          {
                                                            'date' => '2008-07-16T00:36:46',
                                                            'version' => '4.35'
                                                          },
                                                          {
                                                            'date' => '2008-09-13T15:45:06',
                                                            'version' => '4.36'
                                                          },
                                                          {
                                                            'date' => '2008-10-23T02:57:30',
                                                            'version' => '4.37'
                                                          },
                                                          {
                                                            'date' => '2008-11-01T03:47:46',
                                                            'version' => '4.38'
                                                          },
                                                          {
                                                            'date' => '2008-12-16T01:22:42',
                                                            'version' => '4.39'
                                                          },
                                                          {
                                                            'date' => '2009-01-03T01:18:15',
                                                            'version' => '4.40'
                                                          },
                                                          {
                                                            'date' => '2009-03-21T02:01:09',
                                                            'version' => '4.41'
                                                          },
                                                          {
                                                            'date' => '2009-08-26T13:38:39',
                                                            'version' => '4.42'
                                                          },
                                                          {
                                                            'date' => '2010-12-12T00:32:27',
                                                            'version' => '4.43'
                                                          },
                                                          {
                                                            'date' => '2011-06-06T20:48:07',
                                                            'version' => '4.44'
                                                          },
                                                          {
                                                            'date' => '2011-07-02T01:33:33',
                                                            'version' => '4.45'
                                                          },
                                                          {
                                                            'date' => '2011-07-08T14:34:42',
                                                            'version' => '4.46'
                                                          },
                                                          {
                                                            'date' => '2011-07-08T19:31:44',
                                                            'version' => '4.47'
                                                          },
                                                          {
                                                            'date' => '2011-07-11T13:02:37',
                                                            'version' => '4.48'
                                                          },
                                                          {
                                                            'date' => '2021-02-08T07:00:20',
                                                            'version' => '4.49'
                                                          }
                                                        ]
                                        },
                       'CGI-Simple' => {
                                         'advisories' => [
                                                           {
                                                             'affected_versions' => '<1.113',
                                                             'cves' => [
                                                                         'CVE-2010-4410'
                                                                       ],
                                                             'description' => 'Newlines in headers, which could lead to header injection attacks.
',
                                                             'distribution' => 'CGI-Simple',
                                                             'fixed_versions' => '>=1.113',
                                                             'id' => 'CPANSA-CGI-Simple-2010-02',
                                                             'references' => [
                                                                               'https://metacpan.org/changes/distribution/CGI-Simple'
                                                                             ],
                                                             'reported' => '2010-12-27'
                                                           },
                                                           {
                                                             'affected_versions' => '<1.113',
                                                             'description' => 'Non-random multipart boundary.
',
                                                             'distribution' => 'CGI-Simple',
                                                             'fixed_versions' => '>=1.113',
                                                             'id' => 'CPANSA-CGI-Simple-2010-01',
                                                             'references' => [
                                                                               'https://metacpan.org/changes/distribution/CGI-Simple'
                                                                             ],
                                                             'reported' => '2010-12-27'
                                                           },
                                                           {
                                                             'affected_versions' => '<=1.112',
                                                             'cves' => [
                                                                         'CVE-2010-2761'
                                                                       ],
                                                             'description' => 'The multipart_init function in (1) CGI.pm before 3.50 and (2) Simple.pm in CGI::Simple 1.112 and earlier uses a hardcoded value of the MIME boundary string in multipart/x-mixed-replace content, which allows remote attackers to inject arbitrary HTTP headers and conduct HTTP response splitting attacks via crafted input that contains this value, a different vulnerability than CVE-2010-3172.
',
                                                             'distribution' => 'CGI-Simple',
                                                             'fixed_versions' => undef,
                                                             'id' => 'CPANSA-CGI-Simple-2010-2761',
                                                             'references' => [
                                                                               'https://github.com/AndyA/CGI--Simple/commit/e4942b871a26c1317a175a91ebb7262eea59b380',
                                                                               'http://cpansearch.perl.org/src/LDS/CGI.pm-3.50/Changes',
                                                                               'http://openwall.com/lists/oss-security/2010/12/01/1',
                                                                               'http://www.nntp.perl.org/group/perl.perl5.changes/2010/11/msg28043.html',
                                                                               'http://perl5.git.perl.org/perl.git/blobdiff/a0b94c2432b1d8c20653453a0f6970cb10f59aec..84601d63a7e34958da47dad1e61e27cb3bd467d1:/cpan/CGI/lib/CGI.pm',
                                                                               'http://perl5.git.perl.org/perl.git/commit/84601d63a7e34958da47dad1e61e27cb3bd467d1',
                                                                               'http://openwall.com/lists/oss-security/2010/12/01/2',
                                                                               'http://openwall.com/lists/oss-security/2010/12/01/3',
                                                                               'https://bugzilla.mozilla.org/show_bug.cgi?id=600464',
                                                                               'http://osvdb.org/69588',
                                                                               'http://osvdb.org/69589',
                                                                               'http://lists.opensuse.org/opensuse-security-announce/2011-01/msg00003.html',
                                                                               'http://www.mandriva.com/security/advisories?name=MDVSA-2010:237',
                                                                               'http://www.vupen.com/english/advisories/2011/0076',
                                                                               'http://www.mandriva.com/security/advisories?name=MDVSA-2010:250',
                                                                               'http://secunia.com/advisories/42877',
                                                                               'https://bugzilla.mozilla.org/show_bug.cgi?id=591165',
                                                                               'http://www.vupen.com/english/advisories/2011/0207',
                                                                               'http://www.bugzilla.org/security/3.2.9/',
                                                                               'http://secunia.com/advisories/43033',
                                                                               'http://lists.fedoraproject.org/pipermail/package-announce/2011-January/053591.html',
                                                                               'http://secunia.com/advisories/43147',
                                                                               'http://lists.fedoraproject.org/pipermail/package-announce/2011-January/053576.html',
                                                                               'http://www.vupen.com/english/advisories/2011/0249',
                                                                               'http://www.vupen.com/english/advisories/2011/0271',
                                                                               'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053678.html',
                                                                               'http://www.vupen.com/english/advisories/2011/0212',
                                                                               'http://lists.opensuse.org/opensuse-security-announce/2011-01/msg00006.html',
                                                                               'http://secunia.com/advisories/43165',
                                                                               'http://secunia.com/advisories/43068',
                                                                               'http://lists.fedoraproject.org/pipermail/package-announce/2011-February/053665.html',
                                                                               'http://www.redhat.com/support/errata/RHSA-2011-1797.html',
                                                                               'http://lists.opensuse.org/opensuse-security-announce/2011-04/msg00000.html',
                                                                               'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10735',
                                                                               'http://kb.juniper.net/InfoCenter/index?page=content&id=JSA10705'
                                                                             ],
                                                             'reported' => '2010-12-06',
                                                             'severity' => undef
                                                           }
                                                         ],
                                         'main_module' => 'CGI::Simple',
                                         'versions' => [
                                                         {
                                                           'date' => '2007-01-09T22:31:27',
                                                           'version' => '0.078'
                                                         },
                                                         {
                                                           'date' => '2007-02-23T16:22:19',
                                                           'version' => '0.079'
                                                         },
                                                         {
                                                           'date' => '2007-03-30T20:15:35',
                                                           'version' => '0.080'
                                                         },
                                                         {
                                                           'date' => '2007-05-20T19:19:40',
                                                           'version' => '0.081'
                                                         },
                                                         {
                                                           'date' => '2007-05-22T18:43:01',
                                                           'version' => '0.082'
                                                         },
                                                         {
                                                           'date' => '2007-05-22T18:54:06',
                                                           'version' => '0.83'
                                                         },
                                                         {
                                                           'date' => '2007-05-24T03:15:01',
                                                           'version' => '1.0'
                                                         },
                                                         {
                                                           'date' => '2007-07-13T18:58:16',
                                                           'version' => '1.1'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T01:57:01',
                                                           'version' => '1.1.1'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T02:04:25',
                                                           'version' => '1.1.2'
                                                         },
                                                         {
                                                           'date' => '2007-07-31T02:10:47',
                                                           'version' => '1.103'
                                                         },
                                                         {
                                                           'date' => '2008-05-13T15:46:18',
                                                           'version' => '1.104'
                                                         },
                                                         {
                                                           'date' => '2008-05-16T14:37:31',
                                                           'version' => '1.105'
                                                         },
                                                         {
                                                           'date' => '2008-09-14T13:29:51',
                                                           'version' => '1.106'
                                                         },
                                                         {
                                                           'date' => '2009-03-07T21:24:59',
                                                           'version' => '1.107'
                                                         },
                                                         {
                                                           'date' => '2009-03-13T14:06:24',
                                                           'version' => '1.108'
                                                         },
                                                         {
                                                           'date' => '2009-04-16T17:54:13',
                                                           'version' => '1.109'
                                                         },
                                                         {
                                                           'date' => '2009-05-24T21:25:22',
                                                           'version' => '1.110'
                                                         },
                                                         {
                                                           'date' => '2009-05-28T18:02:08',
                                                           'version' => '1.111'
                                                         },
                                                         {
                                                           'date' => '2009-05-31T10:43:56',
                                                           'version' => '1.112'
                                                         },
                                                         {
                                                           'date' => '2010-12-27T13:11:56',
                                                           'version' => '1.113'
                                                         },
                                                         {
                                                           'date' => '2014-10-19T12:53:24',
                                                           'version' => '1.115'
                                                         },
                                                         {
                                                           'date' => '2018-03-01T15:09:42',
                                                           'version' => '1.13'
                                                         },
                                                         {
                                                           'date' => '2018-03-03T10:42:06',
                                                           'version' => '1.14'
                                                         },
                                                         {
                                                           'date' => '2018-03-04T03:42:20',
                                                           'version' => '1.15'
                                                         },
                                                         {
                                                           'date' => '2018-07-25T15:17:39',
                                                           'version' => '1.16'
                                                         },
                                                         {
                                                           'date' => '2018-10-02T09:48:08',
                                                           'version' => '1.17'
                                                         },
                                                         {
                                                           'date' => '2018-10-03T14:21:12',
                                                           'version' => '1.18'
                                                         },
                                                         {
                                                           'date' => '2018-10-04T12:05:58',
                                                           'version' => '1.19'
                                                         },
                                                         {
                                                           'date' => '2018-10-05T11:30:05',
                                                           'version' => '1.20'
                                                         },
                                                         {
                                                           'date' => '2018-10-06T07:21:31',
                                                           'version' => '1.21'
                                                         },
                                                         {
                                                           'date' => '2019-09-07T04:28:17',
                                                           'version' => '1.22'
                                                         },
                                                         {
                                                           'date' => '2020-02-06T06:12:09',
                                                           'version' => '1.23'
                                                         },
                                                         {
                                                           'date' => '2020-02-07T11:11:56',
                                                           'version' => '1.24'
                                                         },
                                                         {
                                                           'date' => '2020-02-10T13:00:54',
                                                           'version' => '1.25'
                                                         },
                                                         {
                                                           'date' => '2022-01-02T18:00:56',
                                                           'version' => '1.26'
                                                         },
                                                         {
                                                           'date' => '2022-01-06T16:00:18',
                                                           'version' => '1.27'
                                                         },
                                                         {
                                                           'date' => '2022-01-11T15:16:20',
                                                           'version' => '1.280'
                                                         }
                                                       ]
                                       },
                       'CGI-apacheSSI' => {
                                            'advisories' => [
                                                              {
                                                                'affected_versions' => '<0.95',
                                                                'cves' => [],
                                                                'description' => 'Security and parsing problems with "include" calls.
',
                                                                'distribution' => 'CGI-apacheSSI',
                                                                'fixed_versions' => '>=0.95',
                                                                'id' => 'CPANSA-CGI-apacheSSI-2016-01',
                                                                'references' => [
                                                                                  'https://metacpan.org/changes/distribution/CGI-apacheSSI'
                                                                                ],
                                                                'reported' => '2016-01-31'
                                                              }
                                                            ],
                                            'main_module' => 'CGI::apacheSSI',
                                            'versions' => [
                                                            {
                                                              'date' => '2014-08-20T22:55:20',
                                                              'version' => '0.93'
                                                            },
                                                            {
                                                              'date' => '2016-01-30T12:57:47',
                                                              'version' => '0.94'
                                                            },
                                                            {
                                                              'date' => '2016-01-31T22:48:55',
                                                              'version' => '0.95'
                                                            },
                                                            {
                                                              'date' => '2016-02-01T00:36:49',
                                                              'version' => '0.96'
                                                            }
                                                          ]
                                          },
                       'CPAN' => {
                                   'advisories' => [
                                                     {
                                                       'affected_versions' => '<1.93',
                                                       'cves' => [],
                                                       'description' => 'Archive::Tar preserves permissions in the tarball; extracted file permissions will be set from users umask instead.
',
                                                       'distribution' => 'CPAN',
                                                       'fixed_versions' => '>=1.93',
                                                       'id' => 'CPANSA-CPAN-2009-01',
                                                       'references' => [
                                                                         'https://github.com/andk/cpanpm/commit/079fa2e7ee77d626eab8bb06d0465c6a05f6c8b6',
                                                                         'https://rt.cpan.org/Ticket/Display.html?id=46384'
                                                                       ],
                                                       'reported' => '2009-09-23'
                                                     },
                                                     {
                                                       'affected_versions' => '<2.28',
                                                       'cves' => [
                                                                   'CVE-2020-16156'
                                                                 ],
                                                       'description' => 'CPAN 2.28 allows Signature Verification Bypass.',
                                                       'distribution' => 'CPAN',
                                                       'fixed_versions' => '>=2.29',
                                                       'id' => 'CPANSA-CPAN-2020-16156',
                                                       'references' => [
                                                                         'https://metacpan.org/pod/distribution/CPAN/scripts/cpan',
                                                                         'https://blog.hackeriet.no/cpan-signature-verification-vulnerabilities/',
                                                                         'http://blogs.perl.org/users/neilb/2021/11/addressing-cpan-vulnerabilities-related-to-checksums.html',
                                                                         'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/SZ32AJIV4RHJMLWLU5QULGKMMIHYOMDC/',
                                                                         'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/SD6RYOJII7HRJ6WVORFNVTYNOFY5JDXN/'
                                                                       ],
                                                       'reported' => '2021-12-13',
                                                       'severity' => 'high'
                                                     }
                                                   ],
                                   'main_module' => 'CPAN',
                                   'versions' => [
                                                   {
                                                     'date' => '1996-09-10T17:13:59',
                                                     'version' => '0.17'
                                                   },
                                                   {
                                                     'date' => '1996-09-10T20:51:00',
                                                     'version' => '0.20'
                                                   },
                                                   {
                                                     'date' => '1996-09-12T05:53:35',
                                                     'version' => '0.26'
                                                   },
                                                   {
                                                     'date' => '1996-09-12T14:01:39',
                                                     'version' => '0.27'
                                                   },
                                                   {
                                                     'date' => '1996-09-16T20:18:59',
                                                     'version' => '0.28'
                                                   },
                                                   {
                                                     'date' => '1996-09-17T17:14:51',
                                                     'version' => '0.29'
                                                   },
                                                   {
                                                     'date' => '1996-09-19T05:24:17',
                                                     'version' => '0.30'
                                                   },
                                                   {
                                                     'date' => '1996-09-20T10:40:01',
                                                     'version' => '0.31'
                                                   },
                                                   {
                                                     'date' => '1996-09-22T19:30:33',
                                                     'version' => '0.35'
                                                   },
                                                   {
                                                     'date' => '1996-09-23T12:55:23',
                                                     'version' => '0.36'
                                                   },
                                                   {
                                                     'date' => '1996-09-23T14:05:44',
                                                     'version' => '0.37'
                                                   },
                                                   {
                                                     'date' => '1996-09-27T12:52:07',
                                                     'version' => '0.39'
                                                   },
                                                   {
                                                     'date' => '1996-09-28T20:51:31',
                                                     'version' => '0.40'
                                                   },
                                                   {
                                                     'date' => '1996-10-01T21:14:27',
                                                     'version' => '0.41'
                                                   },
                                                   {
                                                     'date' => '1996-11-17T07:56:02',
                                                     'version' => '0.42'
                                                   },
                                                   {
                                                     'date' => '1996-11-17T14:51:59',
                                                     'version' => '0.43'
                                                   },
                                                   {
                                                     'date' => '1996-11-30T17:04:28',
                                                     'version' => '0.44'
                                                   },
                                                   {
                                                     'date' => '1996-12-01T12:19:19',
                                                     'version' => '0.45'
                                                   },
                                                   {
                                                     'date' => '1996-12-01T18:24:17',
                                                     'version' => '0.46'
                                                   },
                                                   {
                                                     'date' => '1996-12-10T00:58:25',
                                                     'version' => '1.00'
                                                   },
                                                   {
                                                     'date' => '1996-12-10T10:17:15',
                                                     'version' => '1.01'
                                                   },
                                                   {
                                                     'date' => '1996-12-11T01:31:55',
                                                     'version' => '1.02'
                                                   },
                                                   {
                                                     'date' => '1996-12-21T03:10:23',
                                                     'version' => '1.03'
                                                   },
                                                   {
                                                     'date' => '1996-12-21T20:08:49',
                                                     'version' => '1.04'
                                                   },
                                                   {
                                                     'date' => '1996-12-22T13:04:58',
                                                     'version' => '1.05'
                                                   },
                                                   {
                                                     'date' => '1996-12-22T14:16:08',
                                                     'version' => '1.06'
                                                   },
                                                   {
                                                     'date' => '1996-12-23T04:05:01',
                                                     'version' => '1.07'
                                                   },
                                                   {
                                                     'date' => '1996-12-23T13:18:01',
                                                     'version' => '1.08'
                                                   },
                                                   {
                                                     'date' => '1996-12-24T00:46:19',
                                                     'version' => '1.09'
                                                   },
                                                   {
                                                     'date' => '1997-01-17T02:29:49',
                                                     'version' => '1.09_01'
                                                   },
                                                   {
                                                     'date' => '1997-01-21T01:06:40',
                                                     'version' => '1.10'
                                                   },
                                                   {
                                                     'date' => '1997-01-22T18:50:00',
                                                     'version' => '1.11'
                                                   },
                                                   {
                                                     'date' => '1997-01-23T00:07:58',
                                                     'version' => '1.12'
                                                   },
                                                   {
                                                     'date' => '1997-01-24T01:07:44',
                                                     'version' => '1.14'
                                                   },
                                                   {
                                                     'date' => '1997-01-24T12:32:12',
                                                     'version' => '1.15'
                                                   },
                                                   {
                                                     'date' => '1997-02-02T13:51:48',
                                                     'version' => '1.16_01'
                                                   },
                                                   {
                                                     'date' => '1997-02-02T21:05:12',
                                                     'version' => '1.17'
                                                   },
                                                   {
                                                     'date' => '1997-02-03T00:38:36',
                                                     'version' => '1.18'
                                                   },
                                                   {
                                                     'date' => '1997-02-03T09:13:48',
                                                     'version' => '1.19'
                                                   },
                                                   {
                                                     'date' => '1997-02-05T09:38:00',
                                                     'version' => '1.20'
                                                   },
                                                   {
                                                     'date' => '1997-02-11T06:32:42',
                                                     'version' => '1.21'
                                                   },
                                                   {
                                                     'date' => '1997-03-13T23:14:59',
                                                     'version' => '1.22_01'
                                                   },
                                                   {
                                                     'date' => '1997-03-31T12:03:55',
                                                     'version' => '1.23'
                                                   },
                                                   {
                                                     'date' => '1997-03-31T22:47:11',
                                                     'version' => '1.24'
                                                   },
                                                   {
                                                     'date' => '1997-06-30T18:13:23',
                                                     'version' => '1.25'
                                                   },
                                                   {
                                                     'date' => '1997-07-28T13:58:09',
                                                     'version' => '1.27'
                                                   },
                                                   {
                                                     'date' => '1997-08-04T06:09:33',
                                                     'version' => '1.28'
                                                   },
                                                   {
                                                     'date' => '1997-08-11T23:33:58',
                                                     'version' => '1.29'
                                                   },
                                                   {
                                                     'date' => '1997-08-29T14:34:37',
                                                     'version' => '1.30'
                                                   },
                                                   {
                                                     'date' => '1997-09-21T08:53:03',
                                                     'version' => '1.31'
                                                   },
                                                   {
                                                     'date' => '1997-09-23T18:45:50',
                                                     'version' => '1.3101'
                                                   },
                                                   {
                                                     'date' => '1998-01-02T18:22:35',
                                                     'version' => '1.32'
                                                   },
                                                   {
                                                     'date' => '1998-01-10T18:24:23',
                                                     'version' => '1.33'
                                                   },
                                                   {
                                                     'date' => '1998-02-03T18:06:41',
                                                     'version' => '1.35'
                                                   },
                                                   {
                                                     'date' => '1998-02-08T08:55:55',
                                                     'version' => '1.36'
                                                   },
                                                   {
                                                     'date' => '1998-06-12T06:51:25',
                                                     'version' => '1.37'
                                                   },
                                                   {
                                                     'date' => '1998-06-14T20:18:08',
                                                     'version' => '1.38'
                                                   },
                                                   {
                                                     'date' => '1998-07-24T20:13:41',
                                                     'version' => '1.40'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T02:20:32',
                                                     'version' => '1.41'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T07:58:35',
                                                     'version' => '1.42'
                                                   },
                                                   {
                                                     'date' => '1998-12-01T22:16:27',
                                                     'version' => '1.43'
                                                   },
                                                   {
                                                     'date' => '1998-12-03T17:07:54',
                                                     'version' => '1.43'
                                                   },
                                                   {
                                                     'date' => '1999-01-09T18:38:33',
                                                     'version' => '1.44'
                                                   },
                                                   {
                                                     'date' => '1999-01-10T19:38:27',
                                                     'version' => '1.44_51'
                                                   },
                                                   {
                                                     'date' => '1999-01-13T12:15:42',
                                                     'version' => '1.44_52'
                                                   },
                                                   {
                                                     'date' => '1999-01-15T09:26:40',
                                                     'version' => '1.44_53'
                                                   },
                                                   {
                                                     'date' => '1999-01-15T09:27:45',
                                                     'version' => '1.44_54'
                                                   },
                                                   {
                                                     'date' => '1999-01-23T14:56:16',
                                                     'version' => '1.45'
                                                   },
                                                   {
                                                     'date' => '1999-01-25T01:43:42',
                                                     'version' => '1.46'
                                                   },
                                                   {
                                                     'date' => '1999-01-25T13:11:23',
                                                     'version' => '1.47'
                                                   },
                                                   {
                                                     'date' => '1999-03-06T19:34:54',
                                                     'version' => '1.48'
                                                   },
                                                   {
                                                     'date' => '1999-05-22T16:45:00',
                                                     'version' => '1.49'
                                                   },
                                                   {
                                                     'date' => '1999-05-23T14:32:20',
                                                     'version' => '1.50'
                                                   },
                                                   {
                                                     'date' => '1999-10-23T03:06:39',
                                                     'version' => '1.50_01'
                                                   },
                                                   {
                                                     'date' => '1999-12-29T22:30:22',
                                                     'version' => '1.51'
                                                   },
                                                   {
                                                     'date' => '2000-01-08T15:32:55',
                                                     'version' => '1.52'
                                                   },
                                                   {
                                                     'date' => '2000-03-23T23:39:41',
                                                     'version' => '1.53'
                                                   },
                                                   {
                                                     'date' => '2000-03-25T22:51:15',
                                                     'version' => '1.54'
                                                   },
                                                   {
                                                     'date' => '2000-07-30T11:15:04',
                                                     'version' => '1.55'
                                                   },
                                                   {
                                                     'date' => '2000-08-01T20:47:09',
                                                     'version' => '1.56'
                                                   },
                                                   {
                                                     'date' => '2000-08-16T12:54:07',
                                                     'version' => '1.57'
                                                   },
                                                   {
                                                     'date' => '2000-08-21T19:44:18',
                                                     'version' => '1.57_51'
                                                   },
                                                   {
                                                     'date' => '2000-08-27T22:09:36',
                                                     'version' => '1.57_53'
                                                   },
                                                   {
                                                     'date' => '2000-08-30T16:54:50',
                                                     'version' => '1.57_54'
                                                   },
                                                   {
                                                     'date' => '2000-08-31T08:11:01',
                                                     'version' => '1.57_55'
                                                   },
                                                   {
                                                     'date' => '2000-08-31T22:16:21',
                                                     'version' => '1.57_56'
                                                   },
                                                   {
                                                     'date' => '2000-09-01T12:18:43',
                                                     'version' => '1.57_57'
                                                   },
                                                   {
                                                     'date' => '2000-09-03T22:19:20',
                                                     'version' => '1.57_58'
                                                   },
                                                   {
                                                     'date' => '2000-09-05T09:44:05',
                                                     'version' => '1.57_59'
                                                   },
                                                   {
                                                     'date' => '2000-09-05T19:55:34',
                                                     'version' => '1.57_60'
                                                   },
                                                   {
                                                     'date' => '2000-09-06T10:54:07',
                                                     'version' => '1.57_61'
                                                   },
                                                   {
                                                     'date' => '2000-09-08T02:19:06',
                                                     'version' => '1.57_62'
                                                   },
                                                   {
                                                     'date' => '2000-09-10T08:54:37',
                                                     'version' => '1.57_65'
                                                   },
                                                   {
                                                     'date' => '2000-09-12T08:46:40',
                                                     'version' => '1.57_66'
                                                   },
                                                   {
                                                     'date' => '2000-09-17T10:24:31',
                                                     'version' => '1.57_67'
                                                   },
                                                   {
                                                     'date' => '2000-10-08T14:25:04',
                                                     'version' => '1.57_68'
                                                   },
                                                   {
                                                     'date' => '2000-10-18T14:53:45',
                                                     'version' => '1.58'
                                                   },
                                                   {
                                                     'date' => '2000-10-21T14:21:06',
                                                     'version' => '1.58_51'
                                                   },
                                                   {
                                                     'date' => '2000-10-25T07:05:38',
                                                     'version' => '1.58_52'
                                                   },
                                                   {
                                                     'date' => '2000-10-26T11:03:29',
                                                     'version' => '1.58_53'
                                                   },
                                                   {
                                                     'date' => '2000-10-26T15:34:21',
                                                     'version' => '1.58_54'
                                                   },
                                                   {
                                                     'date' => '2000-10-27T07:59:03',
                                                     'version' => '1.58_55'
                                                   },
                                                   {
                                                     'date' => '2000-11-04T09:36:53',
                                                     'version' => '1.58_56'
                                                   },
                                                   {
                                                     'date' => '2000-11-06T19:30:27',
                                                     'version' => '1.58_57'
                                                   },
                                                   {
                                                     'date' => '2000-11-08T08:10:51',
                                                     'version' => '1.58_90'
                                                   },
                                                   {
                                                     'date' => '2000-11-13T10:26:38',
                                                     'version' => '1.58_91'
                                                   },
                                                   {
                                                     'date' => '2000-11-14T18:24:18',
                                                     'version' => '1.58_92'
                                                   },
                                                   {
                                                     'date' => '2000-11-15T07:19:56',
                                                     'version' => '1.58_93'
                                                   },
                                                   {
                                                     'date' => '2000-12-01T06:05:58',
                                                     'version' => '1.59'
                                                   },
                                                   {
                                                     'date' => '2000-12-01T08:19:58',
                                                     'version' => '1.59_51'
                                                   },
                                                   {
                                                     'date' => '2000-12-26T13:54:06',
                                                     'version' => '1.59_52'
                                                   },
                                                   {
                                                     'date' => '2001-01-02T16:37:24',
                                                     'version' => '1.59_53'
                                                   },
                                                   {
                                                     'date' => '2001-02-09T21:44:55',
                                                     'version' => '1.59_54'
                                                   },
                                                   {
                                                     'date' => '2002-04-19T13:29:54',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-04-20T02:18:41',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-04-21T11:31:25',
                                                     'version' => '1.60'
                                                   },
                                                   {
                                                     'date' => '2002-05-07T10:38:54',
                                                     'version' => '1.61'
                                                   },
                                                   {
                                                     'date' => '2002-07-28T10:51:47',
                                                     'version' => '1.62'
                                                   },
                                                   {
                                                     'date' => '2002-08-30T08:58:10',
                                                     'version' => '1.63'
                                                   },
                                                   {
                                                     'date' => '2003-02-06T10:04:06',
                                                     'version' => '1.64'
                                                   },
                                                   {
                                                     'date' => '2003-02-08T17:10:13',
                                                     'version' => '1.65'
                                                   },
                                                   {
                                                     'date' => '2003-03-04T19:38:21',
                                                     'version' => '1.70'
                                                   },
                                                   {
                                                     'date' => '2003-04-11T04:33:18',
                                                     'version' => '1.70_52'
                                                   },
                                                   {
                                                     'date' => '2003-04-13T12:43:40',
                                                     'version' => '1.70_53'
                                                   },
                                                   {
                                                     'date' => '2003-05-15T21:04:52',
                                                     'version' => '1.70_54'
                                                   },
                                                   {
                                                     'date' => '2003-07-04T09:48:08',
                                                     'version' => '1.71'
                                                   },
                                                   {
                                                     'date' => '2003-07-27T20:35:05',
                                                     'version' => '1.72'
                                                   },
                                                   {
                                                     'date' => '2003-07-28T08:21:47',
                                                     'version' => '1.73'
                                                   },
                                                   {
                                                     'date' => '2003-07-28T22:58:08',
                                                     'version' => '1.74'
                                                   },
                                                   {
                                                     'date' => '2003-07-29T15:14:13',
                                                     'version' => '1.75'
                                                   },
                                                   {
                                                     'date' => '2003-07-31T15:14:02',
                                                     'version' => '1.76'
                                                   },
                                                   {
                                                     'date' => '2003-09-21T21:25:41',
                                                     'version' => '1.76_01'
                                                   },
                                                   {
                                                     'date' => '2005-09-19T06:37:38',
                                                     'version' => '1.76_51'
                                                   },
                                                   {
                                                     'date' => '2005-09-22T07:02:02',
                                                     'version' => '1.76_52'
                                                   },
                                                   {
                                                     'date' => '2005-09-22T07:09:48',
                                                     'version' => '1.76_53'
                                                   },
                                                   {
                                                     'date' => '2005-10-01T08:23:38',
                                                     'version' => '1.76_54'
                                                   },
                                                   {
                                                     'date' => '2005-10-19T06:10:58',
                                                     'version' => '1.76_55'
                                                   },
                                                   {
                                                     'date' => '2005-10-21T04:59:36',
                                                     'version' => '1.76_56'
                                                   },
                                                   {
                                                     'date' => '2005-10-27T07:08:29',
                                                     'version' => '1.76_57'
                                                   },
                                                   {
                                                     'date' => '2005-11-02T04:03:28',
                                                     'version' => '1.76_58'
                                                   },
                                                   {
                                                     'date' => '2005-11-03T06:37:52',
                                                     'version' => '1.76_59'
                                                   },
                                                   {
                                                     'date' => '2005-11-03T07:38:40',
                                                     'version' => '1.76_60'
                                                   },
                                                   {
                                                     'date' => '2005-11-06T10:36:53',
                                                     'version' => '1.76_61'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T04:22:19',
                                                     'version' => '1.76_62'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T04:47:05',
                                                     'version' => '1.76_63'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T21:58:06',
                                                     'version' => '1.76_64'
                                                   },
                                                   {
                                                     'date' => '2005-11-07T22:18:44',
                                                     'version' => '1.76_65'
                                                   },
                                                   {
                                                     'date' => '2005-12-03T10:12:08',
                                                     'version' => '1.80'
                                                   },
                                                   {
                                                     'date' => '2005-12-18T11:29:26',
                                                     'version' => '1.80_51'
                                                   },
                                                   {
                                                     'date' => '2005-12-21T12:13:15',
                                                     'version' => '1.80_53'
                                                   },
                                                   {
                                                     'date' => '2005-12-22T08:42:59',
                                                     'version' => '1.80_54'
                                                   },
                                                   {
                                                     'date' => '2005-12-24T07:25:34',
                                                     'version' => '1.80_55'
                                                   },
                                                   {
                                                     'date' => '2005-12-24T09:59:47',
                                                     'version' => '1.80_56'
                                                   },
                                                   {
                                                     'date' => '2005-12-31T11:58:10',
                                                     'version' => '1.80_57'
                                                   },
                                                   {
                                                     'date' => '2006-01-01T09:01:43',
                                                     'version' => '1.80_58'
                                                   },
                                                   {
                                                     'date' => '2006-01-02T23:15:15',
                                                     'version' => '1.81'
                                                   },
                                                   {
                                                     'date' => '2006-01-04T07:47:25',
                                                     'version' => '1.82'
                                                   },
                                                   {
                                                     'date' => '2006-01-05T08:03:36',
                                                     'version' => '1.83'
                                                   },
                                                   {
                                                     'date' => '2006-01-08T13:35:16',
                                                     'version' => '1.83_51'
                                                   },
                                                   {
                                                     'date' => '2006-01-10T05:00:26',
                                                     'version' => '1.83_52'
                                                   },
                                                   {
                                                     'date' => '2006-01-12T07:54:36',
                                                     'version' => '1.83_53'
                                                   },
                                                   {
                                                     'date' => '2006-01-13T08:20:42',
                                                     'version' => '1.83_54'
                                                   },
                                                   {
                                                     'date' => '2006-01-14T11:34:47',
                                                     'version' => '1.83_55'
                                                   },
                                                   {
                                                     'date' => '2006-01-18T06:03:44',
                                                     'version' => '1.83_56'
                                                   },
                                                   {
                                                     'date' => '2006-01-19T08:00:02',
                                                     'version' => '1.83_57'
                                                   },
                                                   {
                                                     'date' => '2006-01-22T12:05:01',
                                                     'version' => '1.83_58'
                                                   },
                                                   {
                                                     'date' => '2006-01-25T13:10:20',
                                                     'version' => '1.83_59'
                                                   },
                                                   {
                                                     'date' => '2006-01-30T10:35:47',
                                                     'version' => '1.83_60'
                                                   },
                                                   {
                                                     'date' => '2006-01-30T23:18:09',
                                                     'version' => '1.83_61'
                                                   },
                                                   {
                                                     'date' => '2006-01-31T10:28:57',
                                                     'version' => '1.83_62'
                                                   },
                                                   {
                                                     'date' => '2006-02-01T07:49:36',
                                                     'version' => '1.83_63'
                                                   },
                                                   {
                                                     'date' => '2006-02-02T09:17:39',
                                                     'version' => '1.83_64'
                                                   },
                                                   {
                                                     'date' => '2006-02-04T11:20:05',
                                                     'version' => '1.83_65'
                                                   },
                                                   {
                                                     'date' => '2006-02-04T17:05:00',
                                                     'version' => '1.83_66'
                                                   },
                                                   {
                                                     'date' => '2006-02-06T00:46:27',
                                                     'version' => '1.83_67'
                                                   },
                                                   {
                                                     'date' => '2006-02-08T07:43:36',
                                                     'version' => '1.83_68'
                                                   },
                                                   {
                                                     'date' => '2006-02-14T08:17:55',
                                                     'version' => '1.83_69'
                                                   },
                                                   {
                                                     'date' => '2006-02-15T07:01:02',
                                                     'version' => '1.84'
                                                   },
                                                   {
                                                     'date' => '2006-02-19T17:05:36',
                                                     'version' => '1.85'
                                                   },
                                                   {
                                                     'date' => '2006-02-20T08:36:51',
                                                     'version' => '1.86'
                                                   },
                                                   {
                                                     'date' => '2006-02-21T06:05:05',
                                                     'version' => '1.86_51'
                                                   },
                                                   {
                                                     'date' => '2006-02-22T22:29:54',
                                                     'version' => '1.86_52'
                                                   },
                                                   {
                                                     'date' => '2006-02-24T08:24:09',
                                                     'version' => '1.86_53'
                                                   },
                                                   {
                                                     'date' => '2006-02-27T07:01:10',
                                                     'version' => '1.87'
                                                   },
                                                   {
                                                     'date' => '2006-03-06T08:02:28',
                                                     'version' => '1.87_51'
                                                   },
                                                   {
                                                     'date' => '2006-07-21T22:33:11',
                                                     'version' => '1.87_52'
                                                   },
                                                   {
                                                     'date' => '2006-07-22T18:55:13',
                                                     'version' => '1.87_53'
                                                   },
                                                   {
                                                     'date' => '2006-07-23T21:37:11',
                                                     'version' => '1.87_54'
                                                   },
                                                   {
                                                     'date' => '2006-07-29T19:36:50',
                                                     'version' => '1.87_55'
                                                   },
                                                   {
                                                     'date' => '2006-08-24T05:57:41',
                                                     'version' => '1.87_56'
                                                   },
                                                   {
                                                     'date' => '2006-08-26T17:05:56',
                                                     'version' => '1.87_57'
                                                   },
                                                   {
                                                     'date' => '2006-08-31T06:50:49',
                                                     'version' => '1.87_58'
                                                   },
                                                   {
                                                     'date' => '2006-09-03T21:05:29',
                                                     'version' => '1.87_59'
                                                   },
                                                   {
                                                     'date' => '2006-09-10T11:57:33',
                                                     'version' => '1.87_61'
                                                   },
                                                   {
                                                     'date' => '2006-09-11T21:24:18',
                                                     'version' => '1.87_62'
                                                   },
                                                   {
                                                     'date' => '2006-09-13T05:44:15',
                                                     'version' => '1.87_63'
                                                   },
                                                   {
                                                     'date' => '2006-09-16T11:02:25',
                                                     'version' => '1.87_64'
                                                   },
                                                   {
                                                     'date' => '2006-09-19T03:44:51',
                                                     'version' => '1.87_65'
                                                   },
                                                   {
                                                     'date' => '2006-09-21T20:30:41',
                                                     'version' => '1.88'
                                                   },
                                                   {
                                                     'date' => '2006-09-22T20:40:40',
                                                     'version' => '1.8801'
                                                   },
                                                   {
                                                     'date' => '2006-09-30T10:41:20',
                                                     'version' => '1.88_51'
                                                   },
                                                   {
                                                     'date' => '2006-10-03T09:51:49',
                                                     'version' => '1.88_52'
                                                   },
                                                   {
                                                     'date' => '2006-10-09T19:31:56',
                                                     'version' => '1.88_53'
                                                   },
                                                   {
                                                     'date' => '2006-10-14T09:37:15',
                                                     'version' => '1.88_54'
                                                   },
                                                   {
                                                     'date' => '2006-10-16T06:59:27',
                                                     'version' => '1.88_55'
                                                   },
                                                   {
                                                     'date' => '2006-10-22T10:34:16',
                                                     'version' => '1.88_56'
                                                   },
                                                   {
                                                     'date' => '2006-10-23T07:17:30',
                                                     'version' => '1.8802'
                                                   },
                                                   {
                                                     'date' => '2006-10-24T07:18:16',
                                                     'version' => '1.88_57'
                                                   },
                                                   {
                                                     'date' => '2006-10-28T15:00:07',
                                                     'version' => '1.88_58'
                                                   },
                                                   {
                                                     'date' => '2006-11-05T21:24:52',
                                                     'version' => '1.88_59'
                                                   },
                                                   {
                                                     'date' => '2006-11-10T08:39:55',
                                                     'version' => '1.88_61'
                                                   },
                                                   {
                                                     'date' => '2006-11-13T07:44:27',
                                                     'version' => '1.88_62'
                                                   },
                                                   {
                                                     'date' => '2006-11-29T08:11:50',
                                                     'version' => '1.88_63'
                                                   },
                                                   {
                                                     'date' => '2006-12-04T07:53:37',
                                                     'version' => '1.88_64'
                                                   },
                                                   {
                                                     'date' => '2006-12-11T21:36:04',
                                                     'version' => '1.88_65'
                                                   },
                                                   {
                                                     'date' => '2006-12-19T08:21:17',
                                                     'version' => '1.88_66'
                                                   },
                                                   {
                                                     'date' => '2006-12-31T17:18:53',
                                                     'version' => '1.88_67'
                                                   },
                                                   {
                                                     'date' => '2007-01-07T21:22:12',
                                                     'version' => '1.88_68'
                                                   },
                                                   {
                                                     'date' => '2007-01-08T03:42:56',
                                                     'version' => '1.88_69'
                                                   },
                                                   {
                                                     'date' => '2007-01-27T16:57:49',
                                                     'version' => '1.88_71'
                                                   },
                                                   {
                                                     'date' => '2007-01-31T07:11:33',
                                                     'version' => '1.88_72'
                                                   },
                                                   {
                                                     'date' => '2007-02-13T05:24:13',
                                                     'version' => '1.88_73'
                                                   },
                                                   {
                                                     'date' => '2007-02-15T07:12:17',
                                                     'version' => '1.88_74'
                                                   },
                                                   {
                                                     'date' => '2007-02-18T16:52:49',
                                                     'version' => '1.88_75'
                                                   },
                                                   {
                                                     'date' => '2007-02-19T06:20:20',
                                                     'version' => '1.88_76'
                                                   },
                                                   {
                                                     'date' => '2007-02-19T21:26:47',
                                                     'version' => '1.88_77'
                                                   },
                                                   {
                                                     'date' => '2007-03-05T23:26:57',
                                                     'version' => '1.88_78'
                                                   },
                                                   {
                                                     'date' => '2007-03-16T01:54:55',
                                                     'version' => '1.88_79'
                                                   },
                                                   {
                                                     'date' => '2007-04-07T07:41:18',
                                                     'version' => '1.90'
                                                   },
                                                   {
                                                     'date' => '2007-04-19T07:03:03',
                                                     'version' => '1.91'
                                                   },
                                                   {
                                                     'date' => '2007-04-23T00:09:11',
                                                     'version' => '1.9101'
                                                   },
                                                   {
                                                     'date' => '2007-05-08T20:35:04',
                                                     'version' => '1.9102'
                                                   },
                                                   {
                                                     'date' => '2007-07-07T16:15:40',
                                                     'version' => '1.91_51'
                                                   },
                                                   {
                                                     'date' => '2007-07-14T18:45:58',
                                                     'version' => '1.91_52'
                                                   },
                                                   {
                                                     'date' => '2007-08-09T06:49:38',
                                                     'version' => '1.91_53'
                                                   },
                                                   {
                                                     'date' => '2007-09-14T21:18:33',
                                                     'version' => '1.91_54'
                                                   },
                                                   {
                                                     'date' => '2007-09-15T07:14:26',
                                                     'version' => '1.91_55'
                                                   },
                                                   {
                                                     'date' => '2007-09-23T11:15:08',
                                                     'version' => '1.92'
                                                   },
                                                   {
                                                     'date' => '2007-09-27T07:11:10',
                                                     'version' => '1.9201'
                                                   },
                                                   {
                                                     'date' => '2007-09-28T06:58:04',
                                                     'version' => '1.9202'
                                                   },
                                                   {
                                                     'date' => '2007-09-28T07:13:26',
                                                     'version' => '1.9203'
                                                   },
                                                   {
                                                     'date' => '2007-11-04T23:04:18',
                                                     'version' => '1.92_51'
                                                   },
                                                   {
                                                     'date' => '2007-11-05T23:30:06',
                                                     'version' => '1.9204'
                                                   },
                                                   {
                                                     'date' => '2007-11-11T11:27:20',
                                                     'version' => '1.92_52'
                                                   },
                                                   {
                                                     'date' => '2007-11-11T18:49:37',
                                                     'version' => '1.9205'
                                                   },
                                                   {
                                                     'date' => '2007-12-09T23:27:18',
                                                     'version' => '1.92_53'
                                                   },
                                                   {
                                                     'date' => '2007-12-27T04:57:34',
                                                     'version' => '1.92_54'
                                                   },
                                                   {
                                                     'date' => '2007-12-30T15:24:13',
                                                     'version' => '1.92_55'
                                                   },
                                                   {
                                                     'date' => '2008-02-04T21:56:28',
                                                     'version' => '1.92_56'
                                                   },
                                                   {
                                                     'date' => '2008-02-27T05:13:49',
                                                     'version' => '1.92_57'
                                                   },
                                                   {
                                                     'date' => '2008-03-12T07:56:18',
                                                     'version' => '1.92_58'
                                                   },
                                                   {
                                                     'date' => '2008-03-16T18:57:04',
                                                     'version' => '1.92_59'
                                                   },
                                                   {
                                                     'date' => '2008-03-26T07:53:08',
                                                     'version' => '1.92_60'
                                                   },
                                                   {
                                                     'date' => '2008-04-25T04:47:52',
                                                     'version' => '1.92_61'
                                                   },
                                                   {
                                                     'date' => '2008-05-23T04:07:04',
                                                     'version' => '1.92_62'
                                                   },
                                                   {
                                                     'date' => '2008-06-19T06:42:18',
                                                     'version' => '1.92_63'
                                                   },
                                                   {
                                                     'date' => '2008-09-03T05:27:35',
                                                     'version' => '1.92_64'
                                                   },
                                                   {
                                                     'date' => '2008-09-14T09:54:03',
                                                     'version' => '1.92_65'
                                                   },
                                                   {
                                                     'date' => '2008-09-29T23:15:10',
                                                     'version' => '1.92_66'
                                                   },
                                                   {
                                                     'date' => '2008-10-12T16:07:51',
                                                     'version' => '1.93'
                                                   },
                                                   {
                                                     'date' => '2008-10-13T19:37:43',
                                                     'version' => '1.9301'
                                                   },
                                                   {
                                                     'date' => '2009-01-11T22:07:01',
                                                     'version' => '1.93_02'
                                                   },
                                                   {
                                                     'date' => '2009-02-01T12:38:23',
                                                     'version' => '1.93_03'
                                                   },
                                                   {
                                                     'date' => '2009-02-01T21:06:21',
                                                     'version' => '1.93_51'
                                                   },
                                                   {
                                                     'date' => '2009-02-28T15:58:39',
                                                     'version' => '1.9304'
                                                   },
                                                   {
                                                     'date' => '2009-04-13T19:24:43',
                                                     'version' => '1.93_52'
                                                   },
                                                   {
                                                     'date' => '2009-05-04T06:11:28',
                                                     'version' => '1.93_53'
                                                   },
                                                   {
                                                     'date' => '2009-05-07T20:13:16',
                                                     'version' => '1.93_54'
                                                   },
                                                   {
                                                     'date' => '2009-05-24T05:37:28',
                                                     'version' => '1.94'
                                                   },
                                                   {
                                                     'date' => '2009-06-14T19:53:52',
                                                     'version' => '1.94_01'
                                                   },
                                                   {
                                                     'date' => '2009-06-27T02:55:22',
                                                     'version' => '1.9402'
                                                   },
                                                   {
                                                     'date' => '2009-09-14T02:47:24',
                                                     'version' => '1.94_51'
                                                   },
                                                   {
                                                     'date' => '2009-10-15T19:33:19',
                                                     'version' => '1.94_52'
                                                   },
                                                   {
                                                     'date' => '2009-12-18T07:00:09',
                                                     'version' => '1.94_53'
                                                   },
                                                   {
                                                     'date' => '2010-01-14T08:01:42',
                                                     'version' => '1.94_54'
                                                   },
                                                   {
                                                     'date' => '2010-02-03T03:43:49',
                                                     'version' => '1.94_55'
                                                   },
                                                   {
                                                     'date' => '2010-02-17T13:39:33',
                                                     'version' => '1.94_56'
                                                   },
                                                   {
                                                     'date' => '2010-05-24T19:33:41',
                                                     'version' => '1.94_57'
                                                   },
                                                   {
                                                     'date' => '2010-06-24T06:34:13',
                                                     'version' => '1.94_58'
                                                   },
                                                   {
                                                     'date' => '2010-09-26T20:23:30',
                                                     'version' => '1.94_59'
                                                   },
                                                   {
                                                     'date' => '2010-09-28T20:44:58',
                                                     'version' => '1.94_60'
                                                   },
                                                   {
                                                     'date' => '2010-10-03T17:29:37',
                                                     'version' => '1.94_61'
                                                   },
                                                   {
                                                     'date' => '2010-10-26T06:43:51',
                                                     'version' => '1.94_62'
                                                   },
                                                   {
                                                     'date' => '2011-01-16T17:58:10',
                                                     'version' => '1.94_63'
                                                   },
                                                   {
                                                     'date' => '2011-01-21T04:58:35',
                                                     'version' => '1.94_64'
                                                   },
                                                   {
                                                     'date' => '2011-02-14T12:10:12',
                                                     'version' => '1.94_65'
                                                   },
                                                   {
                                                     'date' => '2011-03-12T11:30:03',
                                                     'version' => '1.9600'
                                                   },
                                                   {
                                                     'date' => '2011-06-27T06:56:01',
                                                     'version' => '1.97_51'
                                                   },
                                                   {
                                                     'date' => '2011-08-07T09:40:33',
                                                     'version' => '1.9800'
                                                   },
                                                   {
                                                     'date' => '2012-10-16T21:42:49',
                                                     'version' => '1.99_51'
                                                   },
                                                   {
                                                     'date' => '2013-02-06T07:41:54',
                                                     'version' => '2.00-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-04-12T16:57:44',
                                                     'version' => '2.00'
                                                   },
                                                   {
                                                     'date' => '2013-06-22T20:27:32',
                                                     'version' => '2.01-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-06-23T07:33:40',
                                                     'version' => '2.02-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2013-09-15T09:42:33',
                                                     'version' => '2.03-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-03-18T22:33:22',
                                                     'version' => '2.04-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-03-31T20:55:24',
                                                     'version' => '2.05-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2014-04-04T02:07:20',
                                                     'version' => '2.05-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2014-04-18T13:35:51',
                                                     'version' => '2.05'
                                                   },
                                                   {
                                                     'date' => '2014-08-06T19:32:53',
                                                     'version' => '2.06-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-01-04T18:54:54',
                                                     'version' => '2.06-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-01-05T06:31:55',
                                                     'version' => '2.08-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-02-02T04:41:02',
                                                     'version' => '2.09-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-02-22T15:57:42',
                                                     'version' => '2.10-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2015-03-13T07:45:04',
                                                     'version' => '2.10'
                                                   },
                                                   {
                                                     'date' => '2015-12-31T11:00:08',
                                                     'version' => '2.12-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-05-16T09:56:01',
                                                     'version' => '2.13-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-06-04T14:41:28',
                                                     'version' => '2.14-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2016-06-25T04:32:45',
                                                     'version' => '2.14'
                                                   },
                                                   {
                                                     'date' => '2016-07-17T12:10:30',
                                                     'version' => '2.15-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-01-16T16:20:27',
                                                     'version' => '2.16-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-01-16T21:27:06',
                                                     'version' => '2.16-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2017-02-14T16:22:20',
                                                     'version' => '2.16'
                                                   },
                                                   {
                                                     'date' => '2017-02-15T09:37:10',
                                                     'version' => '2.17-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-02-16T09:48:46',
                                                     'version' => '2.17-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2017-03-30T21:38:23',
                                                     'version' => '2.18-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-11-04T23:27:47',
                                                     'version' => '2.19-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2017-11-26T22:10:39',
                                                     'version' => '2.20-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-09-22T20:46:35',
                                                     'version' => '2.21-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-12-16T10:35:04',
                                                     'version' => '2.22-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2018-12-23T09:11:29',
                                                     'version' => '2.22'
                                                   },
                                                   {
                                                     'date' => '2019-02-10T20:28:53',
                                                     'version' => '2.23-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2019-02-14T21:21:03',
                                                     'version' => '2.24-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2019-02-16T05:56:23',
                                                     'version' => '2.25-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2019-03-03T06:27:10',
                                                     'version' => '2.25'
                                                   },
                                                   {
                                                     'date' => '2019-03-19T00:04:34',
                                                     'version' => '2.26'
                                                   },
                                                   {
                                                     'date' => '2019-05-31T21:11:50',
                                                     'version' => '2.27-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2019-06-09T05:48:20',
                                                     'version' => '2.27-TRIAL2'
                                                   },
                                                   {
                                                     'date' => '2019-07-03T20:15:40',
                                                     'version' => '2.27'
                                                   },
                                                   {
                                                     'date' => '2020-04-03T02:52:43',
                                                     'version' => '2.28-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2020-06-13T04:57:39',
                                                     'version' => '2.28'
                                                   },
                                                   {
                                                     'date' => '2021-11-23T16:58:45',
                                                     'version' => '2.29'
                                                   },
                                                   {
                                                     'date' => '2021-12-12T09:16:03',
                                                     'version' => '2.30-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2021-12-14T20:52:30',
                                                     'version' => '2.31-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2021-12-26T21:35:55',
                                                     'version' => '2.32-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2022-01-21T04:09:07',
                                                     'version' => '2.33-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2022-03-27T17:53:47',
                                                     'version' => '2.33'
                                                   },
                                                   {
                                                     'date' => '2022-04-03T19:19:13',
                                                     'version' => '2.34-TRIAL'
                                                   },
                                                   {
                                                     'date' => '2022-04-17T17:40:25',
                                                     'version' => '2.34'
                                                   }
                                                 ]
                                 },
                       'CPAN-Checksums' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '>=2.12',
                                                                 'cves' => [
                                                                             'CVE-2020-16155'
                                                                           ],
                                                                 'description' => 'The CPAN::Checksums package 2.12 for Perl does not uniquely define signed data.
',
                                                                 'distribution' => 'CPAN-Checksums',
                                                                 'fixed_versions' => undef,
                                                                 'id' => 'CPANSA-CPAN-Checksums-2020-16155',
                                                                 'references' => [
                                                                                   'https://metacpan.org/pod/CPAN::Checksums',
                                                                                   'https://blog.hackeriet.no/cpan-signature-verification-vulnerabilities/'
                                                                                 ],
                                                                 'reported' => '2021-12-13',
                                                                 'severity' => 'medium'
                                                               }
                                                             ],
                                             'main_module' => 'CPAN::Checksums',
                                             'versions' => [
                                                             {
                                                               'date' => '2000-12-10T09:31:19',
                                                               'version' => '1.003'
                                                             },
                                                             {
                                                               'date' => '2000-12-11T08:49:05',
                                                               'version' => '1.004'
                                                             },
                                                             {
                                                               'date' => '2000-12-11T10:20:16',
                                                               'version' => '1.006'
                                                             },
                                                             {
                                                               'date' => '2000-12-11T13:38:18',
                                                               'version' => '1.007'
                                                             },
                                                             {
                                                               'date' => '2000-12-13T11:24:09',
                                                               'version' => '1.008'
                                                             },
                                                             {
                                                               'date' => '2002-03-31T20:27:49',
                                                               'version' => '1.009'
                                                             },
                                                             {
                                                               'date' => '2002-10-06T17:22:35',
                                                               'version' => '1.0'
                                                             },
                                                             {
                                                               'date' => '2002-10-07T08:56:12',
                                                               'version' => '1.011'
                                                             },
                                                             {
                                                               'date' => '2003-02-02T10:26:00',
                                                               'version' => '1.014'
                                                             },
                                                             {
                                                               'date' => '2003-02-03T15:44:57',
                                                               'version' => '1.015'
                                                             },
                                                             {
                                                               'date' => '2003-02-03T19:21:46',
                                                               'version' => '1.016'
                                                             },
                                                             {
                                                               'date' => '2005-01-24T07:59:41',
                                                               'version' => '1.018'
                                                             },
                                                             {
                                                               'date' => '2005-10-31T07:27:02',
                                                               'version' => '1.032'
                                                             },
                                                             {
                                                               'date' => '2005-11-11T07:16:04',
                                                               'version' => '1.039'
                                                             },
                                                             {
                                                               'date' => '2006-05-01T13:34:41',
                                                               'version' => '1.048'
                                                             },
                                                             {
                                                               'date' => '2006-05-09T03:30:39',
                                                               'version' => '1.050'
                                                             },
                                                             {
                                                               'date' => '2007-08-05T12:10:58',
                                                               'version' => '1.061'
                                                             },
                                                             {
                                                               'date' => '2007-10-09T03:09:45',
                                                               'version' => '1.064'
                                                             },
                                                             {
                                                               'date' => '2008-05-17T05:26:24',
                                                               'version' => '2.00'
                                                             },
                                                             {
                                                               'date' => '2008-09-03T19:33:28',
                                                               'version' => '2.01'
                                                             },
                                                             {
                                                               'date' => '2008-10-31T06:54:59',
                                                               'version' => '2.02'
                                                             },
                                                             {
                                                               'date' => '2009-09-20T01:50:36',
                                                               'version' => '2.03'
                                                             },
                                                             {
                                                               'date' => '2009-09-28T04:10:09',
                                                               'version' => '2.04'
                                                             },
                                                             {
                                                               'date' => '2010-01-23T05:39:17',
                                                               'version' => '2.05'
                                                             },
                                                             {
                                                               'date' => '2010-10-24T12:13:44',
                                                               'version' => '2.06'
                                                             },
                                                             {
                                                               'date' => '2010-11-20T22:18:39',
                                                               'version' => '2.07'
                                                             },
                                                             {
                                                               'date' => '2011-08-30T06:32:02',
                                                               'version' => '2.08'
                                                             },
                                                             {
                                                               'date' => '2014-04-04T04:06:11',
                                                               'version' => '2.09'
                                                             },
                                                             {
                                                               'date' => '2015-04-11T05:48:38',
                                                               'version' => '2.10'
                                                             },
                                                             {
                                                               'date' => '2016-04-09T05:42:27',
                                                               'version' => '2.11'
                                                             },
                                                             {
                                                               'date' => '2016-06-14T02:42:03',
                                                               'version' => '2.12'
                                                             },
                                                             {
                                                               'date' => '2021-11-23T16:57:18',
                                                               'version' => '2.13'
                                                             },
                                                             {
                                                               'date' => '2021-12-04T10:00:42',
                                                               'version' => '2.14'
                                                             }
                                                           ]
                                           },
                       'Capture-Tiny' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<0.24',
                                                               'cves' => [
                                                                           'CVE-2014-1875'
                                                                         ],
                                                               'description' => 'The Capture::Tiny module before 0.24 for Perl allows local users to write to arbitrary files via a symlink attack on a temporary file.
',
                                                               'distribution' => 'Capture-Tiny',
                                                               'fixed_versions' => undef,
                                                               'id' => 'CPANSA-Capture-Tiny-2014-1875',
                                                               'references' => [
                                                                                 'http://osvdb.org/102963',
                                                                                 'https://bugzilla.redhat.com/show_bug.cgi?id=1062424',
                                                                                 'http://www.securityfocus.com/bid/65475',
                                                                                 'https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=737835',
                                                                                 'https://github.com/dagolden/Capture-Tiny/issues/16',
                                                                                 'http://lists.fedoraproject.org/pipermail/package-announce/2014-February/128882.html',
                                                                                 'https://github.com/dagolden/Capture-Tiny/commit/635c9eabd52ab8042b0c841823bd6e692de87924',
                                                                                 'http://cpansearch.perl.org/src/DAGOLDEN/Capture-Tiny-0.24/Changes',
                                                                                 'http://lists.fedoraproject.org/pipermail/package-announce/2014-February/128823.html',
                                                                                 'http://seclists.org/oss-sec/2014/q1/272',
                                                                                 'http://seclists.org/oss-sec/2014/q1/267',
                                                                                 'http://secunia.com/advisories/56823',
                                                                                 'https://exchange.xforce.ibmcloud.com/vulnerabilities/91464'
                                                                               ],
                                                               'reported' => '2014-10-06',
                                                               'severity' => undef
                                                             }
                                                           ],
                                           'main_module' => 'Capture::Tiny',
                                           'versions' => [
                                                           {
                                                             'date' => '2009-02-14T04:25:26',
                                                             'version' => '0.01'
                                                           },
                                                           {
                                                             'date' => '2009-02-17T22:26:18',
                                                             'version' => '0.02'
                                                           },
                                                           {
                                                             'date' => '2009-02-20T18:09:46',
                                                             'version' => '0.03'
                                                           },
                                                           {
                                                             'date' => '2009-02-25T14:29:32',
                                                             'version' => '0.04'
                                                           },
                                                           {
                                                             'date' => '2009-03-03T11:58:12',
                                                             'version' => '0.05'
                                                           },
                                                           {
                                                             'date' => '2009-04-21T11:07:47',
                                                             'version' => '0.05_51'
                                                           },
                                                           {
                                                             'date' => '2009-05-07T10:57:33',
                                                             'version' => '0.06'
                                                           },
                                                           {
                                                             'date' => '2010-01-24T05:21:56',
                                                             'version' => '0.07'
                                                           },
                                                           {
                                                             'date' => '2010-06-20T23:17:16',
                                                             'version' => '0.08'
                                                           },
                                                           {
                                                             'date' => '2011-01-28T04:53:00',
                                                             'version' => '0.09'
                                                           },
                                                           {
                                                             'date' => '2011-02-07T12:02:15',
                                                             'version' => '0.10'
                                                           },
                                                           {
                                                             'date' => '2011-05-20T03:35:28',
                                                             'version' => '0.11'
                                                           },
                                                           {
                                                             'date' => '2011-12-01T22:00:04',
                                                             'version' => '0.12'
                                                           },
                                                           {
                                                             'date' => '2011-12-02T18:40:05',
                                                             'version' => '0.13'
                                                           },
                                                           {
                                                             'date' => '2011-12-22T15:16:31',
                                                             'version' => '0.14'
                                                           },
                                                           {
                                                             'date' => '2011-12-23T16:12:30',
                                                             'version' => '0.15'
                                                           },
                                                           {
                                                             'date' => '2012-02-13T02:06:15',
                                                             'version' => '0.16'
                                                           },
                                                           {
                                                             'date' => '2012-02-22T13:09:42',
                                                             'version' => '0.17'
                                                           },
                                                           {
                                                             'date' => '2012-03-07T23:25:31',
                                                             'version' => '0.17_51'
                                                           },
                                                           {
                                                             'date' => '2012-03-09T16:46:53',
                                                             'version' => '0.17_52'
                                                           },
                                                           {
                                                             'date' => '2012-05-04T20:33:43',
                                                             'version' => '0.18'
                                                           },
                                                           {
                                                             'date' => '2012-08-07T00:28:08',
                                                             'version' => '0.19'
                                                           },
                                                           {
                                                             'date' => '2012-09-19T17:22:24',
                                                             'version' => '0.20'
                                                           },
                                                           {
                                                             'date' => '2012-11-15T00:13:08',
                                                             'version' => '0.21'
                                                           },
                                                           {
                                                             'date' => '2013-03-27T19:52:10',
                                                             'version' => '0.22'
                                                           },
                                                           {
                                                             'date' => '2013-10-20T15:28:15',
                                                             'version' => '0.23'
                                                           },
                                                           {
                                                             'date' => '2014-02-06T22:18:06',
                                                             'version' => '0.24'
                                                           },
                                                           {
                                                             'date' => '2014-08-16T14:09:48',
                                                             'version' => '0.25'
                                                           },
                                                           {
                                                             'date' => '2014-11-04T11:57:19',
                                                             'version' => '0.26'
                                                           },
                                                           {
                                                             'date' => '2014-11-05T04:12:33',
                                                             'version' => '0.27'
                                                           },
                                                           {
                                                             'date' => '2015-02-11T11:41:44',
                                                             'version' => '0.28'
                                                           },
                                                           {
                                                             'date' => '2015-04-19T16:44:50',
                                                             'version' => '0.29'
                                                           },
                                                           {
                                                             'date' => '2015-05-16T00:45:01',
                                                             'version' => '0.30'
                                                           },
                                                           {
                                                             'date' => '2016-02-14T14:39:55',
                                                             'version' => '0.31'
                                                           },
                                                           {
                                                             'date' => '2016-02-18T15:14:06',
                                                             'version' => '0.32'
                                                           },
                                                           {
                                                             'date' => '2016-02-19T04:29:41',
                                                             'version' => '0.34'
                                                           },
                                                           {
                                                             'date' => '2016-02-29T02:38:12',
                                                             'version' => '0.36'
                                                           },
                                                           {
                                                             'date' => '2016-05-02T11:09:27',
                                                             'version' => '0.37'
                                                           },
                                                           {
                                                             'date' => '2016-05-02T14:24:23',
                                                             'version' => '0.39'
                                                           },
                                                           {
                                                             'date' => '2016-05-23T15:45:16',
                                                             'version' => '0.40'
                                                           },
                                                           {
                                                             'date' => '2016-05-23T16:01:05',
                                                             'version' => '0.41'
                                                           },
                                                           {
                                                             'date' => '2016-05-31T16:41:30',
                                                             'version' => '0.42'
                                                           },
                                                           {
                                                             'date' => '2016-08-05T18:02:43',
                                                             'version' => '0.44'
                                                           },
                                                           {
                                                             'date' => '2017-02-23T18:32:44',
                                                             'version' => '0.45'
                                                           },
                                                           {
                                                             'date' => '2017-02-25T19:26:54',
                                                             'version' => '0.46'
                                                           },
                                                           {
                                                             'date' => '2017-07-26T14:36:03',
                                                             'version' => '0.47'
                                                           },
                                                           {
                                                             'date' => '2018-04-22T07:09:08',
                                                             'version' => '0.48'
                                                           }
                                                         ]
                                         },
                       'Catalyst-Authentication-Store-LDAP' => {
                                                                 'advisories' => [
                                                                                   {
                                                                                     'affected_versions' => '<1.013',
                                                                                     'cves' => [],
                                                                                     'description' => 'Incorrect password check binds to the unauthenticated user.
',
                                                                                     'distribution' => 'Catalyst-Authentication-Store-LDAP',
                                                                                     'fixed_versions' => '>=1.013',
                                                                                     'id' => 'CPANSA-Catalyst-Authentication-Store-LDAP-2012-01',
                                                                                     'references' => [
                                                                                                       'https://rt.cpan.org/Public/Bug/Display.html?id=81908'
                                                                                                     ],
                                                                                     'reported' => '2012-12-11',
                                                                                     'severity' => 'high'
                                                                                   }
                                                                                 ],
                                                                 'main_module' => 'Catalyst::Authentication::Store::LDAP',
                                                                 'versions' => [
                                                                                 {
                                                                                   'date' => '2008-02-05T18:18:24',
                                                                                   'version' => '0.1000'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-04-10T02:06:58',
                                                                                   'version' => '0.1001'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-07-09T20:45:43',
                                                                                   'version' => '0.1002'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-09-10T13:21:33',
                                                                                   'version' => '0.1003'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2008-10-22T01:57:27',
                                                                                   'version' => '0.1003'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-05-01T02:34:18',
                                                                                   'version' => '0.1005'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2009-12-11T18:54:26',
                                                                                   'version' => '1.006'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-03-19T10:07:13',
                                                                                   'version' => '1.007'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-04-03T03:04:13',
                                                                                   'version' => '1.008'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-05-15T07:14:41',
                                                                                   'version' => '1.009'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-07-06T21:39:55',
                                                                                   'version' => '1.010'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-07-07T20:41:22',
                                                                                   'version' => '1.011'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2010-10-05T08:11:56',
                                                                                   'version' => '1.012'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2013-01-09T14:58:46',
                                                                                   'version' => '1.013'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2013-04-26T19:51:28',
                                                                                   'version' => '1.014'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2015-02-20T18:07:31',
                                                                                   'version' => '1.015'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2016-02-11T17:50:52',
                                                                                   'version' => '1.016'
                                                                                 },
                                                                                 {
                                                                                   'date' => '2021-05-26T09:59:28',
                                                                                   'version' => '1.017'
                                                                                 }
                                                                               ]
                                                               },
                       'Catalyst-Controller-Combine' => {
                                                          'advisories' => [
                                                                            {
                                                                              'affected_versions' => '<0.12',
                                                                              'cves' => [],
                                                                              'description' => 'Allows to use url-encoded path-parts to crawl along the file system and read files outside the intended directory.
',
                                                                              'distribution' => 'Catalyst-Controller-Combine',
                                                                              'fixed_versions' => '>=0.12',
                                                                              'id' => 'CPANSA-Catalyst-Controller-Combine-2010-01',
                                                                              'references' => [
                                                                                                'https://metacpan.org/changes/distribution/Catalyst-Controller-Combine'
                                                                                              ],
                                                                              'reported' => '2010-05-21'
                                                                            }
                                                                          ],
                                                          'main_module' => 'Catalyst::Controller::Combine',
                                                          'versions' => [
                                                                          {
                                                                            'date' => '2009-07-11T17:58:25',
                                                                            'version' => '0.06'
                                                                          },
                                                                          {
                                                                            'date' => '2009-07-13T06:49:00',
                                                                            'version' => '0.07'
                                                                          },
                                                                          {
                                                                            'date' => '2009-10-24T12:48:21',
                                                                            'version' => '0.08'
                                                                          },
                                                                          {
                                                                            'date' => '2010-03-13T19:31:13',
                                                                            'version' => '0.09'
                                                                          },
                                                                          {
                                                                            'date' => '2010-03-27T18:44:05',
                                                                            'version' => '0.10'
                                                                          },
                                                                          {
                                                                            'date' => '2010-06-21T20:47:02',
                                                                            'version' => '0.12'
                                                                          },
                                                                          {
                                                                            'date' => '2011-07-28T19:53:12',
                                                                            'version' => '0.13'
                                                                          },
                                                                          {
                                                                            'date' => '2012-02-20T20:59:00',
                                                                            'version' => '0.14'
                                                                          },
                                                                          {
                                                                            'date' => '2012-05-04T10:43:12',
                                                                            'version' => '0.15'
                                                                          }
                                                                        ]
                                                        },
                       'Catalyst-Plugin-Static' => {
                                                     'advisories' => [
                                                                       {
                                                                         'affected_versions' => '<0.10',
                                                                         'cves' => [],
                                                                         'description' => 'Serving files outside of $config->{root} directory.
',
                                                                         'distribution' => 'Catalyst-Plugin-Static',
                                                                         'fixed_versions' => '>=0.10',
                                                                         'id' => 'CPANSA-Catalyst-Plugin-Static-2005-01',
                                                                         'reported' => '2005-11-14'
                                                                       }
                                                                     ],
                                                     'main_module' => 'Catalyst::Plugin::Static',
                                                     'versions' => [
                                                                     {
                                                                       'date' => '2005-01-29T00:00:20',
                                                                       'version' => '0.01'
                                                                     },
                                                                     {
                                                                       'date' => '2005-02-19T20:28:50',
                                                                       'version' => '0.02'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-17T01:01:03',
                                                                       'version' => '0.03'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-17T19:10:36',
                                                                       'version' => '0.04'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-21T13:34:27',
                                                                       'version' => '0.05'
                                                                     },
                                                                     {
                                                                       'date' => '2005-03-23T06:48:05',
                                                                       'version' => '0.05'
                                                                     },
                                                                     {
                                                                       'date' => '2005-04-15T16:58:18',
                                                                       'version' => '0.06'
                                                                     },
                                                                     {
                                                                       'date' => '2005-04-17T14:50:45',
                                                                       'version' => '0.07'
                                                                     },
                                                                     {
                                                                       'date' => '2005-09-06T13:42:42',
                                                                       'version' => '0.08'
                                                                     },
                                                                     {
                                                                       'date' => '2005-11-14T08:38:35',
                                                                       'version' => '0.09'
                                                                     },
                                                                     {
                                                                       'date' => '2005-11-14T10:26:31',
                                                                       'version' => '0.10'
                                                                     },
                                                                     {
                                                                       'date' => '2009-10-18T18:13:00',
                                                                       'version' => '0.11'
                                                                     }
                                                                   ]
                                                   },
                       'Catalyst-Plugin-Static-Simple' => {
                                                            'advisories' => [
                                                                              {
                                                                                'affected_versions' => '<0.34',
                                                                                'cves' => [
                                                                                            'CVE-2017-16248'
                                                                                          ],
                                                                                'description' => 'The Catalyst-Plugin-Static-Simple module before 0.34 for Perl allows remote attackers to read arbitrary files if there is a \'.\' character anywhere in the pathname, which differs from the intended policy of allowing access only when the filename itself has a \'.\' character.
',
                                                                                'distribution' => 'Catalyst-Plugin-Static-Simple',
                                                                                'fixed_versions' => '>=0.34',
                                                                                'id' => 'CPANSA-Catalyst-Plugin-Static-Simple-2017-01',
                                                                                'references' => [
                                                                                                  'https://blog.hackeriet.no/cpan-signature-verification-vulnerabilities/',
                                                                                                  'https://metacpan.org/pod/CPAN::Checksums'
                                                                                                ],
                                                                                'reported' => '2017-10-31'
                                                                              }
                                                                            ],
                                                            'main_module' => 'Catalyst::Plugin::Static::Simple',
                                                            'versions' => [
                                                                            {
                                                                              'date' => '2005-08-12T01:37:04',
                                                                              'version' => '0.01'
                                                                            },
                                                                            {
                                                                              'date' => '2005-08-16T22:09:54',
                                                                              'version' => '0.02'
                                                                            },
                                                                            {
                                                                              'date' => '2005-08-22T03:44:24',
                                                                              'version' => '0.03'
                                                                            },
                                                                            {
                                                                              'date' => '2005-08-22T15:59:08',
                                                                              'version' => '0.04'
                                                                            },
                                                                            {
                                                                              'date' => '2005-08-26T15:58:06',
                                                                              'version' => '0.05'
                                                                            },
                                                                            {
                                                                              'date' => '2005-09-05T19:36:58',
                                                                              'version' => '0.06'
                                                                            },
                                                                            {
                                                                              'date' => '2005-09-06T01:07:28',
                                                                              'version' => '0.07'
                                                                            },
                                                                            {
                                                                              'date' => '2005-09-07T22:52:21',
                                                                              'version' => '0.08'
                                                                            },
                                                                            {
                                                                              'date' => '2005-10-07T17:40:16',
                                                                              'version' => '0.09'
                                                                            },
                                                                            {
                                                                              'date' => '2005-10-19T21:19:04',
                                                                              'version' => '0.10'
                                                                            },
                                                                            {
                                                                              'date' => '2005-11-14T00:28:01',
                                                                              'version' => '0.11'
                                                                            },
                                                                            {
                                                                              'date' => '2005-12-15T14:56:40',
                                                                              'version' => '0.13'
                                                                            },
                                                                            {
                                                                              'date' => '2006-03-24T16:18:59',
                                                                              'version' => '0.14'
                                                                            },
                                                                            {
                                                                              'date' => '2006-07-05T16:35:54',
                                                                              'version' => '0.14'
                                                                            },
                                                                            {
                                                                              'date' => '2006-12-09T03:25:57',
                                                                              'version' => '0.15'
                                                                            },
                                                                            {
                                                                              'date' => '2007-04-30T18:48:25',
                                                                              'version' => '0.16'
                                                                            },
                                                                            {
                                                                              'date' => '2007-05-11T14:52:16',
                                                                              'version' => '0.17'
                                                                            },
                                                                            {
                                                                              'date' => '2007-07-01T04:12:31',
                                                                              'version' => '0.18'
                                                                            },
                                                                            {
                                                                              'date' => '2007-07-02T20:54:05',
                                                                              'version' => '0.19'
                                                                            },
                                                                            {
                                                                              'date' => '2007-09-24T13:50:15',
                                                                              'version' => '0.20'
                                                                            },
                                                                            {
                                                                              'date' => '2009-03-29T18:47:56',
                                                                              'version' => '0.21'
                                                                            },
                                                                            {
                                                                              'date' => '2009-08-21T16:21:17',
                                                                              'version' => '0.22'
                                                                            },
                                                                            {
                                                                              'date' => '2009-10-06T16:51:19',
                                                                              'version' => '0.23'
                                                                            },
                                                                            {
                                                                              'date' => '2009-10-18T18:12:48',
                                                                              'version' => '0.24'
                                                                            },
                                                                            {
                                                                              'date' => '2009-10-22T20:49:26',
                                                                              'version' => '0.25'
                                                                            },
                                                                            {
                                                                              'date' => '2009-12-06T12:32:46',
                                                                              'version' => '0.26'
                                                                            },
                                                                            {
                                                                              'date' => '2010-01-03T14:56:26',
                                                                              'version' => '0.27'
                                                                            },
                                                                            {
                                                                              'date' => '2010-01-04T13:18:25',
                                                                              'version' => '0.28'
                                                                            },
                                                                            {
                                                                              'date' => '2010-02-01T18:48:45',
                                                                              'version' => '0.29'
                                                                            },
                                                                            {
                                                                              'date' => '2012-05-04T17:17:29',
                                                                              'version' => '0.30'
                                                                            },
                                                                            {
                                                                              'date' => '2013-09-09T14:32:43',
                                                                              'version' => '0.31'
                                                                            },
                                                                            {
                                                                              'date' => '2014-06-05T12:44:48',
                                                                              'version' => '0.32'
                                                                            },
                                                                            {
                                                                              'date' => '2014-10-29T16:02:17',
                                                                              'version' => '0.33'
                                                                            },
                                                                            {
                                                                              'date' => '2017-08-02T17:00:14',
                                                                              'version' => '0.34'
                                                                            },
                                                                            {
                                                                              'date' => '2018-03-14T12:13:30',
                                                                              'version' => '0.35'
                                                                            },
                                                                            {
                                                                              'date' => '2018-03-15T11:41:17',
                                                                              'version' => '0.36'
                                                                            },
                                                                            {
                                                                              'date' => '2021-05-05T14:30:07',
                                                                              'version' => '0.37'
                                                                            }
                                                                          ]
                                                          },
                       'Catalyst-Runtime' => {
                                               'advisories' => [
                                                                 {
                                                                   'affected_versions' => '<5.90020',
                                                                   'cves' => [],
                                                                   'description' => 'Passing a special host to the redirect page link makes it vulnerable to XSS attack.
',
                                                                   'distribution' => 'Catalyst-Runtime',
                                                                   'fixed_versions' => '>=5.90020',
                                                                   'id' => 'CPANSA-Catalyst-Runtime-2013-01',
                                                                   'references' => [
                                                                                     'http://git.shadowcat.co.uk/gitweb/gitweb.cgi?p=catagits/Catalyst-Runtime.git;a=commitdiff;h=7af54927870a7c6f89323ac1876d49f92e7841f5'
                                                                                   ],
                                                                   'reported' => '2013-01-23'
                                                                 },
                                                                 {
                                                                   'affected_versions' => '<5.58',
                                                                   'cves' => [],
                                                                   'description' => 'Path traversal in Static::Simple plugin.
',
                                                                   'distribution' => 'Catalyst-Runtime',
                                                                   'fixed_versions' => '>=5.58',
                                                                   'id' => 'CPANSA-Catalyst-Runtime-2005-01',
                                                                   'reported' => '2005-11-24'
                                                                 }
                                                               ],
                                               'main_module' => 'Catalyst::Runtime',
                                               'versions' => [
                                                               {
                                                                 'date' => '2006-06-25T19:20:53',
                                                                 'version' => '5.70_01'
                                                               },
                                                               {
                                                                 'date' => '2006-06-27T18:10:20',
                                                                 'version' => '5.70_02'
                                                               },
                                                               {
                                                                 'date' => '2006-06-28T21:50:30',
                                                                 'version' => '5.70_03'
                                                               },
                                                               {
                                                                 'date' => '2006-07-07T22:47:30',
                                                                 'version' => '5.7000'
                                                               },
                                                               {
                                                                 'date' => '2006-07-20T06:00:58',
                                                                 'version' => '5.7001'
                                                               },
                                                               {
                                                                 'date' => '2006-09-19T07:36:29',
                                                                 'version' => '5.7002'
                                                               },
                                                               {
                                                                 'date' => '2006-09-23T17:43:12',
                                                                 'version' => '5.7003'
                                                               },
                                                               {
                                                                 'date' => '2006-11-06T23:28:40',
                                                                 'version' => '5.7004'
                                                               },
                                                               {
                                                                 'date' => '2006-11-07T19:43:56',
                                                                 'version' => '5.7005'
                                                               },
                                                               {
                                                                 'date' => '2006-11-15T08:27:59',
                                                                 'version' => '5.7006'
                                                               },
                                                               {
                                                                 'date' => '2007-03-14T11:13:37',
                                                                 'version' => '5.7007'
                                                               },
                                                               {
                                                                 'date' => '2007-08-13T06:36:11',
                                                                 'version' => '5.7008'
                                                               },
                                                               {
                                                                 'date' => '2007-08-21T22:23:53',
                                                                 'version' => '5.7009'
                                                               },
                                                               {
                                                                 'date' => '2007-08-22T05:51:41',
                                                                 'version' => '5.7010'
                                                               },
                                                               {
                                                                 'date' => '2007-10-18T18:11:24',
                                                                 'version' => '5.7011'
                                                               },
                                                               {
                                                                 'date' => '2007-12-17T08:19:28',
                                                                 'version' => '5.7012'
                                                               },
                                                               {
                                                                 'date' => '2008-05-17T12:41:13',
                                                                 'version' => '5.7013'
                                                               },
                                                               {
                                                                 'date' => '2008-05-25T21:16:45',
                                                                 'version' => '5.7013'
                                                               },
                                                               {
                                                                 'date' => '2008-06-25T20:43:41',
                                                                 'version' => '5.7099_01'
                                                               },
                                                               {
                                                                 'date' => '2008-07-18T11:41:25',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-07-20T08:15:02',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-13T20:55:41',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-14T06:06:06',
                                                                 'version' => '5.7099_02'
                                                               },
                                                               {
                                                                 'date' => '2008-10-15T21:44:15',
                                                                 'version' => '5.7015'
                                                               },
                                                               {
                                                                 'date' => '2008-10-17T12:42:53',
                                                                 'version' => '5.8000_03'
                                                               },
                                                               {
                                                                 'date' => '2008-12-05T15:11:14',
                                                                 'version' => '5.8000_04'
                                                               },
                                                               {
                                                                 'date' => '2009-01-12T15:46:59',
                                                                 'version' => '5.7099_04'
                                                               },
                                                               {
                                                                 'date' => '2009-01-19T17:36:04',
                                                                 'version' => '5.71000'
                                                               },
                                                               {
                                                                 'date' => '2009-01-29T08:56:09',
                                                                 'version' => '5.8000_05'
                                                               },
                                                               {
                                                                 'date' => '2009-02-04T20:08:22',
                                                                 'version' => '5.8000_06'
                                                               },
                                                               {
                                                                 'date' => '2009-03-27T09:21:12',
                                                                 'version' => '5.71001'
                                                               },
                                                               {
                                                                 'date' => '2009-04-13T19:03:36',
                                                                 'version' => '5.8000_07'
                                                               },
                                                               {
                                                                 'date' => '2009-04-18T20:26:00',
                                                                 'version' => '5.80001'
                                                               },
                                                               {
                                                                 'date' => '2009-04-21T23:45:45',
                                                                 'version' => '5.80002'
                                                               },
                                                               {
                                                                 'date' => '2009-04-29T14:39:21',
                                                                 'version' => '5.80003'
                                                               },
                                                               {
                                                                 'date' => '2009-05-18T15:16:38',
                                                                 'version' => '5.80004'
                                                               },
                                                               {
                                                                 'date' => '2009-06-06T12:49:15',
                                                                 'version' => '5.80005'
                                                               },
                                                               {
                                                                 'date' => '2009-06-29T22:11:48',
                                                                 'version' => '5.80006'
                                                               },
                                                               {
                                                                 'date' => '2009-06-30T22:11:36',
                                                                 'version' => '5.80007'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T16:14:33',
                                                                 'version' => '5.80008'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T20:29:33',
                                                                 'version' => '5.80009'
                                                               },
                                                               {
                                                                 'date' => '2009-08-21T21:42:08',
                                                                 'version' => '5.80010'
                                                               },
                                                               {
                                                                 'date' => '2009-08-23T11:57:26',
                                                                 'version' => '5.80011'
                                                               },
                                                               {
                                                                 'date' => '2009-09-09T18:01:32',
                                                                 'version' => '5.80012'
                                                               },
                                                               {
                                                                 'date' => '2009-09-17T09:35:20',
                                                                 'version' => '5.80013'
                                                               },
                                                               {
                                                                 'date' => '2009-11-21T02:32:20',
                                                                 'version' => '5.80014'
                                                               },
                                                               {
                                                                 'date' => '2009-11-22T20:24:47',
                                                                 'version' => '5.80014_01'
                                                               },
                                                               {
                                                                 'date' => '2009-12-01T01:14:00',
                                                                 'version' => '5.80014_02'
                                                               },
                                                               {
                                                                 'date' => '2009-12-02T15:42:50',
                                                                 'version' => '5.80015'
                                                               },
                                                               {
                                                                 'date' => '2009-12-11T23:37:44',
                                                                 'version' => '5.80016'
                                                               },
                                                               {
                                                                 'date' => '2010-01-10T02:01:50',
                                                                 'version' => '5.80017'
                                                               },
                                                               {
                                                                 'date' => '2010-01-12T21:39:47',
                                                                 'version' => '5.80018'
                                                               },
                                                               {
                                                                 'date' => '2010-01-29T00:18:07',
                                                                 'version' => '5.80019'
                                                               },
                                                               {
                                                                 'date' => '2010-02-04T06:19:31',
                                                                 'version' => '5.80020'
                                                               },
                                                               {
                                                                 'date' => '2010-03-03T23:16:29',
                                                                 'version' => '5.80021'
                                                               },
                                                               {
                                                                 'date' => '2010-03-28T19:25:48',
                                                                 'version' => '5.80022'
                                                               },
                                                               {
                                                                 'date' => '2010-05-07T22:07:08',
                                                                 'version' => '5.80023'
                                                               },
                                                               {
                                                                 'date' => '2010-05-15T09:57:52',
                                                                 'version' => '5.80024'
                                                               },
                                                               {
                                                                 'date' => '2010-07-29T00:59:16',
                                                                 'version' => '5.80025'
                                                               },
                                                               {
                                                                 'date' => '2010-09-01T15:10:42',
                                                                 'version' => '5.80026'
                                                               },
                                                               {
                                                                 'date' => '2010-09-02T11:33:03',
                                                                 'version' => '5.80027'
                                                               },
                                                               {
                                                                 'date' => '2010-09-28T20:14:11',
                                                                 'version' => '5.80028'
                                                               },
                                                               {
                                                                 'date' => '2010-10-03T16:24:08',
                                                                 'version' => '5.80029'
                                                               },
                                                               {
                                                                 'date' => '2011-01-04T12:56:30',
                                                                 'version' => '5.80030'
                                                               },
                                                               {
                                                                 'date' => '2011-01-24T10:50:27',
                                                                 'version' => '5.89000'
                                                               },
                                                               {
                                                                 'date' => '2011-01-31T08:25:21',
                                                                 'version' => '5.80031'
                                                               },
                                                               {
                                                                 'date' => '2011-02-23T08:28:58',
                                                                 'version' => '5.80032'
                                                               },
                                                               {
                                                                 'date' => '2011-03-01T14:56:37',
                                                                 'version' => '5.89001'
                                                               },
                                                               {
                                                                 'date' => '2011-03-02T10:37:42',
                                                                 'version' => '5.89002'
                                                               },
                                                               {
                                                                 'date' => '2011-07-24T15:58:37',
                                                                 'version' => '5.80033'
                                                               },
                                                               {
                                                                 'date' => '2011-07-28T20:05:01',
                                                                 'version' => '5.89003'
                                                               },
                                                               {
                                                                 'date' => '2011-08-15T21:35:34',
                                                                 'version' => '5.9000'
                                                               },
                                                               {
                                                                 'date' => '2011-08-15T21:59:58',
                                                                 'version' => '5.90001'
                                                               },
                                                               {
                                                                 'date' => '2011-08-22T20:55:10',
                                                                 'version' => '5.90002'
                                                               },
                                                               {
                                                                 'date' => '2011-10-05T07:48:57',
                                                                 'version' => '5.90003'
                                                               },
                                                               {
                                                                 'date' => '2011-10-11T15:19:05',
                                                                 'version' => '5.90004'
                                                               },
                                                               {
                                                                 'date' => '2011-10-22T21:01:24',
                                                                 'version' => '5.90005'
                                                               },
                                                               {
                                                                 'date' => '2011-10-25T17:54:34',
                                                                 'version' => '5.90006'
                                                               },
                                                               {
                                                                 'date' => '2011-11-22T20:40:44',
                                                                 'version' => '5.90007'
                                                               },
                                                               {
                                                                 'date' => '2012-02-06T21:08:28',
                                                                 'version' => '5.90008'
                                                               },
                                                               {
                                                                 'date' => '2012-02-16T09:29:44',
                                                                 'version' => '5.90009'
                                                               },
                                                               {
                                                                 'date' => '2012-02-18T00:49:30',
                                                                 'version' => '5.90010'
                                                               },
                                                               {
                                                                 'date' => '2012-03-08T21:53:00',
                                                                 'version' => '5.90011'
                                                               },
                                                               {
                                                                 'date' => '2012-05-19T07:13:21',
                                                                 'version' => '5.90012'
                                                               },
                                                               {
                                                                 'date' => '2012-06-08T00:37:40',
                                                                 'version' => '5.90013'
                                                               },
                                                               {
                                                                 'date' => '2012-06-21T20:41:41',
                                                                 'version' => '5.90013'
                                                               },
                                                               {
                                                                 'date' => '2012-06-26T14:34:56',
                                                                 'version' => '5.90014'
                                                               },
                                                               {
                                                                 'date' => '2012-06-30T18:00:53',
                                                                 'version' => '5.90015'
                                                               },
                                                               {
                                                                 'date' => '2012-08-17T01:39:42',
                                                                 'version' => '5.90016'
                                                               },
                                                               {
                                                                 'date' => '2012-10-19T21:51:54',
                                                                 'version' => '5.90017'
                                                               },
                                                               {
                                                                 'date' => '2012-10-24T01:01:44',
                                                                 'version' => '5.90018'
                                                               },
                                                               {
                                                                 'date' => '2012-12-04T22:04:19',
                                                                 'version' => '5.90019'
                                                               },
                                                               {
                                                                 'date' => '2013-02-22T14:05:39',
                                                                 'version' => '5.90020'
                                                               },
                                                               {
                                                                 'date' => '2013-04-12T17:09:27',
                                                                 'version' => '5.90030'
                                                               },
                                                               {
                                                                 'date' => '2013-06-12T21:26:14',
                                                                 'version' => '5.90040'
                                                               },
                                                               {
                                                                 'date' => '2013-06-15T02:10:17',
                                                                 'version' => '5.90041'
                                                               },
                                                               {
                                                                 'date' => '2013-06-16T01:57:47',
                                                                 'version' => '5.90042'
                                                               },
                                                               {
                                                                 'date' => '2013-07-26T19:13:01',
                                                                 'version' => '5.90049_001'
                                                               },
                                                               {
                                                                 'date' => '2013-08-21T02:39:45',
                                                                 'version' => '5.90049_002'
                                                               },
                                                               {
                                                                 'date' => '2013-09-20T19:03:54',
                                                                 'version' => '5.90049_003'
                                                               },
                                                               {
                                                                 'date' => '2013-10-18T22:19:33',
                                                                 'version' => '5.90049_004'
                                                               },
                                                               {
                                                                 'date' => '2013-10-31T20:48:42',
                                                                 'version' => '5.90049_005'
                                                               },
                                                               {
                                                                 'date' => '2013-11-05T03:25:31',
                                                                 'version' => '5.90049_006'
                                                               },
                                                               {
                                                                 'date' => '2013-11-05T22:35:22',
                                                                 'version' => '5.90050'
                                                               },
                                                               {
                                                                 'date' => '2013-11-07T17:14:35',
                                                                 'version' => '5.90051'
                                                               },
                                                               {
                                                                 'date' => '2013-12-18T20:03:22',
                                                                 'version' => '5.90052'
                                                               },
                                                               {
                                                                 'date' => '2013-12-19T14:33:08',
                                                                 'version' => '5.90059_001'
                                                               },
                                                               {
                                                                 'date' => '2013-12-22T16:18:16',
                                                                 'version' => '5.90053'
                                                               },
                                                               {
                                                                 'date' => '2013-12-22T16:34:11',
                                                                 'version' => '5.90059_002'
                                                               },
                                                               {
                                                                 'date' => '2013-12-27T02:27:08',
                                                                 'version' => '5.90059_003'
                                                               },
                                                               {
                                                                 'date' => '2014-01-27T17:20:51',
                                                                 'version' => '5.90059_004'
                                                               },
                                                               {
                                                                 'date' => '2014-01-28T19:36:58',
                                                                 'version' => '5.90059_005'
                                                               },
                                                               {
                                                                 'date' => '2014-02-06T20:41:25',
                                                                 'version' => '5.90059_006'
                                                               },
                                                               {
                                                                 'date' => '2014-02-08T03:11:11',
                                                                 'version' => '5.90060'
                                                               },
                                                               {
                                                                 'date' => '2014-03-10T14:46:10',
                                                                 'version' => '5.90061'
                                                               },
                                                               {
                                                                 'date' => '2014-04-14T18:53:26',
                                                                 'version' => '5.90062'
                                                               },
                                                               {
                                                                 'date' => '2014-05-02T00:15:16',
                                                                 'version' => '5.90063'
                                                               },
                                                               {
                                                                 'date' => '2014-05-05T14:55:25',
                                                                 'version' => '5.90064'
                                                               },
                                                               {
                                                                 'date' => '2014-05-27T18:08:08',
                                                                 'version' => '5.90069_001'
                                                               },
                                                               {
                                                                 'date' => '2014-06-05T12:44:59',
                                                                 'version' => '5.90065'
                                                               },
                                                               {
                                                                 'date' => '2014-06-10T00:22:42',
                                                                 'version' => '5.90069_002'
                                                               },
                                                               {
                                                                 'date' => '2014-08-06T15:09:29',
                                                                 'version' => '5.90069_003'
                                                               },
                                                               {
                                                                 'date' => '2014-08-07T15:59:15',
                                                                 'version' => '5.90069_004'
                                                               },
                                                               {
                                                                 'date' => '2014-08-07T21:49:59',
                                                                 'version' => '5.90070'
                                                               },
                                                               {
                                                                 'date' => '2014-08-10T13:15:52',
                                                                 'version' => '5.90071'
                                                               },
                                                               {
                                                                 'date' => '2014-09-15T16:30:58',
                                                                 'version' => '5.90072'
                                                               },
                                                               {
                                                                 'date' => '2014-09-23T17:24:54',
                                                                 'version' => '5.90073'
                                                               },
                                                               {
                                                                 'date' => '2014-10-01T21:45:12',
                                                                 'version' => '5.90074'
                                                               },
                                                               {
                                                                 'date' => '2014-10-07T00:07:51',
                                                                 'version' => '5.90075'
                                                               },
                                                               {
                                                                 'date' => '2014-11-14T00:20:16',
                                                                 'version' => '5.90076'
                                                               },
                                                               {
                                                                 'date' => '2014-11-19T00:28:27',
                                                                 'version' => '5.90077'
                                                               },
                                                               {
                                                                 'date' => '2014-12-02T21:50:30',
                                                                 'version' => '5.90079_001'
                                                               },
                                                               {
                                                                 'date' => '2014-12-02T23:22:07',
                                                                 'version' => '5.90079_002'
                                                               },
                                                               {
                                                                 'date' => '2014-12-03T19:45:16',
                                                                 'version' => '5.90079_003'
                                                               },
                                                               {
                                                                 'date' => '2014-12-26T23:05:46',
                                                                 'version' => '5.90079_004'
                                                               },
                                                               {
                                                                 'date' => '2014-12-31T16:26:20',
                                                                 'version' => '5.90078'
                                                               },
                                                               {
                                                                 'date' => '2014-12-31T21:04:56',
                                                                 'version' => '5.90079_005'
                                                               },
                                                               {
                                                                 'date' => '2015-01-02T15:11:55',
                                                                 'version' => '5.90079_006'
                                                               },
                                                               {
                                                                 'date' => '2015-01-02T18:11:38',
                                                                 'version' => '5.90079'
                                                               },
                                                               {
                                                                 'date' => '2015-01-07T20:01:40',
                                                                 'version' => '5.90079_007'
                                                               },
                                                               {
                                                                 'date' => '2015-01-07T23:26:17',
                                                                 'version' => '5.90079_008'
                                                               },
                                                               {
                                                                 'date' => '2015-01-09T17:04:47',
                                                                 'version' => '5.90080'
                                                               },
                                                               {
                                                                 'date' => '2015-01-10T22:39:56',
                                                                 'version' => '5.90081'
                                                               },
                                                               {
                                                                 'date' => '2015-01-10T23:33:56',
                                                                 'version' => '5.90082'
                                                               },
                                                               {
                                                                 'date' => '2015-02-17T02:29:50',
                                                                 'version' => '5.90083'
                                                               },
                                                               {
                                                                 'date' => '2015-02-23T22:24:50',
                                                                 'version' => '5.90084'
                                                               },
                                                               {
                                                                 'date' => '2015-03-25T18:58:11',
                                                                 'version' => '5.90085'
                                                               },
                                                               {
                                                                 'date' => '2015-03-26T21:30:15',
                                                                 'version' => '5.90089_001'
                                                               },
                                                               {
                                                                 'date' => '2015-04-17T21:32:30',
                                                                 'version' => '5.90089_002'
                                                               },
                                                               {
                                                                 'date' => '2015-04-27T20:20:40',
                                                                 'version' => '5.90089_003'
                                                               },
                                                               {
                                                                 'date' => '2015-04-28T18:24:12',
                                                                 'version' => '5.90089_004'
                                                               },
                                                               {
                                                                 'date' => '2015-04-29T14:04:24',
                                                                 'version' => '5.90090'
                                                               },
                                                               {
                                                                 'date' => '2015-05-08T20:36:59',
                                                                 'version' => '5.90091'
                                                               },
                                                               {
                                                                 'date' => '2015-05-19T16:48:30',
                                                                 'version' => '5.90092'
                                                               },
                                                               {
                                                                 'date' => '2015-05-29T17:06:23',
                                                                 'version' => '5.90093'
                                                               },
                                                               {
                                                                 'date' => '2015-07-24T20:17:46',
                                                                 'version' => '5.90094'
                                                               },
                                                               {
                                                                 'date' => '2015-07-27T14:32:30',
                                                                 'version' => '5.90095'
                                                               },
                                                               {
                                                                 'date' => '2015-07-27T15:44:59',
                                                                 'version' => '5.90096'
                                                               },
                                                               {
                                                                 'date' => '2015-07-28T20:33:41',
                                                                 'version' => '5.90097'
                                                               },
                                                               {
                                                                 'date' => '2015-08-24T16:30:12',
                                                                 'version' => '5.90100'
                                                               },
                                                               {
                                                                 'date' => '2015-09-04T22:57:40',
                                                                 'version' => '5.90101'
                                                               },
                                                               {
                                                                 'date' => '2015-10-29T19:39:24',
                                                                 'version' => '5.90102'
                                                               },
                                                               {
                                                                 'date' => '2015-11-12T10:19:42',
                                                                 'version' => '5.90103'
                                                               },
                                                               {
                                                                 'date' => '2016-04-04T17:18:38',
                                                                 'version' => '5.90104'
                                                               },
                                                               {
                                                                 'date' => '2016-06-08T20:06:53',
                                                                 'version' => '5.90105'
                                                               },
                                                               {
                                                                 'date' => '2016-07-06T01:21:42',
                                                                 'version' => '5.90106'
                                                               },
                                                               {
                                                                 'date' => '2016-07-20T19:12:32',
                                                                 'version' => '5.90110'
                                                               },
                                                               {
                                                                 'date' => '2016-07-20T20:07:16',
                                                                 'version' => '5.90111'
                                                               },
                                                               {
                                                                 'date' => '2016-07-25T21:03:05',
                                                                 'version' => '5.90112'
                                                               },
                                                               {
                                                                 'date' => '2016-12-15T21:35:30',
                                                                 'version' => '5.90113'
                                                               },
                                                               {
                                                                 'date' => '2016-12-19T16:54:08',
                                                                 'version' => '5.90114'
                                                               },
                                                               {
                                                                 'date' => '2017-05-01T16:42:46',
                                                                 'version' => '5.90115'
                                                               },
                                                               {
                                                                 'date' => '2018-01-19T20:55:15',
                                                                 'version' => '5.90116'
                                                               },
                                                               {
                                                                 'date' => '2018-01-21T23:47:21',
                                                                 'version' => '5.90117'
                                                               },
                                                               {
                                                                 'date' => '2018-05-01T09:59:20',
                                                                 'version' => '5.90118'
                                                               },
                                                               {
                                                                 'date' => '2018-09-24T00:25:48',
                                                                 'version' => '5.90119'
                                                               },
                                                               {
                                                                 'date' => '2018-10-19T06:13:58',
                                                                 'version' => '5.90120'
                                                               },
                                                               {
                                                                 'date' => '2018-10-22T20:39:48',
                                                                 'version' => '5.90_121'
                                                               },
                                                               {
                                                                 'date' => '2018-11-03T14:52:06',
                                                                 'version' => '5.90122'
                                                               },
                                                               {
                                                                 'date' => '2018-11-27T15:39:35',
                                                                 'version' => '5.90123'
                                                               },
                                                               {
                                                                 'date' => '2019-01-18T22:36:07',
                                                                 'version' => '5.90124'
                                                               },
                                                               {
                                                                 'date' => '2020-01-19T01:11:05',
                                                                 'version' => '5.90125'
                                                               },
                                                               {
                                                                 'date' => '2020-01-20T01:40:16',
                                                                 'version' => '5.90126'
                                                               },
                                                               {
                                                                 'date' => '2020-07-27T01:25:21',
                                                                 'version' => '5.90_127'
                                                               },
                                                               {
                                                                 'date' => '2020-09-11T12:38:26',
                                                                 'version' => '5.90128'
                                                               }
                                                             ]
                                             },
                       'Clipboard' => {
                                        'advisories' => [
                                                          {
                                                            'affected_versions' => '<0.16',
                                                            'cves' => [
                                                                        'CVE-2014-5509'
                                                                      ],
                                                            'description' => 'clipedit in the Clipboard module for Perl allows local users to delete arbitrary files via a symlink attack on /tmp/clipedit$$.
',
                                                            'distribution' => 'Clipboard',
                                                            'fixed_versions' => undef,
                                                            'id' => 'CPANSA-Clipboard-2014-5509',
                                                            'references' => [
                                                                              'https://rt.cpan.org/Public/Bug/Display.html?id=98435',
                                                                              'https://bugzilla.redhat.com/show_bug.cgi?id=1135624',
                                                                              'http://www.securityfocus.com/bid/69473',
                                                                              'http://www.openwall.com/lists/oss-security/2014/08/30/2'
                                                                            ],
                                                            'reported' => '2018-01-08',
                                                            'severity' => 'medium'
                                                          }
                                                        ],
                                        'main_module' => 'Clipboard',
                                        'versions' => [
                                                        {
                                                          'date' => '2005-05-01T17:19:57',
                                                          'version' => '0.01'
                                                        },
                                                        {
                                                          'date' => '2005-05-02T06:17:33',
                                                          'version' => '0.02'
                                                        },
                                                        {
                                                          'date' => '2005-05-04T06:17:44',
                                                          'version' => '0.03'
                                                        },
                                                        {
                                                          'date' => '2005-05-08T05:54:44',
                                                          'version' => '0.04'
                                                        },
                                                        {
                                                          'date' => '2005-06-01T17:00:34',
                                                          'version' => '0.06'
                                                        },
                                                        {
                                                          'date' => '2005-06-02T05:06:37',
                                                          'version' => '0.07'
                                                        },
                                                        {
                                                          'date' => '2005-06-22T17:05:15',
                                                          'version' => '0.08'
                                                        },
                                                        {
                                                          'date' => '2005-11-19T06:12:48',
                                                          'version' => '0.09'
                                                        },
                                                        {
                                                          'date' => '2010-10-07T01:39:10',
                                                          'version' => '0.10'
                                                        },
                                                        {
                                                          'date' => '2010-10-07T04:49:39',
                                                          'version' => '0.11'
                                                        },
                                                        {
                                                          'date' => '2010-10-11T06:13:22',
                                                          'version' => '0.12'
                                                        },
                                                        {
                                                          'date' => '2010-10-13T04:46:50',
                                                          'version' => '0.13'
                                                        },
                                                        {
                                                          'date' => '2019-01-30T10:47:45',
                                                          'version' => '0.14'
                                                        },
                                                        {
                                                          'date' => '2019-01-30T11:00:22',
                                                          'version' => '0.15'
                                                        },
                                                        {
                                                          'date' => '2019-01-30T11:22:23',
                                                          'version' => '0.16'
                                                        },
                                                        {
                                                          'date' => '2019-01-30T14:00:52',
                                                          'version' => '0.17'
                                                        },
                                                        {
                                                          'date' => '2019-01-30T20:12:11',
                                                          'version' => '0.18'
                                                        },
                                                        {
                                                          'date' => '2019-01-31T11:00:20',
                                                          'version' => '0.19'
                                                        },
                                                        {
                                                          'date' => '2019-04-17T20:55:35',
                                                          'version' => '0.20'
                                                        },
                                                        {
                                                          'date' => '2019-12-02T06:04:27',
                                                          'version' => '0.21'
                                                        },
                                                        {
                                                          'date' => '2020-01-28T18:10:34',
                                                          'version' => '0.22'
                                                        },
                                                        {
                                                          'date' => '2020-03-06T15:43:11',
                                                          'version' => '0.23'
                                                        },
                                                        {
                                                          'date' => '2020-03-07T08:25:07',
                                                          'version' => '0.24'
                                                        },
                                                        {
                                                          'date' => '2020-05-14T06:33:28',
                                                          'version' => '0.25'
                                                        },
                                                        {
                                                          'date' => '2020-05-16T07:56:58',
                                                          'version' => '0.26'
                                                        },
                                                        {
                                                          'date' => '2021-02-13T18:13:34',
                                                          'version' => '0.27'
                                                        },
                                                        {
                                                          'date' => '2021-02-23T07:47:20',
                                                          'version' => '0.28'
                                                        }
                                                      ]
                                      },
                       'Cmd-Dwarf' => {
                                        'advisories' => [
                                                          {
                                                            'affected_versions' => '<1.20',
                                                            'cves' => [],
                                                            'description' => 'JSON highjacking possibility.
',
                                                            'distribution' => 'Cmd-Dwarf',
                                                            'fixed_versions' => '>=1.20',
                                                            'id' => 'CPANSA-Cmd-Dwarf-2014-01',
                                                            'references' => [
                                                                              'https://github.com/seagirl/dwarf/commit/14cf7a1d55db635a07f4838e16f3d9a28e63f529',
                                                                              'https://metacpan.org/changes/distribution/Cmd-Dwarf'
                                                                            ],
                                                            'reported' => '2014-12-03'
                                                          }
                                                        ],
                                        'main_module' => 'Cmd::Dwarf',
                                        'versions' => [
                                                        {
                                                          'date' => '2015-07-30T06:48:35',
                                                          'version' => '1.27'
                                                        },
                                                        {
                                                          'date' => '2015-08-26T13:27:51',
                                                          'version' => '1.28'
                                                        },
                                                        {
                                                          'date' => '2015-08-28T08:58:33',
                                                          'version' => '1.29'
                                                        },
                                                        {
                                                          'date' => '2015-09-17T08:17:32',
                                                          'version' => '1.30'
                                                        },
                                                        {
                                                          'date' => '2016-01-20T06:39:15',
                                                          'version' => '1.31'
                                                        },
                                                        {
                                                          'date' => '2016-10-25T05:56:33',
                                                          'version' => '1.41'
                                                        },
                                                        {
                                                          'date' => '2017-03-29T04:42:05',
                                                          'version' => '1.42'
                                                        },
                                                        {
                                                          'date' => '2017-06-21T07:06:05',
                                                          'version' => '1.50'
                                                        },
                                                        {
                                                          'date' => '2017-10-05T08:08:01',
                                                          'version' => '1.60'
                                                        },
                                                        {
                                                          'date' => '2018-03-17T07:35:19',
                                                          'version' => '1.70'
                                                        },
                                                        {
                                                          'date' => '2018-08-18T11:43:10',
                                                          'version' => '1.80'
                                                        },
                                                        {
                                                          'date' => '2019-04-05T05:22:33',
                                                          'version' => '1.81'
                                                        },
                                                        {
                                                          'date' => '2019-04-05T05:36:46',
                                                          'version' => '1.82'
                                                        },
                                                        {
                                                          'date' => '2019-04-05T09:06:55',
                                                          'version' => '1.83'
                                                        }
                                                      ]
                                      },
                       'Compress-LZ4' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<0.20',
                                                               'cves' => [],
                                                               'description' => 'Outdated LZ4 source code with security issue on 32bit systems.
',
                                                               'distribution' => 'Compress-LZ4',
                                                               'fixed_versions' => '>=0.20',
                                                               'id' => 'CPANSA-Compress-LZ4-2014-01',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Compress-LZ4',
                                                                                 'https://github.com/gray/compress-lz4/commit/fc503812b4cbba16429658e1dfe20ad8bbfd77a0'
                                                                               ],
                                                               'reported' => '2014-07-07'
                                                             }
                                                           ],
                                           'main_module' => 'Compress::LZ4',
                                           'versions' => [
                                                           {
                                                             'date' => '2012-02-11T16:33:26',
                                                             'version' => '0.01'
                                                           },
                                                           {
                                                             'date' => '2012-02-20T21:26:48',
                                                             'version' => '0.02'
                                                           },
                                                           {
                                                             'date' => '2012-03-02T04:47:50',
                                                             'version' => '0.03'
                                                           },
                                                           {
                                                             'date' => '2012-03-18T07:09:30',
                                                             'version' => '0.04'
                                                           },
                                                           {
                                                             'date' => '2012-03-18T19:45:25',
                                                             'version' => '0.05'
                                                           },
                                                           {
                                                             'date' => '2012-03-22T09:23:45',
                                                             'version' => '0.06'
                                                           },
                                                           {
                                                             'date' => '2012-03-22T16:12:43',
                                                             'version' => '0.07'
                                                           },
                                                           {
                                                             'date' => '2012-03-23T16:29:14',
                                                             'version' => '0.08'
                                                           },
                                                           {
                                                             'date' => '2012-03-23T17:27:12',
                                                             'version' => '0.09'
                                                           },
                                                           {
                                                             'date' => '2012-03-26T11:28:24',
                                                             'version' => '0.10'
                                                           },
                                                           {
                                                             'date' => '2012-04-03T21:36:24',
                                                             'version' => '0.11'
                                                           },
                                                           {
                                                             'date' => '2012-04-04T12:55:22',
                                                             'version' => '0.12'
                                                           },
                                                           {
                                                             'date' => '2012-06-01T18:55:41',
                                                             'version' => '0.13'
                                                           },
                                                           {
                                                             'date' => '2012-08-10T00:21:56',
                                                             'version' => '0.14'
                                                           },
                                                           {
                                                             'date' => '2012-08-11T16:37:53',
                                                             'version' => '0.15'
                                                           },
                                                           {
                                                             'date' => '2012-09-08T18:18:41',
                                                             'version' => '0.16'
                                                           },
                                                           {
                                                             'date' => '2013-03-19T00:39:07',
                                                             'version' => '0.17'
                                                           },
                                                           {
                                                             'date' => '2013-11-19T00:56:57',
                                                             'version' => '0.18'
                                                           },
                                                           {
                                                             'date' => '2014-02-08T00:35:09',
                                                             'version' => '0.19'
                                                           },
                                                           {
                                                             'date' => '2014-07-07T21:08:49',
                                                             'version' => '0.20'
                                                           },
                                                           {
                                                             'date' => '2015-05-12T19:01:36',
                                                             'version' => '0.21'
                                                           },
                                                           {
                                                             'date' => '2015-05-20T06:16:53',
                                                             'version' => '0.22'
                                                           },
                                                           {
                                                             'date' => '2016-07-25T20:45:05',
                                                             'version' => '0.23'
                                                           },
                                                           {
                                                             'date' => '2017-03-23T04:34:45',
                                                             'version' => '0.24'
                                                           },
                                                           {
                                                             'date' => '2017-04-06T16:38:31',
                                                             'version' => '0.25'
                                                           }
                                                         ]
                                         },
                       'Compress-Raw-Bzip2' => {
                                                 'advisories' => [
                                                                   {
                                                                     'affected_versions' => '<2.031',
                                                                     'cves' => [
                                                                                 'CVE-2010-0405'
                                                                               ],
                                                                     'description' => 'Integer overflow in the BZ2_decompress function in decompress.c in bzip2 and libbzip2 before 1.0.6 allows context-dependent attackers to cause a denial of service (application crash) or possibly execute arbitrary code via a crafted compressed file.
',
                                                                     'distribution' => 'Compress-Raw-Bzip2',
                                                                     'fixed_versions' => '>=2.031',
                                                                     'id' => 'CPANSA-Compress-Raw-Bzip2-2010-0405',
                                                                     'references' => [
                                                                                       'https://metacpan.org/changes/distribution/Compress-Raw-Bzip2'
                                                                                     ],
                                                                     'reported' => '2010-01-27'
                                                                   },
                                                                   {
                                                                     'affected_versions' => '<2.018',
                                                                     'cves' => [
                                                                                 'CVE-2009-1884'
                                                                               ],
                                                                     'description' => 'Off-by-one error in the bzinflate function in Bzip2.xs in the Compress-Raw-Bzip2 module before 2.018 for Perl allows context-dependent attackers to cause a denial of service (application hang or crash) via a crafted bzip2 compressed stream that triggers a buffer overflow, a related issue to CVE-2009-1391.
',
                                                                     'distribution' => 'Compress-Raw-Bzip2',
                                                                     'fixed_versions' => '>=2.018',
                                                                     'id' => 'CPANSA-Compress-Raw-Bzip2-2009-1884',
                                                                     'references' => [
                                                                                       'http://security.gentoo.org/glsa/glsa-200908-07.xml',
                                                                                       'https://bugs.gentoo.org/show_bug.cgi?id=281955',
                                                                                       'https://www.redhat.com/archives/fedora-package-announce/2009-August/msg00999.html',
                                                                                       'https://www.redhat.com/archives/fedora-package-announce/2009-August/msg00982.html',
                                                                                       'http://www.securityfocus.com/bid/36082',
                                                                                       'http://secunia.com/advisories/36386',
                                                                                       'https://bugzilla.redhat.com/show_bug.cgi?id=518278',
                                                                                       'http://secunia.com/advisories/36415',
                                                                                       'https://exchange.xforce.ibmcloud.com/vulnerabilities/52628'
                                                                                     ],
                                                                     'reported' => '2009-08-19',
                                                                     'severity' => undef
                                                                   }
                                                                 ],
                                                 'main_module' => 'Compress::Raw::Bzip2',
                                                 'versions' => [
                                                                 {
                                                                   'date' => '2006-03-13T16:14:00',
                                                                   'version' => '2.000_10'
                                                                 },
                                                                 {
                                                                   'date' => '2006-04-15T21:23:09',
                                                                   'version' => '2.000_11'
                                                                 },
                                                                 {
                                                                   'date' => '2006-05-17T12:43:30',
                                                                   'version' => '2.000_12'
                                                                 },
                                                                 {
                                                                   'date' => '2006-06-20T12:43:47',
                                                                   'version' => '2.000_13'
                                                                 },
                                                                 {
                                                                   'date' => '2006-10-26T14:15:45',
                                                                   'version' => '2.000_14'
                                                                 },
                                                                 {
                                                                   'date' => '2006-11-01T10:35:27',
                                                                   'version' => '2.001'
                                                                 },
                                                                 {
                                                                   'date' => '2006-12-29T20:40:23',
                                                                   'version' => '2.002'
                                                                 },
                                                                 {
                                                                   'date' => '2007-01-02T13:03:45',
                                                                   'version' => '2.003'
                                                                 },
                                                                 {
                                                                   'date' => '2007-03-03T15:50:04',
                                                                   'version' => '2.004'
                                                                 },
                                                                 {
                                                                   'date' => '2007-07-01T00:06:51',
                                                                   'version' => '2.005'
                                                                 },
                                                                 {
                                                                   'date' => '2007-09-01T19:44:48',
                                                                   'version' => '2.006'
                                                                 },
                                                                 {
                                                                   'date' => '2007-11-10T11:59:25',
                                                                   'version' => '2.008'
                                                                 },
                                                                 {
                                                                   'date' => '2008-04-20T14:41:25',
                                                                   'version' => '2.009'
                                                                 },
                                                                 {
                                                                   'date' => '2008-05-05T17:18:15',
                                                                   'version' => '2.010'
                                                                 },
                                                                 {
                                                                   'date' => '2008-05-17T11:16:17',
                                                                   'version' => '2.011'
                                                                 },
                                                                 {
                                                                   'date' => '2008-07-15T22:23:56',
                                                                   'version' => '2.012'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-02T20:20:05',
                                                                   'version' => '2.014'
                                                                 },
                                                                 {
                                                                   'date' => '2008-09-03T20:47:15',
                                                                   'version' => '2.015'
                                                                 },
                                                                 {
                                                                   'date' => '2009-04-04T09:47:36',
                                                                   'version' => '2.017'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-03T16:26:57',
                                                                   'version' => '2.018'
                                                                 },
                                                                 {
                                                                   'date' => '2009-05-04T09:42:06',
                                                                   'version' => '2.019'
                                                                 },
                                                                 {
                                                                   'date' => '2009-06-03T17:48:18',
                                                                   'version' => '2.020'
                                                                 },
                                                                 {
                                                                   'date' => '2009-08-30T20:25:24',
                                                                   'version' => '2.021'
                                                                 },
                                                                 {
                                                                   'date' => '2009-11-09T23:25:19',
                                                                   'version' => '2.023'
                                                                 },
                                                                 {
                                                                   'date' => '2010-01-09T17:56:12',
                                                                   'version' => '2.024'
                                                                 },
                                                                 {
                                                                   'date' => '2010-03-28T12:56:33',
                                                                   'version' => '2.025'
                                                                 },
                                                                 {
                                                                   'date' => '2010-04-07T19:49:29',
                                                                   'version' => '2.026'
                                                                 },
                                                                 {
                                                                   'date' => '2010-04-24T19:15:32',
                                                                   'version' => '2.027'
                                                                 },
                                                                 {
                                                                   'date' => '2010-07-24T14:29:17',
                                                                   'version' => '2.030'
                                                                 },
                                                                 {
                                                                   'date' => '2010-09-21T19:44:52',
                                                                   'version' => '2.031'
                                                                 },
                                                                 {
                                                                   'date' => '2011-01-06T11:26:00',
                                                                   'version' => '2.032'
                                                                 },
                                                                 {
                                                                   'date' => '2011-01-11T14:02:05',
                                                                   'version' => '2.033'
                                                                 },
                                                                 {
                                                                   'date' => '2011-05-02T21:50:15',
                                                                   'version' => '2.034'
                                                                 },
                                                                 {
                                                                   'date' => '2011-05-07T08:30:09',
                                                                   'version' => '2.035'
                                                                 },
                                                                 {
                                                                   'date' => '2011-06-18T21:45:13',
                                                                   'version' => '2.036'
                                                                 },
                                                                 {
                                                                   'date' => '2011-06-22T07:17:56',
                                                                   'version' => '2.037'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-28T14:27:59',
                                                                   'version' => '2.039'
                                                                 },
                                                                 {
                                                                   'date' => '2011-10-28T22:18:59',
                                                                   'version' => '2.040'
                                                                 },
                                                                 {
                                                                   'date' => '2011-11-17T23:44:58',
                                                                   'version' => '2.042'
                                                                 },
                                                                 {
                                                                   'date' => '2011-11-20T21:31:34',
                                                                   'version' => '2.043'
                                                                 },
                                                                 {
                                                                   'date' => '2011-12-03T22:48:47',
                                                                   'version' => '2.044'
                                                                 },
                                                                 {
                                                                   'date' => '2011-12-04T19:19:58',
                                                                   'version' => '2.045'
                                                                 },
                                                                 {
                                                                   'date' => '2012-01-28T23:26:44',
                                                                   'version' => '2.047'
                                                                 },
                                                                 {
                                                                   'date' => '2012-01-29T16:58:55',
                                                                   'version' => '2.048'
                                                                 },
                                                                 {
                                                                   'date' => '2012-02-18T15:56:34',
                                                                   'version' => '2.049'
                                                                 },
                                                                 {
                                                                   'date' => '2012-04-29T12:40:06',
                                                                   'version' => '2.052'
                                                                 },
                                                                 {
                                                                   'date' => '2012-08-05T20:35:37',
                                                                   'version' => '2.055'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-10T19:08:29',
                                                                   'version' => '2.057'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-12T22:14:16',
                                                                   'version' => '2.058'
                                                                 },
                                                                 {
                                                                   'date' => '2012-11-25T13:38:19',
                                                                   'version' => '2.059'
                                                                 },
                                                                 {
                                                                   'date' => '2013-01-07T20:02:08',
                                                                   'version' => '2.060'
                                                                 },
                                                                 {
                                                                   'date' => '2013-05-27T09:54:30',
                                                                   'version' => '2.061'
                                                                 },
                                                                 {
                                                                   'date' => '2013-08-12T19:06:20',
                                                                   'version' => '2.062'
                                                                 },
                                                                 {
                                                                   'date' => '2013-11-02T17:14:54',
                                                                   'version' => '2.063'
                                                                 },
                                                                 {
                                                                   'date' => '2014-02-01T23:19:50',
                                                                   'version' => '2.064'
                                                                 },
                                                                 {
                                                                   'date' => '2014-09-21T12:40:58',
                                                                   'version' => '2.066'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-08T15:12:21',
                                                                   'version' => '2.067'
                                                                 },
                                                                 {
                                                                   'date' => '2014-12-23T17:44:34',
                                                                   'version' => '2.068'
                                                                 },
                                                                 {
                                                                   'date' => '2015-09-27T14:33:57',
                                                                   'version' => '2.069'
                                                                 },
                                                                 {
                                                                   'date' => '2016-12-28T23:07:42',
                                                                   'version' => '2.070'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-12T20:39:20',
                                                                   'version' => '2.072'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-19T20:35:17',
                                                                   'version' => '2.073'
                                                                 },
                                                                 {
                                                                   'date' => '2017-02-19T22:11:17',
                                                                   'version' => '2.074'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-03T18:20:04',
                                                                   'version' => '2.080'
                                                                 },
                                                                 {
                                                                   'date' => '2018-04-08T15:01:21',
                                                                   'version' => '2.081'
                                                                 },
                                                                 {
                                                                   'date' => '2018-12-30T22:38:05',
                                                                   'version' => '2.083'
                                                                 },
                                                                 {
                                                                   'date' => '2019-01-06T08:56:52',
                                                                   'version' => '2.084'
                                                                 },
                                                                 {
                                                                   'date' => '2019-03-31T19:13:22',
                                                                   'version' => '2.086'
                                                                 },
                                                                 {
                                                                   'date' => '2019-08-10T18:11:44',
                                                                   'version' => '2.087'
                                                                 },
                                                                 {
                                                                   'date' => '2019-11-03T08:56:50',
                                                                   'version' => '2.088'
                                                                 },
                                                                 {
                                                                   'date' => '2019-11-03T19:53:42',
                                                                   'version' => '2.089'
                                                                 },
                                                                 {
                                                                   'date' => '2019-11-09T18:35:48',
                                                                   'version' => '2.090'
                                                                 },
                                                                 {
                                                                   'date' => '2019-11-23T19:34:12',
                                                                   'version' => '2.091'
                                                                 },
                                                                 {
                                                                   'date' => '2019-12-04T22:08:25',
                                                                   'version' => '2.092'
                                                                 },
                                                                 {
                                                                   'date' => '2019-12-07T16:05:12',
                                                                   'version' => '2.093'
                                                                 },
                                                                 {
                                                                   'date' => '2020-07-13T10:53:44',
                                                                   'version' => '2.094'
                                                                 },
                                                                 {
                                                                   'date' => '2020-07-20T19:13:40',
                                                                   'version' => '2.095'
                                                                 },
                                                                 {
                                                                   'date' => '2020-07-31T20:50:12',
                                                                   'version' => '2.096'
                                                                 },
                                                                 {
                                                                   'date' => '2021-01-07T13:00:00',
                                                                   'version' => '2.100'
                                                                 },
                                                                 {
                                                                   'date' => '2021-02-20T14:08:53',
                                                                   'version' => '2.101'
                                                                 },
                                                                 {
                                                                   'date' => '2022-04-03T19:48:28',
                                                                   'version' => '2.103'
                                                                 },
                                                                 {
                                                                   'date' => '2022-06-25T09:02:32',
                                                                   'version' => '2.201'
                                                                 }
                                                               ]
                                               },
                       'Compress-Raw-Zlib' => {
                                                'advisories' => [
                                                                  {
                                                                    'affected_versions' => '<2.075',
                                                                    'cves' => [
                                                                                'CVE-2016-9843',
                                                                                'CVE-2016-9841',
                                                                                'CVE-2016-9840',
                                                                                'CVE-2016-9842'
                                                                              ],
                                                                    'description' => 'Zlib vulnerabilities.
',
                                                                    'distribution' => 'Compress-Raw-Zlib',
                                                                    'fixed_versions' => '>=2.075',
                                                                    'id' => 'CPANSA-Compress-Raw-Zlib-2017-01',
                                                                    'references' => [
                                                                                      'https://metacpan.org/changes/distribution/Compress-Raw-Zlib'
                                                                                    ],
                                                                    'reported' => '2017-11-14'
                                                                  },
                                                                  {
                                                                    'affected_versions' => '>=2.075,<2.103',
                                                                    'cves' => [
                                                                                'CVE-2018-25032'
                                                                              ],
                                                                    'description' => 'zlib 1.2.11 allows memory corruption when deflating (i.e., when compressing) if the input has many distant matches.
',
                                                                    'distribution' => 'Compress-Raw-Zlib',
                                                                    'fixed_versions' => '>=2.103',
                                                                    'id' => 'CPANSA-Compress-Raw-Zlib-2018-25032',
                                                                    'references' => [
                                                                                      'https://metacpan.org/changes/distribution/Compress-Raw-Zlib',
                                                                                      'https://github.com/advisories/GHSA-jc36-42cf-vqwj',
                                                                                      'https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-25032'
                                                                                    ],
                                                                    'reported' => '2022-03-25'
                                                                  },
                                                                  {
                                                                    'affected_versions' => '<2.017',
                                                                    'cves' => [
                                                                                'CVE-2009-1391'
                                                                              ],
                                                                    'description' => 'Off-by-one error in the inflate function in Zlib.xs in Compress::Raw::Zlib Perl module before 2.017, as used in AMaViS, SpamAssassin, and possibly other products, allows context-dependent attackers to cause a denial of service (hang or crash) via a crafted zlib compressed stream that triggers a heap-based buffer overflow, as exploited in the wild by Trojan.Downloader-71014 in June 2009.
',
                                                                    'distribution' => 'Compress-Raw-Zlib',
                                                                    'fixed_versions' => undef,
                                                                    'id' => 'CPANSA-Compress-Raw-Zlib-2009-1391',
                                                                    'references' => [
                                                                                      'http://article.gmane.org/gmane.mail.virus.amavis.user/33635',
                                                                                      'http://article.gmane.org/gmane.mail.virus.amavis.user/33638',
                                                                                      'http://www.securityfocus.com/bid/35307',
                                                                                      'http://secunia.com/advisories/35422',
                                                                                      'https://bugzilla.redhat.com/show_bug.cgi?id=504386',
                                                                                      'http://www.vupen.com/english/advisories/2009/1571',
                                                                                      'http://thread.gmane.org/gmane.mail.virus.amavis.user/33635',
                                                                                      'http://osvdb.org/55041',
                                                                                      'http://lists.opensuse.org/opensuse-security-announce/2009-07/msg00002.html',
                                                                                      'http://secunia.com/advisories/35876',
                                                                                      'http://secunia.com/advisories/35685',
                                                                                      'https://www.redhat.com/archives/fedora-package-announce/2009-July/msg00607.html',
                                                                                      'http://secunia.com/advisories/35689',
                                                                                      'http://www.mandriva.com/security/advisories?name=MDVSA-2009:157',
                                                                                      'http://security.gentoo.org/glsa/glsa-200908-07.xml',
                                                                                      'https://bugs.gentoo.org/show_bug.cgi?id=273141',
                                                                                      'https://exchange.xforce.ibmcloud.com/vulnerabilities/51062',
                                                                                      'https://usn.ubuntu.com/794-1/'
                                                                                    ],
                                                                    'reported' => '2009-06-16',
                                                                    'severity' => undef
                                                                  }
                                                                ],
                                                'main_module' => 'Compress::Raw::Zlib',
                                                'versions' => [
                                                                {
                                                                  'date' => '2006-03-03T23:06:38',
                                                                  'version' => '2.000_09'
                                                                },
                                                                {
                                                                  'date' => '2006-03-13T16:14:20',
                                                                  'version' => '2.000_10'
                                                                },
                                                                {
                                                                  'date' => '2006-04-15T21:23:24',
                                                                  'version' => '2.000_11'
                                                                },
                                                                {
                                                                  'date' => '2006-05-17T12:43:41',
                                                                  'version' => '2.000_12'
                                                                },
                                                                {
                                                                  'date' => '2006-06-20T12:45:30',
                                                                  'version' => '2.000_13'
                                                                },
                                                                {
                                                                  'date' => '2006-10-26T14:15:34',
                                                                  'version' => '2.000_09'
                                                                },
                                                                {
                                                                  'date' => '2006-11-01T10:35:38',
                                                                  'version' => '2.001'
                                                                },
                                                                {
                                                                  'date' => '2006-12-29T20:40:35',
                                                                  'version' => '2.002'
                                                                },
                                                                {
                                                                  'date' => '2007-01-02T13:03:57',
                                                                  'version' => '2.003'
                                                                },
                                                                {
                                                                  'date' => '2007-03-03T15:50:15',
                                                                  'version' => '2.004'
                                                                },
                                                                {
                                                                  'date' => '2007-07-01T00:07:02',
                                                                  'version' => '2.005'
                                                                },
                                                                {
                                                                  'date' => '2007-09-01T19:44:59',
                                                                  'version' => '2.006'
                                                                },
                                                                {
                                                                  'date' => '2007-11-10T11:59:36',
                                                                  'version' => '2.008'
                                                                },
                                                                {
                                                                  'date' => '2008-04-20T14:42:52',
                                                                  'version' => '2.009'
                                                                },
                                                                {
                                                                  'date' => '2008-05-05T17:18:27',
                                                                  'version' => '2.010'
                                                                },
                                                                {
                                                                  'date' => '2008-05-17T11:16:28',
                                                                  'version' => '2.011'
                                                                },
                                                                {
                                                                  'date' => '2008-07-15T22:24:07',
                                                                  'version' => '2.012'
                                                                },
                                                                {
                                                                  'date' => '2008-09-02T20:20:16',
                                                                  'version' => '2.014'
                                                                },
                                                                {
                                                                  'date' => '2008-09-03T20:47:27',
                                                                  'version' => '2.015'
                                                                },
                                                                {
                                                                  'date' => '2009-04-04T09:49:03',
                                                                  'version' => '2.017'
                                                                },
                                                                {
                                                                  'date' => '2009-05-03T16:27:08',
                                                                  'version' => '2.018'
                                                                },
                                                                {
                                                                  'date' => '2009-05-04T09:42:17',
                                                                  'version' => '2.019'
                                                                },
                                                                {
                                                                  'date' => '2009-06-03T17:48:30',
                                                                  'version' => '2.020'
                                                                },
                                                                {
                                                                  'date' => '2009-08-30T20:25:35',
                                                                  'version' => '2.021'
                                                                },
                                                                {
                                                                  'date' => '2009-11-09T23:26:59',
                                                                  'version' => '2.023'
                                                                },
                                                                {
                                                                  'date' => '2010-01-09T17:56:35',
                                                                  'version' => '2.024'
                                                                },
                                                                {
                                                                  'date' => '2010-03-28T12:57:08',
                                                                  'version' => '2.025'
                                                                },
                                                                {
                                                                  'date' => '2010-04-07T19:51:09',
                                                                  'version' => '2.026'
                                                                },
                                                                {
                                                                  'date' => '2010-04-24T19:15:54',
                                                                  'version' => '2.027'
                                                                },
                                                                {
                                                                  'date' => '2010-07-24T14:31:01',
                                                                  'version' => '2.030'
                                                                },
                                                                {
                                                                  'date' => '2011-01-06T11:23:45',
                                                                  'version' => '2.032'
                                                                },
                                                                {
                                                                  'date' => '2011-01-11T14:03:45',
                                                                  'version' => '2.033'
                                                                },
                                                                {
                                                                  'date' => '2011-05-02T22:05:37',
                                                                  'version' => '2.034'
                                                                },
                                                                {
                                                                  'date' => '2011-05-07T08:31:57',
                                                                  'version' => '2.035'
                                                                },
                                                                {
                                                                  'date' => '2011-06-18T21:45:36',
                                                                  'version' => '2.036'
                                                                },
                                                                {
                                                                  'date' => '2011-06-22T07:18:22',
                                                                  'version' => '2.037'
                                                                },
                                                                {
                                                                  'date' => '2011-10-28T14:28:35',
                                                                  'version' => '2.039'
                                                                },
                                                                {
                                                                  'date' => '2011-10-28T22:20:38',
                                                                  'version' => '2.040'
                                                                },
                                                                {
                                                                  'date' => '2011-11-17T23:45:21',
                                                                  'version' => '2.042'
                                                                },
                                                                {
                                                                  'date' => '2011-11-20T21:33:33',
                                                                  'version' => '2.043'
                                                                },
                                                                {
                                                                  'date' => '2011-12-03T22:49:10',
                                                                  'version' => '2.044'
                                                                },
                                                                {
                                                                  'date' => '2011-12-04T19:21:36',
                                                                  'version' => '2.045'
                                                                },
                                                                {
                                                                  'date' => '2012-01-28T23:28:28',
                                                                  'version' => '2.047'
                                                                },
                                                                {
                                                                  'date' => '2012-01-29T17:00:33',
                                                                  'version' => '2.048'
                                                                },
                                                                {
                                                                  'date' => '2012-02-18T15:58:12',
                                                                  'version' => '2.049'
                                                                },
                                                                {
                                                                  'date' => '2012-02-21T19:35:18',
                                                                  'version' => '2.050'
                                                                },
                                                                {
                                                                  'date' => '2012-02-22T20:43:23',
                                                                  'version' => '2.051'
                                                                },
                                                                {
                                                                  'date' => '2012-04-29T12:41:57',
                                                                  'version' => '2.052'
                                                                },
                                                                {
                                                                  'date' => '2012-05-06T08:40:06',
                                                                  'version' => '2.053'
                                                                },
                                                                {
                                                                  'date' => '2012-05-08T19:22:47',
                                                                  'version' => '2.054'
                                                                },
                                                                {
                                                                  'date' => '2012-08-05T20:36:06',
                                                                  'version' => '2.055'
                                                                },
                                                                {
                                                                  'date' => '2012-08-10T22:20:09',
                                                                  'version' => '2.056'
                                                                },
                                                                {
                                                                  'date' => '2012-11-10T19:08:56',
                                                                  'version' => '2.057'
                                                                },
                                                                {
                                                                  'date' => '2012-11-12T22:14:42',
                                                                  'version' => '2.058'
                                                                },
                                                                {
                                                                  'date' => '2012-11-25T13:38:42',
                                                                  'version' => '2.059'
                                                                },
                                                                {
                                                                  'date' => '2013-01-07T20:02:22',
                                                                  'version' => '2.060'
                                                                },
                                                                {
                                                                  'date' => '2013-05-27T09:54:54',
                                                                  'version' => '2.061'
                                                                },
                                                                {
                                                                  'date' => '2013-08-12T19:08:05',
                                                                  'version' => '2.062'
                                                                },
                                                                {
                                                                  'date' => '2013-11-02T17:15:17',
                                                                  'version' => '2.063'
                                                                },
                                                                {
                                                                  'date' => '2014-02-01T23:21:28',
                                                                  'version' => '2.064'
                                                                },
                                                                {
                                                                  'date' => '2014-02-03T20:23:00',
                                                                  'version' => '2.065'
                                                                },
                                                                {
                                                                  'date' => '2014-09-21T12:42:35',
                                                                  'version' => '2.066'
                                                                },
                                                                {
                                                                  'date' => '2014-12-08T15:14:00',
                                                                  'version' => '2.067'
                                                                },
                                                                {
                                                                  'date' => '2014-12-23T17:44:57',
                                                                  'version' => '2.068'
                                                                },
                                                                {
                                                                  'date' => '2015-09-26T18:41:58',
                                                                  'version' => '2.069'
                                                                },
                                                                {
                                                                  'date' => '2016-12-28T23:09:21',
                                                                  'version' => '2.070'
                                                                },
                                                                {
                                                                  'date' => '2016-12-30T22:58:08',
                                                                  'version' => '2.071'
                                                                },
                                                                {
                                                                  'date' => '2017-02-12T20:41:25',
                                                                  'version' => '2.072'
                                                                },
                                                                {
                                                                  'date' => '2017-02-19T20:37:20',
                                                                  'version' => '2.073'
                                                                },
                                                                {
                                                                  'date' => '2017-02-19T22:11:41',
                                                                  'version' => '2.074'
                                                                },
                                                                {
                                                                  'date' => '2017-11-14T15:43:26',
                                                                  'version' => '2.075'
                                                                },
                                                                {
                                                                  'date' => '2017-11-21T22:29:23',
                                                                  'version' => '2.076'
                                                                },
                                                                {
                                                                  'date' => '2018-04-03T18:22:06',
                                                                  'version' => '2.080'
                                                                },
                                                                {
                                                                  'date' => '2018-04-08T15:02:55',
                                                                  'version' => '2.081'
                                                                },
                                                                {
                                                                  'date' => '2018-12-30T22:40:08',
                                                                  'version' => '2.083'
                                                                },
                                                                {
                                                                  'date' => '2019-01-06T08:57:15',
                                                                  'version' => '2.084'
                                                                },
                                                                {
                                                                  'date' => '2019-03-31T19:11:54',
                                                                  'version' => '2.086'
                                                                },
                                                                {
                                                                  'date' => '2019-08-10T18:12:03',
                                                                  'version' => '2.087'
                                                                },
                                                                {
                                                                  'date' => '2019-11-03T08:55:23',
                                                                  'version' => '2.088'
                                                                },
                                                                {
                                                                  'date' => '2019-11-03T19:54:04',
                                                                  'version' => '2.089'
                                                                },
                                                                {
                                                                  'date' => '2019-11-09T15:58:48',
                                                                  'version' => '2.090'
                                                                },
                                                                {
                                                                  'date' => '2019-11-23T19:34:34',
                                                                  'version' => '2.091'
                                                                },
                                                                {
                                                                  'date' => '2019-12-04T22:08:37',
                                                                  'version' => '2.092'
                                                                },
                                                                {
                                                                  'date' => '2019-12-07T16:05:34',
                                                                  'version' => '2.093'
                                                                },
                                                                {
                                                                  'date' => '2020-07-13T10:54:06',
                                                                  'version' => '2.094'
                                                                },
                                                                {
                                                                  'date' => '2020-07-21T06:57:01',
                                                                  'version' => '2.095'
                                                                },
                                                                {
                                                                  'date' => '2020-07-31T20:48:45',
                                                                  'version' => '2.096'
                                                                },
                                                                {
                                                                  'date' => '2021-01-07T13:00:23',
                                                                  'version' => '2.100'
                                                                },
                                                                {
                                                                  'date' => '2021-02-20T14:10:43',
                                                                  'version' => '2.101'
                                                                },
                                                                {
                                                                  'date' => '2022-04-03T19:48:50',
                                                                  'version' => '2.103'
                                                                },
                                                                {
                                                                  'date' => '2022-05-13T06:30:30',
                                                                  'version' => '2.104'
                                                                },
                                                                {
                                                                  'date' => '2022-05-14T14:24:32',
                                                                  'version' => '2.105'
                                                                },
                                                                {
                                                                  'date' => '2022-06-21T21:19:21',
                                                                  'version' => '2.200'
                                                                },
                                                                {
                                                                  'date' => '2022-06-25T09:04:10',
                                                                  'version' => '2.201'
                                                                },
                                                                {
                                                                  'date' => '2022-06-27T08:18:10',
                                                                  'version' => '2.202'
                                                                }
                                                              ]
                                              },
                       'Config-IniFiles' => {
                                              'advisories' => [
                                                                {
                                                                  'affected_versions' => '<2.71',
                                                                  'cves' => [
                                                                              'CVE-2012-2451'
                                                                            ],
                                                                  'description' => 'The Config::IniFiles module before 2.71 for Perl creates temporary files with predictable names, which allows local users to overwrite arbitrary files via a symlink attack.  NOTE: some of these details are obtained from third party information.  NOTE: it has been reported that this might only be exploitable by writing in the same directory as the .ini file. If this is the case, then this issue might not cross privilege boundaries.
',
                                                                  'distribution' => 'Config-IniFiles',
                                                                  'fixed_versions' => undef,
                                                                  'id' => 'CPANSA-Config-IniFiles-2012-2451',
                                                                  'references' => [
                                                                                    'http://www.openwall.com/lists/oss-security/2012/05/02/6',
                                                                                    'http://www.osvdb.org/81671',
                                                                                    'http://secunia.com/advisories/48990',
                                                                                    'https://bitbucket.org/shlomif/perl-config-inifiles/changeset/a08fa26f4f59',
                                                                                    'https://bugzilla.redhat.com/show_bug.cgi?id=818386',
                                                                                    'http://lists.fedoraproject.org/pipermail/package-announce/2012-May/080713.html',
                                                                                    'http://lists.fedoraproject.org/pipermail/package-announce/2012-May/080716.html',
                                                                                    'http://lists.fedoraproject.org/pipermail/package-announce/2012-May/081207.html',
                                                                                    'http://www.securityfocus.com/bid/53361',
                                                                                    'http://www.ubuntu.com/usn/USN-1543-1',
                                                                                    'https://exchange.xforce.ibmcloud.com/vulnerabilities/75328'
                                                                                  ],
                                                                  'reported' => '2012-06-27',
                                                                  'severity' => undef
                                                                }
                                                              ],
                                              'main_module' => 'Config::IniFiles',
                                              'versions' => [
                                                              {
                                                                'date' => '2000-06-20T02:07:11',
                                                                'version' => '0.05'
                                                              },
                                                              {
                                                                'date' => '2000-06-26T02:38:13',
                                                                'version' => '0.06'
                                                              },
                                                              {
                                                                'date' => '2000-07-31T01:32:53',
                                                                'version' => '0.08'
                                                              },
                                                              {
                                                                'date' => '2000-07-31T01:51:15',
                                                                'version' => '0.09'
                                                              },
                                                              {
                                                                'date' => '2000-09-17T03:29:50',
                                                                'version' => '0.11'
                                                              },
                                                              {
                                                                'date' => '2000-09-20T01:06:10',
                                                                'version' => '1.6'
                                                              },
                                                              {
                                                                'date' => '2000-10-17T02:01:37',
                                                                'version' => '1.8'
                                                              },
                                                              {
                                                                'date' => '2000-11-25T03:36:14',
                                                                'version' => '1.11'
                                                              },
                                                              {
                                                                'date' => '2000-11-28T14:09:00',
                                                                'version' => '1.12'
                                                              },
                                                              {
                                                                'date' => '2000-11-28T14:09:15',
                                                                'version' => '1.13'
                                                              },
                                                              {
                                                                'date' => '2000-12-13T17:45:25',
                                                                'version' => '2.10'
                                                              },
                                                              {
                                                                'date' => '2000-12-18T17:56:28',
                                                                'version' => '2.13'
                                                              },
                                                              {
                                                                'date' => '2001-01-08T18:27:24',
                                                                'version' => '2.14'
                                                              },
                                                              {
                                                                'date' => '2001-03-24T21:54:18',
                                                                'version' => '2.17'
                                                              },
                                                              {
                                                                'date' => '2001-03-30T04:48:27',
                                                                'version' => '2.18'
                                                              },
                                                              {
                                                                'date' => '2001-04-05T01:06:51',
                                                                'version' => '2.19'
                                                              },
                                                              {
                                                                'date' => '2001-08-28T11:05:35',
                                                                'version' => '2.21'
                                                              },
                                                              {
                                                                'date' => '2001-12-06T17:15:03',
                                                                'version' => '2.22'
                                                              },
                                                              {
                                                                'date' => '2001-12-07T16:24:14',
                                                                'version' => '2.23'
                                                              },
                                                              {
                                                                'date' => '2001-12-07T17:27:08',
                                                                'version' => '2.24'
                                                              },
                                                              {
                                                                'date' => '2001-12-12T20:50:06',
                                                                'version' => '2.25'
                                                              },
                                                              {
                                                                'date' => '2001-12-19T22:26:32',
                                                                'version' => '2.26'
                                                              },
                                                              {
                                                                'date' => '2001-12-20T16:11:24',
                                                                'version' => '2.27'
                                                              },
                                                              {
                                                                'date' => '2002-08-15T21:41:35',
                                                                'version' => '2.29'
                                                              },
                                                              {
                                                                'date' => '2002-10-15T18:59:21',
                                                                'version' => '2.30'
                                                              },
                                                              {
                                                                'date' => '2002-12-18T01:58:55',
                                                                'version' => '2.36'
                                                              },
                                                              {
                                                                'date' => '2003-01-31T23:06:08',
                                                                'version' => '2.37'
                                                              },
                                                              {
                                                                'date' => '2003-05-14T01:38:13',
                                                                'version' => '2.38'
                                                              },
                                                              {
                                                                'date' => '2005-04-29T20:33:23',
                                                                'version' => '2.39'
                                                              },
                                                              {
                                                                'date' => '2008-12-04T17:02:19',
                                                                'version' => '2.43'
                                                              },
                                                              {
                                                                'date' => '2008-12-25T09:47:08',
                                                                'version' => '2.44'
                                                              },
                                                              {
                                                                'date' => '2008-12-27T15:25:59',
                                                                'version' => '2.45'
                                                              },
                                                              {
                                                                'date' => '2009-01-17T14:40:26',
                                                                'version' => '2.46'
                                                              },
                                                              {
                                                                'date' => '2009-01-21T09:41:11',
                                                                'version' => '2.47'
                                                              },
                                                              {
                                                                'date' => '2009-04-07T12:26:44',
                                                                'version' => '2.48'
                                                              },
                                                              {
                                                                'date' => '2009-05-02T14:27:53',
                                                                'version' => '2.49'
                                                              },
                                                              {
                                                                'date' => '2009-05-31T11:58:04',
                                                                'version' => '2.50'
                                                              },
                                                              {
                                                                'date' => '2009-06-08T09:41:11',
                                                                'version' => '2.51'
                                                              },
                                                              {
                                                                'date' => '2009-06-28T13:21:57',
                                                                'version' => '2.52'
                                                              },
                                                              {
                                                                'date' => '2009-11-13T09:58:28',
                                                                'version' => '2.53'
                                                              },
                                                              {
                                                                'date' => '2009-11-18T11:15:13',
                                                                'version' => '2.54'
                                                              },
                                                              {
                                                                'date' => '2009-12-22T15:48:07',
                                                                'version' => '2.55'
                                                              },
                                                              {
                                                                'date' => '2009-12-31T04:57:40',
                                                                'version' => '2.56'
                                                              },
                                                              {
                                                                'date' => '2010-03-01T13:51:57',
                                                                'version' => '2.57'
                                                              },
                                                              {
                                                                'date' => '2010-05-17T07:45:33',
                                                                'version' => '2.58'
                                                              },
                                                              {
                                                                'date' => '2010-11-12T11:33:52',
                                                                'version' => '2.59'
                                                              },
                                                              {
                                                                'date' => '2010-11-13T07:22:50',
                                                                'version' => '2.60'
                                                              },
                                                              {
                                                                'date' => '2010-11-14T08:57:26',
                                                                'version' => '2.61'
                                                              },
                                                              {
                                                                'date' => '2010-11-19T13:37:37',
                                                                'version' => '2.62'
                                                              },
                                                              {
                                                                'date' => '2010-11-19T14:54:12',
                                                                'version' => '2.63'
                                                              },
                                                              {
                                                                'date' => '2010-11-20T09:55:05',
                                                                'version' => '2.64'
                                                              },
                                                              {
                                                                'date' => '2010-11-25T18:48:52',
                                                                'version' => '2.65'
                                                              },
                                                              {
                                                                'date' => '2011-01-29T16:40:18',
                                                                'version' => '2.66'
                                                              },
                                                              {
                                                                'date' => '2011-06-21T11:59:37',
                                                                'version' => '2.67'
                                                              },
                                                              {
                                                                'date' => '2011-06-21T19:18:33',
                                                                'version' => '2.68'
                                                              },
                                                              {
                                                                'date' => '2012-04-05T09:10:11',
                                                                'version' => '2.69'
                                                              },
                                                              {
                                                                'date' => '2012-04-06T09:52:14',
                                                                'version' => '2.70'
                                                              },
                                                              {
                                                                'date' => '2012-05-02T08:05:15',
                                                                'version' => '2.71'
                                                              },
                                                              {
                                                                'date' => '2012-05-05T16:56:55',
                                                                'version' => '2.72'
                                                              },
                                                              {
                                                                'date' => '2012-05-14T07:49:33',
                                                                'version' => '2.73'
                                                              },
                                                              {
                                                                'date' => '2012-05-23T21:47:46',
                                                                'version' => '2.74'
                                                              },
                                                              {
                                                                'date' => '2012-05-25T12:29:48',
                                                                'version' => '2.75'
                                                              },
                                                              {
                                                                'date' => '2012-06-15T14:47:10',
                                                                'version' => '2.76'
                                                              },
                                                              {
                                                                'date' => '2012-06-21T16:39:23',
                                                                'version' => '2.77'
                                                              },
                                                              {
                                                                'date' => '2012-10-21T11:18:39',
                                                                'version' => '2.78'
                                                              },
                                                              {
                                                                'date' => '2013-05-06T07:10:33',
                                                                'version' => '2.79'
                                                              },
                                                              {
                                                                'date' => '2013-05-14T19:25:07',
                                                                'version' => '2.80'
                                                              },
                                                              {
                                                                'date' => '2013-05-16T10:36:17',
                                                                'version' => '2.81'
                                                              },
                                                              {
                                                                'date' => '2013-05-21T15:35:10',
                                                                'version' => '2.82'
                                                              },
                                                              {
                                                                'date' => '2014-01-27T09:01:28',
                                                                'version' => '2.83'
                                                              },
                                                              {
                                                                'date' => '2015-04-13T18:40:30',
                                                                'version' => '2.84'
                                                              },
                                                              {
                                                                'date' => '2015-04-13T19:08:57',
                                                                'version' => '2.85'
                                                              },
                                                              {
                                                                'date' => '2015-04-14T07:55:59',
                                                                'version' => '2.86'
                                                              },
                                                              {
                                                                'date' => '2015-06-16T09:06:37',
                                                                'version' => '2.87'
                                                              },
                                                              {
                                                                'date' => '2015-07-10T08:38:11',
                                                                'version' => '2.88'
                                                              },
                                                              {
                                                                'date' => '2016-05-03T09:14:13',
                                                                'version' => '2.89'
                                                              },
                                                              {
                                                                'date' => '2016-06-02T13:09:19',
                                                                'version' => '2.90'
                                                              },
                                                              {
                                                                'date' => '2016-06-03T03:11:38',
                                                                'version' => '2.91'
                                                              },
                                                              {
                                                                'date' => '2016-06-17T09:34:08',
                                                                'version' => '2.92'
                                                              },
                                                              {
                                                                'date' => '2016-07-24T08:34:00',
                                                                'version' => '2.93'
                                                              },
                                                              {
                                                                'date' => '2016-11-29T17:31:38',
                                                                'version' => '2.94'
                                                              },
                                                              {
                                                                'date' => '2018-03-16T11:14:39',
                                                                'version' => '2.95'
                                                              },
                                                              {
                                                                'date' => '2018-04-07T08:45:56',
                                                                'version' => '2.96'
                                                              },
                                                              {
                                                                'date' => '2018-04-21T09:13:56',
                                                                'version' => '2.97'
                                                              },
                                                              {
                                                                'date' => '2018-04-21T11:50:34',
                                                                'version' => '2.98'
                                                              },
                                                              {
                                                                'date' => '2018-09-13T07:11:41',
                                                                'version' => '3.000000'
                                                              },
                                                              {
                                                                'date' => '2019-01-16T09:54:40',
                                                                'version' => '3.000001'
                                                              },
                                                              {
                                                                'date' => '2019-03-14T13:34:40',
                                                                'version' => '3.000002'
                                                              },
                                                              {
                                                                'date' => '2020-03-24T15:45:08',
                                                                'version' => '3.000003'
                                                              }
                                                            ]
                                            },
                       'Config-Model' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'cves' => [
                                                                           'CVE-2017-0373'
                                                                         ],
                                                               'description' => 'The gen_class_pod implementation in lib/Config/Model/Utils/GenClassPod.pm in Config-Model (aka libconfig-model-perl) before 2.102 has a dangerous "use lib" line, which allows remote attackers to have an unspecified impact via a crafted Debian package file.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-03',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/9bd64d9ec6c0939166a2216a37d58dd19a725951'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             },
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'cves' => [
                                                                           'CVE-2017-0374'
                                                                         ],
                                                               'description' => 'Loads models from a local directory, making it possible to substitute the model.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-02',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/4d37c75b0c4f9633b67999f8260b08027a6bc524'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             },
                                                             {
                                                               'affected_versions' => '<2.102',
                                                               'description' => 'YAML or YAML::XS can be loaded automatically making it possible to run arbitrary code loading a specially crafted YAML file.
',
                                                               'distribution' => 'Config-Model',
                                                               'fixed_versions' => '>=2.102',
                                                               'id' => 'CPANSA-Config-Model-2017-01',
                                                               'references' => [
                                                                                 'https://metacpan.org/changes/distribution/Config-Model',
                                                                                 'https://github.com/dod38fr/config-model/commit/01d212348bfbadf31bd74aadd26b1e391ff2fd92'
                                                                               ],
                                                               'reported' => '2017-05-10'
                                                             }
                                                           ],
                                           'main_module' => 'Config::Model',
                                           'versions' => [
                                                           {
                                                             'date' => '2006-04-21T12:27:44',
                                                             'version' => '0.505'
                                                           },
                                                           {
                                                             'date' => '2006-05-19T13:32:14',
                                                             'version' => '0.506'
                                                           },
                                                           {
                                                             'date' => '2006-06-15T12:10:38',
                                                             'version' => '0.507'
                                                           },
                                                           {
                                                             'date' => '2006-07-20T12:28:36',
                                                             'version' => '0.601'
                                                           },
                                                           {
                                                             'date' => '2006-09-07T12:06:17',
                                                             'version' => '0.602'
                                                           },
                                                           {
                                                             'date' => '2006-10-19T11:24:40',
                                                             'version' => '0.603'
                                                           },
                                                           {
                                                             'date' => '2006-12-06T12:58:35',
                                                             'version' => '0.604'
                                                           },
                                                           {
                                                             'date' => '2007-01-08T13:16:42',
                                                             'version' => '0.605'
                                                           },
                                                           {
                                                             'date' => '2007-01-11T12:42:09',
                                                             'version' => '0.606'
                                                           },
                                                           {
                                                             'date' => '2007-01-12T13:06:38',
                                                             'version' => '0.607'
                                                           },
                                                           {
                                                             'date' => '2007-02-23T13:00:34',
                                                             'version' => '0.608'
                                                           },
                                                           {
                                                             'date' => '2007-05-14T11:41:18',
                                                             'version' => '0.609'
                                                           },
                                                           {
                                                             'date' => '2007-06-06T12:28:06',
                                                             'version' => '0.610'
                                                           },
                                                           {
                                                             'date' => '2007-07-03T15:35:21',
                                                             'version' => '0.611'
                                                           },
                                                           {
                                                             'date' => '2007-07-27T11:38:57',
                                                             'version' => '0.612'
                                                           },
                                                           {
                                                             'date' => '2007-10-01T15:52:56',
                                                             'version' => '0.613'
                                                           },
                                                           {
                                                             'date' => '2007-10-23T16:10:29',
                                                             'version' => '0.614'
                                                           },
                                                           {
                                                             'date' => '2007-11-15T12:36:18',
                                                             'version' => '0.615'
                                                           },
                                                           {
                                                             'date' => '2007-12-04T12:41:22',
                                                             'version' => '0.616'
                                                           },
                                                           {
                                                             'date' => '2008-01-28T11:55:50',
                                                             'version' => '0.617'
                                                           },
                                                           {
                                                             'date' => '2008-02-14T12:56:25',
                                                             'version' => '0.618'
                                                           },
                                                           {
                                                             'date' => '2008-02-29T12:08:41',
                                                             'version' => '0.619'
                                                           },
                                                           {
                                                             'date' => '2008-03-18T17:40:57',
                                                             'version' => '0.620'
                                                           },
                                                           {
                                                             'date' => '2008-03-20T07:49:00',
                                                             'version' => '0.6201'
                                                           },
                                                           {
                                                             'date' => '2008-04-04T11:38:49',
                                                             'version' => '0.621'
                                                           },
                                                           {
                                                             'date' => '2008-04-25T16:23:31',
                                                             'version' => '0.622'
                                                           },
                                                           {
                                                             'date' => '2008-05-19T11:47:46',
                                                             'version' => '0.623'
                                                           },
                                                           {
                                                             'date' => '2008-07-25T11:35:07',
                                                             'version' => '0.624'
                                                           },
                                                           {
                                                             'date' => '2008-07-30T12:02:43',
                                                             'version' => '0.625'
                                                           },
                                                           {
                                                             'date' => '2008-09-22T12:20:00',
                                                             'version' => '0.626'
                                                           },
                                                           {
                                                             'date' => '2008-09-23T11:05:58',
                                                             'version' => '0.627'
                                                           },
                                                           {
                                                             'date' => '2008-09-29T12:35:05',
                                                             'version' => '0.628'
                                                           },
                                                           {
                                                             'date' => '2008-10-13T15:09:27',
                                                             'version' => '0.629'
                                                           },
                                                           {
                                                             'date' => '2008-10-21T11:59:27',
                                                             'version' => '0.630'
                                                           },
                                                           {
                                                             'date' => '2008-11-10T14:37:44',
                                                             'version' => '0.631'
                                                           },
                                                           {
                                                             'date' => '2008-12-16T13:32:26',
                                                             'version' => '0.632'
                                                           },
                                                           {
                                                             'date' => '2008-12-23T15:36:48',
                                                             'version' => '0.633'
                                                           },
                                                           {
                                                             'date' => '2009-03-05T13:06:32',
                                                             'version' => '0.634'
                                                           },
                                                           {
                                                             'date' => '2009-04-20T12:21:46',
                                                             'version' => '0.635'
                                                           },
                                                           {
                                                             'date' => '2009-05-30T16:19:54',
                                                             'version' => '0.636'
                                                           },
                                                           {
                                                             'date' => '2009-06-23T12:07:41',
                                                             'version' => '0.637'
                                                           },
                                                           {
                                                             'date' => '2009-06-30T11:31:35',
                                                             'version' => '0.638'
                                                           },
                                                           {
                                                             'date' => '2009-09-08T11:35:25',
                                                             'version' => '0.639'
                                                           },
                                                           {
                                                             'date' => '2009-09-09T16:10:41',
                                                             'version' => '0.640'
                                                           },
                                                           {
                                                             'date' => '2010-01-20T17:30:14',
                                                             'version' => '0.641'
                                                           },
                                                           {
                                                             'date' => '2010-01-21T17:17:34',
                                                             'version' => '0.642'
                                                           },
                                                           {
                                                             'date' => '2010-02-25T13:04:52',
                                                             'version' => '0.643'
                                                           },
                                                           {
                                                             'date' => '2010-03-12T15:24:45',
                                                             'version' => '0.644'
                                                           },
                                                           {
                                                             'date' => '2010-03-28T14:53:46',
                                                             'version' => '1.001'
                                                           },
                                                           {
                                                             'date' => '2010-04-22T12:22:00',
                                                             'version' => '1.202'
                                                           },
                                                           {
                                                             'date' => '2010-06-03T11:09:45',
                                                             'version' => '1.203'
                                                           },
                                                           {
                                                             'date' => '2010-06-03T11:20:09',
                                                             'version' => '1.204'
                                                           },
                                                           {
                                                             'date' => '2010-06-07T16:04:03',
                                                             'version' => '1.205'
                                                           },
                                                           {
                                                             'date' => '2010-08-13T10:53:09',
                                                             'version' => '1.206'
                                                           },
                                                           {
                                                             'date' => '2010-09-14T16:14:40',
                                                             'version' => '1.207'
                                                           },
                                                           {
                                                             'date' => '2010-09-16T11:46:11',
                                                             'version' => '1.208'
                                                           },
                                                           {
                                                             'date' => '2010-09-20T12:29:12',
                                                             'version' => '1.209'
                                                           },
                                                           {
                                                             'date' => '2010-09-30T16:34:27',
                                                             'version' => '1.210'
                                                           },
                                                           {
                                                             'date' => '2010-10-08T10:46:45',
                                                             'version' => '1.211'
                                                           },
                                                           {
                                                             'date' => '2010-10-15T11:08:52',
                                                             'version' => '1.212'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T12:29:03',
                                                             'version' => '1.213'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T15:17:01',
                                                             'version' => '1.214'
                                                           },
                                                           {
                                                             'date' => '2010-10-19T15:28:56',
                                                             'version' => '1.215'
                                                           },
                                                           {
                                                             'date' => '2010-10-26T12:16:51',
                                                             'version' => '1.216'
                                                           },
                                                           {
                                                             'date' => '2010-10-30T12:44:11',
                                                             'version' => '1.217'
                                                           },
                                                           {
                                                             'date' => '2010-11-05T11:53:14',
                                                             'version' => '1.218'
                                                           },
                                                           {
                                                             'date' => '2010-11-09T13:20:51',
                                                             'version' => '1.219'
                                                           },
                                                           {
                                                             'date' => '2010-11-10T08:41:22',
                                                             'version' => '1.220'
                                                           },
                                                           {
                                                             'date' => '2010-11-21T17:40:10',
                                                             'version' => '1.221'
                                                           },
                                                           {
                                                             'date' => '2010-11-22T14:01:55',
                                                             'version' => '1.222'
                                                           },
                                                           {
                                                             'date' => '2010-11-28T17:34:03',
                                                             'version' => '1.223'
                                                           },
                                                           {
                                                             'date' => '2010-12-06T13:18:53',
                                                             'version' => '1.224'
                                                           },
                                                           {
                                                             'date' => '2010-12-07T08:01:43',
                                                             'version' => '1.225'
                                                           },
                                                           {
                                                             'date' => '2010-12-08T18:48:08',
                                                             'version' => '1.226'
                                                           },
                                                           {
                                                             'date' => '2011-01-07T18:12:45',
                                                             'version' => '1.227'
                                                           },
                                                           {
                                                             'date' => '2011-01-09T12:27:15',
                                                             'version' => '1.228'
                                                           },
                                                           {
                                                             'date' => '2011-01-10T19:57:53',
                                                             'version' => '1.229'
                                                           },
                                                           {
                                                             'date' => '2011-01-20T16:47:27',
                                                             'version' => '1.230'
                                                           },
                                                           {
                                                             'date' => '2011-01-30T11:30:23',
                                                             'version' => '1.231'
                                                           },
                                                           {
                                                             'date' => '2011-01-30T13:51:34',
                                                             'version' => '1.232'
                                                           },
                                                           {
                                                             'date' => '2011-02-11T12:25:32',
                                                             'version' => '1.233'
                                                           },
                                                           {
                                                             'date' => '2011-02-21T17:11:22',
                                                             'version' => '1.234'
                                                           },
                                                           {
                                                             'date' => '2011-03-01T13:06:28',
                                                             'version' => '1.235'
                                                           },
                                                           {
                                                             'date' => '2011-04-01T14:09:03',
                                                             'version' => '1.236'
                                                           },
                                                           {
                                                             'date' => '2011-04-04T12:57:04',
                                                             'version' => '1.237'
                                                           },
                                                           {
                                                             'date' => '2011-04-05T14:45:45',
                                                             'version' => '1.238'
                                                           },
                                                           {
                                                             'date' => '2011-04-05T17:40:17',
                                                             'version' => '1.240'
                                                           },
                                                           {
                                                             'date' => '2011-04-07T18:09:49',
                                                             'version' => '1.241'
                                                           },
                                                           {
                                                             'date' => '2011-04-25T15:28:14',
                                                             'version' => '1.242'
                                                           },
                                                           {
                                                             'date' => '2011-05-02T12:33:33',
                                                             'version' => '1.243'
                                                           },
                                                           {
                                                             'date' => '2011-05-16T15:52:46',
                                                             'version' => '1.244'
                                                           },
                                                           {
                                                             'date' => '2011-06-17T12:10:22',
                                                             'version' => '1.245'
                                                           },
                                                           {
                                                             'date' => '2011-06-20T12:32:24',
                                                             'version' => '1.246'
                                                           },
                                                           {
                                                             'date' => '2011-06-27T14:14:52',
                                                             'version' => '1.247'
                                                           },
                                                           {
                                                             'date' => '2011-07-05T15:48:52',
                                                             'version' => '1.248'
                                                           },
                                                           {
                                                             'date' => '2011-07-12T09:54:39',
                                                             'version' => '1.249'
                                                           },
                                                           {
                                                             'date' => '2011-07-22T12:40:47',
                                                             'version' => '1.250'
                                                           },
                                                           {
                                                             'date' => '2011-08-30T12:16:32',
                                                             'version' => '1.251'
                                                           },
                                                           {
                                                             'date' => '2011-09-01T16:06:19',
                                                             'version' => '1.252'
                                                           },
                                                           {
                                                             'date' => '2011-09-02T16:03:35',
                                                             'version' => '1.253'
                                                           },
                                                           {
                                                             'date' => '2011-09-04T15:21:52',
                                                             'version' => '1.254'
                                                           },
                                                           {
                                                             'date' => '2011-09-15T15:23:39',
                                                             'version' => '1.255'
                                                           },
                                                           {
                                                             'date' => '2011-09-16T12:28:51',
                                                             'version' => '1.256'
                                                           },
                                                           {
                                                             'date' => '2011-09-23T10:52:00',
                                                             'version' => '1.257'
                                                           },
                                                           {
                                                             'date' => '2011-10-14T14:45:06',
                                                             'version' => '1.258'
                                                           },
                                                           {
                                                             'date' => '2011-10-16T10:17:53',
                                                             'version' => '1.259'
                                                           },
                                                           {
                                                             'date' => '2011-10-28T13:28:02',
                                                             'version' => '1.260'
                                                           },
                                                           {
                                                             'date' => '2011-11-18T17:02:26',
                                                             'version' => '1.261'
                                                           },
                                                           {
                                                             'date' => '2011-11-19T11:55:30',
                                                             'version' => '1.262'
                                                           },
                                                           {
                                                             'date' => '2011-11-29T15:43:38',
                                                             'version' => '1.263'
                                                           },
                                                           {
                                                             'date' => '2011-11-30T07:50:25',
                                                             'version' => '1.264'
                                                           },
                                                           {
                                                             'date' => '2011-12-06T18:26:54',
                                                             'version' => '1.265'
                                                           },
                                                           {
                                                             'date' => '2012-02-06T11:55:29',
                                                             'version' => '2.001'
                                                           },
                                                           {
                                                             'date' => '2012-02-08T09:49:49',
                                                             'version' => '2.002'
                                                           },
                                                           {
                                                             'date' => '2012-02-08T13:14:22',
                                                             'version' => '2.003'
                                                           },
                                                           {
                                                             'date' => '2012-02-09T11:28:18',
                                                             'version' => '2.004'
                                                           },
                                                           {
                                                             'date' => '2012-02-23T18:25:32',
                                                             'version' => '2.005'
                                                           },
                                                           {
                                                             'date' => '2012-02-25T11:30:41',
                                                             'version' => '2.006'
                                                           },
                                                           {
                                                             'date' => '2012-02-26T16:34:50',
                                                             'version' => '2.007'
                                                           },
                                                           {
                                                             'date' => '2012-03-01T12:40:23',
                                                             'version' => '2.008'
                                                           },
                                                           {
                                                             'date' => '2012-03-13T13:11:49',
                                                             'version' => '2.009'
                                                           },
                                                           {
                                                             'date' => '2012-03-13T13:15:03',
                                                             'version' => '2.010'
                                                           },
                                                           {
                                                             'date' => '2012-03-19T21:41:44',
                                                             'version' => '2.011'
                                                           },
                                                           {
                                                             'date' => '2012-04-05T11:41:54',
                                                             'version' => '2.012'
                                                           },
                                                           {
                                                             'date' => '2012-04-06T12:10:46',
                                                             'version' => '2.013'
                                                           },
                                                           {
                                                             'date' => '2012-05-04T13:57:13',
                                                             'version' => '2.014'
                                                           },
                                                           {
                                                             'date' => '2012-05-14T10:06:13',
                                                             'version' => '2.015'
                                                           },
                                                           {
                                                             'date' => '2012-05-20T08:38:36',
                                                             'version' => '2.016'
                                                           },
                                                           {
                                                             'date' => '2012-05-21T10:56:35',
                                                             'version' => '2.017'
                                                           },
                                                           {
                                                             'date' => '2012-05-29T13:53:06',
                                                             'version' => '2.018'
                                                           },
                                                           {
                                                             'date' => '2012-06-05T12:34:15',
                                                             'version' => '2.019'
                                                           },
                                                           {
                                                             'date' => '2012-06-18T08:34:26',
                                                             'version' => '2.020'
                                                           },
                                                           {
                                                             'date' => '2012-06-27T14:44:55',
                                                             'version' => '2.021_01'
                                                           },
                                                           {
                                                             'date' => '2012-06-28T15:30:52',
                                                             'version' => '2.021'
                                                           },
                                                           {
                                                             'date' => '2012-07-03T14:47:31',
                                                             'version' => '2.022'
                                                           },
                                                           {
                                                             'date' => '2012-07-04T13:50:37',
                                                             'version' => '2.023'
                                                           },
                                                           {
                                                             'date' => '2012-09-04T11:30:02',
                                                             'version' => '2.024'
                                                           },
                                                           {
                                                             'date' => '2012-09-10T10:52:02',
                                                             'version' => '2.025'
                                                           },
                                                           {
                                                             'date' => '2012-09-20T17:12:09',
                                                             'version' => '2.026_1'
                                                           },
                                                           {
                                                             'date' => '2012-09-21T10:38:47',
                                                             'version' => '2.026_2'
                                                           },
                                                           {
                                                             'date' => '2012-09-27T11:53:42',
                                                             'version' => '2.026'
                                                           },
                                                           {
                                                             'date' => '2012-10-30T12:48:16',
                                                             'version' => '2.027'
                                                           },
                                                           {
                                                             'date' => '2012-11-27T12:44:55',
                                                             'version' => '2.028'
                                                           },
                                                           {
                                                             'date' => '2012-11-28T13:31:04',
                                                             'version' => '2.029'
                                                           },
                                                           {
                                                             'date' => '2013-02-27T18:37:05',
                                                             'version' => '2.030_01'
                                                           },
                                                           {
                                                             'date' => '2013-03-23T09:47:53',
                                                             'version' => '2.030'
                                                           },
                                                           {
                                                             'date' => '2013-04-03T17:22:28',
                                                             'version' => '2.031'
                                                           },
                                                           {
                                                             'date' => '2013-04-15T11:28:33',
                                                             'version' => '2.032'
                                                           },
                                                           {
                                                             'date' => '2013-04-15T19:27:14',
                                                             'version' => '2.033'
                                                           },
                                                           {
                                                             'date' => '2013-04-17T19:29:52',
                                                             'version' => '2.034'
                                                           },
                                                           {
                                                             'date' => '2013-04-27T15:05:09',
                                                             'version' => '2.035'
                                                           },
                                                           {
                                                             'date' => '2013-05-25T17:53:04',
                                                             'version' => '2.036'
                                                           },
                                                           {
                                                             'date' => '2013-06-15T17:46:45',
                                                             'version' => '2.037'
                                                           },
                                                           {
                                                             'date' => '2013-07-03T19:30:32',
                                                             'version' => '2.038'
                                                           },
                                                           {
                                                             'date' => '2013-07-18T18:12:07',
                                                             'version' => '2.039'
                                                           },
                                                           {
                                                             'date' => '2013-07-20T09:46:11',
                                                             'version' => '2.040'
                                                           },
                                                           {
                                                             'date' => '2013-08-14T17:58:40',
                                                             'version' => '2.041'
                                                           },
                                                           {
                                                             'date' => '2013-09-15T17:41:45',
                                                             'version' => '2.042'
                                                           },
                                                           {
                                                             'date' => '2013-09-20T17:35:06',
                                                             'version' => '2.043'
                                                           },
                                                           {
                                                             'date' => '2013-10-13T16:02:40',
                                                             'version' => '2.044'
                                                           },
                                                           {
                                                             'date' => '2013-10-18T17:48:15',
                                                             'version' => '2.045'
                                                           },
                                                           {
                                                             'date' => '2013-12-15T13:07:37',
                                                             'version' => '2.046'
                                                           },
                                                           {
                                                             'date' => '2014-01-25T15:54:37',
                                                             'version' => '2.047'
                                                           },
                                                           {
                                                             'date' => '2014-02-23T18:02:19',
                                                             'version' => '2.048'
                                                           },
                                                           {
                                                             'date' => '2014-02-26T19:45:44',
                                                             'version' => '2.049'
                                                           },
                                                           {
                                                             'date' => '2014-02-27T18:12:32',
                                                             'version' => '2.050'
                                                           },
                                                           {
                                                             'date' => '2014-03-06T18:23:11',
                                                             'version' => '2.051'
                                                           },
                                                           {
                                                             'date' => '2014-03-23T16:20:43',
                                                             'version' => '2.052'
                                                           },
                                                           {
                                                             'date' => '2014-03-25T19:11:57',
                                                             'version' => '2.053'
                                                           },
                                                           {
                                                             'date' => '2014-04-01T17:51:50',
                                                             'version' => '2.054'
                                                           },
                                                           {
                                                             'date' => '2014-05-02T11:33:28',
                                                             'version' => '2.055'
                                                           },
                                                           {
                                                             'date' => '2014-05-18T19:34:53',
                                                             'version' => '2.056'
                                                           },
                                                           {
                                                             'date' => '2014-06-12T19:32:47',
                                                             'version' => '2.057'
                                                           },
                                                           {
                                                             'date' => '2014-06-19T19:43:18',
                                                             'version' => '2.058'
                                                           },
                                                           {
                                                             'date' => '2014-06-29T15:08:02',
                                                             'version' => '2.059'
                                                           },
                                                           {
                                                             'date' => '2014-08-19T12:43:59',
                                                             'version' => '2.060'
                                                           },
                                                           {
                                                             'date' => '2014-09-23T19:21:04',
                                                             'version' => '2.061'
                                                           },
                                                           {
                                                             'date' => '2014-11-23T19:45:05',
                                                             'version' => '2.062'
                                                           },
                                                           {
                                                             'date' => '2014-11-28T17:55:21',
                                                             'version' => '2.063'
                                                           },
                                                           {
                                                             'date' => '2014-12-04T18:47:05',
                                                             'version' => '2.064'
                                                           },
                                                           {
                                                             'date' => '2015-01-06T20:16:15',
                                                             'version' => '2.065'
                                                           },
                                                           {
                                                             'date' => '2015-02-15T16:13:00',
                                                             'version' => '2.066'
                                                           },
                                                           {
                                                             'date' => '2015-03-01T18:38:28',
                                                             'version' => '2.067'
                                                           },
                                                           {
                                                             'date' => '2015-03-29T13:39:56',
                                                             'version' => '2.068'
                                                           },
                                                           {
                                                             'date' => '2015-04-25T19:29:15',
                                                             'version' => '2.069'
                                                           },
                                                           {
                                                             'date' => '2015-05-03T14:00:52',
                                                             'version' => '2.070'
                                                           },
                                                           {
                                                             'date' => '2015-05-23T11:15:16',
                                                             'version' => '2.071'
                                                           },
                                                           {
                                                             'date' => '2015-07-18T19:31:43',
                                                             'version' => '2.072'
                                                           },
                                                           {
                                                             'date' => '2015-07-19T07:35:51',
                                                             'version' => '2.073'
                                                           },
                                                           {
                                                             'date' => '2015-09-30T18:56:39',
                                                             'version' => '2.074'
                                                           },
                                                           {
                                                             'date' => '2015-11-22T20:11:19',
                                                             'version' => '2.075'
                                                           },
                                                           {
                                                             'date' => '2016-01-14T18:13:20',
                                                             'version' => '2.076'
                                                           },
                                                           {
                                                             'date' => '2016-01-20T19:55:36',
                                                             'version' => '2.077'
                                                           },
                                                           {
                                                             'date' => '2016-01-24T18:48:46',
                                                             'version' => '2.078'
                                                           },
                                                           {
                                                             'date' => '2016-02-12T20:44:28',
                                                             'version' => '2.079'
                                                           },
                                                           {
                                                             'date' => '2016-02-27T17:59:55',
                                                             'version' => '2.080'
                                                           },
                                                           {
                                                             'date' => '2016-02-29T19:01:45',
                                                             'version' => '2.081'
                                                           },
                                                           {
                                                             'date' => '2016-03-29T18:22:30',
                                                             'version' => '2.082'
                                                           },
                                                           {
                                                             'date' => '2016-04-20T18:32:29',
                                                             'version' => '2.083'
                                                           },
                                                           {
                                                             'date' => '2016-05-26T17:35:53',
                                                             'version' => '2.084'
                                                           },
                                                           {
                                                             'date' => '2016-05-29T17:13:14',
                                                             'version' => '2.085'
                                                           },
                                                           {
                                                             'date' => '2016-06-04T19:28:08',
                                                             'version' => '2.086'
                                                           },
                                                           {
                                                             'date' => '2016-06-29T17:35:35',
                                                             'version' => '2.087'
                                                           },
                                                           {
                                                             'date' => '2016-07-09T18:06:03',
                                                             'version' => '2.088'
                                                           },
                                                           {
                                                             'date' => '2016-09-04T13:17:52',
                                                             'version' => '2.089'
                                                           },
                                                           {
                                                             'date' => '2016-09-10T16:07:07',
                                                             'version' => '2.090'
                                                           },
                                                           {
                                                             'date' => '2016-09-13T17:05:56',
                                                             'version' => '2.091'
                                                           },
                                                           {
                                                             'date' => '2016-09-23T17:46:04',
                                                             'version' => '2.092'
                                                           },
                                                           {
                                                             'date' => '2016-11-08T18:33:39',
                                                             'version' => '2.093'
                                                           },
                                                           {
                                                             'date' => '2016-11-09T18:23:05',
                                                             'version' => '2.094'
                                                           },
                                                           {
                                                             'date' => '2016-12-06T18:01:00',
                                                             'version' => '2.095'
                                                           },
                                                           {
                                                             'date' => '2016-12-11T20:28:14',
                                                             'version' => '2.096'
                                                           },
                                                           {
                                                             'date' => '2016-12-22T17:35:34',
                                                             'version' => '2.097'
                                                           },
                                                           {
                                                             'date' => '2017-02-26T18:58:23',
                                                             'version' => '2.098'
                                                           },
                                                           {
                                                             'date' => '2017-03-05T17:09:37',
                                                             'version' => '2.099'
                                                           },
                                                           {
                                                             'date' => '2017-03-18T12:06:34',
                                                             'version' => '2.100'
                                                           },
                                                           {
                                                             'date' => '2017-04-28T17:40:56',
                                                             'version' => '2.101'
                                                           },
                                                           {
                                                             'date' => '2017-05-14T19:10:40',
                                                             'version' => '2.102'
                                                           },
                                                           {
                                                             'date' => '2017-05-25T08:15:17',
                                                             'version' => '2.103'
                                                           },
                                                           {
                                                             'date' => '2017-06-03T13:23:33',
                                                             'version' => '2.104'
                                                           },
                                                           {
                                                             'date' => '2017-06-09T17:26:55',
                                                             'version' => '2.105'
                                                           },
                                                           {
                                                             'date' => '2017-07-16T14:07:23',
                                                             'version' => '2.106'
                                                           },
                                                           {
                                                             'date' => '2017-08-30T19:12:10',
                                                             'version' => '2.107'
                                                           },
                                                           {
                                                             'date' => '2017-08-31T17:23:43',
                                                             'version' => '2.108'
                                                           },
                                                           {
                                                             'date' => '2017-09-18T17:52:57',
                                                             'version' => '2.109'
                                                           },
                                                           {
                                                             'date' => '2017-09-21T19:12:32',
                                                             'version' => '2.110'
                                                           },
                                                           {
                                                             'date' => '2017-09-22T18:41:04',
                                                             'version' => '2.111'
                                                           },
                                                           {
                                                             'date' => '2017-10-01T09:12:45',
                                                             'version' => '2.112'
                                                           },
                                                           {
                                                             'date' => '2017-10-12T19:07:46',
                                                             'version' => '2.113'
                                                           },
                                                           {
                                                             'date' => '2017-11-11T16:35:03',
                                                             'version' => '2.114'
                                                           },
                                                           {
                                                             'date' => '2017-12-14T18:03:18',
                                                             'version' => '2.115'
                                                           },
                                                           {
                                                             'date' => '2017-12-16T09:52:09',
                                                             'version' => '2.116'
                                                           },
                                                           {
                                                             'date' => '2018-02-03T18:09:35',
                                                             'version' => '2.117'
                                                           },
                                                           {
                                                             'date' => '2018-03-26T18:33:19',
                                                             'version' => '2.118'
                                                           },
                                                           {
                                                             'date' => '2018-04-02T16:55:50',
                                                             'version' => '2.119'
                                                           },
                                                           {
                                                             'date' => '2018-04-08T07:56:03',
                                                             'version' => '2.120'
                                                           },
                                                           {
                                                             'date' => '2018-04-15T17:08:18',
                                                             'version' => '2.121'
                                                           },
                                                           {
                                                             'date' => '2018-04-17T17:20:14',
                                                             'version' => '2.122'
                                                           },
                                                           {
                                                             'date' => '2018-05-01T17:18:09',
                                                             'version' => '2.123'
                                                           },
                                                           {
                                                             'date' => '2018-06-09T17:16:59',
                                                             'version' => '2.124'
                                                           },
                                                           {
                                                             'date' => '2018-06-24T12:47:24',
                                                             'version' => '2.125'
                                                           },
                                                           {
                                                             'date' => '2018-08-20T13:10:09',
                                                             'version' => '2.126'
                                                           },
                                                           {
                                                             'date' => '2018-09-30T16:44:13',
                                                             'version' => '2.127'
                                                           },
                                                           {
                                                             'date' => '2018-11-21T19:33:41',
                                                             'version' => '2.128'
                                                           },
                                                           {
                                                             'date' => '2018-12-05T18:44:58',
                                                             'version' => '2.129'
                                                           },
                                                           {
                                                             'date' => '2018-12-07T19:02:10',
                                                             'version' => '2.130'
                                                           },
                                                           {
                                                             'date' => '2018-12-16T18:32:58',
                                                             'version' => '2.131'
                                                           },
                                                           {
                                                             'date' => '2018-12-22T17:50:27',
                                                             'version' => '2.132'
                                                           },
                                                           {
                                                             'date' => '2019-01-13T20:17:07',
                                                             'version' => '2.133'
                                                           },
                                                           {
                                                             'date' => '2019-05-05T10:51:38',
                                                             'version' => '2.134'
                                                           },
                                                           {
                                                             'date' => '2019-06-05T17:21:24',
                                                             'version' => '2.135'
                                                           },
                                                           {
                                                             'date' => '2019-07-29T15:44:09',
                                                             'version' => '2.136'
                                                           },
                                                           {
                                                             'date' => '2019-12-01T17:32:00',
                                                             'version' => '2.137'
                                                           },
                                                           {
                                                             'date' => '2019-12-27T14:43:21',
                                                             'version' => '2.138'
                                                           },
                                                           {
                                                             'date' => '2020-07-18T14:38:14',
                                                             'version' => '2.139'
                                                           },
                                                           {
                                                             'date' => '2020-07-31T08:24:37',
                                                             'version' => '2.140'
                                                           },
                                                           {
                                                             'date' => '2021-01-17T18:04:01',
                                                             'version' => '2.141'
                                                           },
                                                           {
                                                             'date' => '2021-04-07T17:08:47',
                                                             'version' => '2.142'
                                                           },
                                                           {
                                                             'date' => '2021-10-31T17:28:44',
                                                             'version' => '2.143'
                                                           },
                                                           {
                                                             'date' => '2021-11-04T17:26:40',
                                                             'version' => '2.144'
                                                           },
                                                           {
                                                             'date' => '2021-11-06T18:23:25',
                                                             'version' => '2.145'
                                                           },
                                                           {
                                                             'date' => '2021-11-28T18:13:47',
                                                             'version' => '2.146'
                                                           },
                                                           {
                                                             'date' => '2021-11-29T18:42:25',
                                                             'version' => '2.147'
                                                           },
                                                           {
                                                             'date' => '2022-01-09T15:02:17',
                                                             'version' => '2.148'
                                                           },
                                                           {
                                                             'date' => '2022-01-13T16:42:50',
                                                             'version' => '2.149'
                                                           },
                                                           {
                                                             'date' => '2022-05-08T15:10:12',
                                                             'version' => '2.150'
                                                           }
                                                         ]
                                         },
                       'Convert-ASN1' => {
                                           'advisories' => [
                                                             {
                                                               'affected_versions' => '<0.27',
                                                               'cves' => [
                                                                           'CVE-2013-7488'
                                                                         ],
                                                               'description' => 'perl-Convert-ASN1 (aka the Convert::ASN1 module for Perl) through 0.27 allows remote attackers to cause an infinite loop via unexpected input.
',
                                                               'distribution' => 'Convert-ASN1',
                                                               'fixed_versions' => undef,
                                                               'id' => 'CPANSA-Convert-ASN1-2013-7488',
                                                               'references' => [
                                                                                 'https://github.com/gbarr/perl-Convert-ASN1/issues/14',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/ONNQSW4SSKMG5RUEFZJZA5T5R2WXEGQF/',
                                                                                 'https://lists.fedoraproject.org/archives/list/package-announce@lists.fedoraproject.org/message/6V3PJEQOT47ZO77263XPGS3Y3AJROI4X/'
                                                                               ],
                                                               'reported' => '2020-04-07',
                                                               'severity' => 'high'
                                                             }
                                                           ],
                                           'main_module' => 'Convert::ASN1',
                                           'versions' => [
                                                           {
                                                             'date' => '2000-04-03T21:52:45',
                                                             'version' => '0.04'
                                                           },
                                                           {
                                                             'date' => '2000-05-12T10:14:51',
                                                             'version' => '0.05'
                                                           },
                                                           {
                                                             'date' => '2000-05-22T11:08:54',
                                                             'version' => '0.06'
                                                           },
                                                           {
                                                             'date' => '2000-05-30T14:31:54',
                                                             'version' => '0.07'
                                                           },
                                                           {
                                                             'date' => '2001-02-05T22:44:53',
                                                             'version' => '0.08'
                                                           },
                                                           {
                                                             'date' => '2001-04-19T23:07:25',
                                                             'version' => '0.09'
                                                           },
                                                           {
                                                             'date' => '2001-04-20T06:40:05',
                                                             'version' => '0.10'
                                                           },
                                                           {
                                                             'date' => '2001-06-11T13:37:41',
                                                             'version' => '0.11'
                                                           },
                                                           {
                                                             'date' => '2001-07-31T17:11:59',
                                                             'version' => '0.12'
                                                           },
                                                           {
                                                             'date' => '2001-08-26T07:23:52',
                                                             'version' => '0.13'
                                                           },
                                                           {
                                                             'date' => '2001-09-10T18:07:31',
                                                             'version' => '0.14'
                                                           },
                                                           {
                                                             'date' => '2002-01-22T11:33:25',
                                                             'version' => '0.15'
                                                           },
                                                           {
                                                             'date' => '2002-08-20T00:05:24',
                                                             'version' => '0.16'
                                                           },
                                                           {
                                                             'date' => '2003-05-12T17:52:00',
                                                             'version' => '0.17'
                                                           },
                                                           {
                                                             'date' => '2003-10-08T14:31:56',
                                                             'version' => '0.18'
                                                           },
                                                           {
                                                             'date' => '2005-04-19T00:51:07',
                                                             'version' => '0.19'
                                                           },
                                                           {
                                                             'date' => '2006-02-22T01:29:15',
                                                             'version' => '0.20'
                                                           },
                                                           {
                                                             'date' => '2007-02-03T02:50:32',
                                                             'version' => '0.21'
                                                           },
                                                           {
                                                             'date' => '2008-09-15T19:39:08',
                                                             'version' => '0.22'
                                                           },
                                                           {
                                                             'date' => '2012-05-03T21:33:29',
                                                             'version' => '0.23'
                                                           },
                                                           {
                                                             'date' => '2012-06-04T22:12:03',
                                                             'version' => '0.24'
                                                           },
                                                           {
                                                             'date' => '2012-06-09T00:32:31',
                                                             'version' => '0.25'
                                                           },
                                                           {
                                                             'date' => '2012-06-09T18:31:05',
                                                             'version' => '0.26'
                                                           },
                                                           {
                                                             'date' => '2014-06-25T18:49:11',
                                                             'version' => '0.27'
                                                           },
                                                           {
                                                             'date' => '2021-05-23T21:05:04',
                                                             'version' => '0.28'
                                                           },
                                                           {
                                                             'date' => '2021-05-24T21:29:37',
                                                             'version' => '0.29'
                                                           },
                                                           {
                                                             'date' => '2021-05-30T00:58:54',
                                                             'version' => '0.30'
                                                           },
                                                           {
                                                             'date' => '2021-06-03T01:30:40',
                                                             'version' => '0.31'
                                                           },
                                                           {
                                                             'date' => '2021-09-21T21:46:25',
                                                             'version' => '0.32'
                                                           },
                                                           {
                                                             'date' => '2021-09-22T22:51:23',
                                                             'version' => '0.33'
                                                           }
                                                         ]
                                         },
                       'Convert-UUlib' => {
                                            'advisories' => [
                                                              {
                                                                'affected_versions' => '<1.051',
                                                                'cves' => [
                                                                            'CVE-2005-1349'
                                                                          ],
                                                                'description' => 'Buffer overflow in Convert-UUlib (Convert::UUlib) before 1.051 allows remote attackers to execute arbitrary code via a malformed parameter to a read operation.
',
                                                                'distribution' => 'Convert-UUlib',
                                                                'fixed_versions' => undef,
                                                                'id' => 'CPANSA-Convert-UUlib-2005-1349',
                                                                'references' => [
                                                                                  'http://www.gentoo.org/security/en/glsa/glsa-200504-26.xml',
                                                                                  'http://secunia.com/advisories/15130',
                                                                                  'http://www.securityfocus.com/bid/13401',
                                                                                  'http://www.mandriva.com/security/advisories?name=MDKSA-2006:022',
                                                                                  'https://exchange.xforce.ibmcloud.com/vulnerabilities/20275'
                                                                                ],
                                                                'reported' => '2005-05-02',
                                                                'severity' => undef
                                                              }
                                                            ],
                                            'main_module' => 'Convert::UUlib',
                                            'versions' => [
                                                            {
                                                              'date' => '1999-05-08T20:44:28',
                                                              'version' => '0.03'
                                                            },
                                                            {
                                                              'date' => '1999-05-25T19:26:16',
                                                              'version' => '0.05'
                                                            },
                                                            {
                                                              'date' => '1999-07-29T21:35:05',
                                                              'version' => '0.06'
                                                            },
                                                            {
                                                              'date' => '2000-07-16T20:52:56',
                                                              'version' => '0.11'
                                                            },
                                                            {
                                                              'date' => '2001-05-04T21:14:40',
                                                              'version' => '0.111'
                                                            },
                                                            {
                                                              'date' => '2001-06-14T16:49:29',
                                                              'version' => '0.2'
                                                            },
                                                            {
                                                              'date' => '2001-09-16T01:45:11',
                                                              'version' => '0.201'
                                                            },
                                                            {
                                                              'date' => '2002-03-31T22:10:15',
                                                              'version' => '0.21'
                                                            },
                                                            {
                                                              'date' => '2002-03-31T22:52:00',
                                                              'version' => '0.21'
                                                            },
                                                            {
                                                              'date' => '2002-04-05T22:18:55',
                                                              'version' => '0.211'
                                                            },
                                                            {
                                                              'date' => '2002-04-06T02:39:32',
                                                              'version' => '0.212'
                                                            },
                                                            {
                                                              'date' => '2002-07-27T19:20:26',
                                                              'version' => '0.213'
                                                            },
                                                            {
                                                              'date' => '2002-10-13T18:14:28',
                                                              'version' => '0.3'
                                                            },
                                                            {
                                                              'date' => '2002-10-15T23:26:09',
                                                              'version' => '0.31'
                                                            },
                                                            {
                                                              'date' => '2003-11-24T16:10:49',
                                                              'version' => '1.0'
                                                            },
                                                            {
                                                              'date' => '2004-03-16T20:05:14',
                                                              'version' => '1.01'
                                                            },
                                                            {
                                                              'date' => '2004-04-18T14:51:27',
                                                              'version' => '1.02'
                                                            },
                                                            {
                                                              'date' => '2004-04-18T20:16:15',
                                                              'version' => '1.03'
                                                            },
                                                            {
                                                              'date' => '2004-12-28T14:12:40',
                                                              'version' => '1.04'
                                                            },
                                                            {
                                                              'date' => '2005-03-03T17:52:16',
                                                              'version' => '1.051'
                                                            },
                                                            {
                                                              'date' => '2005-12-05T23:58:50',
                                                              'version' => '1.06'
                                                            },
                                                            {
                                                              'date' => '2006-12-10T16:45:11',
                                                              'version' => '1.07'
                                                            },
                                                            {
                                                              'date' => '2006-12-16T22:31:30',
                                                              'version' => '1.08'
                                                            },
                                                            {
                                                              'date' => '2007-05-25T17:40:35',
                                                              'version' => '1.09'
                                                            },
                                                            {
                                                              'date' => '2008-06-13T13:27:38',
                                                              'version' => '1.10'
                                                            },
                                                            {
                                                              'date' => '2008-06-13T13:34:18',
                                                              'version' => '1.11'
                                                            },
                                                            {
                                                              'date' => '2008-10-13T12:13:26',
                                                              'version' => '1.12'
                                                            },
                                                            {
                                                              'date' => '2009-08-28T23:26:34',
                                                              'version' => '1.3'
                                                            },
                                                            {
                                                              'date' => '2009-09-16T07:05:05',
                                                              'version' => '1.31'
                                                            },
                                                            {
                                                              'date' => '2009-09-16T18:10:46',
                                                              'version' => '1.32'
                                                            },
                                                            {
                                                              'date' => '2009-10-28T08:05:40',
                                                              'version' => '1.33'
                                                            },
                                                            {
                                                              'date' => '2010-12-14T21:21:33',
                                                              'version' => '1.34'
                                                            },
                                                            {
                                                              'date' => '2011-05-29T15:23:57',
                                                              'version' => '1.4'
                                                            },
                                                            {
                                                              'date' => '2015-07-11T01:57:19',
                                                              'version' => '1.5'
                                                            },
                                                            {
                                                              'date' => '2019-10-24T15:19:15',
                                                              'version' => '1.6'
                                                            },
                                                            {
                                                              'date' => '2020-02-17T22:21:21',
                                                              'version' => '1.62'
                                                            },
                                                            {
                                                              'date' => '2020-02-29T21:09:26',
                                                              'version' => '1.7'
                                                            },
                                                            {
                                                              'date' => '2020-03-16T23:54:43',
                                                              'version' => '1.71'
                                                            },
                                                            {
                                                              'date' => '2020-12-17T01:25:02',
                                                              'version' => '1.8'
                                                            }
                                                          ]
                                          },
                       'Cpanel-JSON-XS' => {
                                             'advisories' => [
                                                               {
                                                                 'affected_versions' => '<3.0225',
                                                                 'cves' => [],
                                                                 'description' => 'Overflow during processing of ill-formed UTF-8 strings.
',
                                                                 'distribution' => 'Cpanel-JSON-XS',
                                                                 'fixed_versions' => '>=3.0225',
                                                                 'id' => 'CPANSA-Cpanel-JSON-XS-2016-02',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Cpanel-JSON-XS',
                                                                                   'https://github.com/rurban/Cpanel-JSON-XS/commit/f71768984ba7f50b0476c17a4f3b3f2ca88a6951',
                                                                                   'https://github.com/dankogai/p5-encode/issues/64'
                                                                                 ],
                                                                 'reported' => '2016-11-23'
                                                               },
                                                               {
                                                                 'affected_versions' => '<3.0218',
                                                                 'cves' => [],
                                                                 'description' => 'Possible overflows in av and hv length types.
',
                                                                 'distribution' => 'Cpanel-JSON-XS',
                                                                 'fixed_versions' => '>=3.0218',
                                                                 'id' => 'CPANSA-Cpanel-JSON-XS-2016-01',
                                                                 'references' => [
                                                                                   'https://metacpan.org/changes/distribution/Cpanel-JSON-XS',
                                                                                   'https://github.com/rurban/Cpanel-JSON-XS/commit/6554531b39fac236321d8601d35eaaa75ae45e20'
                                                                                 ],
                                                                 'reported' => '2016-10-06'
                                                               }
                                                             ],
                                             'main_module' => 'Cpanel::JSON::XS',
                                             'versions' => [
                                                             {
                                                               'date' => '2013-03-01T00:52:41',
                                                               'version' => '2.33_03'
                                                             },
                                                             {
                                                               'date' => '2013-03-01T22:07:06',
                                                               'version' => '2.33_04'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T16:53:34',
                                                               'version' => '2.3305'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T17:17:51',
                                                               'version' => '2.3306'
                                                             },
                                                             {
                                                               'date' => '2013-03-27T22:58:47',
                                                               'version' => '2.3307'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T14:28:56',
                                                               'version' => '2.3308'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T15:12:42',
                                                               'version' => '2.3309'
                                                             },
                                                             {
                                                               'date' => '2013-03-28T17:33:21',
                                                               'version' => '2.3310'
                                                             },
                                                             {
                                                               'date' => '2013-06-26T16:24:40',
                                                               'version' => '2.3313'
                                                             },
                                                             {
                                                               'date' => '2013-09-09T05:54:40',
                                                               'version' => '2.3314'
                                                             },
                                                             {
                                                               'date' => '2013-10-02T20:06:47',
                                                               'version' => '2.3401'
                                                             },
                                                             {
                                                               'date' => '2013-11-02T14:42:20',
                                                               'version' => '2.3402'
                                                             },
                                                             {
                                                               'date' => '2013-11-02T15:17:41',
                                                               'version' => '2.3403'
                                                             },
                                                             {
                                                               'date' => '2014-01-30T15:58:58',
                                                               'version' => '2.3404'
                                                             },
                                                             {
                                                               'date' => '2014-04-15T21:17:11',
                                                               'version' => '3.0101'
                                                             },
                                                             {
                                                               'date' => '2014-04-17T18:37:34',
                                                               'version' => '3.0102'
                                                             },
                                                             {
                                                               'date' => '2014-04-21T17:49:09',
                                                               'version' => '3.0103'
                                                             },
                                                             {
                                                               'date' => '2014-04-26T16:04:39',
                                                               'version' => '3.0104'
                                                             },
                                                             {
                                                               'date' => '2014-11-06T10:38:31',
                                                               'version' => '3.0105'
                                                             },
                                                             {
                                                               'date' => '2014-11-11T21:57:49',
                                                               'version' => '3.0106'
                                                             },
                                                             {
                                                               'date' => '2014-11-28T12:16:29',
                                                               'version' => '3.0107'
                                                             },
                                                             {
                                                               'date' => '2014-12-11T17:02:07',
                                                               'version' => '3.0108'
                                                             },
                                                             {
                                                               'date' => '2014-12-12T10:24:33',
                                                               'version' => '3.0109'
                                                             },
                                                             {
                                                               'date' => '2014-12-12T22:35:37',
                                                               'version' => '3.0110'
                                                             },
                                                             {
                                                               'date' => '2014-12-13T18:40:06',
                                                               'version' => '3.0111'
                                                             },
                                                             {
                                                               'date' => '2014-12-14T16:34:01',
                                                               'version' => '3.0112'
                                                             },
                                                             {
                                                               'date' => '2014-12-15T12:23:32',
                                                               'version' => '3.0113'
                                                             },
                                                             {
                                                               'date' => '2015-01-04T14:06:03',
                                                               'version' => '3.0114'
                                                             },
                                                             {
                                                               'date' => '2015-01-31T21:42:51',
                                                               'version' => '3.0115'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T08:58:33',
                                                               'version' => '3.0201'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T13:16:40',
                                                               'version' => '3.0202'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T13:42:02',
                                                               'version' => '3.0203'
                                                             },
                                                             {
                                                               'date' => '2015-11-26T22:30:26',
                                                               'version' => '3.0204'
                                                             },
                                                             {
                                                               'date' => '2015-11-29T14:09:00',
                                                               'version' => '3.0205'
                                                             },
                                                             {
                                                               'date' => '2015-11-30T16:16:48',
                                                               'version' => '3.0206'
                                                             },
                                                             {
                                                               'date' => '2015-12-02T16:34:35',
                                                               'version' => '3.0207'
                                                             },
                                                             {
                                                               'date' => '2015-12-02T22:46:58',
                                                               'version' => '3.0208'
                                                             },
                                                             {
                                                               'date' => '2015-12-03T09:45:04',
                                                               'version' => '3.0209'
                                                             },
                                                             {
                                                               'date' => '2015-12-03T11:59:24',
                                                               'version' => '3.0210'
                                                             },
                                                             {
                                                               'date' => '2016-01-10T17:38:25',
                                                               'version' => '3.0211'
                                                             },
                                                             {
                                                               'date' => '2016-02-27T13:30:04',
                                                               'version' => '3.0212'
                                                             },
                                                             {
                                                               'date' => '2016-03-02T10:28:37',
                                                               'version' => '3.0213'
                                                             },
                                                             {
                                                               'date' => '2016-04-12T08:40:05',
                                                               'version' => '3.0213_01'
                                                             },
                                                             {
                                                               'date' => '2016-04-13T10:40:03',
                                                               'version' => '3.0213_02'
                                                             },
                                                             {
                                                               'date' => '2016-06-02T16:18:51',
                                                               'version' => '3.0214'
                                                             },
                                                             {
                                                               'date' => '2016-06-06T13:28:49',
                                                               'version' => '3.0215'
                                                             },
                                                             {
                                                               'date' => '2016-06-12T12:14:20',
                                                               'version' => '3.0216'
                                                             },
                                                             {
                                                               'date' => '2016-06-18T09:59:27',
                                                               'version' => '3.0217'
                                                             },
                                                             {
                                                               'date' => '2016-10-04T10:11:33',
                                                               'version' => '3.0217_01'
                                                             },
                                                             {
                                                               'date' => '2016-10-04T14:47:29',
                                                               'version' => '3.0217_02'
                                                             },
                                                             {
                                                               'date' => '2016-10-06T08:46:17',
                                                               'version' => '3.0217_03'
                                                             },
                                                             {
                                                               'date' => '2016-10-07T12:11:03',
                                                               'version' => '3.0217_04'
                                                             },
                                                             {
                                                               'date' => '2016-10-07T17:22:48',
                                                               'version' => '3.0217_05'
                                                             },
                                                             {
                                                               'date' => '2016-10-08T08:01:50',
                                                               'version' => '3.0217_06'
                                                             },
                                                             {
                                                               'date' => '2016-10-13T12:47:31',
                                                               'version' => '3.0218'
                                                             },
                                                             {
                                                               'date' => '2016-10-26T11:45:35',
                                                               'version' => '3.0219'
                                                             },
                                                             {
                                                               'date' => '2016-10-28T08:34:28',
                                                               'version' => '3.0220'
                                                             },
                                                             {
                                                               'date' => '2016-10-30T12:27:36',
                                                               'version' => '3.0221'
                                                             },
                                                             {
                                                               'date' => '2016-10-30T15:04:32',
                                                               'version' => '3.0222'
                                                             },
                                                             {
                                                               'date' => '2016-11-16T11:47:38',
                                                               'version' => '3.0223'
                                                             },
                                                             {
                                                               'date' => '2016-11-20T11:31:34',
                                                               'version' => '3.0224'
                                                             },
                                                             {
                                                               'date' => '2016-11-23T18:43:00',
                                                               'version' => '3.0225'
                                                             },
                                                             {
                                                               'date' => '2017-02-11T13:24:48',
                                                               'version' => '3.0226'
                                                             },
                                                             {
                                                               'date' => '2017-02-13T10:57:06',
                                                               'version' => '3.0227'
                                                             },
                                                             {
                                                               'date' => '2017-03-07T23:57:39',
                                                               'version' => '3.0228'
                                                             },
                                                             {
                                                               'date' => '2017-03-10T14:08:07',
                                                               'version' => '3.0229'
                                                             },
                                                             {
                                                               'date' => '2017-03-12T09:52:13',
                                                               'version' => '3.0230'
                                                             },
                                                             {
                                                               'date' => '2017-03-29T09:51:51',
                                                               'version' => '3.0231'
                                                             },
                                                             {
                                                               'date' => '2017-05-01T05:35:12',
                                                               'version' => '3.0232'
                                                             },
                                                             {
                                                               'date' => '2017-05-01T14:54:56',
                                                               'version' => '3.0233'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T15:43:41',
                                                               'version' => '3.0234'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T16:21:47',
                                                               'version' => '3.0235'
                                                             },
                                                             {
                                                               'date' => '2017-07-27T20:15:25',
                                                               'version' => '3.0236'
                                                             },
                                                             {
                                                               'date' => '2017-07-28T11:15:05',
                                                               'version' => '3.0237'
                                                             },
                                                             {
                                                               'date' => '2017-08-25T20:53:56',
                                                               'version' => '3.0238'
                                                             },
                                                             {
                                                               'date' => '2017-08-28T20:48:37',
                                                               'version' => '3.0239'
                                                             },
                                                             {
                                                               'date' => '2018-01-30T11:52:27',
                                                               'version' => '3.99_01'
                                                             },
                                                             {
                                                               'date' => '2018-01-31T12:58:24',
                                                               'version' => '3.99_02'
                                                             },
                                                             {
                                                               'date' => '2018-01-31T17:18:58',
                                                               'version' => '3.99_03'
                                                             },
                                                             {
                                                               'date' => '2018-02-02T01:57:54',
                                                               'version' => '4.00'
                                                             },
                                                             {
                                                               'date' => '2018-02-03T11:50:36',
                                                               'version' => '4.01'
                                                             },
                                                             {
                                                               'date' => '2018-02-27T16:08:55',
                                                               'version' => '4.02'
                                                             },
                                                             {
                                                               'date' => '2018-06-21T11:16:14',
                                                               'version' => '4.03'
                                                             },
                                                             {
                                                               'date' => '2018-06-22T17:37:07',
                                                               'version' => '4.04'
                                                             },
                                                             {
                                                               'date' => '2018-08-19T16:55:22',
                                                               'version' => '4.05'
                                                             },
                                                             {
                                                               'date' => '2018-08-23T07:50:22',
                                                               'version' => '4.06'
                                                             },
                                                             {
                                                               'date' => '2018-11-02T09:51:34',
                                                               'version' => '4.07'
                                                             },
                                                             {
                                                               'date' => '2018-11-28T14:26:40',
                                                               'version' => '4.08'
                                                             },
                                                             {
                                                               'date' => '2019-02-15T10:09:53',
                                                               'version' => '4.09'
                                                             },
                                                             {
                                                               'date' => '2019-03-18T07:50:15',
                                                               'version' => '4.10'
                                                             },
                                                             {
                                                               'date' => '2019-03-26T16:46:53',
                                                               'version' => '4.11'
                                                             },
                                                             {
                                                               'date' => '2019-06-11T08:04:04',
                                                               'version' => '4.12'
                                                             },
                                                             {
                                                               'date' => '2019-10-14T14:14:37',
                                                               'version' => '4.13'
                                                             },
                                                             {
                                                               'date' => '2019-10-15T15:16:21',
                                                               'version' => '4.14'
                                                             },
                                                             {
                                                               'date' => '2019-10-22T07:01:03',
                                                               'version' => '4.15'
                                                             },
                                                             {
                                                               'date' => '2019-11-04T15:51:01',
                                                               'version' => '4.16'
                                                             },
                                                             {
                                                               'date' => '2019-11-05T13:48:29',
                                                               'version' => '4.17'
                                                             },
                                                             {
                                                               'date' => '2019-12-13T15:54:58',
                                                               'version' => '4.18'
                                                             },
                                                             {
                                                               'date' => '2020-02-06T15:07:47',
                                                               'version' => '4.19'
                                                             },
                                                             {
                                                               'date' => '2020-08-12T12:18:46',
                                                               'version' => '4.20'
                                                             },
                                                             {
                                                               'date' => '2020-08-13T06:56:18',
                                                               'version' => '4.21'
                                                             },
                                                             {
                                                               'date' => '2020-09-04T19:26:28',
                                                               'version' => '4.22'
                                                             },
                                                             {
                                                               'date' => '2020-09-05T10:21:25',
                                                               'version' => '4.23'
                                                             },
                                                             {
                                                               'date' => '2020-10-02T09:05:37',
                                                               'version' => '4.24'
                                                             },
                                                             {
                                                               'date' => '2020-10-28T07:04:49',
                                                               'version' => '4.25'
                                                             },
                                                             {
                                                               'date' => '2021-04-12T06:34:32',
                                                               'version' => '4.26'
                                                             },
                                                             {
                                                               'date' => '2021-10-14T19:19:01',
                                                               'version' => '4.27'
                                                             },
                                                             {
                                                               'date' => '2022-05-05T14:46:07',
                                                               'version' => '4.28'
                                                             },
                                                             {
                                                               'date' => '2022-05-27T15:32:51',
                                                               'version' => '4.29'
                                                             },
                                                             {
                                                               'date' => '2022-06-16T19:19:38',
                                                               'version' => '4.30'
                                                             }
                                                           ]
                                           },
                       'Crypt' => {
                                    'advisories' => [
                                                      {
                                                        'affected_versions' => '<0.070',
                                                        'cves' => [
                                                                    'CVE-2019-17362'
                                                                  ],
                                                        'description' => 'In LibTomCrypt through 1.18.2, the der_decode_utf8_string function (in der_decode_utf8_string.c) does not properly detect certain invalid UTF-8 sequences. This allows context-dependent attackers to cause a denial of service (out-of-bounds read and crash) or read information from other memory locations via carefully crafted DER-encoded data.
',
                                                        'distribution' => 'Crypt',
                                                        'fixed_versions' => '>=0.070',
                                                        'id' => 'CPANSA-Crypt-2019-17362',
                                                        'references' => [
                                                                          'https://github.com/libtom/libtomcrypt/pull/508',
                                                                          'https://github.com/libtom/libtomcrypt/issues/507',
                                                                          'https://vuldb.com/?id.142995',
                                                                          'https://lists.debian.org/debian-lts-announce/2019/10/msg00010.html',
                                                                          'http://lists.opensuse.org/opensuse-security-announce/2019-11/msg00020.html',
                                                                          'http://lists.opensuse.org/opensuse-security-announce/2019-11/msg00041.html'
                                                                        ],
                                                        'reported' => '2019-10-09',
                                                        'severity' => 'critical'
                                                      },
                                                      {
                                                        'affected_versions' => '<0.062',
                                                  