# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::ApplicationVersionSummary;
  use Moose;
  has ApplicationStatus => (is => 'ro', isa => 'Str', required => 1);
  has ApplicationVersionId => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::ApplicationVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::ApplicationVersionSummary object:

  $service_obj->Method(Att1 => { ApplicationStatus => $value, ..., ApplicationVersionId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::ApplicationVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationStatus

=head1 DESCRIPTION

The summary of the application version.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ApplicationStatus => Str

The status of the application.


=head2 B<REQUIRED> ApplicationVersionId => Int

The ID of the application version. Kinesis Data Analytics updates the
C<ApplicationVersionId> each time you update the application.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

