# Generated by default/object.tt
package Paws::Chime::ChannelMessageSummary;
  use Moose;
  has Content => (is => 'ro', isa => 'Str');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has LastEditedTimestamp => (is => 'ro', isa => 'Str');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has MessageId => (is => 'ro', isa => 'Str');
  has Metadata => (is => 'ro', isa => 'Str');
  has Redacted => (is => 'ro', isa => 'Bool');
  has Sender => (is => 'ro', isa => 'Paws::Chime::Identity');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelMessageSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelMessageSummary object:

  $service_obj->Method(Att1 => { Content => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelMessageSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Content

=head1 DESCRIPTION

Summary of the messages in a C<Channel>.

=head1 ATTRIBUTES


=head2 Content => Str

The content of the message.


=head2 CreatedTimestamp => Str

The time at which the message summary was created.


=head2 LastEditedTimestamp => Str

The time at which a message was last edited.


=head2 LastUpdatedTimestamp => Str

The time at which a message was last updated.


=head2 MessageId => Str

The ID of the message.


=head2 Metadata => Str

The metadata of the message.


=head2 Redacted => Bool

Indicates whether a message was redacted.


=head2 Sender => L<Paws::Chime::Identity>

The message sender.


=head2 Type => Str

The type of message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

