# Generated by default/object.tt
package Paws::GreengrassV2::LambdaFunctionRecipeSource;
  use Moose;
  has ComponentDependencies => (is => 'ro', isa => 'Paws::GreengrassV2::ComponentDependencyMap', request_name => 'componentDependencies', traits => ['NameInRequest']);
  has ComponentLambdaParameters => (is => 'ro', isa => 'Paws::GreengrassV2::LambdaExecutionParameters', request_name => 'componentLambdaParameters', traits => ['NameInRequest']);
  has ComponentName => (is => 'ro', isa => 'Str', request_name => 'componentName', traits => ['NameInRequest']);
  has ComponentPlatforms => (is => 'ro', isa => 'ArrayRef[Paws::GreengrassV2::ComponentPlatform]', request_name => 'componentPlatforms', traits => ['NameInRequest']);
  has ComponentVersion => (is => 'ro', isa => 'Str', request_name => 'componentVersion', traits => ['NameInRequest']);
  has LambdaArn => (is => 'ro', isa => 'Str', request_name => 'lambdaArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::LambdaFunctionRecipeSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::LambdaFunctionRecipeSource object:

  $service_obj->Method(Att1 => { ComponentDependencies => $value, ..., LambdaArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::LambdaFunctionRecipeSource object:

  $result = $service_obj->Method(...);
  $result->Att1->ComponentDependencies

=head1 DESCRIPTION

Contains information about an AWS Lambda function to import to create a
component.

=head1 ATTRIBUTES


=head2 ComponentDependencies => L<Paws::GreengrassV2::ComponentDependencyMap>

The component versions on which this Lambda function component depends.


=head2 ComponentLambdaParameters => L<Paws::GreengrassV2::LambdaExecutionParameters>

The system and runtime parameters for the Lambda function as it runs on
the AWS IoT Greengrass core device.


=head2 ComponentName => Str

The name of the component.

Defaults to the name of the Lambda function.


=head2 ComponentPlatforms => ArrayRef[L<Paws::GreengrassV2::ComponentPlatform>]

The platforms that the component version supports.


=head2 ComponentVersion => Str

The version of the component.

Defaults to the version of the Lambda function as a semantic version.
For example, if your function version is C<3>, the component version
becomes C<3.0.0>.


=head2 B<REQUIRED> LambdaArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the Lambda function. The ARN must include the version of the
function to import. You can't use version aliases like C<$LATEST>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

